/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.IOException;
import loci.formats.FormatException;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000CodecOptions;
import loci.formats.tiff.IFD;
import loci.formats.tiff.TiffCompression;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TiffCompressionCompressTest {
    private static final int IMAGE_WIDTH = 64;
    private static final int IMAGE_LENGTH = 64;
    private static final int BITS_PER_PIXEL = 16;
    private IFD ifd = new IFD();
    private byte[] data;

    @BeforeMethod
    public void setUp() {
        this.ifd.put((Object)256, (Object)64);
        this.ifd.put((Object)257, (Object)64);
        this.ifd.put((Object)258, (Object)new int[]{16});
        this.ifd.put((Object)277, (Object)1);
        this.ifd.put((Object)0, (Object)Boolean.TRUE);
        this.data = new byte[8192];
    }

    @Test
    public void testUNCOMPRESSED() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.UNCOMPRESSED;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        byte[] compressed = compression.compress(this.data, options);
        AssertJUnit.assertNotNull((Object)compressed);
        AssertJUnit.assertEquals((int)compressed.length, (int)this.data.length);
    }

    @Test(expectedExceptions={FormatException.class})
    public void testCCITT_1D() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.CCITT_1D;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        compression.compress(this.data, options);
    }

    @Test(expectedExceptions={FormatException.class})
    public void testGROUP_3_FAX() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.GROUP_3_FAX;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        compression.compress(this.data, options);
    }

    @Test(expectedExceptions={FormatException.class})
    public void testGROUP_4_FAX() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.GROUP_3_FAX;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        compression.compress(this.data, options);
    }

    @Test
    public void testLZW() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.LZW;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        byte[] compressed = compression.compress(this.data, options);
        AssertJUnit.assertNotNull((Object)compressed);
    }

    @Test
    public void testJPEG() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.JPEG;
        this.ifd.put((Object)258, (Object)new int[]{8});
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        byte[] compressed = compression.compress(this.data, options);
        AssertJUnit.assertNotNull((Object)compressed);
    }

    @Test(expectedExceptions={FormatException.class})
    public void testPACK_BITS() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.PACK_BITS;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        compression.compress(this.data, options);
    }

    @Test
    public void testPROPRIETARY_DEFLATE() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.PROPRIETARY_DEFLATE;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        byte[] compressed = compression.compress(this.data, options);
        AssertJUnit.assertNotNull((Object)compressed);
    }

    @Test
    public void testDEFLATE() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.DEFLATE;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        byte[] compressed = compression.compress(this.data, options);
        AssertJUnit.assertNotNull((Object)compressed);
    }

    @Test(expectedExceptions={FormatException.class})
    public void testTHUNDERSCAN() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.THUNDERSCAN;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        compression.compress(this.data, options);
    }

    @Test
    public void testJPEG_2000() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.JPEG_2000;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        byte[] compressed = compression.compress(this.data, options);
        AssertJUnit.assertNotNull((Object)compressed);
    }

    @Test
    public void testJPEG_2000_LOSSY() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.JPEG_2000_LOSSY;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        byte[] compressed = compression.compress(this.data, options);
        AssertJUnit.assertNotNull((Object)compressed);
    }

    @Test
    public void testALT_JPEG() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.ALT_JPEG;
        this.ifd.put((Object)258, (Object)new int[]{8});
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        byte[] compressed = compression.compress(this.data, options);
        AssertJUnit.assertNotNull((Object)compressed);
    }

    @Test(expectedExceptions={FormatException.class})
    public void testNIKON() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.NIKON;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd);
        compression.compress(this.data, options);
    }

    @Test(enabled=true)
    public void testJPEG_2000_ResetQuality() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.JPEG_2000;
        JPEG2000CodecOptions opt = JPEG2000CodecOptions.getDefaultOptions();
        opt.quality = 1.0;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd, (CodecOptions)opt);
        AssertJUnit.assertEquals((Object)options.quality, (Object)opt.quality);
        compression = TiffCompression.JPEG_2000_LOSSY;
        options = compression.getCompressionCodecOptions(this.ifd, (CodecOptions)opt);
        AssertJUnit.assertEquals((Object)options.quality, (Object)opt.quality);
        compression = TiffCompression.ALT_JPEG2000;
        options = compression.getCompressionCodecOptions(this.ifd, (CodecOptions)opt);
        AssertJUnit.assertEquals((Object)options.quality, (Object)opt.quality);
    }

    @Test(enabled=true)
    public void testJPEG_2000_ResetBlockSize() throws FormatException, IOException {
        int i;
        TiffCompression compression = TiffCompression.JPEG_2000;
        JPEG2000CodecOptions opt = JPEG2000CodecOptions.getDefaultOptions();
        int v = 16;
        opt.codeBlockSize = new int[]{v, v};
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd, (CodecOptions)opt);
        AssertJUnit.assertTrue((boolean)(options instanceof JPEG2000CodecOptions));
        JPEG2000CodecOptions j2k = (JPEG2000CodecOptions)options;
        AssertJUnit.assertEquals((int)j2k.codeBlockSize.length, (int)opt.codeBlockSize.length);
        for (i = 0; i < j2k.codeBlockSize.length; ++i) {
            AssertJUnit.assertEquals((int)j2k.codeBlockSize[i], (int)opt.codeBlockSize[i]);
        }
        compression = TiffCompression.JPEG_2000_LOSSY;
        options = compression.getCompressionCodecOptions(this.ifd, (CodecOptions)opt);
        AssertJUnit.assertTrue((boolean)(options instanceof JPEG2000CodecOptions));
        j2k = (JPEG2000CodecOptions)options;
        AssertJUnit.assertEquals((int)j2k.codeBlockSize.length, (int)opt.codeBlockSize.length);
        for (i = 0; i < j2k.codeBlockSize.length; ++i) {
            AssertJUnit.assertEquals((int)j2k.codeBlockSize[i], (int)opt.codeBlockSize[i]);
        }
        compression = TiffCompression.ALT_JPEG2000;
        options = compression.getCompressionCodecOptions(this.ifd, (CodecOptions)opt);
        j2k = (JPEG2000CodecOptions)options;
        AssertJUnit.assertEquals((int)j2k.codeBlockSize.length, (int)opt.codeBlockSize.length);
        for (i = 0; i < j2k.codeBlockSize.length; ++i) {
            AssertJUnit.assertEquals((int)j2k.codeBlockSize[i], (int)opt.codeBlockSize[i]);
        }
    }

    @Test(enabled=true)
    public void testJPEG_2000_ResetNumberDecompositionLevel() throws FormatException, IOException {
        TiffCompression compression = TiffCompression.JPEG_2000;
        JPEG2000CodecOptions opt = JPEG2000CodecOptions.getDefaultOptions();
        int v = 16;
        opt.numDecompositionLevels = v;
        CodecOptions options = compression.getCompressionCodecOptions(this.ifd, (CodecOptions)opt);
        AssertJUnit.assertTrue((boolean)(options instanceof JPEG2000CodecOptions));
        JPEG2000CodecOptions j2k = (JPEG2000CodecOptions)options;
        AssertJUnit.assertEquals((Object)j2k.numDecompositionLevels, (Object)opt.numDecompositionLevels);
        compression = TiffCompression.JPEG_2000_LOSSY;
        options = compression.getCompressionCodecOptions(this.ifd, (CodecOptions)opt);
        AssertJUnit.assertTrue((boolean)(options instanceof JPEG2000CodecOptions));
        j2k = (JPEG2000CodecOptions)options;
        AssertJUnit.assertEquals((Object)j2k.numDecompositionLevels, (Object)opt.numDecompositionLevels);
        compression = TiffCompression.ALT_JPEG2000;
        options = compression.getCompressionCodecOptions(this.ifd, (CodecOptions)opt);
        j2k = (JPEG2000CodecOptions)options;
        AssertJUnit.assertEquals((Object)j2k.numDecompositionLevels, (Object)opt.numDecompositionLevels);
    }
}

