/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import hdf.hdf5lib.H5;
import java.util.Arrays;

public class HDF5DataSet
implements AutoCloseable {
    private final HDF5BaseReader baseReader;
    private final HDF5 h5;
    private final String dataSetPath;
    private final HDF5StorageLayout layout;
    private long dataSpaceId;
    private long[] maxDimensions;
    private long[] dimensions;
    private long dataSetId;
    private long[] memoryBlockDimensions;
    private long memorySpaceId;
    private long dataTypeId;
    private int fullRank;

    HDF5DataSet(HDF5BaseReader baseReader, String datasetPath, long dataSetId, long dataSpaceId, long[] dimensions, long[] maxDimensionsOrNull, HDF5StorageLayout layout, boolean ownDataSpaceId) {
        this.baseReader = baseReader;
        this.h5 = baseReader.h5;
        this.dataSetPath = datasetPath;
        this.dataSetId = dataSetId;
        this.dataSpaceId = ownDataSpaceId ? dataSpaceId : H5.H5Scopy(dataSpaceId);
        this.maxDimensions = maxDimensionsOrNull;
        this.dimensions = dimensions;
        this.layout = layout;
        this.memoryBlockDimensions = null;
        this.memorySpaceId = -1L;
        this.dataTypeId = -1L;
        this.fullRank = -1;
    }

    public String getDataSetPath() {
        return this.dataSetPath;
    }

    long getDataSetId() {
        return this.dataSetId;
    }

    long getDataSpaceId() {
        H5.H5Sselect_all(this.dataSpaceId);
        return this.dataSpaceId;
    }

    long getMemorySpaceId(long[] memoryBlockDimensions) {
        if (!Arrays.equals(this.memoryBlockDimensions, memoryBlockDimensions)) {
            this.closeMemorySpaceId();
            this.memoryBlockDimensions = memoryBlockDimensions;
            this.memorySpaceId = H5.H5Screate_simple(memoryBlockDimensions.length, memoryBlockDimensions, null);
        }
        H5.H5Sselect_all(this.memorySpaceId);
        return this.memorySpaceId;
    }

    long[] getDimensions() {
        return this.dimensions;
    }

    void setDimensions(long[] dimensions) {
        this.dimensions = dimensions;
    }

    long[] getMaxDimensions() {
        if (this.maxDimensions == null) {
            this.maxDimensions = this.h5.getDataSpaceMaxDimensions(this.dataSpaceId, this.dimensions.length);
        }
        return this.maxDimensions;
    }

    HDF5StorageLayout getLayout() {
        return this.layout;
    }

    int getRank() {
        return this.dimensions.length;
    }

    int getFullRank() {
        if (this.fullRank == -1) {
            this.fullRank = this.baseReader.getRank(this.dataSetPath);
        }
        return this.fullRank;
    }

    void extend(long[] requiredDimensions) {
        long[] newDimensions = this.h5.computeNewDimensions(this.dimensions, requiredDimensions, false);
        if (!Arrays.equals(this.dimensions, newDimensions)) {
            this.closeDataSpaceId();
            this.h5.extendDataSet(this, newDimensions, false);
            this.dimensions = newDimensions;
            this.dataSpaceId = this.h5.getDataSpaceForDataSet(this.dataSetId, null);
        }
    }

    long getDataTypeId() {
        if (this.dataTypeId == -1L) {
            this.dataTypeId = H5.H5Dget_type(this.dataSetId);
        }
        return this.dataTypeId;
    }

    @Override
    public void close() {
        this.closeDataSetId();
        this.closeDataSpaceId();
        this.closeMemorySpaceId();
        this.closeDataTypeId();
    }

    private void closeDataTypeId() {
        if (this.dataTypeId > -1L) {
            H5.H5Tclose(this.dataTypeId);
            this.dataTypeId = -1L;
        }
    }

    private void closeDataSetId() {
        if (this.dataSetId > 0L) {
            H5.H5Dclose(this.dataSetId);
            this.dataSetId = -1L;
        }
    }

    private void closeDataSpaceId() {
        if (this.dataSpaceId > -1L) {
            H5.H5Sclose(this.dataSpaceId);
            this.dataSpaceId = -1L;
        }
    }

    private void closeMemorySpaceId() {
        if (this.memorySpaceId > 0L) {
            H5.H5Sclose(this.memorySpaceId);
            this.memoryBlockDimensions = null;
            this.memorySpaceId = -1L;
        }
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.dataSetPath == null ? 0 : this.dataSetPath.hashCode());
        result = 31 * result + (int)this.dataSetId;
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDF5DataSet other = (HDF5DataSet)obj;
        if (this.dataSetPath == null ? other.dataSetPath != null : !this.dataSetPath.equals(other.dataSetPath)) {
            return false;
        }
        return this.dataSetId == other.dataSetId;
    }
}

