/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import java.nio.ByteBuffer;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class BufferAlignmentWriteTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
    }

    @Test
    public void testWriteArrayOffEnd() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.write(new byte[]{1});
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteArrayTwiceOffEnd() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.write(new byte[]{1});
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.length());
        this.fileHandle.write(new byte[]{1});
        AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteBufferOffEnd() throws IOException {
        this.fileHandle.seek(16L);
        ByteBuffer b = ByteBuffer.allocate(1).put((byte)1);
        this.fileHandle.write(b);
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteBufferTwiceOffEnd() throws IOException {
        this.fileHandle.seek(16L);
        ByteBuffer b = ByteBuffer.allocate(1).put((byte)1);
        this.fileHandle.write(b);
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.length());
        b.position(0);
        this.fileHandle.write(b);
        AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteOffEndSubArray() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.write(new byte[]{0, 1}, 1, 1);
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteTwiceOffEndSubArray() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.write(new byte[]{0, 1}, 1, 1);
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.length());
        this.fileHandle.write(new byte[]{0, 1}, 1, 1);
        AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteOffEndSubBuffer() throws IOException {
        this.fileHandle.seek(16L);
        ByteBuffer b = ByteBuffer.allocate(2);
        b.put((byte)0);
        b.put((byte)1);
        this.fileHandle.write(b, 1, 1);
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }

    @Test
    public void testWriteTwiceOffEndSubBuffer() throws IOException {
        this.fileHandle.seek(16L);
        ByteBuffer b = ByteBuffer.allocate(2);
        b.put((byte)0);
        b.put((byte)1);
        this.fileHandle.write(b, 1, 1);
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)17L, (long)this.fileHandle.length());
        this.fileHandle.write(b, 1, 1);
        AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((long)18L, (long)this.fileHandle.length());
        this.fileHandle.seek(16L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readByte());
    }
}

