/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.Collection;
import loci.common.IniList;
import loci.common.IniParser;
import loci.common.IniTable;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class IniParserTest {
    private final IniParser parser = new IniParser();
    private final Charset utf8charset = Charset.forName("UTF-8");

    public BufferedReader stringToBufferedReader(String s) {
        ByteArrayInputStream stream = new ByteArrayInputStream(s.getBytes(this.utf8charset));
        return new BufferedReader(new InputStreamReader(stream));
    }

    @DataProvider(name="simplekeyvalue")
    public Object[][] createSimpleKeyValuePair() {
        return new Object[][]{{"key=value"}, {"key = value"}, {"key=value  "}, {"  key=value"}, {"key=value#comment"}, {"key=value # comment"}};
    }

    @Test(dataProvider="simplekeyvalue")
    public void testSimpleKeyValue(String s) throws IOException {
        BufferedReader reader = this.stringToBufferedReader(s);
        IniTable table = new IniTable();
        table.put((Object)"header", (Object)"DEFAULT_HEADER");
        table.put((Object)"key", (Object)"value");
        IniList list = new IniList();
        list.add((Object)table);
        Assert.assertEquals((Collection)this.parser.parseINI(reader), (Collection)list);
    }

    @DataProvider(name="simpleheader")
    public Object[][] createSimpleHeader() {
        return new Object[][]{{"key=value", "DEFAULT_HEADER"}, {"[\nkey=value", "DEFAULT_HEADER"}, {"{\nkey=value", "DEFAULT_HEADER"}, {"{chapter}\nkey=value", "DEFAULT_HEADER"}, {"{}\nkey=value", "DEFAULT_HEADER"}, {"[]\nkey=value", ""}, {"[header]\nkey=value", "header"}, {"[ header ]\nkey=value", " header "}, {"[header\nkey=value", "header"}, {"[[header]]\nkey=value", "[header]"}, {"{chapter}\n[header]\nkey=value", "chapter: header"}, {"{chapter\n[header\nkey=value", "chapter: header"}};
    }

    @Test(dataProvider="simpleheader")
    public void testHeader(String s, String header) throws IOException {
        BufferedReader reader = this.stringToBufferedReader(s);
        IniTable table = new IniTable();
        table.put((Object)"header", (Object)header);
        table.put((Object)"key", (Object)"value");
        IniList list = new IniList();
        list.add((Object)table);
        Assert.assertEquals((Collection)this.parser.parseINI(reader), (Collection)list);
    }

    @DataProvider(name="invalidheader")
    public Object[][] createSingleString() {
        return new Object[][]{{"["}, {"{"}};
    }

    @Test(dataProvider="invalidheader")
    public void testInvalidHeader(String s) throws IOException {
        BufferedReader reader = this.stringToBufferedReader(s);
        IniTable table = new IniTable();
        table.put((Object)"header", (Object)"DEFAULT_HEADER");
        IniList list = new IniList();
        list.add((Object)table);
        Assert.assertEquals((Collection)this.parser.parseINI(reader), (Collection)list);
    }

    public void testEmptyString() throws IOException {
        BufferedReader reader = this.stringToBufferedReader("");
        Assert.assertEquals((Object)this.parser.parseINI(reader), (Object)new IniTable());
    }

    public void testNull() throws IOException {
        BufferedReader reader = this.stringToBufferedReader(null);
        Assert.assertEquals((Object)this.parser.parseINI(reader), (Object)new IniTable());
    }

    public void testEmptyKeyValue() throws IOException {
        BufferedReader reader = this.stringToBufferedReader("=");
        IniTable table = new IniTable();
        table.put((Object)"header", (Object)"DEFAULT_HEADER");
        table.put((Object)"", (Object)"");
        IniList list = new IniList();
        list.add((Object)table);
        Assert.assertEquals((Collection)this.parser.parseINI(reader), (Collection)list);
    }

    @Test
    public void testMultiValueINI() throws IOException {
        String s = "key1=value1 # comment\n\nkey2=line1\\\nline2\nignored line\nkey3 = value3";
        BufferedReader reader = this.stringToBufferedReader(s);
        IniTable table = new IniTable();
        table.put((Object)"header", (Object)"DEFAULT_HEADER");
        table.put((Object)"key1", (Object)"value1");
        table.put((Object)"key2", (Object)"line1 line2");
        table.put((Object)"key3", (Object)"value3");
        IniList list = new IniList();
        list.add((Object)table);
        Assert.assertEquals((Collection)this.parser.parseINI(reader), (Collection)list);
    }

    @Test
    public void testMultiHeaderINI() throws IOException {
        String s = "key0=value0\n[header1]\nkey1=value1\n{chapter}\n[header2]\nkey2=value2\n[header3]\nkey3=value3\n";
        BufferedReader reader = this.stringToBufferedReader(s);
        IniTable table0 = new IniTable();
        table0.put((Object)"header", (Object)"DEFAULT_HEADER");
        table0.put((Object)"key0", (Object)"value0");
        IniTable table1 = new IniTable();
        table1.put((Object)"header", (Object)"header1");
        table1.put((Object)"key1", (Object)"value1");
        IniTable table2 = new IniTable();
        table2.put((Object)"header", (Object)"chapter: header2");
        table2.put((Object)"key2", (Object)"value2");
        IniTable table3 = new IniTable();
        table3.put((Object)"header", (Object)"chapter: header3");
        table3.put((Object)"key3", (Object)"value3");
        IniList list = new IniList();
        list.add((Object)table0);
        list.add((Object)table1);
        list.add((Object)table2);
        list.add((Object)table3);
        Assert.assertEquals((Collection)this.parser.parseINI(reader), (Collection)list);
    }
}

