/*
 * Decompiled with CFR 0.152.
 */
package com.bc.zarr;

import com.bc.zarr.ArrayParams;
import com.bc.zarr.ZarrArray;
import com.bc.zarr.ZarrPath;
import com.bc.zarr.ZarrUtils;
import com.bc.zarr.storage.FileSystemStore;
import com.bc.zarr.storage.InMemoryStore;
import com.bc.zarr.storage.Store;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

public class ZarrGroup {
    private final Store store;
    private final ZarrPath relativePath;

    public static ZarrGroup create() throws IOException {
        return ZarrGroup.create((String)null);
    }

    public static ZarrGroup create(String path) throws IOException {
        return ZarrGroup.create(path, null);
    }

    public static ZarrGroup create(String path, Map<String, Object> attributes) throws IOException {
        if (path == null) {
            return ZarrGroup.create(new InMemoryStore(), attributes);
        }
        return ZarrGroup.create(Paths.get(path, new String[0]), attributes);
    }

    public static ZarrGroup create(Path fileSystemPath) throws IOException {
        return ZarrGroup.create(fileSystemPath, null);
    }

    public static ZarrGroup create(Path fileSystemPath, Map<String, Object> attributes) throws IOException {
        return ZarrGroup.create(new FileSystemStore(fileSystemPath), attributes);
    }

    public static ZarrGroup create(Store store) throws IOException {
        return ZarrGroup.create(store, null);
    }

    public static ZarrGroup create(Store store, Map<String, Object> attributes) throws IOException {
        ZarrGroup zarrGroup = new ZarrGroup(store);
        zarrGroup.createHeader();
        zarrGroup.writeAttributes(attributes);
        return zarrGroup;
    }

    public static ZarrGroup open(String path) throws IOException {
        if (path == null) {
            return ZarrGroup.create();
        }
        return ZarrGroup.open(Paths.get(path, new String[0]));
    }

    public static ZarrGroup open(Path fileSystemPath) throws IOException {
        if (fileSystemPath == null) {
            return ZarrGroup.create();
        }
        ZarrUtils.ensureDirectory(fileSystemPath);
        return ZarrGroup.open(new FileSystemStore(fileSystemPath));
    }

    public static ZarrGroup open(Store store) throws IOException {
        if (store == null) {
            return ZarrGroup.create();
        }
        ZarrGroup.validateGroupToBeOpened(store, new ZarrPath(""));
        return new ZarrGroup(store);
    }

    private static void validateGroupToBeOpened(Store store, ZarrPath relativePath) throws IOException {
        try (InputStream is = store.getInputStream(relativePath.resolve((String)".zgroup").storeKey);){
            if (is == null) {
                throw new IOException("'.zgroup' expected but is not readable or missing in store.");
            }
            ZarrGroup.ensureZarrFormatIs2(is);
        }
    }

    private static void ensureZarrFormatIs2(InputStream is) throws IOException {
        try (InputStreamReader in = new InputStreamReader(is);
             BufferedReader reader = new BufferedReader(in);){
            ZarrFormat fromJson = ZarrUtils.fromJson(reader, ZarrFormat.class);
            if (fromJson.zarr_format != 2.0) {
                throw new IOException("Zarr format 2 expected but is '" + fromJson.zarr_format + "'");
            }
        }
    }

    public ZarrGroup createSubGroup(String subGroupName) throws IOException {
        return this.createSubGroup(subGroupName, null);
    }

    public ZarrGroup createSubGroup(String subGroupName, Map<String, Object> attributes) throws IOException {
        ZarrPath relativePath = this.relativePath.resolve(subGroupName);
        ZarrGroup group = new ZarrGroup(this.store, relativePath);
        group.createHeader();
        group.writeAttributes(attributes);
        return group;
    }

    public ZarrGroup openSubGroup(String subGroupName) throws IOException {
        ZarrPath relativePath = this.relativePath.resolve(subGroupName);
        ZarrGroup.validateGroupToBeOpened(this.store, relativePath);
        return new ZarrGroup(this.store, relativePath);
    }

    private ZarrGroup(Store store) {
        this.relativePath = new ZarrPath("");
        this.store = store;
    }

    private ZarrGroup(Store store, ZarrPath relativePath) {
        this.relativePath = relativePath;
        this.store = store;
    }

    public ZarrArray createArray(String name, ArrayParams params) throws IOException {
        return this.createArray(name, params, null);
    }

    public ZarrArray createArray(String name, ArrayParams params, Map<String, Object> attributes) throws IOException {
        ZarrPath relativePath = this.relativePath.resolve(name);
        return ZarrArray.create(relativePath, this.store, params, attributes);
    }

    public ZarrArray openArray(String name) throws IOException {
        ZarrPath relativePath = this.relativePath.resolve(name);
        return ZarrArray.open(relativePath, this.store);
    }

    public Set<String> getArrayKeys() throws IOException {
        return this.store.getArrayKeys();
    }

    public Set<String> getGroupKeys() throws IOException {
        TreeSet<String> groupKeys = this.store.getGroupKeys();
        groupKeys.remove("");
        return groupKeys;
    }

    public void writeAttributes(Map<String, Object> attributes) throws IOException {
        ZarrUtils.writeAttributes(attributes, this.relativePath, this.store);
    }

    public Map<String, Object> getAttributes() throws IOException {
        return ZarrUtils.readAttributes(this.relativePath, this.store);
    }

    public String toString() {
        return this.getClass().getCanonicalName() + "{'/" + this.relativePath.storeKey + "'}";
    }

    private void createHeader() throws IOException {
        Map<String, Integer> singletonMap = Collections.singletonMap("zarr_format", 2);
        ZarrPath headerPath = this.relativePath.resolve(".zgroup");
        try (OutputStream os = this.store.getOutputStream(headerPath.storeKey);
             OutputStreamWriter writer = new OutputStreamWriter(os);){
            ZarrUtils.toJson(singletonMap, writer, true);
        }
    }

    private static final class ZarrFormat {
        public double zarr_format;

        private ZarrFormat() {
        }
    }
}

