/*
 * Decompiled with CFR 0.152.
 */
package spec.schema;

import java.io.File;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.xml.transform.stream.StreamSource;
import ome.specification.OmeValidator;
import ome.specification.XMLMockObjects;
import ome.specification.XMLWriter;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import spec.AbstractTest;

public class SchemaCurrent_TO_2008_02_Test
extends AbstractTest {
    private List<File> files;
    private InputStream STYLESHEET_A;
    private InputStream STYLESHEET_B;
    private InputStream STYLESHEET_C;
    private StreamSource[] schemaArray;
    private OmeValidator anOmeValidator = new OmeValidator();

    private void checkImageNode(Node destNode, Node srcNode) {
        int i;
        String name;
        Node n;
        Assert.assertNotNull((Object)destNode);
        Assert.assertNotNull((Object)srcNode);
        NamedNodeMap attributesSrc = srcNode.getAttributes();
        String nameSrc = "";
        String idSrc = "";
        for (int i2 = 0; i2 < attributesSrc.getLength(); ++i2) {
            n = attributesSrc.item(i2);
            name = n.getNodeName();
            if (name.equals("ID")) {
                idSrc = n.getNodeValue();
                continue;
            }
            if (!name.equals("Name")) continue;
            nameSrc = n.getNodeValue();
        }
        NamedNodeMap attributes = destNode.getAttributes();
        for (int i3 = 0; i3 < attributes.getLength(); ++i3) {
            n = attributes.item(i3);
            if (n == null) continue;
            name = n.getNodeName();
            if (name.equals("ID")) {
                Assert.assertEquals((String)n.getNodeValue(), (String)idSrc);
                continue;
            }
            if (!name.equals("Name")) continue;
            Assert.assertEquals((String)n.getNodeValue(), (String)nameSrc);
        }
        Node pixelsNode = null;
        NodeList list = srcNode.getChildNodes();
        for (i = 0; i < list.getLength(); ++i) {
            n = list.item(i);
            if (n == null || !(name = n.getNodeName()).contains("Pixels")) continue;
            pixelsNode = n;
        }
        list = destNode.getChildNodes();
        for (i = 0; i < list.getLength(); ++i) {
            n = list.item(i);
            if (n == null || !(name = n.getNodeName()).contains("Pixels")) continue;
            this.checkPixelsNode(n, pixelsNode);
        }
    }

    private void checkPixelsNode(Node destNode, Node srcNode) {
        int i;
        String name;
        Node n;
        NamedNodeMap attributesSrc = srcNode.getAttributes();
        String nameSrc = "";
        String idSrc = "";
        String sizeX = "";
        String sizeY = "";
        String sizeZ = "";
        String sizeC = "";
        String sizeT = "";
        String pixelsType = "";
        String dimensionOrder = "";
        for (int i2 = 0; i2 < attributesSrc.getLength(); ++i2) {
            n = attributesSrc.item(i2);
            name = n.getNodeName();
            if (name.equals("ID")) {
                idSrc = n.getNodeValue();
                continue;
            }
            if (name.equals("Name")) {
                nameSrc = n.getNodeValue();
                continue;
            }
            if (name.equals("SizeX")) {
                sizeX = n.getNodeValue();
                continue;
            }
            if (name.equals("SizeY")) {
                sizeY = n.getNodeValue();
                continue;
            }
            if (name.equals("SizeZ")) {
                sizeZ = n.getNodeValue();
                continue;
            }
            if (name.equals("SizeC")) {
                sizeC = n.getNodeValue();
                continue;
            }
            if (name.equals("SizeT")) {
                sizeT = n.getNodeValue();
                continue;
            }
            if (name.equals("PixelType")) {
                pixelsType = n.getNodeValue();
                continue;
            }
            if (!name.equals("DimensionOrder")) continue;
            dimensionOrder = n.getNodeValue();
        }
        String bigEndianDst = "";
        NamedNodeMap attributes = destNode.getAttributes();
        for (int i3 = 0; i3 < attributes.getLength(); ++i3) {
            n = attributes.item(i3);
            if (n == null) continue;
            name = n.getNodeName();
            if (name.equals("ID")) {
                Assert.assertEquals((String)n.getNodeValue(), (String)idSrc);
                continue;
            }
            if (name.equals("Name")) {
                Assert.assertEquals((String)n.getNodeValue(), (String)nameSrc);
                continue;
            }
            if (name.equals("SizeX")) {
                Assert.assertEquals((String)n.getNodeValue(), (String)sizeX);
                continue;
            }
            if (name.equals("SizeY")) {
                Assert.assertEquals((String)n.getNodeValue(), (String)sizeY);
                continue;
            }
            if (name.equals("SizeZ")) {
                Assert.assertEquals((String)n.getNodeValue(), (String)sizeZ);
                continue;
            }
            if (name.equals("SizeC")) {
                Assert.assertEquals((String)n.getNodeValue(), (String)sizeC);
                continue;
            }
            if (name.equals("SizeT")) {
                Assert.assertEquals((String)n.getNodeValue(), (String)sizeT);
                continue;
            }
            if (name.equals("DimensionOrder")) {
                Assert.assertEquals((String)n.getNodeValue(), (String)dimensionOrder);
                continue;
            }
            if (!name.equals("BigEndian")) continue;
            bigEndianDst = n.getNodeValue();
        }
        NodeList list = srcNode.getChildNodes();
        ArrayList<Node> binDataNodeSrc = new ArrayList<Node>();
        for (int i4 = 0; i4 < list.getLength(); ++i4) {
            n = list.item(i4);
            if (n == null || !(name = n.getNodeName()).contains("BinData")) continue;
            binDataNodeSrc.add(n);
        }
        list = destNode.getChildNodes();
        ArrayList<Node> binDataNodeDest = new ArrayList<Node>();
        for (i = 0; i < list.getLength(); ++i) {
            n = list.item(i);
            if (n == null || !(name = n.getNodeName()).contains("BinData")) continue;
            binDataNodeDest.add(n);
        }
        Assert.assertTrue((binDataNodeSrc.size() > 0 ? 1 : 0) != 0);
        Assert.assertEquals((int)binDataNodeSrc.size(), (int)binDataNodeDest.size());
        for (i = 0; i < binDataNodeDest.size(); ++i) {
            this.checkBinDataNode((Node)binDataNodeDest.get(i), (Node)binDataNodeSrc.get(i));
        }
        n = (Node)binDataNodeSrc.get(0);
        attributesSrc = n.getAttributes();
        for (i = 0; i < attributesSrc.getLength(); ++i) {
            n = attributesSrc.item(i);
            if (n == null || !(name = n.getNodeName()).contains("BigEndian")) continue;
            Assert.assertEquals((String)n.getNodeValue(), (String)bigEndianDst);
        }
    }

    private void checkBinDataNode(Node destNode, Node srcNode) {
        String name;
        Node n;
        Assert.assertNotNull((Object)destNode);
        Assert.assertNotNull((Object)srcNode);
        NamedNodeMap attributesSrc = srcNode.getAttributes();
        String compression = "";
        for (int i = 0; i < attributesSrc.getLength(); ++i) {
            n = attributesSrc.item(i);
            name = n.getNodeName();
            if (!name.equals("Compression")) continue;
            compression = n.getNodeValue();
        }
        NamedNodeMap attributes = destNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            n = attributes.item(i);
            if (n == null || !(name = n.getNodeName()).equals("Compression")) continue;
            Assert.assertEquals((String)n.getNodeValue(), (String)compression);
        }
        Assert.assertEquals((String)destNode.getTextContent(), (String)srcNode.getTextContent());
    }

    @Override
    @BeforeClass
    protected void setUp() throws Exception {
        super.setUp();
        this.schemaArray = new StreamSource[1];
        this.schemaArray[0] = new StreamSource(this.getClass().getResourceAsStream("/released-schema/2008-02/ome.xsd"));
        this.STYLESHEET_A = this.getClass().getResourceAsStream("/transforms/2012-06-to-2011-06.xsl");
        this.STYLESHEET_B = this.getClass().getResourceAsStream("/transforms/2011-06-to-2010-06.xsl");
        this.STYLESHEET_C = this.getClass().getResourceAsStream("/transforms/2010-06-to-2008-02.xsl");
        this.files = new ArrayList<File>();
    }

    @Override
    @AfterClass
    public void tearDown() throws Exception {
        Iterator<File> i = this.files.iterator();
        while (i.hasNext()) {
            i.next().delete();
        }
        this.files.clear();
    }

    @Test(enabled=false)
    public void testDowngradeTo200802ImageNoMetadata() throws Exception {
        String name;
        Node n;
        int i;
        File inFile = File.createTempFile("testDowngradeTo200802ImageNoMetadata", ".ome.xml");
        this.files.add(inFile);
        File middleFileA = File.createTempFile("testDowngradeTo200802ImageNoMetadataMiddleA", ".ome.xml");
        this.files.add(middleFileA);
        File middleFileB = File.createTempFile("testDowngradeTo200802ImageNoMetadataMiddleB", ".ome.xml");
        this.files.add(middleFileB);
        File outputFile = File.createTempFile("testDowngradeTo200802ImageNoMetadataOutput", ".ome.xml");
        this.files.add(outputFile);
        XMLMockObjects xml = new XMLMockObjects();
        XMLWriter writer = new XMLWriter();
        writer.writeFile(inFile, xml.createImage(), true);
        this.transformFileWithStream(inFile, middleFileA, this.STYLESHEET_A);
        this.transformFileWithStream(middleFileA, middleFileB, this.STYLESHEET_B);
        this.transformFileWithStream(middleFileB, outputFile, this.STYLESHEET_C);
        Document doc = this.anOmeValidator.parseFileWithStreamArray(outputFile, this.schemaArray);
        Assert.assertNotNull((Object)doc);
        NodeList list = doc.getChildNodes();
        Assert.assertEquals((int)list.getLength(), (int)1);
        Node root = list.item(0);
        Assert.assertEquals((String)root.getNodeName(), (String)"OME");
        list = root.getChildNodes();
        Document docSrc = this.anOmeValidator.parseFile(inFile, null);
        Node rootSrc = docSrc.getChildNodes().item(0);
        Node imageNode = null;
        NodeList listSrc = rootSrc.getChildNodes();
        for (i = 0; i < listSrc.getLength(); ++i) {
            n = listSrc.item(i);
            name = n.getNodeName();
            if (name == null || !name.contains("Image")) continue;
            imageNode = n;
        }
        for (i = 0; i < list.getLength(); ++i) {
            n = list.item(i);
            name = n.getNodeName();
            if (name == null || !name.contains("Image") || imageNode == null) continue;
            this.checkImageNode(n, imageNode);
        }
    }
}

