/*
 * Decompiled with CFR 0.152.
 */
package loci.common;

import java.util.Locale;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.IllegalInstantException;
import org.joda.time.Instant;
import org.joda.time.ReadableInstant;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DateTools {
    public static final int UNIX = 0;
    public static final int COBOL = 1;
    public static final int MICROSOFT = 2;
    public static final int ZVI = 3;
    public static final int ALT_ZVI = 4;
    public static final long UNIX_EPOCH = 0L;
    public static final long COBOL_EPOCH = 11644473600000L;
    public static final long MICROSOFT_EPOCH = 2209143600000L;
    public static final long ZVI_EPOCH = 2921084975759000L;
    public static final long ALT_ZVI_EPOCH = 2921084284761000L;
    public static final String ISO8601_FORMAT_MS = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    public static final String ISO8601_FORMAT = "yyyy-MM-dd'T'HH:mm:ss";
    public static final String TIMESTAMP_FORMAT = "yyyy-MM-dd HH:mm:ss";
    public static final String FILENAME_FORMAT = "yyyy-MM-dd_HH-mm-ss";
    private static final DateTimeFormatter ISO8601_FORMATTER_MS = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss.SSS");
    private static final DateTimeFormatter ISO8601_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd'T'HH:mm:ss");
    private static final DateTimeFormatter TIMESTAMP_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter FILENAME_FORMATTER = DateTimeFormat.forPattern((String)"yyyy-MM-dd_HH-mm-ss");
    private static final Logger LOGGER = LoggerFactory.getLogger(DateTools.class);

    private DateTools() {
    }

    public static long getMillisFromTicks(long hi, long lo) {
        long ticks = hi << 32 | lo;
        return ticks / 10000L;
    }

    public static String convertDate(long stamp, int format) {
        return DateTools.convertDate(stamp, format, ISO8601_FORMAT);
    }

    public static String convertDate(long stamp, int format, String outputFormat) {
        return DateTools.convertDate(stamp, format, outputFormat, false);
    }

    public static String convertDate(long stamp, int format, String outputFormat, boolean correctTimeZoneForGMT) {
        long ms = stamp;
        switch (format) {
            case 0: {
                ms -= 0L;
                break;
            }
            case 1: {
                ms -= 11644473600000L;
                break;
            }
            case 2: {
                ms -= 2209143600000L;
                break;
            }
            case 3: {
                ms -= 2921084975759000L;
                break;
            }
            case 4: {
                ms -= 2921084284761000L;
            }
        }
        DateTimeFormatter fmt = DateTimeFormat.forPattern((String)outputFormat);
        try {
            if (correctTimeZoneForGMT) {
                DateTimeZone tz = DateTimeZone.getDefault();
                ms = tz.convertLocalToUTC(ms, false);
            }
        }
        catch (ArithmeticException tz) {
        }
        catch (IllegalInstantException tz) {
            // empty catch block
        }
        DateTime d = new DateTime(ms, DateTimeZone.UTC);
        return fmt.print((ReadableInstant)d);
    }

    protected static Instant parseDate(String date, String format, String separator) {
        long ms = 0L;
        int msSeparator = 0;
        String newDate = date.trim();
        if (separator != null) {
            msSeparator = date.lastIndexOf(separator);
        }
        if (msSeparator > 0) {
            newDate = date.substring(0, msSeparator);
            String msString = date.substring(msSeparator + 1);
            int postmsSeparator = 0;
            for (int pos = 0; pos < msString.length(); ++pos) {
                if (Character.isDigit(msString.charAt(pos))) continue;
                postmsSeparator = pos;
                break;
            }
            if (postmsSeparator > 0) {
                try {
                    ms = Long.parseLong(msString.substring(0, postmsSeparator));
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Failed to parse milliseconds from '{}'", (Object)ms);
                }
                newDate = newDate + msString.substring(postmsSeparator);
            } else {
                try {
                    ms = Long.parseLong(msString);
                }
                catch (NumberFormatException e) {
                    LOGGER.debug("Failed to parse milliseconds from '{}'", (Object)ms);
                }
            }
        }
        DateTimeFormatter parser = DateTimeFormat.forPattern((String)format).withZone(DateTimeZone.UTC);
        Instant timestamp = null;
        try {
            timestamp = Instant.parse((String)newDate, (DateTimeFormatter)parser);
            timestamp = timestamp.plus(ms);
        }
        catch (IllegalArgumentException e) {
            LOGGER.debug("Invalid timestamp '{}' for current locale", (Object)date);
            DateTimeFormatter usParser = parser.withLocale(Locale.US);
            try {
                timestamp = Instant.parse((String)newDate, (DateTimeFormatter)usParser);
                timestamp = timestamp.plus(ms);
            }
            catch (IllegalArgumentException | UnsupportedOperationException exc) {
                LOGGER.debug("Could not parse timestamp '{}' with EN_US locale", (Object)date, (Object)exc);
            }
        }
        catch (UnsupportedOperationException e) {
            LOGGER.debug("Error parsing timestamp '{}'", (Object)date, (Object)e);
        }
        return timestamp;
    }

    public static String formatDate(String date, String format) {
        return DateTools.formatDate(date, format, false);
    }

    public static String formatDate(String date, String format, String separator) {
        return DateTools.formatDate(date, format, false, separator);
    }

    public static String formatDate(String date, String format, boolean lenient) {
        return DateTools.formatDate(date, format, false, null);
    }

    public static String formatDate(String date, String format, boolean lenient, String separator) {
        if (date == null) {
            return null;
        }
        Instant timestamp = DateTools.parseDate(date, format, separator);
        if (timestamp == null) {
            return null;
        }
        DateTimeFormatter isoformat = timestamp.getMillis() % 1000L != 0L ? ISO8601_FORMATTER_MS : ISO8601_FORMATTER;
        return isoformat.print((ReadableInstant)timestamp);
    }

    public static String formatDate(String date, String[] formats) {
        return DateTools.formatDate(date, formats, false, null);
    }

    public static String formatDate(String date, String[] formats, boolean lenient) {
        return DateTools.formatDate(date, formats, lenient, null);
    }

    public static String formatDate(String date, String[] formats, String separator) {
        return DateTools.formatDate(date, formats, false, separator);
    }

    public static String formatDate(String date, String[] formats, boolean lenient, String separator) {
        for (int i = 0; i < formats.length; ++i) {
            String result = DateTools.formatDate(date, formats[i], lenient, separator);
            if (result == null) continue;
            return result;
        }
        return null;
    }

    public static long getTime(String date, String format) {
        return DateTools.getTime(date, format, null);
    }

    public static long getTime(String date, String format, String separator) {
        Instant timestamp = DateTools.parseDate(date, format, separator);
        if (timestamp == null) {
            return -1L;
        }
        return timestamp.getMillis();
    }

    public static String getTimestamp() {
        return TIMESTAMP_FORMATTER.print((ReadableInstant)new DateTime());
    }

    public static String getFileTimestamp() {
        return FILENAME_FORMATTER.print((ReadableInstant)new DateTime());
    }
}

