/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import java.io.IOException;
import java.util.HashMap;
import java.util.StringTokenizer;
import ucar.ma2.DataType;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.internal.dataset.conv.CSMConvention;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.ProjectionImpl;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.geoloc.projection.TransverseMercator;

public class GDVConvention
extends CSMConvention {
    private static final String CONVENTION_NAME = "GDV";
    protected ProjectionCT projCT;

    GDVConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
        this.checkForMeter = false;
    }

    @Override
    protected void augmentDataset(CancelTask cancelTask) throws IOException {
        this.projCT = this.makeProjectionCT();
        if (this.projCT != null) {
            VariableDS.Builder vb = this.makeCoordinateTransformVariable(this.projCT);
            this.rootGroup.addVariable(vb);
            String xname = this.findCoordinateName(AxisType.GeoX);
            String yname = this.findCoordinateName(AxisType.GeoY);
            if (xname != null && yname != null) {
                vb.addAttribute(new Attribute("_CoordinateAxes", xname + " " + yname));
            }
        }
    }

    @Override
    protected void identifyCoordinateAxes() {
        for (CoordSystemBuilder.VarProcess vp : this.varList) {
            String dimName;
            if (vp.isCoordinateVariable || vp.vb.dataType == DataType.STRUCTURE || (dimName = this.findAlias(vp.vb)).isEmpty()) continue;
            this.rootGroup.findDimension(dimName).ifPresent(dim -> {
                vp.isCoordinateAxis = true;
                this.parseInfo.format(" Coordinate Axis added (GDV alias) = %s for dimension %s%n", vp.vb.getFullName(), dimName);
            });
        }
        super.identifyCoordinateAxes();
        this.identifyCoordinateAxesForce();
    }

    private void identifyCoordinateAxesForce() {
        AxisType atype;
        HashMap<AxisType, CoordSystemBuilder.VarProcess> map = new HashMap<AxisType, CoordSystemBuilder.VarProcess>();
        for (CoordSystemBuilder.VarProcess vp : this.varList) {
            if (!vp.isCoordinateAxis || (atype = this.getAxisType(vp.vb)) == null) continue;
            map.put(atype, vp);
        }
        for (CoordSystemBuilder.VarProcess vp : this.varList) {
            if (vp.isCoordinateVariable || vp.vb.dataType == DataType.STRUCTURE || (atype = this.getAxisType(vp.vb)) == null || map.get((Object)atype) != null) continue;
            vp.isCoordinateAxis = true;
            this.parseInfo.format(" Coordinate Axis added (GDV forced) = %s  for axis %s%n", new Object[]{vp.vb.getFullName(), atype});
        }
    }

    private String findCoordinateName(AxisType axisType) {
        for (Variable.Builder<?> aVlist : this.rootGroup.vbuilders) {
            VariableDS.Builder ve = (VariableDS.Builder)aVlist;
            if (axisType != this.getAxisType(ve)) continue;
            return ve.getFullName();
        }
        return null;
    }

    @Override
    protected void makeCoordinateTransforms() {
        CoordSystemBuilder.VarProcess vp;
        if (this.projCT != null && (vp = this.findVarProcess(this.projCT.getName(), null)) != null) {
            vp.isCoordinateTransform = true;
            vp.ct = CoordinateTransform.builder().setPreBuilt(this.projCT);
            this.coords.addCoordinateTransform(vp.ct);
        }
        super.makeCoordinateTransforms();
    }

    @Override
    protected AxisType getAxisType(VariableDS.Builder v) {
        String vname = v.shortName;
        if (vname.equalsIgnoreCase("x") || this.findAlias(v).equalsIgnoreCase("x")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon") || vname.equalsIgnoreCase("longitude") || this.findAlias(v).equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y") || this.findAlias(v).equalsIgnoreCase("y")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat") || vname.equalsIgnoreCase("latitude") || this.findAlias(v).equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("lev") || this.findAlias(v).equalsIgnoreCase("lev") || vname.equalsIgnoreCase("level") || this.findAlias(v).equalsIgnoreCase("level")) {
            return AxisType.GeoZ;
        }
        if (vname.equalsIgnoreCase("z") || this.findAlias(v).equalsIgnoreCase("z") || vname.equalsIgnoreCase("altitude") || vname.equalsIgnoreCase("depth")) {
            return AxisType.Height;
        }
        if (vname.equalsIgnoreCase("time") || this.findAlias(v).equalsIgnoreCase("time")) {
            return AxisType.Time;
        }
        return super.getAxisType(v);
    }

    private String findAlias(Variable.Builder v) {
        String alias = v.getAttributeContainer().findAttValueIgnoreCase("coord_axis", null);
        if (alias == null) {
            alias = v.getAttributeContainer().findAttValueIgnoreCase("coord_alias", "");
        }
        return alias;
    }

    private ProjectionCT makeProjectionCT() {
        ProjectionImpl proj;
        String projection = this.rootGroup.getAttributeContainer().findAttValueIgnoreCase("projection", null);
        if (null == projection) {
            this.parseInfo.format("GDV Conventions error: NO projection name found %n", new Object[0]);
            return null;
        }
        String params = this.rootGroup.getAttributeContainer().findAttValueIgnoreCase("projection_params", null);
        if (null == params) {
            params = this.rootGroup.getAttributeContainer().findAttValueIgnoreCase("proj_params", null);
        }
        if (null == params) {
            this.parseInfo.format("GDV Conventions error: NO projection parameters found %n", new Object[0]);
            return null;
        }
        int count = 0;
        double[] p = new double[4];
        try {
            StringTokenizer stoke = new StringTokenizer(params, " ,");
            while (stoke.hasMoreTokens() && count < 4) {
                p[count++] = Double.parseDouble(stoke.nextToken());
            }
        }
        catch (NumberFormatException e) {
            StringTokenizer stoke = new StringTokenizer(params, " ,");
            while (stoke.hasMoreTokens() && count < 4) {
                stoke.nextToken();
                p[count++] = Double.parseDouble(stoke.nextToken());
            }
        }
        this.parseInfo.format("GDV Conventions projection %s params = %f %f %f %f%n", projection, p[0], p[1], p[2], p[3]);
        if (projection.equalsIgnoreCase("LambertConformal")) {
            proj = new LambertConformal(p[0], p[1], p[2], p[3]);
        } else if (projection.equalsIgnoreCase("TransverseMercator")) {
            proj = new TransverseMercator(p[0], p[1], p[2]);
        } else if (projection.equalsIgnoreCase("Stereographic") || projection.equalsIgnoreCase("Oblique_Stereographic")) {
            proj = new Stereographic(p[0], p[1], p[2]);
        } else {
            this.parseInfo.format("GDV Conventions error: Unknown projection %s%n", projection);
            return null;
        }
        return new ProjectionCT(proj.getClassName(), "FGDC", proj);
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return GDVConvention.CONVENTION_NAME;
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new GDVConvention(datasetBuilder);
        }
    }
}

