/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import loci.common.Location;
import loci.formats.FileStitcher;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.in.DynamicMetadataOptions;
import loci.formats.in.FakeReader;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FileStitcherTest {
    public static final String KEY = "test.option";
    public static final String VALUE = "foo";
    private static final int PIXEL_TYPE = 1;
    private static final int SIZE_X = 128;
    private static final int SIZE_Y = 64;
    private static final int SIZE_Z = 2;
    private static final int SIZE_T = 4;
    private static final int SIZE_C = 3;
    private static final String TEMPLATE = "%s&pixelType=%s&sizeX=%d&sizeY=%d&sizeZ=%d&sizeT=%d&sizeC=%d.fake";
    private static final String[] DIM_TAGS = new String[]{"Z", "T", "C"};
    private static final int[] DIMS = new int[]{2, 4, 3};

    public static void checkKV(IFormatReader r, String k, String expv) {
        MetadataOptions rOpt = r.getMetadataOptions();
        Assert.assertTrue((boolean)(rOpt instanceof DynamicMetadataOptions));
        String v = ((DynamicMetadataOptions)rOpt).get(k);
        Assert.assertNotNull((Object)v);
        Assert.assertEquals((String)v, (String)expv);
    }

    public static void checkKV(IFormatReader[] readers, String k, String expv) {
        for (IFormatReader r : readers) {
            FileStitcherTest.checkKV(r, k, expv);
        }
    }

    private String mkBlock(String axis, int nElem) {
        if (nElem <= 1) {
            return String.format("%s0", axis);
        }
        return String.format("%s%s0-%d%s", axis, "<", nElem - 1, ">");
    }

    private static String[] mkBasenames(String[] filenames) {
        String[] basenames = new String[filenames.length];
        for (int i = 0; i < filenames.length; ++i) {
            basenames[i] = new Location(filenames[i]).getName();
        }
        return basenames;
    }

    private static List<List<Integer>> product(List<Integer> dims) {
        ArrayList<List<Integer>> ret = new ArrayList<List<Integer>>();
        if (0 == dims.size()) {
            ret.add(new ArrayList());
        } else {
            for (int i = 0; i < dims.get(dims.size() - 1); ++i) {
                for (List<Integer> p : FileStitcherTest.product(dims.subList(0, dims.size() - 1))) {
                    p.add(i);
                    ret.add(p);
                }
            }
        }
        return ret;
    }

    private static List<Integer> range(Integer len) {
        ArrayList<Integer> ret = new ArrayList<Integer>();
        for (int i = 0; i < len; ++i) {
            ret.add(i);
        }
        return ret;
    }

    private static void check(String pattern, String[] filenames, Integer[] dims) throws IOException, FormatException {
        FileStitcher fs = new FileStitcher();
        fs.setId(pattern);
        Assert.assertEquals((String)fs.getFilePattern().getPattern(), (String)pattern);
        Assert.assertEquals((int)fs.getImageCount(), (int)24);
        Assert.assertEquals((int)fs.getSizeX(), (int)128);
        Assert.assertEquals((int)fs.getSizeY(), (int)64);
        Assert.assertEquals((int)fs.getSizeZ(), (int)2);
        Assert.assertEquals((int)fs.getSizeT(), (int)4);
        Assert.assertEquals((int)fs.getSizeC(), (int)3);
        Assert.assertEquals((int)fs.getPixelType(), (int)1);
        Assert.assertEqualsNoOrder((Object[])FileStitcherTest.mkBasenames(fs.getUsedFiles()), (Object[])filenames);
        FileStitcherTest.checkPlanes(fs, dims);
        fs.close();
    }

    private static void checkPlanes(FileStitcher fs, Integer[] dims) throws IOException, FormatException {
        ArrayList idxSets = new ArrayList();
        for (int k = 0; k < 5; ++k) {
            idxSets.add(new HashSet());
        }
        for (int i = 0; i < fs.getImageCount(); ++i) {
            int[] specialPixels = FakeReader.readSpecialPixels((byte[])fs.openBytes(i));
            for (int k = 0; k < 5; ++k) {
                ((Set)idxSets.get(k)).add(specialPixels[k]);
            }
        }
        Assert.assertEquals((Set)((Set)idxSets.get(0)), new HashSet<Integer>(FileStitcherTest.range(1)));
        Assert.assertEquals((Set)((Set)idxSets.get(1)), new HashSet<Integer>(FileStitcherTest.range(dims[0] * dims[1] * dims[2])));
        Assert.assertEquals((Set)((Set)idxSets.get(2)), new HashSet<Integer>(FileStitcherTest.range(dims[0])));
        Assert.assertEquals((Set)((Set)idxSets.get(3)), new HashSet<Integer>(FileStitcherTest.range(dims[2])));
        Assert.assertEquals((Set)((Set)idxSets.get(4)), new HashSet<Integer>(FileStitcherTest.range(dims[1])));
    }

    @DataProvider(name="dimZTC")
    public Object[][] createDimZTC() {
        return new Object[][]{{new Integer[]{2, 4, 1}}, {new Integer[]{2, 1, 3}}, {new Integer[]{1, 4, 3}}, {new Integer[]{2, 1, 1}}, {new Integer[]{1, 4, 1}}, {new Integer[]{1, 1, 3}}, {new Integer[]{1, 1, 1}}};
    }

    @DataProvider(name="levels")
    public Object[][] createLevels() {
        return new Object[][]{{MetadataLevel.MINIMUM}, {MetadataLevel.NO_OVERLAYS}, {MetadataLevel.ALL}};
    }

    @Test(dataProvider="dimZTC")
    public void testStitch(Integer[] dims) throws IOException, FormatException {
        Integer[] patternDims = new Integer[]{1, 1, 1};
        StringBuilder blocks = new StringBuilder();
        for (int i = 0; i < dims.length; ++i) {
            if (dims[i] == 1) {
                patternDims[i] = DIMS[i];
            }
            blocks.append(this.mkBlock(DIM_TAGS[i], patternDims[i]));
        }
        ArrayList<String> filenames = new ArrayList<String>();
        String ptString = FormatTools.getPixelTypeString((int)1);
        for (List<Integer> idx : FileStitcherTest.product(Arrays.asList(patternDims))) {
            String tag = String.format("Z%dT%dC%d", idx.toArray(new Integer[idx.size()]));
            filenames.add(String.format(TEMPLATE, tag, ptString, 128, 64, dims[0], dims[1], dims[2]));
        }
        String pattern = String.format(TEMPLATE, blocks.toString(), ptString, 128, 64, dims[0], dims[1], dims[2]);
        FileStitcherTest.check(pattern, filenames.toArray(new String[filenames.size()]), dims);
    }

    @Test
    public void testUnderlyingReaders() throws IOException, FormatException {
        FakeReader reader = new FakeReader();
        FileStitcher fs = new FileStitcher((IFormatReader)reader);
        Assert.assertNotNull((Object)fs.getUnderlyingReaders());
        fs.setId("test_z<0-2>.fake");
        Assert.assertNotNull((Object)fs.getUnderlyingReaders());
        fs.close();
    }

    @Test
    public void testOptionsExplicit() throws IOException, FormatException {
        DynamicMetadataOptions opt = new DynamicMetadataOptions();
        opt.set(KEY, VALUE);
        FileStitcher fs = new FileStitcher();
        fs.setMetadataOptions((MetadataOptions)opt);
        fs.setId("test_z<0-2>.fake");
        FileStitcherTest.checkKV(fs.getUnderlyingReaders(), KEY, VALUE);
        DynamicMetadataOptions newOpt = new DynamicMetadataOptions();
        String newValue = "foo_";
        newOpt.set(KEY, newValue);
        fs.setMetadataOptions((MetadataOptions)newOpt);
        FileStitcherTest.checkKV(fs.getUnderlyingReaders(), KEY, newValue);
        fs.close();
    }

    @Test(dataProvider="levels")
    public void testOptionsImplicit(MetadataLevel level) throws IOException, FormatException {
        FileStitcher fs = new FileStitcher();
        fs.getMetadataOptions().setMetadataLevel(level);
        fs.setId("test_z<0-2>.fake");
        for (IFormatReader r : fs.getUnderlyingReaders()) {
            Assert.assertEquals((Object)r.getMetadataOptions().getMetadataLevel(), (Object)level);
        }
        fs.close();
    }
}

