/*
 * Decompiled with CFR 0.152.
 */
package spec.schema;

import java.io.InputStream;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.stream.StreamSource;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.services.OMEXMLService;
import ome.specification.SchemaResolver;
import ome.units.UNITS;
import ome.xml.model.Arc;
import ome.xml.model.BinData;
import ome.xml.model.Channel;
import ome.xml.model.Detector;
import ome.xml.model.DetectorSettings;
import ome.xml.model.Dichroic;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.Laser;
import ome.xml.model.LightPath;
import ome.xml.model.LightSource;
import ome.xml.model.LightSourceSettings;
import ome.xml.model.Microscope;
import ome.xml.model.OME;
import ome.xml.model.Objective;
import ome.xml.model.Pixels;
import ome.xml.model.TransmittanceRange;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import spec.schema.samples.Instrument2011_06;

@Test(groups={"all"})
public class Schema2011_06_Instrument_Upgrade_Test {
    private static final Templates UPDATE_201106 = XMLTools.getStylesheet((String)"/transforms/2011-06-to-2012-06.xsl", SchemaResolver.class);
    private OME ome;
    private Image image0;
    private Instrument instrument0;
    private Pixels pixels0;
    private Objective objective0;
    private Channel channel0;
    private BinData bindata0;
    private Detector detector0;
    private Dichroic dichroic0;
    private Filter filter0;
    private Filter filter1;
    private Filter filter2;
    private Filter filter3;
    private FilterSet filterSet0;
    private LightSource lightsource0;
    private Laser laser0;
    private LightSource lightsource1;
    private Arc arc1;

    @BeforeClass
    public void setUp() throws Exception {
        InputStream source = this.getClass().getResourceAsStream("/spec/schema/samples/2011-06/6x4y1z1t1c8b-swatch-instrument.ome");
        ServiceFactory sf = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        String xml = XMLTools.transformXML((Source)new StreamSource(source), (Templates)UPDATE_201106);
        this.ome = (OME)service.createOMEXMLRoot(xml);
    }

    @Test
    public void testOmeNode() {
        Assert.assertNotNull((Object)this.ome);
        Assert.assertEquals((int)0, (int)this.ome.sizeOfDatasetList());
        Assert.assertEquals((int)0, (int)this.ome.sizeOfExperimenterGroupList());
        Assert.assertEquals((int)0, (int)this.ome.sizeOfExperimenterList());
        Assert.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        Assert.assertEquals((int)1, (int)this.ome.sizeOfInstrumentList());
        Assert.assertEquals((int)0, (int)this.ome.sizeOfPlateList());
        Assert.assertEquals((int)0, (int)this.ome.sizeOfProjectList());
        Assert.assertEquals((int)0, (int)this.ome.sizeOfROIList());
        Assert.assertEquals((int)0, (int)this.ome.sizeOfScreenList());
        Assert.assertNull((Object)this.ome.getCreator());
        Assert.assertNull((Object)this.ome.getUUID());
        Assert.assertNull((Object)this.ome.getStructuredAnnotations());
    }

    @Test(groups={"11-06-i-instrument"}, dependsOnMethods={"testOmeNode"})
    public void testInstrument0() {
        Assert.assertNotNull((Object)this.ome);
        this.instrument0 = this.ome.getInstrument(0);
        Assert.assertNotNull((Object)this.instrument0);
        Assert.assertEquals((int)1, (int)this.instrument0.sizeOfDetectorList());
        Assert.assertEquals((int)1, (int)this.instrument0.sizeOfDichroicList());
        Assert.assertEquals((int)4, (int)this.instrument0.sizeOfFilterList());
        Assert.assertEquals((int)1, (int)this.instrument0.sizeOfFilterSetList());
        Assert.assertEquals((int)2, (int)this.instrument0.sizeOfLightSourceList());
        Assert.assertEquals((int)1, (int)this.instrument0.sizeOfObjectiveList());
        Microscope microscope0 = this.instrument0.getMicroscope();
        Assert.assertNotNull((Object)microscope0);
        Assert.assertEquals((String)"OME Instruments", (String)microscope0.getManufacturer());
        Assert.assertEquals((String)"Lab Mk3", (String)microscope0.getModel());
        Assert.assertEquals((String)"L3-1234", (String)microscope0.getSerialNumber());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0MicroscopeType, (Object)microscope0.getType());
    }

    @Test(groups={"11-06-i-lightsource"}, dependsOnMethods={"testInstrument0"})
    public void testLightSource0() {
        Assert.assertNotNull((Object)this.ome);
        this.lightsource0 = this.instrument0.getLightSource(1);
        Assert.assertNotNull((Object)this.lightsource0);
        Assert.assertEquals((String)"OME Lights Ltd", (String)this.lightsource0.getManufacturer());
        Assert.assertEquals((String)"Ruby60", (String)this.lightsource0.getModel());
        Assert.assertEquals((String)"A654321", (String)this.lightsource0.getSerialNumber());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0LightSource0Power, (Object)this.lightsource0.getPower().value(UNITS.MILLIWATT).doubleValue());
        Assert.assertEquals((String)Laser.class.getName(), (String)this.lightsource0.getClass().getName());
        this.laser0 = (Laser)this.lightsource0;
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0LightSource0LaserType, (Object)this.laser0.getType());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0LightSource0LaserLaserMedium, (Object)this.laser0.getLaserMedium());
        Assert.assertNull((Object)this.laser0.getFrequencyMultiplication());
        Assert.assertNull((Object)this.laser0.getPockelCell());
        Assert.assertNull((Object)this.laser0.getPulse());
        Assert.assertNull((Object)this.laser0.getRepetitionRate());
        Assert.assertNull((Object)this.laser0.getTuneable());
        Assert.assertNull((Object)this.laser0.getWavelength());
    }

    @Test(groups={"11-06-i-lightsource"}, dependsOnMethods={"testInstrument0"})
    public void testLightSource1() {
        Assert.assertNotNull((Object)this.ome);
        this.lightsource1 = this.instrument0.getLightSource(0);
        Assert.assertNotNull((Object)this.lightsource1);
        Assert.assertEquals((String)"OME Lights Inc", (String)this.lightsource1.getManufacturer());
        Assert.assertEquals((String)"Arc60", (String)this.lightsource1.getModel());
        Assert.assertEquals((String)"A123456", (String)this.lightsource1.getSerialNumber());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0LightSource1Power, (Object)this.lightsource1.getPower().value(UNITS.MILLIWATT).doubleValue());
        Assert.assertEquals((String)Arc.class.getName(), (String)this.lightsource1.getClass().getName());
        this.arc1 = (Arc)this.lightsource1;
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0LightSource1ArcType, (Object)this.arc1.getType());
    }

    @Test(groups={"11-06-i-lightsourcelinks"}, dependsOnGroups={"11-06-i-lightsource"})
    public void testLaser0Pump() {
        Assert.assertNotNull((Object)this.laser0);
        Assert.assertEquals((Object)this.arc1, (Object)this.laser0.getLinkedPump());
    }

    @Test(groups={"11-06-i-filterset"}, dependsOnGroups={"11-06-i-filter", "11-06-i-dichroic"})
    public void testFilterSet0() {
        Assert.assertNotNull((Object)this.ome);
        this.filterSet0 = this.instrument0.getFilterSet(0);
        Assert.assertNotNull((Object)this.filterSet0);
        Assert.assertEquals((String)"OME Filters", (String)this.filterSet0.getManufacturer());
        Assert.assertEquals((String)"Standard Mk3", (String)this.filterSet0.getModel());
        Assert.assertEquals((String)"Lot174-A", (String)this.filterSet0.getLotNumber());
        Assert.assertNull((Object)this.filterSet0.getSerialNumber());
        Assert.assertEquals((int)1, (int)this.filterSet0.sizeOfLinkedExcitationFilterList());
        Assert.assertEquals((Object)this.filter0, (Object)this.filterSet0.getLinkedExcitationFilter(0));
        Assert.assertEquals((Object)this.dichroic0, (Object)this.filterSet0.getLinkedDichroic());
        Assert.assertEquals((int)1, (int)this.filterSet0.sizeOfLinkedEmissionFilterList());
        Assert.assertEquals((Object)this.filter1, (Object)this.filterSet0.getLinkedEmissionFilter(0));
    }

    @Test(groups={"11-06-i-filter"}, dependsOnMethods={"testInstrument0"})
    public void testFilter0() {
        Assert.assertNotNull((Object)this.ome);
        this.filter0 = this.instrument0.getFilter(0);
        Assert.assertNotNull((Object)this.filter0);
        Assert.assertEquals((String)"OME Filters Inc", (String)this.filter0.getManufacturer());
        Assert.assertEquals((String)"Model1", (String)this.filter0.getModel());
        Assert.assertEquals((String)"Disc A", (String)this.filter0.getFilterWheel());
        Assert.assertNull((Object)this.filter0.getType());
        Assert.assertNull((Object)this.filter0.getLotNumber());
        Assert.assertNull((Object)this.filter0.getSerialNumber());
        TransmittanceRange transmittanceRange = this.filter0.getTransmittanceRange();
        Assert.assertNotNull((Object)transmittanceRange);
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter0TransmittanceRangeCutIn, (Object)transmittanceRange.getCutIn());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter0TransmittanceRangeCutInTolerance, (Object)transmittanceRange.getCutInTolerance());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter0TransmittanceRangeCutOut, (Object)transmittanceRange.getCutOut());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter0TransmittanceRangeCutOutTolerance, (Object)transmittanceRange.getCutOutTolerance());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter0TransmittanceRangeTransmittance, (Object)transmittanceRange.getTransmittance());
    }

    @Test(groups={"11-06-i-filter"}, dependsOnMethods={"testInstrument0"})
    public void testFilter1() {
        Assert.assertNotNull((Object)this.ome);
        this.filter1 = this.instrument0.getFilter(1);
        Assert.assertNotNull((Object)this.filter1);
        Assert.assertEquals((String)"OME Filters Ltd", (String)this.filter1.getManufacturer());
        Assert.assertEquals((String)"Deluxe Mk4", (String)this.filter1.getModel());
        Assert.assertNull((Object)this.filter1.getFilterWheel());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter1Type, (Object)this.filter1.getType());
        Assert.assertNull((Object)this.filter1.getLotNumber());
        Assert.assertNull((Object)this.filter1.getSerialNumber());
        TransmittanceRange transmittanceRange = this.filter1.getTransmittanceRange();
        Assert.assertNotNull((Object)transmittanceRange);
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter1TransmittanceRangeCutIn, (Object)transmittanceRange.getCutIn());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter1TransmittanceRangeCutInTolerance, (Object)transmittanceRange.getCutInTolerance());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter1TransmittanceRangeCutOut, (Object)transmittanceRange.getCutOut());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter1TransmittanceRangeCutOutTolerance, (Object)transmittanceRange.getCutOutTolerance());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter1TransmittanceRangeTransmittance, (Object)transmittanceRange.getTransmittance());
    }

    @Test(groups={"11-06-i-filter"}, dependsOnMethods={"testInstrument0"})
    public void testFilter2() {
        Assert.assertNotNull((Object)this.ome);
        this.filter2 = this.instrument0.getFilter(2);
        Assert.assertNotNull((Object)this.filter2);
        Assert.assertEquals((String)"OME Filters Asc", (String)this.filter2.getManufacturer());
        Assert.assertEquals((String)"Deluxe Mk5", (String)this.filter2.getModel());
        Assert.assertNull((Object)this.filter2.getFilterWheel());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter2Type, (Object)this.filter2.getType());
        Assert.assertNull((Object)this.filter2.getLotNumber());
        Assert.assertNull((Object)this.filter2.getSerialNumber());
        TransmittanceRange transmittanceRange = this.filter2.getTransmittanceRange();
        Assert.assertNotNull((Object)transmittanceRange);
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter2TransmittanceRangeCutIn, (Object)transmittanceRange.getCutIn());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter2TransmittanceRangeCutInTolerance, (Object)transmittanceRange.getCutInTolerance());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter2TransmittanceRangeCutOut, (Object)transmittanceRange.getCutOut());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter2TransmittanceRangeCutOutTolerance, (Object)transmittanceRange.getCutOutTolerance());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter2TransmittanceRangeTransmittance, (Object)transmittanceRange.getTransmittance());
    }

    @Test(groups={"11-06-i-filter"}, dependsOnMethods={"testInstrument0"})
    public void testFilter3() {
        Assert.assertNotNull((Object)this.ome);
        this.filter3 = this.instrument0.getFilter(3);
        Assert.assertNotNull((Object)this.filter3);
        Assert.assertEquals((String)"OME Filters.Com", (String)this.filter3.getManufacturer());
        Assert.assertEquals((String)"Deluxe Mk6", (String)this.filter3.getModel());
        Assert.assertNull((Object)this.filter3.getFilterWheel());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter3Type, (Object)this.filter3.getType());
        Assert.assertNull((Object)this.filter3.getLotNumber());
        Assert.assertNull((Object)this.filter3.getSerialNumber());
        TransmittanceRange transmittanceRange = this.filter3.getTransmittanceRange();
        Assert.assertNotNull((Object)transmittanceRange);
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter3TransmittanceRangeCutIn, (Object)transmittanceRange.getCutIn());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter3TransmittanceRangeCutInTolerance, (Object)transmittanceRange.getCutInTolerance());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter3TransmittanceRangeCutOut, (Object)transmittanceRange.getCutOut());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter3TransmittanceRangeCutOutTolerance, (Object)transmittanceRange.getCutOutTolerance());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Filter3TransmittanceRangeTransmittance, (Object)transmittanceRange.getTransmittance());
    }

    @Test(groups={"11-06-i-dichroic"}, dependsOnMethods={"testInstrument0"})
    public void testDichroic0() {
        Assert.assertNotNull((Object)this.ome);
        this.dichroic0 = this.instrument0.getDichroic(0);
        Assert.assertNotNull((Object)this.dichroic0);
        Assert.assertEquals((String)"OME Instruments", (String)this.dichroic0.getManufacturer());
        Assert.assertEquals((String)"Standard Mk3", (String)this.dichroic0.getModel());
        Assert.assertNull((Object)this.dichroic0.getLotNumber());
        Assert.assertNull((Object)this.dichroic0.getSerialNumber());
    }

    @Test(groups={"11-06-i-detector"}, dependsOnMethods={"testInstrument0"})
    public void testDetector0() {
        Assert.assertNotNull((Object)this.ome);
        this.detector0 = this.instrument0.getDetector(0);
        Assert.assertNotNull((Object)this.detector0);
        Assert.assertEquals((String)"OME Detectors", (String)this.detector0.getManufacturer());
        Assert.assertEquals((String)"Standard CCD Mk2", (String)this.detector0.getModel());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0DetectorType, (Object)this.detector0.getType());
        Assert.assertNull((Object)this.detector0.getAmplificationGain());
        Assert.assertNull((Object)this.detector0.getGain());
        Assert.assertNull((Object)this.detector0.getLotNumber());
        Assert.assertNull((Object)this.detector0.getOffset());
        Assert.assertNull((Object)this.detector0.getSerialNumber());
        Assert.assertNull((Object)this.detector0.getVoltage());
        Assert.assertNull((Object)this.detector0.getZoom());
    }

    @Test(groups={"11-06-i-objective"}, dependsOnMethods={"testInstrument0"})
    public void testObjective0() {
        Assert.assertNotNull((Object)this.ome);
        this.objective0 = this.instrument0.getObjective(0);
        Assert.assertNotNull((Object)this.objective0);
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Objective0CalibratedMagnification, (Object)this.objective0.getCalibratedMagnification());
        Assert.assertEquals((String)"OME Objectives", (String)this.objective0.getManufacturer());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Objective0NominalMagnification, (Object)this.objective0.getNominalMagnification());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Objective0Correction, (Object)this.objective0.getCorrection());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Objective0Immersion, (Object)this.objective0.getImmersion());
        Assert.assertNull((Object)this.objective0.getIris());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Objective0LensNA, (Object)this.objective0.getLensNA());
        Assert.assertEquals((String)"60xUV-Air", (String)this.objective0.getModel());
        Assert.assertNull((Object)this.objective0.getSerialNumber());
        Assert.assertEquals((Object)Instrument2011_06.ref.Instrument0Objective0WorkingDistance, (Object)this.objective0.getWorkingDistance());
    }

    @Test(groups={"11-06-i-image"}, dependsOnMethods={"testOmeNode"})
    public void testImage0Name() {
        Assert.assertNotNull((Object)this.ome);
        Assert.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        this.image0 = this.ome.getImage(0);
        Assert.assertNotNull((Object)this.image0);
        Assert.assertEquals((String)"6x6x1x8-swatch.tif", (String)this.image0.getName());
    }

    @Test(groups={"11-06-i-image"}, dependsOnMethods={"testImage0Name"})
    public void testImage0Values() {
        Assert.assertNotNull((Object)this.image0);
        Assert.assertEquals((Object)"2010-02-23T12:51:30", (Object)this.image0.getAcquisitionDate());
        Assert.assertEquals((String)"This image has instrument data", (String)this.image0.getDescription());
    }

    @Test(groups={"11-06-i-image"}, dependsOnMethods={"testImage0Name"})
    public void testPixels0() {
        Assert.assertNotNull((Object)this.image0);
        this.pixels0 = this.image0.getPixels();
        Assert.assertEquals((int)1, (int)this.pixels0.sizeOfBinDataList());
        Assert.assertEquals((int)1, (int)this.pixels0.sizeOfChannelList());
        Assert.assertEquals((int)0, (int)this.pixels0.sizeOfPlaneList());
        Assert.assertEquals((int)0, (int)this.pixels0.sizeOfTiffDataList());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0DimensionOrder, (Object)this.pixels0.getDimensionOrder());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0PhysicalSizeX, (Object)this.pixels0.getPhysicalSizeX());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0PhysicalSizeY, (Object)this.pixels0.getPhysicalSizeY());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0Type, (Object)this.pixels0.getType());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0SizeC, (Object)this.pixels0.getSizeC());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0SizeT, (Object)this.pixels0.getSizeT());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0SizeX, (Object)this.pixels0.getSizeX());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0SizeY, (Object)this.pixels0.getSizeY());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0SizeZ, (Object)this.pixels0.getSizeZ());
        Assert.assertNull((Object)this.pixels0.getMetadataOnly());
        Assert.assertNull((Object)this.pixels0.getPhysicalSizeZ());
        Assert.assertNull((Object)this.pixels0.getTimeIncrement());
    }

    @Test(groups={"11-06-i-image"}, dependsOnMethods={"testPixels0"})
    public void testChannel0() {
        Assert.assertNotNull((Object)this.pixels0);
        this.channel0 = this.pixels0.getChannel(0);
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0Channel0Color, (Object)this.channel0.getColor());
        Assert.assertNull((Object)this.channel0.getContrastMethod());
        Assert.assertNull((Object)this.channel0.getEmissionWavelength());
        Assert.assertNull((Object)this.channel0.getExcitationWavelength());
        Assert.assertNull((Object)this.channel0.getFluor());
        Assert.assertNull((Object)this.channel0.getIlluminationType());
        Assert.assertNull((Object)this.channel0.getName());
        Assert.assertNull((Object)this.channel0.getNDFilter());
        Assert.assertNull((Object)this.channel0.getPinholeSize());
        Assert.assertNull((Object)this.channel0.getPockelCellSetting());
        Assert.assertNull((Object)this.channel0.getSamplesPerPixel());
        Assert.assertNull((Object)this.channel0.getAcquisitionMode());
        Assert.assertNotNull((Object)this.channel0.getLightPath());
        Assert.assertNotNull((Object)this.channel0.getLightSourceSettings());
        Assert.assertNotNull((Object)this.channel0.getDetectorSettings());
    }

    @Test(groups={"11-06-i-image"}, dependsOnMethods={"testPixels0"})
    public void testBinData0() {
        Assert.assertNotNull((Object)this.pixels0);
        this.bindata0 = this.pixels0.getBinData(0);
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0Bindata0Length, (Object)this.bindata0.getLength());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0Pixels0_0Bindata0BigEndian, (Object)this.bindata0.getBigEndian());
        Assert.assertNull((Object)this.bindata0.getCompression());
    }

    @Test(groups={"11-06-i-links"}, dependsOnGroups={"11-06-i-image", "11-06-i-instrument", "11-06-i-lightsourcelinks", "11-06-i-filterset", "11-06-i-detector"})
    public void testImage0Linkage() {
        Assert.assertNotNull((Object)this.image0);
        Assert.assertEquals((int)0, (int)this.image0.sizeOfLinkedAnnotationList());
        Assert.assertEquals((int)0, (int)this.image0.sizeOfLinkedROIList());
        Assert.assertEquals((Object)this.instrument0, (Object)this.image0.getLinkedInstrument());
    }

    @Test(groups={"11-06-i-links"}, dependsOnGroups={"11-06-i-image", "11-06-i-lightsource"})
    public void testChannel0ToLightsourceSettings() {
        Assert.assertNotNull((Object)this.channel0);
        LightSourceSettings lightsourceSettings = this.channel0.getLightSourceSettings();
        Assert.assertNotNull((Object)lightsourceSettings);
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0LightSourceSettings0Attenuation, (Object)lightsourceSettings.getAttenuation());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0LightSourceSettings0Wavelength, (Object)lightsourceSettings.getWavelength());
        Assert.assertNull((Object)lightsourceSettings.getMicrobeamManipulation());
    }

    @Test(enabled=false, groups={"11-06-i-links"}, dependsOnGroups={"11-06-i-image", "11-06-i-lightsource"})
    public void testChannel0ToLightsourceLinkage() {
        Assert.assertNotNull((Object)this.channel0);
        LightSourceSettings lightsourceSettings = this.channel0.getLightSourceSettings();
        Assert.assertNotNull((Object)lightsourceSettings);
        Assert.assertNotNull((Object)lightsourceSettings.getLightSource());
        Assert.assertEquals((Object)this.lightsource0, (Object)lightsourceSettings.getLightSource());
    }

    @Test(groups={"11-06-i-links"}, dependsOnGroups={"11-06-i-image", "11-06-i-filter"})
    public void testChannel0LightpathLinkage() {
        Assert.assertNotNull((Object)this.channel0);
        LightPath lightpath = this.channel0.getLightPath();
        Assert.assertNotNull((Object)lightpath);
        Assert.assertEquals((int)1, (int)lightpath.sizeOfLinkedExcitationFilterList());
        Assert.assertEquals((Object)this.filter3, (Object)lightpath.getLinkedExcitationFilter(0));
        Assert.assertNull((Object)lightpath.getLinkedDichroic());
        Assert.assertEquals((int)1, (int)lightpath.sizeOfLinkedEmissionFilterList());
        Assert.assertEquals((Object)this.filter2, (Object)lightpath.getLinkedEmissionFilter(0));
    }

    @Test(groups={"11-06-i-links"}, dependsOnGroups={"11-06-i-image", "11-06-i-detector"})
    public void testChannel0DetectorSettings() {
        Assert.assertNotNull((Object)this.channel0);
        DetectorSettings detectorSettings = this.channel0.getDetectorSettings();
        Assert.assertNotNull((Object)detectorSettings);
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0DetectorSettings0Binning, (Object)detectorSettings.getBinning());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0DetectorSettings0Gain, (Object)detectorSettings.getGain());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0DetectorSettings0Offset, (Object)detectorSettings.getOffset());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0DetectorSettings0ReadOutRate, (Object)detectorSettings.getReadOutRate());
        Assert.assertEquals((Object)Instrument2011_06.ref.Image0DetectorSettings0Voltage, (Object)detectorSettings.getVoltage().value());
    }

    @Test(enabled=false, groups={"11-06-i-links"}, dependsOnGroups={"11-06-i-image", "11-06-i-detector"})
    public void testChannel0ToDetectorLinkage() {
        Assert.assertNotNull((Object)this.channel0);
        DetectorSettings detectorSettings = this.channel0.getDetectorSettings();
        Assert.assertNotNull((Object)detectorSettings);
        Assert.assertNotNull((Object)detectorSettings.getDetector());
        Assert.assertEquals((Object)this.detector0, (Object)detectorSettings.getDetector());
    }
}

