/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDAbstractArray;
import ch.systemsx.cisd.hdf5.CharacterEncoding;
import ch.systemsx.cisd.hdf5.HDF5CompoundByteifyerFactory;
import ch.systemsx.cisd.hdf5.HDF5DataClass;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.HDF5Utils;
import ch.systemsx.cisd.hdf5.hdf5lib.HDFHelper;
import java.util.Objects;

public final class HDF5DataTypeInformation {
    private final boolean arrayType;
    private final boolean signed;
    private final boolean variableLengthString;
    private final String dataTypePathOrNull;
    private final String nameOrNull;
    private final HDF5DataClass dataClass;
    private int elementSize;
    private int numberOfElements;
    private CharacterEncoding encoding;
    private int[] dimensions;
    private String opaqueTagOrNull;
    private final DataTypeInfoOptions options;
    private HDF5DataTypeVariant typeVariantOrNull;

    public static DataTypeInfoOptions options() {
        return new DataTypeInfoOptions();
    }

    HDF5DataTypeInformation(String dataTypePathOrNull, DataTypeInfoOptions options, HDF5DataClass dataClass, String houseKeepingNameSuffix, int elementSize, boolean signed) {
        this(dataTypePathOrNull, options, dataClass, CharacterEncoding.ASCII, houseKeepingNameSuffix, elementSize, 1, new int[0], false, signed, false, null);
    }

    HDF5DataTypeInformation(HDF5DataClass dataClass, String houseKeepingNameSuffix, int elementSize, boolean signed) {
        this(null, DataTypeInfoOptions.ALL, dataClass, CharacterEncoding.ASCII, houseKeepingNameSuffix, elementSize, 1, new int[0], false, signed, false, null);
    }

    HDF5DataTypeInformation(HDF5DataClass dataClass, String houseKeepingNameSuffix, int elementSize, int numberOfElements, boolean signed) {
        this(null, DataTypeInfoOptions.ALL, dataClass, CharacterEncoding.ASCII, houseKeepingNameSuffix, elementSize, numberOfElements, new int[]{numberOfElements}, false, signed, false, null);
    }

    HDF5DataTypeInformation(String dataTypePathOrNull, DataTypeInfoOptions options, HDF5DataClass dataClass, CharacterEncoding encoding, String houseKeepingNameSuffix, int elementSize, boolean signed, boolean variableLengthString, String opaqueTagOrNull) {
        this(dataTypePathOrNull, options, dataClass, encoding, houseKeepingNameSuffix, elementSize, 1, new int[0], false, signed, variableLengthString, opaqueTagOrNull);
    }

    HDF5DataTypeInformation(String dataTypePathOrNull, DataTypeInfoOptions options, HDF5DataClass dataClass, CharacterEncoding encoding, String houseKeepingNameSuffix, int elementSize, int[] dimensions, boolean arrayType, boolean signed, boolean variableLengthString) {
        this(dataTypePathOrNull, options, dataClass, encoding, houseKeepingNameSuffix, elementSize, MDAbstractArray.getLength(dimensions), dimensions, arrayType, signed, variableLengthString, null);
    }

    private HDF5DataTypeInformation(String dataTypePathOrNull, DataTypeInfoOptions options, HDF5DataClass dataClass, CharacterEncoding encoding, String houseKeepingNameSuffix, int elementSize, int numberOfElements, int[] dimensions, boolean arrayType, boolean signed, boolean variableLengthString, String opaqueTagOrNull) {
        if (dataClass == HDF5DataClass.BOOLEAN || dataClass == HDF5DataClass.STRING) {
            this.dataTypePathOrNull = null;
            this.nameOrNull = null;
        } else {
            this.dataTypePathOrNull = dataTypePathOrNull;
            this.nameOrNull = HDF5Utils.tryGetDataTypeNameFromPath(dataTypePathOrNull, houseKeepingNameSuffix, dataClass);
        }
        this.arrayType = arrayType;
        this.signed = signed;
        this.variableLengthString = variableLengthString;
        this.dataClass = dataClass;
        this.elementSize = elementSize;
        this.numberOfElements = numberOfElements;
        this.dimensions = dimensions;
        this.encoding = encoding;
        this.opaqueTagOrNull = opaqueTagOrNull;
        this.options = options;
    }

    public HDF5DataClass getRawDataClass() {
        return this.dataClass;
    }

    public HDF5DataClass getDataClass() {
        if (this.typeVariantOrNull == HDF5DataTypeVariant.ENUM) {
            return HDF5DataClass.ENUM;
        }
        if (this.typeVariantOrNull == HDF5DataTypeVariant.BITFIELD) {
            return HDF5DataClass.BITFIELD;
        }
        return this.dataClass;
    }

    public int getElementSize() {
        return this.elementSize;
    }

    public int getUsableLength() {
        if (this.dataClass == HDF5DataClass.STRING && this.elementSize > 0) {
            return this.variableLengthString ? -1 : this.elementSize / this.encoding.getMaxBytesPerChar();
        }
        return this.elementSize;
    }

    public int getElementSizeForPadding() {
        if (this.variableLengthString) {
            return HDFHelper.getMachineWordSize();
        }
        if (this.dataClass == HDF5DataClass.STRING) {
            return 1;
        }
        return this.elementSize;
    }

    void setElementSize(int elementSize) {
        this.elementSize = elementSize;
    }

    public int getNumberOfElements() {
        return this.numberOfElements;
    }

    public int getSize() {
        return this.elementSize * this.numberOfElements;
    }

    public int getRank() {
        return this.dimensions.length;
    }

    public int[] getDimensions() {
        return this.dimensions;
    }

    void setDimensions(int[] dimensions) {
        this.dimensions = dimensions;
        this.numberOfElements = MDAbstractArray.getLength(dimensions);
    }

    public boolean isArrayType() {
        return this.arrayType;
    }

    public boolean isSigned() {
        return this.signed;
    }

    public boolean isVariableLengthString() {
        return this.variableLengthString;
    }

    public String tryGetOpaqueTag() {
        return this.opaqueTagOrNull;
    }

    public boolean knowsDataTypePath() {
        return this.options.knowsDataTypePath();
    }

    public String tryGetDataTypePath() {
        return this.dataTypePathOrNull;
    }

    public String tryGetName() {
        return this.nameOrNull;
    }

    public boolean knowsDataTypeVariant() {
        return this.options.knowsDataTypeVariant;
    }

    public HDF5DataTypeVariant tryGetTypeVariant() {
        if (this.typeVariantOrNull == null && this.options.knowsDataTypeVariant()) {
            return HDF5DataTypeVariant.NONE;
        }
        return this.typeVariantOrNull;
    }

    private HDF5DataTypeVariant tryGetTypeVariantReplaceNoneWithNull() {
        return this.typeVariantOrNull == HDF5DataTypeVariant.NONE ? null : this.typeVariantOrNull;
    }

    void setTypeVariant(HDF5DataTypeVariant typeVariant) {
        this.typeVariantOrNull = typeVariant;
    }

    public boolean isTimeStamp() {
        return this.typeVariantOrNull != null ? this.typeVariantOrNull.isTimeStamp() : false;
    }

    public boolean isTimeDuration() {
        return this.typeVariantOrNull != null ? this.typeVariantOrNull.isTimeDuration() : false;
    }

    public HDF5TimeUnit tryGetTimeUnit() {
        return this.typeVariantOrNull != null ? this.typeVariantOrNull.tryGetTimeUnit() : null;
    }

    public boolean isEnum() {
        return this.getDataClass() == HDF5DataClass.ENUM;
    }

    public boolean isBitField() {
        return this.getDataClass() == HDF5DataClass.BITFIELD;
    }

    public Class<?> tryGetJavaType() {
        int rank = this.dimensions.length == 1 && this.dimensions[0] == 1 ? 0 : this.dimensions.length;
        Class<?> overrideDataTypeOrNull = HDF5CompoundByteifyerFactory.tryGetOverrideJavaType(this.dataClass, rank, this.elementSize, this.typeVariantOrNull);
        if (overrideDataTypeOrNull != null) {
            return overrideDataTypeOrNull;
        }
        return this.dataClass.getJavaTypeProvider().tryGetJavaType(rank, this.elementSize, this.typeVariantOrNull);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HDF5DataTypeInformation)) {
            return false;
        }
        HDF5DataTypeInformation that = (HDF5DataTypeInformation)obj;
        HDF5DataTypeVariant thisTypeVariant = this.tryGetTypeVariant();
        HDF5DataTypeVariant thatTypeVariant = that.tryGetTypeVariant();
        return this.dataClass.equals((Object)that.dataClass) && this.elementSize == that.elementSize && this.encoding == that.encoding && this.numberOfElements == that.numberOfElements && Objects.equals(this.nameOrNull, that.nameOrNull) && Objects.equals(this.dataTypePathOrNull, that.dataTypePathOrNull) && Objects.equals((Object)thisTypeVariant, (Object)thatTypeVariant);
    }

    public int hashCode() {
        HDF5DataTypeVariant typeVariant = this.tryGetTypeVariant();
        return (((((1003 + this.dataClass.hashCode()) * 59 + this.elementSize) * 59 + Objects.hashCode((Object)this.encoding)) * 59 + this.numberOfElements) * 59 + Objects.hashCode(this.nameOrNull)) * 59 + Objects.hashCode(this.dataTypePathOrNull) * 59 + Objects.hashCode((Object)typeVariant);
    }

    public String toString() {
        String name = this.nameOrNull != null ? "<" + this.nameOrNull + ">" : "";
        HDF5DataTypeVariant variantOrNull = this.tryGetTypeVariantReplaceNoneWithNull();
        if (this.numberOfElements == 1) {
            if (variantOrNull != null) {
                return String.valueOf(name) + (Object)((Object)this.dataClass) + "(" + this.getUsableLength() + ")/" + variantOrNull.toString();
            }
            return String.valueOf(name) + (Object)((Object)this.dataClass) + "(" + this.getUsableLength() + ")";
        }
        if (this.dimensions.length == 1) {
            if (variantOrNull != null) {
                return String.valueOf(name) + (Object)((Object)this.dataClass) + "(" + this.getUsableLength() + ", #" + this.numberOfElements + ")/" + variantOrNull.toString();
            }
            return String.valueOf(name) + (Object)((Object)this.dataClass) + "(" + this.getUsableLength() + ", #" + this.numberOfElements + ")";
        }
        StringBuilder builder = new StringBuilder();
        builder.append(name);
        builder.append(this.dataClass.toString());
        builder.append('(');
        builder.append(this.getUsableLength());
        builder.append(", [");
        int[] nArray = this.dimensions;
        int n = this.dimensions.length;
        int n2 = 0;
        while (n2 < n) {
            int d = nArray[n2];
            builder.append(d);
            builder.append(',');
            ++n2;
        }
        if (this.dimensions.length > 0) {
            builder.setLength(builder.length() - 1);
        }
        builder.append(']');
        builder.append(')');
        if (this.typeVariantOrNull != null) {
            builder.append('/');
            builder.append(this.typeVariantOrNull.toString());
        }
        return builder.toString();
    }

    public static final class DataTypeInfoOptions {
        public static final DataTypeInfoOptions MINIMAL = new DataTypeInfoOptions(false, false);
        public static final DataTypeInfoOptions ALL = new DataTypeInfoOptions(true, true);
        public static final DataTypeInfoOptions DEFAULT = new DataTypeInfoOptions(false, true);
        public static final DataTypeInfoOptions PATH = new DataTypeInfoOptions(true, false);
        private boolean knowsDataTypePath;
        private boolean knowsDataTypeVariant;

        DataTypeInfoOptions(boolean knowsDataTypePath, boolean knowsDataTypeVariant) {
            this.knowsDataTypePath = knowsDataTypePath;
            this.knowsDataTypeVariant = knowsDataTypeVariant;
        }

        DataTypeInfoOptions() {
            this.knowsDataTypePath = false;
            this.knowsDataTypeVariant = true;
        }

        public DataTypeInfoOptions path(boolean readDataTypePath) {
            this.knowsDataTypePath = readDataTypePath;
            return this;
        }

        public DataTypeInfoOptions path() {
            this.knowsDataTypePath = true;
            return this;
        }

        public DataTypeInfoOptions variant(boolean readDataTypeVariant) {
            this.knowsDataTypeVariant = readDataTypeVariant;
            return this;
        }

        public DataTypeInfoOptions noVariant() {
            this.knowsDataTypeVariant = false;
            return this;
        }

        public DataTypeInfoOptions all() {
            this.knowsDataTypePath = true;
            this.knowsDataTypeVariant = true;
            return this;
        }

        public DataTypeInfoOptions nothing() {
            this.knowsDataTypePath = false;
            this.knowsDataTypeVariant = false;
            return this;
        }

        public boolean knowsDataTypePath() {
            return this.knowsDataTypePath;
        }

        public boolean knowsDataTypeVariant() {
            return this.knowsDataTypeVariant;
        }
    }
}

