/*
 * Decompiled with CFR 0.152.
 */
package spec.schema;

import java.io.InputStream;
import javax.xml.transform.Templates;
import loci.common.services.ServiceFactory;
import loci.common.xml.XMLTools;
import loci.formats.services.OMEXMLService;
import ome.specification.SchemaResolver;
import ome.xml.model.BinData;
import ome.xml.model.Channel;
import ome.xml.model.Dataset;
import ome.xml.model.Experimenter;
import ome.xml.model.ExperimenterGroup;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.Label;
import ome.xml.model.Line;
import ome.xml.model.OME;
import ome.xml.model.Objective;
import ome.xml.model.Pixels;
import ome.xml.model.Plate;
import ome.xml.model.PlateAcquisition;
import ome.xml.model.Point;
import ome.xml.model.Polygon;
import ome.xml.model.Polyline;
import ome.xml.model.Project;
import ome.xml.model.ROI;
import ome.xml.model.Reagent;
import ome.xml.model.Rectangle;
import ome.xml.model.Screen;
import ome.xml.model.Shape;
import ome.xml.model.StructuredAnnotations;
import ome.xml.model.Union;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import ome.xml.model.XMLAnnotation;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;
import spec.schema.samples.Upgrade2011_06;

@Test(groups={"all"})
public class Schema2011_06_File_Upgrade_Test {
    private static final Templates UPDATE_201106 = XMLTools.getStylesheet((String)"/transforms/2011-06-to-2012-06.xsl", SchemaResolver.class);
    private static final String MESSAGE_REMOVED_PATH = "Removed Path";
    private OME ome;
    private Image image0;
    private Dataset dataset0;
    private Project project0;
    private Plate plate0;
    private Plate plate1;
    private Well well0;
    private Instrument instrument0;
    private Pixels pixels0;
    private StructuredAnnotations annotations;
    private WellSample wellSample0;
    private PlateAcquisition plateAcquisition0;
    private Screen screen0;
    private Screen screen1;
    private Screen screen2;
    private Screen screen3;
    private Experimenter experimenter0;
    private Experimenter experimenter1;
    private Experimenter experimenter2;
    private Experimenter experimenter3;
    private Experimenter experimenter4;
    private Experimenter experimenter5;
    private Experimenter experimenter6;
    private ExperimenterGroup experimenterGroup0;
    private ExperimenterGroup experimenterGroup1;
    private ExperimenterGroup experimenterGroup2;
    private ExperimenterGroup experimenterGroup3;
    private ExperimenterGroup experimenterGroup4;
    private Objective objective0;
    private Channel channel0;
    private Channel channel1;
    private Channel channel2;
    private BinData bindata0;
    private BinData bindata1;
    private BinData bindata2;
    private XMLAnnotation xmlAnnotation0;
    private XMLAnnotation xmlAnnotation1;
    private ROI roi0;
    private ROI roi1;
    private ROI roi2;
    private ROI roi3;
    private ROI roi4;
    private Union union0;
    private Union union1;
    private Union union2;
    private Union union3;
    private Union union4;
    private Shape shape0;
    private Shape shape1;
    private Shape shape2;
    private Shape shape3;
    private Shape shape4;
    private Shape shape5;
    private Shape shape6;
    private Shape shape7;
    private Shape shape8;
    private Shape shape9;
    private Shape shape11;
    private Shape shape12;
    private Shape shape13;
    private Reagent reagent0;
    private Reagent reagent1;
    private Reagent reagent2;
    private Reagent reagent3;

    @BeforeClass
    public void setUp() throws Exception {
        InputStream source = this.getClass().getResourceAsStream("/spec/schema/samples/2011-06/6x4y1z1t3c8b-swatch-upgrade.ome");
        byte[] b = new byte[source.available()];
        source.read(b);
        source.close();
        String xml = new String(b);
        ServiceFactory sf = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        this.ome = (OME)service.createOMEXMLRoot(xml);
    }

    @Test
    public void testOmeNode() {
        Assert.assertNotNull((Object)this.ome);
        Assert.assertEquals((int)1, (int)this.ome.sizeOfDatasetList());
        Assert.assertEquals((int)5, (int)this.ome.sizeOfExperimenterGroupList());
        Assert.assertEquals((int)7, (int)this.ome.sizeOfExperimenterList());
        Assert.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        Assert.assertEquals((int)1, (int)this.ome.sizeOfInstrumentList());
        Assert.assertEquals((int)2, (int)this.ome.sizeOfPlateList());
        Assert.assertEquals((int)1, (int)this.ome.sizeOfProjectList());
        Assert.assertEquals((int)5, (int)this.ome.sizeOfROIList());
        Assert.assertEquals((int)4, (int)this.ome.sizeOfScreenList());
        Assert.assertNull((Object)this.ome.getCreator());
        Assert.assertNull((Object)this.ome.getUUID());
        Assert.assertNotNull((Object)this.ome.getStructuredAnnotations());
    }

    @Test(groups={"11-06-u-proj"}, dependsOnMethods={"testOmeNode"})
    public void testDataset0() {
        Assert.assertNotNull((Object)this.ome);
        this.dataset0 = this.ome.getDataset(0);
        Assert.assertNotNull((Object)this.dataset0);
    }

    @Test(groups={"11-06-u-proj"}, dependsOnMethods={"testOmeNode"})
    public void testProject0() {
        Assert.assertNotNull((Object)this.ome);
        this.project0 = this.ome.getProject(0);
        Assert.assertNotNull((Object)this.project0);
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testOmeNode"})
    public void testPlate0() {
        Assert.assertNotNull((Object)this.ome);
        this.plate0 = this.ome.getPlate(0);
        Assert.assertNotNull((Object)this.plate0);
        Assert.assertEquals((String)"Plate 0 Description", (String)this.plate0.getDescription());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testPlate0"})
    public void testPlateAcquisition0Description() {
        Assert.assertNotNull((Object)this.plate0);
        Assert.assertEquals((int)1, (int)this.plate0.sizeOfPlateAcquisitionList());
        this.plateAcquisition0 = this.plate0.getPlateAcquisition(0);
        Assert.assertNotNull((Object)this.plateAcquisition0);
        Assert.assertEquals((String)"Plate Acquisition 0 Description", (String)this.plateAcquisition0.getDescription());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testPlate0"})
    public void testPlate0Well0() {
        Assert.assertNotNull((Object)this.plate0);
        Assert.assertEquals((int)1, (int)this.plate0.sizeOfWellList());
        this.well0 = this.plate0.getWell(0);
        Assert.assertNotNull((Object)this.well0);
        Assert.assertEquals((Object)Upgrade2011_06.ref.Plate0Well0Column, (Object)this.well0.getColumn());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Plate0Well0Row, (Object)this.well0.getRow());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Plate0Well0Color, (Object)this.well0.getColor());
        Assert.assertEquals((String)"TheWell0Status", (String)this.well0.getType());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testPlate0Well0"})
    public void testPlate0WellSample0() {
        Assert.assertNotNull((Object)this.well0);
        Assert.assertEquals((int)1, (int)this.well0.sizeOfWellSampleList());
        this.wellSample0 = this.well0.getWellSample(0);
        Assert.assertNotNull((Object)this.wellSample0);
        Assert.assertEquals((Object)Upgrade2011_06.ref.Plate0Well0WellSample0Index, (Object)this.wellSample0.getIndex());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testOmeNode"})
    public void testPlate1Description() {
        Assert.assertNotNull((Object)this.ome);
        this.plate1 = this.ome.getPlate(1);
        Assert.assertNotNull((Object)this.plate1);
        Assert.assertNull((Object)this.plate1.getDescription());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testOmeNode"})
    public void testScreen0() {
        Assert.assertNotNull((Object)this.ome);
        this.screen0 = this.ome.getScreen(0);
        Assert.assertNotNull((Object)this.screen0);
        Assert.assertEquals((String)"ScreenName0", (String)this.screen0.getName());
        Assert.assertEquals((String)"Screen 0 Description", (String)this.screen0.getDescription());
        Assert.assertEquals((String)"Protocol Description Test0", (String)this.screen0.getProtocolDescription());
        Assert.assertEquals((String)"ProtocolTest0ID", (String)this.screen0.getProtocolIdentifier());
        Assert.assertEquals((String)"Reagents Set XYZ", (String)this.screen0.getReagentSetDescription());
        Assert.assertEquals((String)"ReagentsXYZ-ID", (String)this.screen0.getReagentSetIdentifier());
        Assert.assertEquals((String)"ScreenType0", (String)this.screen0.getType());
        Assert.assertEquals((int)1, (int)this.screen0.sizeOfReagentList());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testOmeNode"})
    public void testScreen1() {
        Assert.assertNotNull((Object)this.ome);
        this.screen1 = this.ome.getScreen(1);
        Assert.assertNotNull((Object)this.screen1);
        Assert.assertEquals((String)"ScreenName1", (String)this.screen1.getName());
        Assert.assertEquals((String)"Screen 1 Description", (String)this.screen1.getDescription());
        Assert.assertEquals((String)"Protocol Description Test1", (String)this.screen1.getProtocolDescription());
        Assert.assertEquals((String)"ProtocolTest1ID", (String)this.screen1.getProtocolIdentifier());
        Assert.assertEquals((String)"Reagents Set PQR", (String)this.screen1.getReagentSetDescription());
        Assert.assertEquals((String)"ReagentsPQR-ID", (String)this.screen1.getReagentSetIdentifier());
        Assert.assertEquals((String)"ScreenType1", (String)this.screen1.getType());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testOmeNode"})
    public void testScreen2() {
        Assert.assertNotNull((Object)this.ome);
        this.screen2 = this.ome.getScreen(2);
        Assert.assertNotNull((Object)this.screen2);
        Assert.assertEquals((String)"ScreenName2", (String)this.screen2.getName());
        Assert.assertEquals((String)"Screen 2 Description", (String)this.screen2.getDescription());
        Assert.assertEquals((String)"Protocol Description Test2", (String)this.screen2.getProtocolDescription());
        Assert.assertEquals((String)"ProtocolTest2ID", (String)this.screen2.getProtocolIdentifier());
        Assert.assertEquals((String)"Reagents Set IJK", (String)this.screen2.getReagentSetDescription());
        Assert.assertEquals((String)"ReagentsIJK-ID", (String)this.screen2.getReagentSetIdentifier());
        Assert.assertEquals((String)"ScreenType2", (String)this.screen2.getType());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testOmeNode"})
    public void testScreen3() {
        Assert.assertNotNull((Object)this.ome);
        this.screen3 = this.ome.getScreen(3);
        Assert.assertNotNull((Object)this.screen3);
        Assert.assertEquals((String)"ScreenName3", (String)this.screen3.getName());
        Assert.assertEquals((String)"Screen 3 Description", (String)this.screen3.getDescription());
        Assert.assertEquals((String)"Protocol Description Test3", (String)this.screen3.getProtocolDescription());
        Assert.assertEquals((String)"ProtocolTest3ID", (String)this.screen3.getProtocolIdentifier());
        Assert.assertEquals((String)"Reagents Set AJP", (String)this.screen3.getReagentSetDescription());
        Assert.assertEquals((String)"ReagentsAJP-ID", (String)this.screen3.getReagentSetIdentifier());
        Assert.assertEquals((String)"ScreenType3", (String)this.screen3.getType());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testScreen0"})
    public void testReagent0() {
        Assert.assertNotNull((Object)this.screen0);
        this.reagent0 = this.screen0.getReagent(0);
        Assert.assertNotNull((Object)this.reagent0);
        Assert.assertNull((Object)this.reagent0.getName());
        Assert.assertNull((Object)this.reagent0.getReagentIdentifier());
        Assert.assertNull((Object)this.reagent0.getName());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testScreen1"})
    public void testReagent1() {
        Assert.assertNotNull((Object)this.screen1);
        this.reagent1 = this.screen1.getReagent(0);
        Assert.assertNotNull((Object)this.reagent1);
        Assert.assertNull((Object)this.reagent1.getName());
        Assert.assertNull((Object)this.reagent1.getReagentIdentifier());
        Assert.assertNull((Object)this.reagent1.getName());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testScreen2"})
    public void testReagent2() {
        Assert.assertNotNull((Object)this.screen2);
        this.reagent2 = this.screen2.getReagent(0);
        Assert.assertNotNull((Object)this.reagent2);
        Assert.assertNull((Object)this.reagent2.getName());
        Assert.assertNull((Object)this.reagent2.getReagentIdentifier());
        Assert.assertNull((Object)this.reagent2.getName());
    }

    @Test(groups={"11-06-u-spw"}, dependsOnMethods={"testScreen3"})
    public void testReagent3() {
        Assert.assertNotNull((Object)this.screen3);
        this.reagent3 = this.screen3.getReagent(0);
        Assert.assertNotNull((Object)this.reagent3);
        Assert.assertNull((Object)this.reagent3.getName());
        Assert.assertNull((Object)this.reagent3.getReagentIdentifier());
        Assert.assertNull((Object)this.reagent3.getName());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenter0() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenter0 = this.ome.getExperimenter(0);
        Assert.assertNotNull((Object)this.experimenter0);
        Assert.assertNull((Object)this.experimenter0.getFirstName());
        Assert.assertNull((Object)this.experimenter0.getMiddleName());
        Assert.assertNull((Object)this.experimenter0.getLastName());
        Assert.assertNull((Object)this.experimenter0.getUserName());
        Assert.assertNull((Object)this.experimenter0.getInstitution());
        Assert.assertNull((Object)this.experimenter0.getEmail());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenter1() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenter1 = this.ome.getExperimenter(1);
        Assert.assertNotNull((Object)this.experimenter1);
        Assert.assertEquals((String)"John", (String)this.experimenter1.getFirstName());
        Assert.assertEquals((String)"Andrew", (String)this.experimenter1.getMiddleName());
        Assert.assertEquals((String)"Smith", (String)this.experimenter1.getLastName());
        Assert.assertNull((Object)this.experimenter1.getUserName());
        Assert.assertNull((Object)this.experimenter1.getInstitution());
        Assert.assertEquals((String)"john@example.org", (String)this.experimenter1.getEmail());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenter2() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenter2 = this.ome.getExperimenter(2);
        Assert.assertNotNull((Object)this.experimenter2);
        Assert.assertNull((Object)this.experimenter2.getFirstName());
        Assert.assertNull((Object)this.experimenter2.getMiddleName());
        Assert.assertNull((Object)this.experimenter2.getLastName());
        Assert.assertNull((Object)this.experimenter2.getUserName());
        Assert.assertNull((Object)this.experimenter2.getInstitution());
        Assert.assertNull((Object)this.experimenter2.getEmail());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenter3() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenter3 = this.ome.getExperimenter(3);
        Assert.assertNotNull((Object)this.experimenter3);
        Assert.assertNull((Object)this.experimenter3.getFirstName());
        Assert.assertNull((Object)this.experimenter3.getMiddleName());
        Assert.assertNull((Object)this.experimenter3.getLastName());
        Assert.assertNull((Object)this.experimenter3.getUserName());
        Assert.assertNull((Object)this.experimenter3.getInstitution());
        Assert.assertNull((Object)this.experimenter3.getEmail());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenter4() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenter4 = this.ome.getExperimenter(4);
        Assert.assertNotNull((Object)this.experimenter4);
        Assert.assertNull((Object)this.experimenter4.getFirstName());
        Assert.assertNull((Object)this.experimenter4.getMiddleName());
        Assert.assertNull((Object)this.experimenter4.getLastName());
        Assert.assertNull((Object)this.experimenter4.getUserName());
        Assert.assertNull((Object)this.experimenter4.getInstitution());
        Assert.assertNull((Object)this.experimenter4.getEmail());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenter5() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenter5 = this.ome.getExperimenter(5);
        Assert.assertNotNull((Object)this.experimenter5);
        Assert.assertNull((Object)this.experimenter5.getFirstName());
        Assert.assertNull((Object)this.experimenter5.getMiddleName());
        Assert.assertNull((Object)this.experimenter5.getLastName());
        Assert.assertNull((Object)this.experimenter5.getUserName());
        Assert.assertNull((Object)this.experimenter5.getInstitution());
        Assert.assertNull((Object)this.experimenter5.getEmail());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenter6() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenter6 = this.ome.getExperimenter(6);
        Assert.assertNotNull((Object)this.experimenter6);
        Assert.assertNull((Object)this.experimenter6.getFirstName());
        Assert.assertNull((Object)this.experimenter6.getMiddleName());
        Assert.assertNull((Object)this.experimenter6.getLastName());
        Assert.assertNull((Object)this.experimenter6.getUserName());
        Assert.assertNull((Object)this.experimenter6.getInstitution());
        Assert.assertNull((Object)this.experimenter6.getEmail());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenterGroup0() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenterGroup0 = this.ome.getExperimenterGroup(0);
        Assert.assertNotNull((Object)this.experimenterGroup0);
        Assert.assertEquals((String)"MyGroup - Leader+Contact match", (String)this.experimenterGroup0.getName());
        Assert.assertEquals((String)"A description for my group 0.\n\t\t\tComplete with basic formatting, like new lines.", (String)this.experimenterGroup0.getDescription());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenterGroup1() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenterGroup1 = this.ome.getExperimenterGroup(1);
        Assert.assertNotNull((Object)this.experimenterGroup1);
        Assert.assertEquals((String)"MyOtherGroup", (String)this.experimenterGroup1.getName());
        Assert.assertEquals((String)"A description for my group 1.\n\t\t\tComplete with basic formatting, like new lines.", (String)this.experimenterGroup1.getDescription());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenterGroup2() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenterGroup2 = this.ome.getExperimenterGroup(2);
        Assert.assertNotNull((Object)this.experimenterGroup2);
        Assert.assertEquals((String)"NoMatch", (String)this.experimenterGroup2.getName());
        Assert.assertEquals((String)"A description for my group 2.\n\t\t\tComplete with basic formatting, like new lines.", (String)this.experimenterGroup2.getDescription());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenterGroup3() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenterGroup3 = this.ome.getExperimenterGroup(3);
        Assert.assertNotNull((Object)this.experimenterGroup3);
        Assert.assertEquals((String)"LeaderMatch", (String)this.experimenterGroup3.getName());
        Assert.assertEquals((String)"A description for my group 3.\n\t\t\tComplete with basic formatting, like new lines.", (String)this.experimenterGroup3.getDescription());
    }

    @Test(groups={"11-06-u-exper"}, dependsOnMethods={"testOmeNode"})
    public void testExperimenterGroup4() {
        Assert.assertNotNull((Object)this.ome);
        this.experimenterGroup4 = this.ome.getExperimenterGroup(4);
        Assert.assertNotNull((Object)this.experimenterGroup4);
        Assert.assertEquals((String)"ContactMatch", (String)this.experimenterGroup4.getName());
        Assert.assertEquals((String)"A description for my group 4.\n\t\t\tComplete with basic formatting, like new lines.", (String)this.experimenterGroup4.getDescription());
    }

    @Test(groups={"11-06-u-instrument"}, dependsOnMethods={"testOmeNode"})
    public void testInstrument0() {
        Assert.assertNotNull((Object)this.ome);
        this.instrument0 = this.ome.getInstrument(0);
        Assert.assertNotNull((Object)this.instrument0);
        Assert.assertEquals((int)0, (int)this.instrument0.sizeOfDetectorList());
        Assert.assertEquals((int)0, (int)this.instrument0.sizeOfDichroicList());
        Assert.assertEquals((int)0, (int)this.instrument0.sizeOfFilterList());
        Assert.assertEquals((int)0, (int)this.instrument0.sizeOfFilterSetList());
        Assert.assertEquals((int)0, (int)this.instrument0.sizeOfLightSourceList());
    }

    @Test(groups={"11-06-u-instrument"}, dependsOnMethods={"testOmeNode"})
    public void testObjective0() {
        Assert.assertNotNull((Object)this.ome);
        this.objective0 = this.instrument0.getObjective(0);
        Assert.assertNotNull((Object)this.objective0);
        Assert.assertEquals((Object)Upgrade2011_06.ref.Instrument0Objective0CalibratedMagnification, (Object)this.objective0.getCalibratedMagnification());
        Assert.assertEquals((String)"123", (String)this.objective0.getLotNumber());
        Assert.assertEquals((String)"OME-Labs", (String)this.objective0.getManufacturer());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Instrument0Objective0NominalMagnification, (Object)this.objective0.getNominalMagnification());
        Assert.assertNull((Object)this.objective0.getCorrection());
        Assert.assertNull((Object)this.objective0.getImmersion());
        Assert.assertNull((Object)this.objective0.getIris());
        Assert.assertNull((Object)this.objective0.getLensNA());
        Assert.assertNull((Object)this.objective0.getModel());
        Assert.assertNull((Object)this.objective0.getSerialNumber());
        Assert.assertNull((Object)this.objective0.getWorkingDistance());
    }

    @Test(groups={"11-06-u-image"}, dependsOnMethods={"testOmeNode"})
    public void testImage0Name() {
        Assert.assertNotNull((Object)this.ome);
        Assert.assertEquals((int)1, (int)this.ome.sizeOfImageList());
        this.image0 = this.ome.getImage(0);
        Assert.assertNotNull((Object)this.image0);
        Assert.assertEquals((String)"6x6x1x8-swatch.tif", (String)this.image0.getName());
    }

    @Test(groups={"11-06-u-image"}, dependsOnMethods={"testImage0Name"})
    public void testImage0Date() {
        Assert.assertNotNull((Object)this.image0);
        Assert.assertEquals((Object)"2010-02-23T12:51:30", (Object)this.image0.getAcquisitionDate());
    }

    @Test(groups={"11-06-u-image"}, dependsOnMethods={"testImage0Name"})
    public void testPixels0() {
        Assert.assertNotNull((Object)this.image0);
        this.pixels0 = this.image0.getPixels();
        Assert.assertEquals((int)3, (int)this.pixels0.sizeOfBinDataList());
        Assert.assertEquals((int)3, (int)this.pixels0.sizeOfChannelList());
        Assert.assertEquals((int)0, (int)this.pixels0.sizeOfPlaneList());
        Assert.assertEquals((int)0, (int)this.pixels0.sizeOfTiffDataList());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0DimensionOrder, (Object)this.pixels0.getDimensionOrder());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0PhysicalSizeX, (Object)this.pixels0.getPhysicalSizeX());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0PhysicalSizeY, (Object)this.pixels0.getPhysicalSizeY());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Type, (Object)this.pixels0.getType());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0SizeC, (Object)this.pixels0.getSizeC());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0SizeT, (Object)this.pixels0.getSizeT());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0SizeX, (Object)this.pixels0.getSizeX());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0SizeY, (Object)this.pixels0.getSizeY());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0SizeZ, (Object)this.pixels0.getSizeZ());
        Assert.assertNull((Object)this.pixels0.getMetadataOnly());
        Assert.assertNull((Object)this.pixels0.getPhysicalSizeZ());
        Assert.assertNull((Object)this.pixels0.getTimeIncrement());
    }

    @Test(groups={"11-06-u-image"}, dependsOnMethods={"testPixels0"})
    public void testChannel0() {
        Assert.assertNotNull((Object)this.pixels0);
        this.channel0 = this.pixels0.getChannel(0);
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Channel0AcquisitionMode, (Object)this.channel0.getAcquisitionMode());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Channel0Color, (Object)this.channel0.getColor());
        Assert.assertNull((Object)this.channel0.getContrastMethod());
        Assert.assertNull((Object)this.channel0.getDetectorSettings());
        Assert.assertNull((Object)this.channel0.getEmissionWavelength());
        Assert.assertNull((Object)this.channel0.getExcitationWavelength());
        Assert.assertNull((Object)this.channel0.getFluor());
        Assert.assertNull((Object)this.channel0.getIlluminationType());
        Assert.assertNull((Object)this.channel0.getLightPath());
        Assert.assertNull((Object)this.channel0.getLightSourceSettings());
        Assert.assertNull((Object)this.channel0.getName());
        Assert.assertNull((Object)this.channel0.getNDFilter());
        Assert.assertNull((Object)this.channel0.getPinholeSize());
        Assert.assertNull((Object)this.channel0.getPockelCellSetting());
        Assert.assertNull((Object)this.channel0.getSamplesPerPixel());
    }

    @Test(groups={"11-06-u-image"}, dependsOnMethods={"testPixels0"})
    public void testChannel1() {
        Assert.assertNotNull((Object)this.pixels0);
        this.channel1 = this.pixels0.getChannel(1);
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Channel1AcquisitionMode, (Object)this.channel1.getAcquisitionMode());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Channel1Color, (Object)this.channel1.getColor());
        Assert.assertNull((Object)this.channel1.getContrastMethod());
        Assert.assertNull((Object)this.channel1.getDetectorSettings());
        Assert.assertNull((Object)this.channel1.getEmissionWavelength());
        Assert.assertNull((Object)this.channel1.getExcitationWavelength());
        Assert.assertNull((Object)this.channel1.getFluor());
        Assert.assertNull((Object)this.channel1.getIlluminationType());
        Assert.assertNull((Object)this.channel1.getLightPath());
        Assert.assertNull((Object)this.channel1.getLightSourceSettings());
        Assert.assertNull((Object)this.channel1.getName());
        Assert.assertNull((Object)this.channel1.getNDFilter());
        Assert.assertNull((Object)this.channel1.getPinholeSize());
        Assert.assertNull((Object)this.channel1.getPockelCellSetting());
        Assert.assertNull((Object)this.channel1.getSamplesPerPixel());
    }

    @Test(groups={"11-06-u-image"}, dependsOnMethods={"testPixels0"})
    public void testChannel2() {
        Assert.assertNotNull((Object)this.pixels0);
        this.channel2 = this.pixels0.getChannel(2);
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Channel2AcquisitionMode, (Object)this.channel2.getAcquisitionMode());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Channel2Color, (Object)this.channel2.getColor());
        Assert.assertNull((Object)this.channel2.getContrastMethod());
        Assert.assertNull((Object)this.channel2.getDetectorSettings());
        Assert.assertNull((Object)this.channel2.getEmissionWavelength());
        Assert.assertNull((Object)this.channel2.getExcitationWavelength());
        Assert.assertNull((Object)this.channel2.getFluor());
        Assert.assertNull((Object)this.channel2.getIlluminationType());
        Assert.assertNull((Object)this.channel2.getLightPath());
        Assert.assertNull((Object)this.channel2.getLightSourceSettings());
        Assert.assertNull((Object)this.channel2.getName());
        Assert.assertNull((Object)this.channel2.getNDFilter());
        Assert.assertNull((Object)this.channel2.getPinholeSize());
        Assert.assertNull((Object)this.channel2.getPockelCellSetting());
        Assert.assertNull((Object)this.channel2.getSamplesPerPixel());
    }

    @Test(groups={"11-06-u-image"}, dependsOnMethods={"testPixels0"})
    public void testBinData0() {
        Assert.assertNotNull((Object)this.pixels0);
        this.bindata0 = this.pixels0.getBinData(0);
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Bindata0Length, (Object)this.bindata0.getLength());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Bindata0BigEndian, (Object)this.bindata0.getBigEndian());
        Assert.assertNull((Object)this.bindata0.getCompression());
    }

    @Test(groups={"11-06-u-image"}, dependsOnMethods={"testPixels0"})
    public void testBinData1() {
        Assert.assertNotNull((Object)this.pixels0);
        this.bindata1 = this.pixels0.getBinData(1);
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Bindata1Length, (Object)this.bindata1.getLength());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Bindata1BigEndian, (Object)this.bindata1.getBigEndian());
        Assert.assertNull((Object)this.bindata1.getCompression());
    }

    @Test(groups={"11-06-u-image"}, dependsOnMethods={"testPixels0"})
    public void testBinData2() {
        Assert.assertNotNull((Object)this.pixels0);
        this.bindata2 = this.pixels0.getBinData(2);
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Bindata2Length, (Object)this.bindata2.getLength());
        Assert.assertEquals((Object)Upgrade2011_06.ref.Image0Pixels0_0Bindata2BigEndian, (Object)this.bindata2.getBigEndian());
        Assert.assertNull((Object)this.bindata2.getCompression());
    }

    @Test(groups={"11-06-u-annotation"}, dependsOnMethods={"testOmeNode"})
    public void testAnnotations() {
        Assert.assertNotNull((Object)this.ome);
        this.annotations = this.ome.getStructuredAnnotations();
        Assert.assertEquals((int)2, (int)this.annotations.sizeOfXMLAnnotationList());
        Assert.assertEquals((int)0, (int)this.annotations.sizeOfBooleanAnnotationList());
        Assert.assertEquals((int)0, (int)this.annotations.sizeOfCommentAnnotationList());
        Assert.assertEquals((int)0, (int)this.annotations.sizeOfDoubleAnnotationList());
        Assert.assertEquals((int)0, (int)this.annotations.sizeOfFileAnnotationList());
        Assert.assertEquals((int)0, (int)this.annotations.sizeOfListAnnotationList());
        Assert.assertEquals((int)0, (int)this.annotations.sizeOfLongAnnotationList());
        Assert.assertEquals((int)0, (int)this.annotations.sizeOfTagAnnotationList());
        Assert.assertEquals((int)0, (int)this.annotations.sizeOfTermAnnotationList());
        Assert.assertEquals((int)0, (int)this.annotations.sizeOfTimestampAnnotationList());
    }

    @Test(groups={"11-06-u-annotation"}, dependsOnMethods={"testAnnotations"})
    public void testXMLAnnotation0() {
        Assert.assertNotNull((Object)this.annotations);
        this.xmlAnnotation0 = this.annotations.getXMLAnnotation(0);
        Assert.assertEquals((String)"<test1/>", (String)this.xmlAnnotation0.getValue());
        Assert.assertNull((Object)this.xmlAnnotation0.getNamespace());
        Assert.assertNull((Object)this.xmlAnnotation0.getDescription());
    }

    @Test(groups={"11-06-u-annotation"}, dependsOnMethods={"testAnnotations"})
    public void testXMLAnnotation1() {
        Assert.assertNotNull((Object)this.annotations);
        this.xmlAnnotation1 = this.annotations.getXMLAnnotation(1);
        Assert.assertEquals((String)"<test2/>", (String)this.xmlAnnotation1.getValue());
        Assert.assertNull((Object)this.xmlAnnotation1.getNamespace());
        Assert.assertNull((Object)this.xmlAnnotation1.getDescription());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testOmeNode"})
    public void testROI0AndUnion() {
        Assert.assertNotNull((Object)this.ome);
        this.roi0 = this.ome.getROI(0);
        Assert.assertNull((Object)this.roi0.getDescription());
        Assert.assertNull((Object)this.roi0.getName());
        this.union0 = this.roi0.getUnion();
        Assert.assertNotNull((Object)this.union0);
        Assert.assertEquals((int)1, (int)this.union0.sizeOfShapeList());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testOmeNode"})
    public void testROI1AndUnion() {
        Assert.assertNotNull((Object)this.ome);
        this.roi1 = this.ome.getROI(1);
        Assert.assertEquals((String)"ROI 1 Upgradable description.", (String)this.roi1.getDescription());
        Assert.assertNull((Object)this.roi1.getName());
        this.union1 = this.roi1.getUnion();
        Assert.assertNotNull((Object)this.union1);
        Assert.assertEquals((int)1, (int)this.union1.sizeOfShapeList());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testOmeNode"})
    public void testROI2AndUnion() {
        Assert.assertNotNull((Object)this.ome);
        this.roi2 = this.ome.getROI(2);
        Assert.assertNull((Object)this.roi2.getDescription());
        Assert.assertNull((Object)this.roi2.getName());
        this.union2 = this.roi2.getUnion();
        Assert.assertNotNull((Object)this.union2);
        Assert.assertEquals((int)8, (int)this.union2.sizeOfShapeList());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testOmeNode"})
    public void testROI3AndUnion() {
        Assert.assertNotNull((Object)this.ome);
        this.roi3 = this.ome.getROI(3);
        Assert.assertNull((Object)this.roi3.getDescription());
        Assert.assertNull((Object)this.roi3.getName());
        this.union3 = this.roi3.getUnion();
        Assert.assertNotNull((Object)this.union3);
        Assert.assertEquals((int)1, (int)this.union3.sizeOfShapeList());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testOmeNode"})
    public void testROI4AndUnion() {
        Assert.assertNotNull((Object)this.ome);
        this.roi4 = this.ome.getROI(4);
        Assert.assertNull((Object)this.roi4.getDescription());
        Assert.assertNull((Object)this.roi4.getName());
        this.union4 = this.roi4.getUnion();
        Assert.assertNotNull((Object)this.union4);
        Assert.assertEquals((int)2, (int)this.union4.sizeOfShapeList());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI0AndUnion"})
    public void testShape0() {
        Assert.assertNotNull((Object)this.union0);
        this.shape0 = this.union0.getShape(0);
        Assert.assertEquals((String)Point.class.getName(), (String)this.shape0.getClass().getName());
        Point point0 = (Point)this.shape0;
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI0Shape0TheC, (Object)point0.getTheC());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI0Shape0PointX, (Object)point0.getX());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI0Shape0PointY, (Object)point0.getY());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI1AndUnion"})
    public void testShape1() {
        Assert.assertNotNull((Object)this.union1);
        this.shape1 = this.union1.getShape(0);
        Assert.assertEquals((String)Point.class.getName(), (String)this.shape1.getClass().getName());
        Point point1 = (Point)this.shape1;
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI1Shape1TheC, (Object)point1.getTheC());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI1Shape1PointX, (Object)point1.getX());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI1Shape1PointY, (Object)point1.getY());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI1Shape1FillRule, (Object)point1.getFillRule());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI1Shape1FontFamily, (Object)point1.getFontFamily());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI1Shape1FontSize, (Object)point1.getFontSize());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI1Shape1FontStyle, (Object)point1.getFontStyle());
        Assert.assertEquals((String)"1", (String)point1.getStrokeDashArray());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI1Shape1StrokeWidth, (Object)point1.getStrokeWidth());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI1Shape1Fill, (Object)point1.getFillColor());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI1Shape1Stroke, (Object)point1.getStrokeColor());
        Assert.assertEquals((String)"Hello", (String)point1.getText());
    }

    @Test(enabled=false, groups={"11-06-u-roi"}, dependsOnMethods={"testROI2AndUnion"})
    public void testShape2() {
        Assert.assertNotNull((Object)this.union2);
        this.shape2 = this.union2.getShape(0);
        Assert.assertEquals((String)Rectangle.class.getName(), (String)this.shape2.getClass().getName());
        Rectangle rectangle2 = (Rectangle)this.shape2;
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2FillRule, (Object)rectangle2.getFillRule());
        Assert.assertEquals((String)"Hi There! (from shape 2)", (String)rectangle2.getText());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2RectangleX, (Object)rectangle2.getX());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2RectangleY, (Object)rectangle2.getY());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2RectangleWidth, (Object)rectangle2.getWidth());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2RectangleHeight, (Object)rectangle2.getHeight());
        Assert.assertNotNull((Object)rectangle2.getTransform());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2TransformA00, (Object)rectangle2.getTransform().getA00());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2TransformA01, (Object)rectangle2.getTransform().getA01());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2TransformA02, (Object)rectangle2.getTransform().getA02());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2TransformA10, (Object)rectangle2.getTransform().getA10());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2TransformA11, (Object)rectangle2.getTransform().getA11());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape2TransformA12, (Object)rectangle2.getTransform().getA12());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI2AndUnion"})
    public void testShape3() {
        Assert.assertNotNull((Object)this.union2);
        this.shape3 = this.union2.getShape(0);
        Assert.assertEquals((String)Label.class.getName(), (String)this.shape3.getClass().getName());
        Label label3 = (Label)this.shape3;
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape3FillRule, (Object)label3.getFillRule());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape3FontFamily, (Object)label3.getFontFamily());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape3FontStyle, (Object)label3.getFontStyle());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape3TextX, (Object)label3.getX());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape3TextY, (Object)label3.getY());
        Assert.assertEquals((String)"Hello World Text Value!(from shape 3)", (String)label3.getText());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI2AndUnion"})
    public void testShape4() {
        Assert.assertNotNull((Object)this.union2);
        this.shape4 = this.union2.getShape(4);
        Assert.assertEquals((String)Polygon.class.getName(), (String)this.shape4.getClass().getName());
        Polygon polygon4 = (Polygon)this.shape4;
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape4Stroke, (Object)polygon4.getStrokeColor());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape4StrokeWidth, (Object)polygon4.getStrokeWidth());
        Assert.assertEquals((String)"1,1 10,20, 20,20 20,10", (String)polygon4.getPoints());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI2AndUnion"})
    public void testShape5() {
        Assert.assertNotNull((Object)this.union2);
        this.shape5 = this.union2.getShape(5);
        Assert.assertEquals((String)Polyline.class.getName(), (String)this.shape5.getClass().getName());
        Polyline polyline5 = (Polyline)this.shape5;
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape5Stroke, (Object)polyline5.getStrokeColor());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape5StrokeWidth, (Object)polyline5.getStrokeWidth());
        Assert.assertEquals((String)"15,15 15,25, 25,25 25,15", (String)polyline5.getPoints());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape5MarkerStart, (Object)polyline5.getMarkerStart());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape5MarkerEnd, (Object)polyline5.getMarkerEnd());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI2AndUnion"})
    public void testShape6() {
        Assert.assertNotNull((Object)this.union2);
        this.shape6 = this.union2.getShape(6);
        Assert.assertEquals((String)Polyline.class.getName(), (String)this.shape6.getClass().getName());
        Polyline polyline6 = (Polyline)this.shape6;
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape6Stroke, (Object)polyline6.getStrokeColor());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape6StrokeWidth, (Object)polyline6.getStrokeWidth());
        Assert.assertEquals((String)"1.1,1.1 10.1,20.1, 20.1,20.1 20.1,10.1", (String)polyline6.getPoints());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape6MarkerStart, (Object)polyline6.getMarkerStart());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI2AndUnion"})
    public void testShape7() {
        Assert.assertNotNull((Object)this.union2);
        this.shape7 = this.union2.getShape(1);
        Assert.assertEquals((String)Line.class.getName(), (String)this.shape7.getClass().getName());
        Line line7 = (Line)this.shape7;
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape7Stroke, (Object)line7.getStrokeColor());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape7StrokeWidth, (Object)line7.getStrokeWidth());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape7MarkerStart, (Object)line7.getMarkerStart());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape7MarkerEnd, (Object)line7.getMarkerEnd());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape7LineX1, (Object)line7.getX1());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape7LineY1, (Object)line7.getY1());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape7LineX2, (Object)line7.getX2());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape7LineY2, (Object)line7.getY2());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI2AndUnion"})
    public void testShape8() {
        Assert.assertNotNull((Object)this.union2);
        this.shape8 = this.union2.getShape(2);
        Assert.assertEquals((String)Line.class.getName(), (String)this.shape8.getClass().getName());
        Line line8 = (Line)this.shape8;
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape8Stroke, (Object)line8.getStrokeColor());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape8StrokeWidth, (Object)line8.getStrokeWidth());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape8MarkerEnd, (Object)line8.getMarkerEnd());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape8LineX1, (Object)line8.getX1());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape8LineY1, (Object)line8.getY1());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape8LineX2, (Object)line8.getX2());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape8LineY2, (Object)line8.getY2());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI2AndUnion"})
    public void testShape9() {
        Assert.assertNotNull((Object)this.union2);
        this.shape9 = this.union2.getShape(3);
        Assert.assertEquals((String)Line.class.getName(), (String)this.shape9.getClass().getName());
        Line line9 = (Line)this.shape9;
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape9Stroke, (Object)line9.getStrokeColor());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape9StrokeWidth, (Object)line9.getStrokeWidth());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape9MarkerEnd, (Object)line9.getMarkerEnd());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape9LineX1, (Object)line9.getX1());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape9LineY1, (Object)line9.getY1());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape9LineX2, (Object)line9.getX2());
        Assert.assertEquals((Object)Upgrade2011_06.ref.ROI2Shape9LineY2, (Object)line9.getY2());
    }

    @Test(groups={"11-06-u-roi-extra"}, dependsOnGroups={"11-06-u-roi"})
    public void testShape10() {
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI3AndUnion"})
    public void testShape11() {
        Assert.assertNotNull((Object)this.union3);
        this.shape11 = this.union3.getShape(0);
        Assert.assertEquals((String)Label.class.getName(), (String)this.shape11.getClass().getName());
        Label label11 = (Label)this.shape11;
        Assert.assertEquals((String)MESSAGE_REMOVED_PATH, (String)label11.getText());
        Assert.assertEquals((Object)0.0, (Object)label11.getX());
        Assert.assertEquals((Object)0.0, (Object)label11.getY());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI4AndUnion"})
    public void testShape12() {
        Assert.assertNotNull((Object)this.union4);
        this.shape12 = this.union4.getShape(0);
        Assert.assertEquals((String)Label.class.getName(), (String)this.shape12.getClass().getName());
        Label label12 = (Label)this.shape12;
        Assert.assertEquals((String)MESSAGE_REMOVED_PATH, (String)label12.getText());
        Assert.assertEquals((Object)0.0, (Object)label12.getX());
        Assert.assertEquals((Object)0.0, (Object)label12.getY());
    }

    @Test(groups={"11-06-u-roi"}, dependsOnMethods={"testROI4AndUnion"})
    public void testShape13() {
        Assert.assertNotNull((Object)this.union4);
        this.shape13 = this.union4.getShape(1);
        Assert.assertEquals((String)Label.class.getName(), (String)this.shape13.getClass().getName());
        Label label13 = (Label)this.shape13;
        Assert.assertEquals((String)MESSAGE_REMOVED_PATH, (String)label13.getText());
        Assert.assertEquals((Object)0.0, (Object)label13.getX());
        Assert.assertEquals((Object)0.0, (Object)label13.getY());
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-spw", "11-06-u-annotation"})
    public void testPlate0Linkage() {
        Assert.assertNotNull((Object)this.plate0);
        Assert.assertEquals((int)1, (int)this.plate0.sizeOfLinkedAnnotationList());
        Assert.assertEquals((Object)this.xmlAnnotation0, (Object)this.plate0.getLinkedAnnotation(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-spw", "11-06-u-annotation"})
    public void testPlate1Linkage() {
        Assert.assertNotNull((Object)this.plate1);
        Assert.assertEquals((int)0, (int)this.plate1.sizeOfLinkedAnnotationList());
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-spw", "11-06-u-annotation"})
    public void testPlateAcquisition0Linkage() {
        Assert.assertNotNull((Object)this.plateAcquisition0);
        Assert.assertEquals((int)1, (int)this.plateAcquisition0.sizeOfLinkedAnnotationList());
        Assert.assertEquals((Object)this.xmlAnnotation1, (Object)this.plateAcquisition0.getLinkedAnnotation(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-spw", "11-06-u-image"})
    public void testWellSample0Linkage() {
        Assert.assertNotNull((Object)this.wellSample0);
        Assert.assertEquals((Object)this.image0, (Object)this.wellSample0.getLinkedImage());
    }

    @Test(groups={"links"}, dependsOnGroups={"11-06-u-spw", "11-06-u-annotation"})
    public void testScreen0Linkage() {
        Assert.assertNotNull((Object)this.screen0);
        Assert.assertEquals((int)1, (int)this.screen0.sizeOfLinkedAnnotationList());
        Assert.assertEquals((int)1, (int)this.screen0.sizeOfLinkedPlateList());
        Assert.assertEquals((Object)this.plate0, (Object)this.screen0.getLinkedPlate(0));
        Assert.assertEquals((Object)this.xmlAnnotation1, (Object)this.screen0.getLinkedAnnotation(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-spw", "11-06-u-annotation"})
    public void testScreen1Linkage() {
        Assert.assertNotNull((Object)this.screen1);
        Assert.assertEquals((int)1, (int)this.screen1.sizeOfLinkedAnnotationList());
        Assert.assertEquals((int)2, (int)this.screen1.sizeOfLinkedPlateList());
        Assert.assertEquals((Object)this.plate1, (Object)this.screen1.getLinkedPlate(0));
        Assert.assertEquals((Object)this.plate0, (Object)this.screen1.getLinkedPlate(1));
        Assert.assertEquals((Object)this.xmlAnnotation1, (Object)this.screen1.getLinkedAnnotation(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-spw", "11-06-u-annotation"})
    public void testScreen2Linkage() {
        Assert.assertNotNull((Object)this.screen2);
        Assert.assertEquals((int)1, (int)this.screen2.sizeOfLinkedAnnotationList());
        Assert.assertEquals((int)0, (int)this.screen2.sizeOfLinkedPlateList());
        Assert.assertEquals((Object)this.xmlAnnotation1, (Object)this.screen2.getLinkedAnnotation(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-spw", "11-06-u-annotation"})
    public void testScreen3Linkage() {
        Assert.assertNotNull((Object)this.screen3);
        Assert.assertEquals((int)1, (int)this.screen3.sizeOfLinkedAnnotationList());
        Assert.assertEquals((int)1, (int)this.screen3.sizeOfLinkedPlateList());
        Assert.assertEquals((Object)this.plate0, (Object)this.screen3.getLinkedPlate(0));
        Assert.assertEquals((Object)this.xmlAnnotation1, (Object)this.screen3.getLinkedAnnotation(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-exper"})
    public void testExperimenterGroup0Linkage() {
        Assert.assertNotNull((Object)this.experimenterGroup0);
        Assert.assertEquals((int)1, (int)this.experimenterGroup0.sizeOfLinkedExperimenterList());
        Assert.assertEquals((int)1, (int)this.experimenterGroup0.sizeOfLinkedLeaderList());
        Assert.assertEquals((Object)this.experimenter5, (Object)this.experimenterGroup0.getLinkedExperimenter(0));
        Assert.assertEquals((Object)this.experimenter0, (Object)this.experimenterGroup0.getLinkedLeader(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-exper"})
    public void testExperimenterGroup1Linkage() {
        Assert.assertNotNull((Object)this.experimenterGroup1);
        Assert.assertEquals((int)2, (int)this.experimenterGroup1.sizeOfLinkedExperimenterList());
        Assert.assertEquals((int)2, (int)this.experimenterGroup1.sizeOfLinkedLeaderList());
        Assert.assertEquals((Object)this.experimenter2, (Object)this.experimenterGroup1.getLinkedExperimenter(0));
        Assert.assertEquals((Object)this.experimenter3, (Object)this.experimenterGroup1.getLinkedExperimenter(1));
        Assert.assertEquals((Object)this.experimenter0, (Object)this.experimenterGroup1.getLinkedLeader(0));
        Assert.assertEquals((Object)this.experimenter1, (Object)this.experimenterGroup1.getLinkedLeader(1));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-exper"})
    public void testExperimenterGroup2Linkage() {
        Assert.assertNotNull((Object)this.experimenterGroup2);
        Assert.assertEquals((int)1, (int)this.experimenterGroup2.sizeOfLinkedExperimenterList());
        Assert.assertEquals((int)1, (int)this.experimenterGroup2.sizeOfLinkedLeaderList());
        Assert.assertEquals((Object)this.experimenter4, (Object)this.experimenterGroup2.getLinkedExperimenter(0));
        Assert.assertEquals((Object)this.experimenter6, (Object)this.experimenterGroup2.getLinkedLeader(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-exper"})
    public void testExperimenterGroup3Linkage() {
        Assert.assertNotNull((Object)this.experimenterGroup3);
        Assert.assertEquals((int)0, (int)this.experimenterGroup3.sizeOfLinkedExperimenterList());
        Assert.assertEquals((int)1, (int)this.experimenterGroup3.sizeOfLinkedLeaderList());
        Assert.assertEquals((Object)this.experimenter0, (Object)this.experimenterGroup3.getLinkedLeader(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-exper"})
    public void testExperimenterGroup4Linkage() {
        Assert.assertNotNull((Object)this.experimenterGroup4);
        Assert.assertEquals((int)0, (int)this.experimenterGroup4.sizeOfLinkedExperimenterList());
        Assert.assertEquals((int)1, (int)this.experimenterGroup4.sizeOfLinkedLeaderList());
        Assert.assertEquals((Object)this.experimenter0, (Object)this.experimenterGroup4.getLinkedLeader(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-image", "11-06-u-exper", "11-06-u-roi", "11-06-u-annotation"})
    public void testImage0Linkage() {
        Assert.assertNotNull((Object)this.image0);
        Assert.assertEquals((int)0, (int)this.image0.sizeOfLinkedAnnotationList());
        Assert.assertEquals((int)3, (int)this.image0.sizeOfLinkedROIList());
        Assert.assertEquals((Object)this.experimenter1, (Object)this.image0.getLinkedExperimenter());
        Assert.assertEquals((Object)this.roi0, (Object)this.image0.getLinkedROI(0));
        Assert.assertEquals((Object)this.roi1, (Object)this.image0.getLinkedROI(1));
        Assert.assertEquals((Object)this.roi2, (Object)this.image0.getLinkedROI(2));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-proj", "11-06-u-annotation"})
    public void testProject0Linkage() {
        Assert.assertNotNull((Object)this.project0);
        Assert.assertEquals((int)1, (int)this.project0.sizeOfLinkedAnnotationList());
        Assert.assertEquals((int)1, (int)this.project0.sizeOfLinkedDatasetList());
        Assert.assertEquals((Object)this.dataset0, (Object)this.project0.getLinkedDataset(0));
        Assert.assertEquals((Object)this.xmlAnnotation0, (Object)this.project0.getLinkedAnnotation(0));
    }

    @Test(groups={"11-06-u-links"}, dependsOnGroups={"11-06-u-image", "11-06-u-proj", "11-06-u-annotation"})
    public void testDataset0Linkage() {
        Assert.assertNotNull((Object)this.dataset0);
        Assert.assertEquals((int)1, (int)this.dataset0.sizeOfLinkedAnnotationList());
        Assert.assertEquals((int)1, (int)this.dataset0.sizeOfLinkedImageList());
        Assert.assertEquals((Object)this.image0, (Object)this.dataset0.getLinkedImage(0));
        Assert.assertEquals((Object)this.xmlAnnotation1, (Object)this.dataset0.getLinkedAnnotation(0));
    }
}

