/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.util.Iterator;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.stream.MemoryCacheImageInputStream;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import loci.common.DataTools;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;
import ome.codecs.LosslessJPEGCodec;
import ome.codecs.gui.AWTImageTools;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class JPEGCodec
extends BaseCodec {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        if (data == null || data.length == 0) {
            return data;
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        if (options.bitsPerSample > 8) {
            throw new CodecException("> 8 bit data cannot be compressed with JPEG.");
        }
        int maxByteArrayLength = 0xFFFFFFF;
        ByteArrayOutputStream out = new ByteArrayOutputStream(Math.min(maxByteArrayLength, Math.max(1024, data.length / 4)));
        BufferedImage img = AWTImageTools.makeImage(data, options.width, options.height, options.channels, options.interleaved, options.bitsPerSample / 8, false, options.littleEndian, options.signed);
        try {
            ImageWriter jpgWriter;
            boolean disableChromaSubsampling;
            double jpegquality = 0.75;
            if (options.quality > 0.0) {
                jpegquality = options.quality;
            }
            boolean bl = disableChromaSubsampling = (jpegquality = Math.max(0.25, Math.min(1.0, jpegquality))) >= 0.9;
            if (options.disableChromaSubsampling) {
                disableChromaSubsampling = options.disableChromaSubsampling;
            }
            if ((jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next()) == null) {
                return null;
            }
            ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
            jpgWriteParam.setCompressionMode(2);
            jpgWriteParam.setCompressionQuality((float)jpegquality);
            if (jpegquality == 1.0) {
                jpgWriteParam.setSourceSubsampling(1, 1, 0, 0);
            }
            MemoryCacheImageOutputStream stream = new MemoryCacheImageOutputStream(out);
            try {
                Iterator<ImageWriter> iterator = ImageIO.getImageWritersByFormatName("jpeg");
                if (iterator.hasNext()) {
                    ImageWriter writer = iterator.next();
                    writer.setOutput(stream);
                    IIOImage outputImage = null;
                    outputImage = !disableChromaSubsampling ? new IIOImage(img, null, null) : this.createIIOImageNoChromaSubsampling(jpgWriter, img, jpgWriteParam);
                    writer.write(null, outputImage, jpgWriteParam);
                }
            }
            finally {
                jpgWriter.dispose();
                stream.flush();
                stream.close();
            }
        }
        catch (IOException e) {
            throw new CodecException("Could not write JPEG data", e);
        }
        return out.toByteArray();
    }

    private IIOImage createIIOImageNoChromaSubsampling(ImageWriter jpgWriter, BufferedImage img, ImageWriteParam jpgWriteParam) throws CodecException {
        try {
            IIOMetadata metadata = jpgWriter.getDefaultImageMetadata(new ImageTypeSpecifier(img.getColorModel(), img.getSampleModel()), jpgWriteParam);
            Node rootNode = metadata != null ? metadata.getAsTree("javax_imageio_jpeg_image_1.0") : null;
            boolean metadataUpdated = false;
            if (rootNode != null && rootNode.getLastChild() != null) {
                Node markerNode = rootNode.getLastChild();
                NodeList markers = markerNode.getChildNodes();
                for (int i = 0; i < markers.getLength(); ++i) {
                    Node node = markers.item(i);
                    if (!node.getNodeName().equalsIgnoreCase("sof") || !node.hasChildNodes() || node.getChildNodes().getLength() != 3) continue;
                    NamedNodeMap attrMap = node.getFirstChild().getAttributes();
                    int samplingmode = 17;
                    attrMap.getNamedItem("HsamplingFactor").setNodeValue((samplingmode & 0xF) + "");
                    attrMap.getNamedItem("VsamplingFactor").setNodeValue((samplingmode >> 4 & 0xF) + "");
                    metadataUpdated = true;
                    break;
                }
            }
            if (metadataUpdated) {
                metadata.setFromTree("javax_imageio_jpeg_image_1.0", rootNode);
            }
            IIOImage iioImage = new IIOImage(img, null, metadata);
            return iioImage;
        }
        catch (IOException e) {
            throw new CodecException("Could not create IIOImage object with disbaled chroma subsampling", e);
        }
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        DataBufferByte bb;
        BufferedImage b = null;
        long fp = in.getFilePointer();
        try {
            try {
                while (in.read() != -1 || in.read() != -40) {
                }
                in.seek(in.getFilePointer() - 2L);
            }
            catch (EOFException e) {
                in.seek(fp);
            }
            MemoryCacheImageInputStream stream = new MemoryCacheImageInputStream(new BufferedInputStream(in, 81920));
            b = ImageIO.read(stream);
            if (b == null) {
                throw new NullPointerException("ImageIO returned null when reading JPEG stream");
            }
        }
        catch (IOException exc) {
            in.seek(fp);
            return new LosslessJPEGCodec().decompress(in, options);
        }
        if (options == null) {
            options = CodecOptions.getDefaultOptions();
        }
        int nPixels = b.getWidth() * b.getHeight();
        WritableRaster r = b.getRaster();
        if (!options.ycbcr && r.getDataBuffer() instanceof DataBufferByte && b.getType() == 10 && (bb = (DataBufferByte)r.getDataBuffer()).getNumBanks() == 1) {
            byte[] raw = bb.getData();
            if (options.interleaved || bb.getSize() == nPixels) {
                return raw;
            }
        }
        byte[][] buf = AWTImageTools.getPixelBytes(b, options.littleEndian);
        if (options.ycbcr && buf.length == 3) {
            int n = buf[0].length;
            int nBytes = n / (b.getWidth() * b.getHeight());
            int mask = (int)(Math.pow(2.0, nBytes * 8) - 1.0);
            for (int i = 0; i < n; i += nBytes) {
                double y = DataTools.bytesToInt(buf[0], i, nBytes, options.littleEndian);
                double cb = DataTools.bytesToInt(buf[1], i, nBytes, options.littleEndian);
                double cr = DataTools.bytesToInt(buf[2], i, nBytes, options.littleEndian);
                cb = Math.max(0.0, cb - 128.0);
                cr = Math.max(0.0, cr - 128.0);
                int red = (int)(y + 1.402 * cr);
                int green = (int)(y - 0.34414 * cb - 0.71414 * cr);
                int blue = (int)(y + 1.772 * cb);
                red = Math.min(red, mask) & mask;
                green = Math.min(green, mask) & mask;
                blue = Math.min(blue, mask) & mask;
                DataTools.unpackBytes(red, buf[0], i, nBytes, options.littleEndian);
                DataTools.unpackBytes(green, buf[1], i, nBytes, options.littleEndian);
                DataTools.unpackBytes(blue, buf[2], i, nBytes, options.littleEndian);
            }
        }
        byte[] rtn = new byte[buf.length * buf[0].length];
        if (buf.length == 1) {
            rtn = buf[0];
        } else if (options.interleaved) {
            int channels = buf.length;
            for (int j = 0; j < channels; ++j) {
                byte[] bufChannel = buf[j];
                int n = bufChannel.length;
                int next = j;
                for (int i = 0; i < n; ++i) {
                    rtn[next] = bufChannel[i];
                    next += channels;
                }
            }
        } else {
            for (int i = 0; i < buf.length; ++i) {
                System.arraycopy(buf[i], 0, rtn, i * buf[0].length, buf[i].length);
            }
        }
        return rtn;
    }
}

