/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.MetadataTools;
import loci.formats.in.MetadataLevel;
import loci.formats.meta.MetadataStore;

public class FEIReader
extends FormatReader {
    public static final String FEI_MAGIC_STRING = "XL";
    private static final int INVALID_PIXELS = 112;
    private int headerSize;

    public FEIReader() {
        super("FEI/Philips", "img");
        this.suffixSufficient = false;
        this.domains = new String[]{"Scanning Electron Microscopy (SEM)"};
    }

    @Override
    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 2;
        if (!FormatTools.validStream(stream, 2, false)) {
            return false;
        }
        return stream.readString(2).startsWith(FEI_MAGIC_STRING);
    }

    @Override
    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        FormatTools.checkPlaneParameters(this, no, buf.length, x, y, w, h2);
        this.in.seek(this.headerSize);
        byte[] segment = new byte[this.getSizeX() / 2];
        byte[] plane = new byte[FormatTools.getPlaneSize(this)];
        for (int q = 0; q < 4; ++q) {
            for (int row = q; row < this.getSizeY(); row += 4) {
                for (int s2 = 0; s2 < 2; ++s2) {
                    this.in.read(segment);
                    this.in.skipBytes(56);
                    for (int col = s2; col < this.getSizeX(); col += 2) {
                        plane[row * this.getSizeX() + col] = segment[col / 2];
                    }
                }
            }
        }
        try (RandomAccessInputStream pixels = new RandomAccessInputStream(plane);){
            this.readPlane(pixels, x, y, w, h2, buf);
        }
        return buf;
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.headerSize = 0;
        }
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.order(true);
        CoreMetadata m4 = (CoreMetadata)this.core.get(0);
        LOGGER.info("Reading file header");
        if (this.getMetadataOptions().getMetadataLevel() != MetadataLevel.MINIMUM) {
            this.in.skipBytes(44);
            float magnification = this.in.readFloat();
            float kV = this.in.readFloat() / 1000.0f;
            float wd = this.in.readFloat();
            this.in.skipBytes(12);
            float spot = this.in.readFloat();
            this.addGlobalMeta("Magnification", magnification);
            this.addGlobalMeta("kV", kV);
            this.addGlobalMeta("Working distance", wd);
            this.addGlobalMeta("Spot", spot);
        }
        this.in.seek(514L);
        m4.sizeX = this.in.readShort() - 112;
        m4.sizeY = this.in.readShort();
        this.in.skipBytes(4);
        this.headerSize = this.in.readShort();
        m4.sizeZ = 1;
        m4.sizeC = 1;
        m4.sizeT = 1;
        m4.imageCount = 1;
        m4.littleEndian = true;
        m4.pixelType = 1;
        m4.rgb = false;
        m4.indexed = false;
        m4.interleaved = false;
        m4.dimensionOrder = "XYCZT";
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels(store, this);
    }
}

