/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests", "readLineTest"})
public class ReadLineTest {
    private static final byte[] PAGE = new byte[]{97, 98, 99, 10, 100, 101, 102, 10, 103, 104, 105, 10, 106, 107, 108, 10};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequential() throws IOException {
        AssertJUnit.assertEquals((String)"abc", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((String)"def", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((String)"ghi", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)12L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((String)"jkl", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.getFilePointer());
    }

    @Test
    public void testSeekForward() throws IOException {
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((String)"ghi", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)12L, (long)this.fileHandle.getFilePointer());
    }

    @Test
    public void testReset() throws IOException {
        AssertJUnit.assertEquals((String)"abc", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((String)"def", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.getFilePointer());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((String)"abc", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((String)"def", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.getFilePointer());
    }

    @Test
    public void testSeekBack() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((String)"ghi", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)12L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((String)"jkl", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.getFilePointer());
    }

    @Test
    public void testPartial() throws IOException {
        AssertJUnit.assertEquals((byte)97, (byte)this.fileHandle.readByte());
        AssertJUnit.assertEquals((long)1L, (long)this.fileHandle.getFilePointer());
        AssertJUnit.assertEquals((String)"bc", (String)this.fileHandle.readLine());
        AssertJUnit.assertEquals((byte)100, (byte)this.fileHandle.readByte());
    }

    @Test
    public void testRandomAccess() throws IOException {
        this.testSeekForward();
        this.testSeekBack();
        this.fileHandle.seek(0L);
        this.testPartial();
        this.fileHandle.seek(0L);
        this.testReset();
    }
}

