/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.awt.image.ColorModel;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.List;
import java.util.Set;
import loci.common.Region;
import loci.formats.FormatException;
import loci.formats.IFormatWriter;
import loci.formats.ImageWriter;
import loci.formats.Resolution;
import loci.formats.codec.Codec;
import loci.formats.codec.CodecOptions;
import loci.formats.in.MetadataLevel;
import loci.formats.in.MetadataOptions;
import loci.formats.meta.MetadataRetrieve;

public abstract class WriterWrapper
implements IFormatWriter {
    protected IFormatWriter writer;

    public WriterWrapper() {
        this(new ImageWriter());
    }

    public WriterWrapper(IFormatWriter w) {
        if (w == null) {
            throw new IllegalArgumentException("Format writer cannot be null");
        }
        this.writer = w;
    }

    public IFormatWriter getWriter() {
        return this.writer;
    }

    public IFormatWriter unwrap() throws FormatException, IOException {
        return this.unwrap(null, null);
    }

    public IFormatWriter unwrap(String id) throws FormatException, IOException {
        return this.unwrap(null, id);
    }

    public IFormatWriter unwrap(Class<? extends IFormatWriter> writerClass, String id) throws FormatException, IOException {
        IFormatWriter w = this;
        while (!(!(w instanceof WriterWrapper) && !(w instanceof ImageWriter) || writerClass != null && writerClass.isInstance(w))) {
            if (w instanceof ImageWriter) {
                ImageWriter iw = (ImageWriter)w;
                w = id == null ? iw.getWriter() : iw.getWriter(id);
                continue;
            }
            w = w.getWriter();
        }
        if (writerClass != null && !writerClass.isInstance(w)) {
            return null;
        }
        return w;
    }

    public WriterWrapper duplicate(Class<? extends IFormatWriter> imageWriterClass) throws FormatException {
        WriterWrapper wrapperCopy = this.duplicateRecurse(imageWriterClass);
        boolean interleaved = this.isInterleaved();
        ColorModel cm = this.getColorModel();
        int rate = this.getFramesPerSecond();
        String compress = this.getCompression();
        int tileSizeX = this.getTileSizeX();
        int tileSizeY = this.getTileSizeY();
        wrapperCopy.setInterleaved(interleaved);
        wrapperCopy.setColorModel(cm);
        wrapperCopy.setFramesPerSecond(rate);
        wrapperCopy.setCompression(compress);
        wrapperCopy.setTileSizeX(tileSizeX);
        wrapperCopy.setTileSizeY(tileSizeY);
        return wrapperCopy;
    }

    @Override
    public Set<MetadataLevel> getSupportedMetadataLevels() {
        return this.writer.getSupportedMetadataLevels();
    }

    @Override
    public MetadataOptions getMetadataOptions() {
        return this.writer.getMetadataOptions();
    }

    @Override
    public void setMetadataOptions(MetadataOptions options) {
        this.writer.setMetadataOptions(options);
    }

    @Override
    public void changeOutputFile(String id) throws FormatException, IOException {
        this.writer.changeOutputFile(id);
    }

    @Override
    public void saveBytes(int no, byte[] buf) throws FormatException, IOException {
        this.writer.saveBytes(no, buf);
    }

    @Override
    public void saveBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        this.writer.saveBytes(no, buf, x, y, w, h2);
    }

    @Override
    public void saveBytes(int no, byte[] buf, Region tile) throws FormatException, IOException {
        this.writer.saveBytes(no, buf, tile);
    }

    @Override
    public void savePlane(int no, Object plane) throws FormatException, IOException {
        this.writer.savePlane(no, plane);
    }

    @Override
    public void savePlane(int no, Object plane, int x, int y, int w, int h2) throws FormatException, IOException {
        this.writer.savePlane(no, plane, x, y, w, h2);
    }

    @Override
    public void savePlane(int no, Object plane, Region tile) throws FormatException, IOException {
        this.writer.savePlane(no, plane, tile);
    }

    @Override
    public void setSeries(int series) throws FormatException {
        this.writer.setSeries(series);
    }

    @Override
    public int getSeries() {
        return this.writer.getSeries();
    }

    @Override
    public void setInterleaved(boolean interleaved) {
        this.writer.setInterleaved(interleaved);
    }

    @Override
    public boolean isInterleaved() {
        return this.writer.isInterleaved();
    }

    @Override
    public void setValidBitsPerPixel(int bits) {
        this.writer.setValidBitsPerPixel(bits);
    }

    @Override
    public boolean canDoStacks() {
        return this.writer.canDoStacks();
    }

    @Override
    public void setMetadataRetrieve(MetadataRetrieve r) {
        this.writer.setMetadataRetrieve(r);
    }

    @Override
    public MetadataRetrieve getMetadataRetrieve() {
        return this.writer.getMetadataRetrieve();
    }

    @Override
    public void setColorModel(ColorModel cm) {
        this.writer.setColorModel(cm);
    }

    @Override
    public ColorModel getColorModel() {
        return this.writer.getColorModel();
    }

    @Override
    public void setFramesPerSecond(int rate) {
        this.writer.setFramesPerSecond(rate);
    }

    @Override
    public int getFramesPerSecond() {
        return this.writer.getFramesPerSecond();
    }

    @Override
    public String[] getCompressionTypes() {
        return this.writer.getCompressionTypes();
    }

    @Override
    public int[] getPixelTypes() {
        return this.writer.getPixelTypes();
    }

    @Override
    public int[] getPixelTypes(String codec) {
        return this.writer.getPixelTypes(codec);
    }

    @Override
    public boolean isSupportedType(int type) {
        return this.writer.isSupportedType(type);
    }

    @Override
    public void setCompression(String compress) throws FormatException {
        this.writer.setCompression(compress);
    }

    @Override
    public void setCodecOptions(CodecOptions options) {
        this.writer.setCodecOptions(options);
    }

    @Override
    public String getCompression() {
        return this.writer.getCompression();
    }

    @Override
    public void setWriteSequentially(boolean sequential) {
        this.writer.setWriteSequentially(sequential);
    }

    @Override
    public int getTileSizeX() throws FormatException {
        return this.writer.getTileSizeX();
    }

    @Override
    public int setTileSizeX(int tileSize) throws FormatException {
        return this.writer.setTileSizeX(tileSize);
    }

    @Override
    public int getTileSizeY() throws FormatException {
        return this.writer.getTileSizeY();
    }

    @Override
    public int setTileSizeY(int tileSize) throws FormatException {
        return this.writer.setTileSizeY(tileSize);
    }

    @Override
    public void setResolutions(List<Resolution> resolutions) {
        this.writer.setResolutions(resolutions);
    }

    @Override
    public List<Resolution> getResolutions() {
        return this.writer.getResolutions();
    }

    @Override
    public void saveCompressedBytes(int no, byte[] buf, int x, int y, int w, int h2) throws FormatException, IOException {
        this.writer.saveCompressedBytes(no, buf, x, y, w, h2);
    }

    @Override
    public Codec getCodec() {
        return this.writer.getCodec();
    }

    @Override
    public CodecOptions getCodecOptions() {
        return this.writer.getCodecOptions();
    }

    @Override
    public boolean isThisType(String name) {
        return this.writer.isThisType(name);
    }

    @Override
    public String getFormat() {
        return this.writer.getFormat();
    }

    @Override
    public String[] getSuffixes() {
        return this.writer.getSuffixes();
    }

    @Override
    public Class<?> getNativeDataType() {
        return this.writer.getNativeDataType();
    }

    @Override
    public void setId(String id) throws FormatException, IOException {
        this.writer.setId(id);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    @Override
    public int getResolutionCount() {
        return this.writer.getResolutionCount();
    }

    @Override
    public int getResolution() {
        return this.writer.getResolution();
    }

    @Override
    public void setResolution(int resolution) {
        this.writer.setResolution(resolution);
    }

    private WriterWrapper duplicateRecurse(Class<? extends IFormatWriter> imageWriterClass) throws FormatException {
        IFormatWriter childCopy = null;
        if (this.writer instanceof WriterWrapper) {
            childCopy = ((WriterWrapper)this.writer).duplicateRecurse(imageWriterClass);
        } else {
            Class c = null;
            c = this.writer instanceof ImageWriter ? (imageWriterClass == null ? ImageWriter.class : imageWriterClass) : this.writer.getClass();
            try {
                childCopy = (IFormatWriter)c.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (ReflectiveOperationException exc) {
                throw new FormatException(exc);
            }
        }
        Class<?> wrapperClass = this.getClass();
        WriterWrapper wrapperCopy = null;
        try {
            wrapperCopy = (WriterWrapper)wrapperClass.getConstructor(IFormatWriter.class).newInstance(childCopy);
        }
        catch (InstantiationException exc) {
            throw new FormatException(exc);
        }
        catch (IllegalAccessException exc) {
            throw new FormatException(exc);
        }
        catch (NoSuchMethodException exc) {
            throw new FormatException(exc);
        }
        catch (InvocationTargetException exc) {
            throw new FormatException(exc);
        }
        return wrapperCopy;
    }
}

