/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.dataset.conv;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;
import javax.annotation.Nullable;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.CoordinateTransform;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dataset.spi.CoordSystemBuilderFactory;
import ucar.nc2.internal.dataset.CoordSystemBuilder;
import ucar.nc2.units.SimpleUnit;
import ucar.nc2.util.CancelTask;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.ProjectionPoint;
import ucar.unidata.geoloc.projection.LambertConformal;
import ucar.unidata.geoloc.projection.Stereographic;
import ucar.unidata.util.StringUtil2;

public class AWIPSConvention
extends CoordSystemBuilder {
    private static final String CONVENTION_NAME = "AWIPS";
    private static final boolean debugProj = false;
    private static final boolean debugBreakup = false;
    ProjectionCT projCT;
    double startx;
    double starty;
    double dx;
    double dy;

    AWIPSConvention(NetcdfDataset.Builder datasetBuilder) {
        super(datasetBuilder);
        this.conventionName = CONVENTION_NAME;
    }

    @Override
    public void augmentDataset(CancelTask cancelTask) throws IOException {
        if (this.rootGroup.findVariable("x").isPresent()) {
            return;
        }
        int nx = this.rootGroup.findDimension("x").map(Dimension::getLength).orElseThrow(() -> new RuntimeException("missing dimension x"));
        int ny = this.rootGroup.findDimension("y").map(Dimension::getLength).orElseThrow(() -> new RuntimeException("missing dimension y"));
        String projName = this.rootGroup.getAttributeContainer().findAttValueIgnoreCase("projName", "none");
        if (projName.equalsIgnoreCase("LATLON")) {
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeLonCoordAxis(nx, "x"));
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeLatCoordAxis(ny, "y"));
        } else if (projName.equalsIgnoreCase("LAMBERT_CONFORMAL")) {
            this.projCT = this.makeLCProjection(projName);
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeXCoordAxis("x"));
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeYCoordAxis("y"));
        } else if (projName.equalsIgnoreCase("STEREOGRAPHIC")) {
            this.projCT = this.makeStereoProjection(projName);
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeXCoordAxis("x"));
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, this.makeYCoordAxis("y"));
        }
        CoordinateAxis.Builder timeCoord = this.makeTimeCoordAxis();
        if (timeCoord != null) {
            this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, timeCoord);
            String dimName = timeCoord.getFirstDimensionName();
            if (!timeCoord.shortName.equals(dimName)) {
                timeCoord.addAttribute(new Attribute("_CoordinateAliasForDimension", dimName));
            }
        }
        for (Variable.Builder builder : ImmutableList.copyOf(this.rootGroup.vbuilders)) {
            VariableDS.Builder levelVar;
            String levelName = builder.shortName + "Levels";
            if (!this.rootGroup.findVariable(levelName).isPresent() || (levelVar = (VariableDS.Builder)this.rootGroup.findVariable(levelName).get()).getRank() != 2 || levelVar.dataType != DataType.CHAR) continue;
            try {
                List<Dimension> levels = this.breakupLevels(levelVar);
                this.createNewVariables((VariableDS.Builder)builder, levels, levelVar.orgVar.getDimension(0));
            }
            catch (IOException | InvalidRangeException ioe) {
                this.parseInfo.format("createNewVariables IOException%n", new Object[0]);
            }
        }
        if (this.projCT != null) {
            VariableDS.Builder v = this.makeCoordinateTransformVariable(this.projCT);
            v.addAttribute(new Attribute("_CoordinateAxes", "x y"));
            this.rootGroup.addVariable(v);
        }
        for (Variable.Builder<?> builder : this.rootGroup.vbuilders) {
            String units = builder.getAttributeContainer().findAttValueIgnoreCase("units", null);
            if (units == null) continue;
            ((VariableDS.Builder)builder).setUnits(this.normalize(units));
        }
    }

    private String normalize(String units) {
        if (units.equals("/second")) {
            units = "1/sec";
        }
        if (units.equals("degrees K")) {
            units = "K";
        } else {
            units = StringUtil2.substitute(units, "**", "^");
            units = StringUtil2.remove(units, 41);
            units = StringUtil2.remove(units, 40);
        }
        return units;
    }

    private List<Dimension> breakupLevels(VariableDS.Builder levelVar) throws IOException {
        ArrayChar levelVarData;
        ArrayList<Dimension> dimList = new ArrayList<Dimension>();
        try {
            levelVarData = (ArrayChar)levelVar.orgVar.read();
        }
        catch (IOException ioe) {
            return dimList;
        }
        ArrayList<String> values = null;
        String currentUnits = null;
        ArrayChar.StringIterator iter = levelVarData.getStringIterator();
        while (iter.hasNext()) {
            String s2 = iter.next();
            StringTokenizer stoke = new StringTokenizer(s2);
            if (!stoke.hasMoreTokens()) continue;
            String units = stoke.nextToken().trim();
            if (!units.equals(currentUnits)) {
                if (values != null) {
                    dimList.add(this.makeZCoordAxis(values, currentUnits));
                }
                values = new ArrayList<String>();
                currentUnits = units;
            }
            if (stoke.hasMoreTokens()) {
                values.add(stoke.nextToken());
                continue;
            }
            values.add("0");
        }
        if (values != null) {
            dimList.add(this.makeZCoordAxis(values, currentUnits));
        }
        return dimList;
    }

    private Dimension makeZCoordAxis(List<String> values, String units) {
        Dimension dim;
        int len = values.size();
        String name = this.makeZCoordName(units);
        name = len > 1 ? name + len : name + values.get(0);
        StringUtil2.replace(name, ' ', "-");
        if (this.rootGroup.findDimension(name).isPresent() && (dim = this.rootGroup.findDimension(name).get()).getLength() == len && this.rootGroup.findVariable(name).isPresent()) {
            return dim;
        }
        String orgName = name;
        int count = 1;
        while (this.rootGroup.findDimension(name).isPresent()) {
            name = orgName + "-" + count;
            ++count;
        }
        Dimension dim2 = new Dimension(name, len);
        this.rootGroup.addDimension(dim2);
        CoordinateAxis1D.Builder v = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(name)).setDataType(DataType.DOUBLE)).setDimensionsByName(name)).setUnits(this.makeUnitsName(units))).setDesc(this.makeLongName(name));
        String positive = this.getZisPositive(v);
        if (null != positive) {
            v.addAttribute(new Attribute("_CoordinateZisPositive", positive));
        }
        Array data = Array.makeArray(DataType.DOUBLE, values);
        v.setCachedData(data, true);
        this.datasetBuilder.replaceCoordinateAxis(this.rootGroup, v);
        this.parseInfo.format("Created Z Coordinate Axis = %s%n", name);
        return dim2;
    }

    private String makeZCoordName(String units) {
        if (units.equalsIgnoreCase("MB")) {
            return "PressureLevels";
        }
        if (units.equalsIgnoreCase("K")) {
            return "PotTempLevels";
        }
        if (units.equalsIgnoreCase("BL")) {
            return "BoundaryLayers";
        }
        if (units.equalsIgnoreCase("FHAG")) {
            return "FixedHeightAboveGround";
        }
        if (units.equalsIgnoreCase("FH")) {
            return "FixedHeight";
        }
        if (units.equalsIgnoreCase("SFC")) {
            return "Surface";
        }
        if (units.equalsIgnoreCase("MSL")) {
            return "MeanSeaLevel";
        }
        if (units.equalsIgnoreCase("FRZ")) {
            return "FreezingLevel";
        }
        if (units.equalsIgnoreCase("TROP")) {
            return "Tropopause";
        }
        if (units.equalsIgnoreCase("MAXW")) {
            return "MaxWindLevel";
        }
        return units;
    }

    private String makeUnitsName(String units) {
        if (units.equalsIgnoreCase("MB")) {
            return "hPa";
        }
        if (units.equalsIgnoreCase("BL")) {
            return "hPa";
        }
        if (units.equalsIgnoreCase("FHAG")) {
            return "m";
        }
        if (units.equalsIgnoreCase("FH")) {
            return "m";
        }
        return "";
    }

    private String makeLongName(String name) {
        if (name.equalsIgnoreCase("PotTempLevels")) {
            return "Potential Temperature Level";
        }
        if (name.equalsIgnoreCase("BoundaryLayers")) {
            return "BoundaryLayer hectoPascals above ground";
        }
        return name;
    }

    private void createNewVariables(VariableDS.Builder ncVar, List<Dimension> newDims, Dimension levelDim) throws InvalidRangeException {
        ArrayList<Dimension> dims = new ArrayList<Dimension>(ncVar.orgVar.getDimensions());
        int newDimIndex = dims.indexOf(levelDim);
        int[] origin = new int[ncVar.getRank()];
        int[] shape = ncVar.orgVar.getShape();
        int count = 0;
        for (Dimension dim : newDims) {
            origin[newDimIndex] = count;
            shape[newDimIndex] = dim.getLength();
            Variable varSection = ncVar.orgVar.section(new Section(origin, shape));
            String name = ncVar.shortName + "-" + dim.getShortName();
            VariableDS.Builder varNew = (VariableDS.Builder)((Variable.Builder)((VariableDS.Builder)VariableDS.builder().setName(name)).setOriginalVariable(varSection)).setDataType(ncVar.dataType);
            dims.set(newDimIndex, dim);
            varNew.addDimensions(dims);
            varNew.addAttributes(ncVar.getAttributeContainer());
            String long_name = ncVar.getAttributeContainer().findAttValueIgnoreCase("long_name", ncVar.shortName);
            long_name = long_name + "-" + dim.getShortName();
            varNew.getAttributeContainer().addAttribute(new Attribute("long_name", long_name));
            this.rootGroup.addVariable(varNew);
            this.parseInfo.format("Created New Variable as section = %s%n", name);
            count += dim.getLength();
        }
    }

    @Override
    @Nullable
    protected AxisType getAxisType(VariableDS.Builder v) {
        String vname = v.shortName;
        if (vname.equalsIgnoreCase("x")) {
            return AxisType.GeoX;
        }
        if (vname.equalsIgnoreCase("lon")) {
            return AxisType.Lon;
        }
        if (vname.equalsIgnoreCase("y")) {
            return AxisType.GeoY;
        }
        if (vname.equalsIgnoreCase("lat")) {
            return AxisType.Lat;
        }
        if (vname.equalsIgnoreCase("record")) {
            return AxisType.Time;
        }
        String dimName = v.getFirstDimensionName();
        if (dimName != null && dimName.equalsIgnoreCase("record")) {
            return AxisType.Time;
        }
        String unit = v.getUnits();
        if (unit != null) {
            if (SimpleUnit.isCompatible("millibar", unit)) {
                return AxisType.Pressure;
            }
            if (SimpleUnit.isCompatible("m", unit)) {
                return AxisType.Height;
            }
        }
        return AxisType.GeoZ;
    }

    @Override
    protected void makeCoordinateTransforms() {
        if (this.projCT != null) {
            CoordSystemBuilder.VarProcess vp = this.findVarProcess(this.projCT.getName(), null);
            vp.isCoordinateTransform = true;
            vp.ct = CoordinateTransform.builder().setPreBuilt(this.projCT);
        }
        super.makeCoordinateTransforms();
    }

    private String getZisPositive(CoordinateAxis.Builder v) {
        String attValue = v.getAttributeContainer().findAttValueIgnoreCase("positive", null);
        if (null != attValue) {
            return attValue.equalsIgnoreCase("up") ? "up" : "down";
        }
        String unit = v.getUnits();
        if (unit != null && SimpleUnit.isCompatible("millibar", unit)) {
            return "down";
        }
        if (unit != null && SimpleUnit.isCompatible("m", unit)) {
            return "up";
        }
        return null;
    }

    private ProjectionCT makeLCProjection(String name) throws NoSuchElementException {
        double centralLat = this.findAttributeDouble("centralLat");
        double centralLon = this.findAttributeDouble("centralLon");
        double rotation = this.findAttributeDouble("rotation");
        LambertConformal lc = new LambertConformal(rotation, centralLon, centralLat, centralLat);
        double lat0 = this.findAttributeDouble("lat00");
        double lon0 = this.findAttributeDouble("lon00");
        ProjectionPoint start = lc.latLonToProj(new LatLonPointImpl(lat0, lon0));
        this.startx = start.getX();
        this.starty = start.getY();
        this.dx = this.findAttributeDouble("dxKm");
        this.dy = this.findAttributeDouble("dyKm");
        return new ProjectionCT(name, "FGDC", lc);
    }

    private ProjectionCT makeStereoProjection(String name) throws NoSuchElementException {
        double centralLat = this.findAttributeDouble("centralLat");
        double centralLon = this.findAttributeDouble("centralLon");
        double latDxDy = this.findAttributeDouble("latDxDy");
        double latR = Math.toRadians(latDxDy);
        double scale = (1.0 + Math.abs(Math.sin(latR))) / 2.0;
        Stereographic proj = new Stereographic(centralLat, centralLon, scale);
        double lat0 = this.findAttributeDouble("lat00");
        double lon0 = this.findAttributeDouble("lon00");
        ProjectionPoint start = proj.latLonToProj(new LatLonPointImpl(lat0, lon0));
        this.startx = start.getX();
        this.starty = start.getY();
        this.dx = this.findAttributeDouble("dxKm");
        this.dy = this.findAttributeDouble("dyKm");
        this.parseInfo.format("---makeStereoProjection start at proj coord %s%n", start);
        double latN = this.findAttributeDouble("latNxNy");
        double lonN = this.findAttributeDouble("lonNxNy");
        ProjectionPoint pt = proj.latLonToProj(new LatLonPointImpl(latN, lonN));
        this.parseInfo.format("                        end at proj coord %s%n", pt);
        this.parseInfo.format("                        scale= %f%n", scale);
        return new ProjectionCT(name, "FGDC", proj);
    }

    CoordinateAxis.Builder makeXCoordAxis(String xname) {
        CoordinateAxis1D.Builder v = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(xname)).setDataType(DataType.DOUBLE)).setDimensionsByName(xname)).setUnits("km")).setDesc("x on projection");
        v.setAutoGen(this.startx, this.dx);
        this.parseInfo.format("Created X Coordinate Axis = %s%n", xname);
        return v;
    }

    CoordinateAxis.Builder makeYCoordAxis(String yname) {
        CoordinateAxis1D.Builder v = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(yname)).setDataType(DataType.DOUBLE)).setDimensionsByName(yname)).setUnits("km")).setDesc("y on projection");
        v.setAutoGen(this.starty, this.dy);
        this.parseInfo.format("Created Y Coordinate Axis = %s%n", yname);
        return v;
    }

    @Nullable
    private CoordinateAxis.Builder makeLonCoordAxis(int n, String xname) {
        double min2 = this.findAttributeDouble("xMin");
        double max = this.findAttributeDouble("xMax");
        double d = this.findAttributeDouble("dx");
        if (Double.isNaN(min2) || Double.isNaN(max) || Double.isNaN(d)) {
            return null;
        }
        CoordinateAxis1D.Builder v = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(xname)).setDataType(DataType.DOUBLE)).setDimensionsByName(xname)).setUnits("degrees_east")).setDesc("longitude");
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lon.toString()));
        v.setAutoGen(min2, d);
        double maxCalc = min2 + d * (double)n;
        this.parseInfo.format("Created Lon Coordinate Axis (max calc= %f should be = %f)%n", maxCalc, max);
        return v;
    }

    private CoordinateAxis.Builder makeLatCoordAxis(int n, String name) {
        double min2 = this.findAttributeDouble("yMin");
        double max = this.findAttributeDouble("yMax");
        double d = this.findAttributeDouble("dy");
        if (Double.isNaN(min2) || Double.isNaN(max) || Double.isNaN(d)) {
            return null;
        }
        CoordinateAxis1D.Builder v = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(name)).setDataType(DataType.DOUBLE)).setDimensionsByName(name)).setUnits("degrees_north")).setDesc("latitude");
        v.addAttribute(new Attribute("_CoordinateAxisType", AxisType.Lat.toString()));
        v.setAutoGen(min2, d);
        double maxCalc = min2 + d * (double)n;
        this.parseInfo.format("Created Lat Coordinate Axis (max calc= %f should be = %f)%n", maxCalc, max);
        return v;
    }

    private CoordinateAxis.Builder makeTimeCoordAxis() {
        String units;
        Array vals;
        VariableDS.Builder timeVar = (VariableDS.Builder)this.rootGroup.findVariable("valtimeMINUSreftime").orElseThrow(() -> new RuntimeException("must have varible 'valtimeMINUSreftime'"));
        Dimension recordDim = this.rootGroup.findDimension("record").orElseThrow(() -> new RuntimeException("must have dimension 'record'"));
        try {
            vals = timeVar.orgVar.read();
        }
        catch (IOException ioe) {
            return null;
        }
        int recLen = recordDim.getLength();
        int valLen = (int)vals.getSize();
        if (recLen != valLen) {
            try {
                vals = vals.sectionNoReduce(new int[]{0}, new int[]{recordDim.getLength()}, null);
                this.parseInfo.format(" corrected the TimeCoordAxis length%n", new Object[0]);
            }
            catch (InvalidRangeException e) {
                this.parseInfo.format("makeTimeCoordAxis InvalidRangeException%n", new Object[0]);
            }
        }
        if ((units = this.makeTimeUnitFromFilename(this.datasetBuilder.location)) == null) {
            return this.makeTimeCoordAxisFromReference(vals);
        }
        String name = "timeCoord";
        String desc = "synthesized time coordinate from valtimeMINUSreftime and filename YYYYMMDD_HHMM";
        CoordinateAxis1D.Builder timeCoord = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(name)).setDataType(DataType.INT)).setDimensionsByName("record")).setUnits(units)).setDesc(desc)).setCachedData(vals, true);
        this.parseInfo.format("Created Time Coordinate Axis = %s%n", name);
        return timeCoord;
    }

    private String makeTimeUnitFromFilename(String dsName) {
        int posLast;
        int posFirst = (dsName = dsName.replace('\\', '/')).lastIndexOf(47);
        if (posFirst < 0) {
            posFirst = 0;
        }
        if ((dsName = (posLast = dsName.indexOf(46, posFirst)) < 0 ? dsName.substring(posFirst + 1) : dsName.substring(posFirst + 1, posLast)).length() != 13) {
            return null;
        }
        String year = dsName.substring(0, 4);
        String mon = dsName.substring(4, 6);
        String day = dsName.substring(6, 8);
        String hour = dsName.substring(9, 11);
        String min2 = dsName.substring(11, 13);
        return "seconds since " + year + "-" + mon + "-" + day + " " + hour + ":" + min2 + ":0";
    }

    @Nullable
    private CoordinateAxis.Builder makeTimeCoordAxisFromReference(Array vals) {
        double refValue;
        if (!this.rootGroup.findVariable("reftime").isPresent()) {
            return null;
        }
        VariableDS.Builder refVar = (VariableDS.Builder)this.rootGroup.findVariable("reftime").get();
        try {
            Array refArray = refVar.orgVar.read();
            refValue = refArray.getDouble(refArray.getIndex());
        }
        catch (IOException ioe) {
            return null;
        }
        if (refValue == (double)9.96921E36f) {
            return null;
        }
        Array dvals = Array.factory(DataType.DOUBLE, vals.getShape());
        IndexIterator diter = dvals.getIndexIterator();
        IndexIterator iiter = vals.getIndexIterator();
        while (iiter.hasNext()) {
            diter.setDoubleNext(iiter.getDoubleNext() + refValue);
        }
        String name = "timeCoord";
        String units = refVar.getAttributeContainer().findAttValueIgnoreCase("units", "seconds since 1970-1-1 00:00:00");
        units = this.normalize(units);
        String desc = "synthesized time coordinate from reftime, valtimeMINUSreftime";
        CoordinateAxis1D.Builder timeCoord = (CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)((CoordinateAxis1D.Builder)CoordinateAxis1D.builder().setName(name)).setDataType(DataType.DOUBLE)).setDimensionsByName("record")).setUnits(units)).setDesc(desc)).setCachedData(dvals, true);
        this.parseInfo.format("Created Time Coordinate Axis From reftime Variable%n", new Object[0]);
        return timeCoord;
    }

    double findAttributeDouble(String attname) {
        Attribute att = this.rootGroup.getAttributeContainer().findAttributeIgnoreCase(attname);
        if (att == null || att.isString()) {
            this.parseInfo.format("ERROR cant find numeric attribute= %s%n", attname);
            return Double.NaN;
        }
        return att.getNumericValue().doubleValue();
    }

    public static class Factory
    implements CoordSystemBuilderFactory {
        @Override
        public String getConventionName() {
            return AWIPSConvention.CONVENTION_NAME;
        }

        @Override
        public boolean isMine(NetcdfFile ncfile) {
            return null != ncfile.findGlobalAttribute("projName") && null != ncfile.findDimension("charsPerLevel") && null != ncfile.findDimension("x") && null != ncfile.findDimension("y");
        }

        @Override
        public CoordSystemBuilder open(NetcdfDataset.Builder datasetBuilder) {
            return new AWIPSConvention(datasetBuilder);
        }
    }
}

