/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.List;
import loci.formats.CoreMetadata;
import loci.formats.CoreMetadataList;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;

public abstract class SubResolutionFormatReader
extends FormatReader {
    protected CoreMetadataList core;

    public SubResolutionFormatReader(String format, String suffix) {
        super(format, suffix);
    }

    public SubResolutionFormatReader(String format, String[] suffixes) {
        super(format, suffixes);
    }

    @Override
    protected void initFile(String id) throws FormatException, IOException {
        super.initFile(id);
        this.core = new CoreMetadataList();
        CoreMetadata core0 = new CoreMetadata();
        this.core.add(core0);
        core0.orderCertain = true;
    }

    @Override
    protected void flattenHashtables() {
        this.updateMetadataLists(this.metadata);
        for (int s2 = 0; s2 < this.core.size(); ++s2) {
            for (int r = 0; r < this.core.size(s2); ++r) {
                if (((CoreMetadata)this.core.get((int)s2, (int)r)).seriesMetadata.size() <= 0) continue;
                this.updateMetadataLists(((CoreMetadata)this.core.get((int)s2, (int)r)).seriesMetadata);
            }
        }
    }

    @Override
    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.core = null;
        }
    }

    @Override
    public int getSeriesCount() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.hasFlattenedResolutions()) {
            return this.core.flattenedSize();
        }
        return this.core.size();
    }

    @Override
    public void setSeries(int no) {
        if (this.hasFlattenedResolutions()) {
            int[] pos = this.core.flattenedIndexes(no);
            this.series = pos[0];
            this.resolution = pos[1];
        } else {
            this.series = no;
            this.resolution = 0;
        }
    }

    @Override
    public int getSeries() {
        if (this.hasFlattenedResolutions()) {
            return this.core.flattenedIndex(this.series, this.resolution);
        }
        return this.series;
    }

    @Override
    public List<CoreMetadata> getCoreMetadataList() {
        FormatTools.assertId(this.currentId, true, 1);
        return this.core.getFlattenedList();
    }

    @Override
    public int seriesToCoreIndex(int s2) {
        if (this.hasFlattenedResolutions()) {
            return s2;
        }
        return this.core.flattenedIndex(s2, 0);
    }

    @Override
    public int coreIndexToSeries(int index) {
        if (this.hasFlattenedResolutions()) {
            return index;
        }
        return this.core.flattenedIndexes(index)[0];
    }

    @Override
    public int getResolutionCount() {
        FormatTools.assertId(this.currentId, true, 1);
        if (this.hasFlattenedResolutions()) {
            return 1;
        }
        return this.core.size(this.series);
    }

    @Override
    public void setResolution(int no) {
        if (no < 0 || no >= this.getResolutionCount()) {
            throw new IllegalArgumentException("Invalid resolution: " + no);
        }
        if (!this.hasFlattenedResolutions()) {
            this.resolution = no;
        }
    }

    @Override
    public int getResolution() {
        if (this.hasFlattenedResolutions()) {
            return 0;
        }
        return this.resolution;
    }

    @Override
    public int getCoreIndex() {
        return this.core.flattenedIndex(this.series, this.resolution);
    }

    @Override
    public void setCoreIndex(int no) {
        if (no < 0 || no >= this.core.flattenedSize()) {
            throw new IllegalArgumentException("Invalid series: " + no);
        }
        int[] pos = this.core.flattenedIndexes(no);
        this.series = pos[0];
        this.resolution = pos[1];
    }

    @Override
    protected CoreMetadata getCurrentCore() {
        return (CoreMetadata)this.core.get(this.series, this.resolution);
    }
}

