/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import loci.formats.ome.OMEXMLMetadataImpl;
import loci.formats.utests.OMEModelMock;
import ome.units.UNITS;
import ome.xml.meta.MetadataRoot;
import ome.xml.meta.OMEXMLMetadataRoot;
import ome.xml.model.Annotation;
import ome.xml.model.Arc;
import ome.xml.model.BooleanAnnotation;
import ome.xml.model.Channel;
import ome.xml.model.CommentAnnotation;
import ome.xml.model.Detector;
import ome.xml.model.Dichroic;
import ome.xml.model.Filament;
import ome.xml.model.Filter;
import ome.xml.model.FilterSet;
import ome.xml.model.Image;
import ome.xml.model.Instrument;
import ome.xml.model.Laser;
import ome.xml.model.LightEmittingDiode;
import ome.xml.model.ListAnnotation;
import ome.xml.model.LongAnnotation;
import ome.xml.model.OMEModel;
import ome.xml.model.OMEModelImpl;
import ome.xml.model.OMEModelObject;
import ome.xml.model.Objective;
import ome.xml.model.Pixels;
import ome.xml.model.Plate;
import ome.xml.model.ROI;
import ome.xml.model.Rectangle;
import ome.xml.model.Shape;
import ome.xml.model.TiffData;
import ome.xml.model.TimestampAnnotation;
import ome.xml.model.UUID;
import ome.xml.model.Union;
import ome.xml.model.Well;
import ome.xml.model.WellSample;
import ome.xml.model.XMLAnnotation;
import ome.xml.model.enums.ArcType;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.EnumerationException;
import ome.xml.model.enums.FilamentType;
import ome.xml.model.enums.FilterType;
import ome.xml.model.enums.LaserType;
import ome.xml.model.enums.NamingConvention;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

@Test(groups={"inOutTests"})
public class InOutCurrentTest {
    public static final String IMAGE_ID = "Image:0";
    public static final String GENERAL_ANNOTATION_NAMESPACE = "test-ome-InOutCurrent-namespace";
    public static final String IMAGE_ANNOTATION_ID = "Annotation:ImageBoolean0";
    public static final String IMAGE_LIST_ANNOTATION_ID = "Annotation:ImageList0";
    public static final String PIXELS_ID = "Pixels:0";
    public static final String CHANNEL_ANNOTATION_ID = "Annotation:ChannelXML0";
    public static final String INSTRUMENT_ID = "Instrument:0";
    public static final String INSTRUMENT_ANNOTATION_ID = "Annotation:InstrumentString1";
    public static final String INSTRUMENT_ANNOTATION_VALUE = "Value:String1";
    public static final String DETECTOR_ID = "Detector:0";
    public static final String DETECTOR_ANNOTATION_ID = "Annotation:DetectorString2";
    public static final String DETECTOR_ANNOTATION_VALUE = "Value:String2";
    public static final String LIGHTSOURCE_LASER_ID = "LightSource:0";
    public static final String LIGHTSOURCE_LASER_ANNOTATION_ID = "Annotation:LightSourceLaserString3";
    public static final String LIGHTSOURCE_LASER_ANNOTATION_VALUE = "Value:String3";
    public static final String LIGHTSOURCE_PUMP_ID = "LightSource:1";
    public static final String LIGHTSOURCE_ARC_ID = "LightSource:2";
    public static final String LIGHTSOURCE_ARC_ANNOTATION_ID = "Annotation:LightSourceArcString4";
    public static final String LIGHTSOURCE_ARC_ANNOTATION_VALUE = "Value:String4";
    public static final String LIGHTSOURCE_FILAMENT_ID = "LightSource:3";
    public static final String LIGHTSOURCE_FILAMENT_ANNOTATION_ID = "Annotation:LightSourceFilamentString5";
    public static final String LIGHTSOURCE_FILAMENT_ANNOTATION_VALUE = "Value:String5";
    public static final String LIGHTSOURCE_LED_ID = "LightSource:4";
    public static final String LIGHTSOURCE_LED_ANNOTATION_ID = "Annotation:LightSourceLEDString6";
    public static final String LIGHTSOURCE_LED_ANNOTATION_VALUE = "Value:String6";
    public static final String DICHROIC_ID = "Dichroic:0";
    public static final String DICHROIC_ANNOTATION_ID = "Annotation:DichroicString7";
    public static final String DICHROIC_ANNOTATION_VALUE = "Value:String7";
    public static final String FILTERSET_ID = "FilterSet:0";
    public static final String EM_FILTER_ID = "Filter:0";
    public static final String EM_FILTER_ANNOTATION_ID = "Annotation:EmFilterString8";
    public static final String EM_FILTER_ANNOTATION_VALUE = "Value:String8";
    public static final String EX_FILTER_ID = "Filter:1";
    public static final String OBJECTIVE_ID = "Objective:0";
    public static final String OBJECTIVE_ANNOTATION_ID = "Annotation:ObjectiveString9";
    public static final String OBJECTIVE_ANNOTATION_VALUE = "Value:String9";
    public static final String PLATE_ID = "Plate:0";
    public static final String PLATE_ANNOTATION_ID = "Annotation:PlateTimestamp0";
    public static final String WELL_ANNOTATION_ID = "Annotation:WellLong0";
    public static final String ROI_ID = "ROI:5";
    public static final String ROI_ANNOTATION_ID = "Annotation:ROIString0";
    public static final String SHAPE_ID = "Shape:0";
    public static final String SHAPE_ANNOTATION_ID = "Annotation:ShapeString10";
    public static final String SHAPE_ANNOTATION_VALUE = "Value:String10";
    public static final DimensionOrder DIMENSION_ORDER = DimensionOrder.XYZCT;
    public static final PixelType PIXEL_TYPE = PixelType.UINT16;
    public static final Integer SIZE_X = 512;
    public static final Integer SIZE_Y = 512;
    public static final Integer SIZE_Z = 64;
    public static final Integer SIZE_C = 3;
    public static final Integer SIZE_T = 50;
    public static final String DETECTOR_MODEL = "ReallySensitive!";
    public static final String LIGHTSOURCE_LASER_MODEL = "ReallyBrightLaser!";
    public static final String LIGHTSOURCE_PUMP_MODEL = "ReallyBrightPump!";
    public static final String LIGHTSOURCE_ARC_MODEL = "ReallyBrightArc!";
    public static final String LIGHTSOURCE_FILAMENT_MODEL = "ReallyBrightFilament!";
    public static final String LIGHTSOURCE_LED_MODEL = "ReallyBrightLED!";
    public static final String OBJECTIVE_MODEL = "ReallyClear!";
    public static final String DICHROIC_SN = "0123456789";
    public static final String FILTERSET_LOT = "RandomLot";
    public static final FilterType EM_FILTER_TYPE = FilterType.LONGPASS;
    public static final FilterType EX_FILTER_TYPE = FilterType.NEUTRALDENSITY;
    public static final Double LIGHTSOURCE_LASER_POWER = 1000.0;
    public static final Double LIGHTSOURCE_PUMP_POWER = 100.0;
    public static final Double LIGHTSOURCE_ARC_POWER = 500.0;
    public static final Double LIGHTSOURCE_FILAMENT_POWER = 200.0;
    public static final Double LIGHTSOURCE_LED_POWER = 10.0;
    public static final LaserType LASER_TYPE = LaserType.DYE;
    public static final ArcType ARC_TYPE = ArcType.HGXE;
    public static final FilamentType FILAMENT_TYPE = FilamentType.HALOGEN;
    public static final Boolean IMAGE_ANNOTATION_VALUE = Boolean.FALSE;
    public static final String CHANNEL_ANNOTATION_VALUE = "<TestData><key>foo</key><value>bar</value></TestData>";
    public static final Double PIXELS_ANNOTATION_VALUE = 3.14;
    public static final String PLATE_ANNOTATION_VALUE = "1970-01-01T00:00:00";
    public static final Long WELL_ANNOTATION_VALUE = 262144L;
    public static final PositiveInteger WELL_ROWS = new PositiveInteger(Integer.valueOf(3));
    public static final PositiveInteger WELL_COLS = new PositiveInteger(Integer.valueOf(2));
    public static final NamingConvention WELL_ROW = NamingConvention.LETTER;
    public static final NamingConvention WELL_COL = NamingConvention.NUMBER;
    public static final String ROI_ANNOTATION_VALUE = "Some extra ROI data";
    public static final Double RECTANGLE_X = 10.0;
    public static final Double RECTANGLE_Y = 20.0;
    public static final Double RECTANGLE_WIDTH = 128.0;
    public static final Double RECTANGLE_HEIGHT = 256.0;
    public static final String TIFF_DATA_UUID = "6DFA2954-FA9B-4447-A26C-82F9580D9425";
    public static final String XML_NS = "http://www.openmicroscopy.org/Schemas/OME/2016-06";
    public static final String XSI_NS = "http://www.w3.org/2001/XMLSchema-instance";
    public static final String SCHEMA_LOCATION = "http://www.openmicroscopy.org/Schemas/OME/2016-06/ome.xsd";
    private Document document;
    public String asString;
    public OMEModelMock mock;
    public OMEXMLMetadataRoot ome;
    public OMEModel model;
    public OMEXMLMetadataImpl metadata;

    @Parameters(value={"mockClassName"})
    @BeforeClass
    public void setUp(@Optional String mockClassName) throws Exception {
        if (mockClassName == null) {
            mockClassName = "loci.formats.utests.ObjectBasedOMEModelMock";
        }
        Class<?> mockClass = Class.forName(mockClassName);
        Constructor<?> constructor = mockClass.getDeclaredConstructor(new Class[0]);
        this.mock = (OMEModelMock)constructor.newInstance(new Object[0]);
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        this.document = parser.newDocument();
        this.ome = (OMEXMLMetadataRoot)this.mock.getRoot();
        Element root = this.ome.asXMLElement(this.document);
        root.setAttribute("xmlns", XML_NS);
        root.setAttribute("xmlns:xsi", XSI_NS);
        root.setAttribute("xsi:schemaLocation", "http://www.openmicroscopy.org/Schemas/OME/2016-06 http://www.openmicroscopy.org/Schemas/OME/2016-06/ome.xsd");
        this.document.appendChild(root);
        this.asString = this.asString();
    }

    @Test
    public void testValidOMENode() throws EnumerationException {
        this.model = new OMEModelImpl();
        this.ome = new OMEXMLMetadataRoot(this.document.getDocumentElement(), this.model);
        this.model.resolveReferences();
        AssertJUnit.assertNotNull((Object)this.ome);
        AssertJUnit.assertEquals((int)1, (int)this.ome.sizeOfImageList());
    }

    @Test
    public void testValidMetadataRoot() {
        this.metadata = new OMEXMLMetadataImpl();
        this.metadata.setRoot((MetadataRoot)this.ome);
        AssertJUnit.assertEquals((Object)this.ome, (Object)this.metadata.getRoot());
    }

    @Test(dependsOnMethods={"testValidOMENode"})
    public void testValidImageNode() {
        Image image = this.ome.getImage(0);
        AssertJUnit.assertNotNull((Object)image);
        AssertJUnit.assertEquals((String)IMAGE_ID, (String)image.getID());
    }

    @Test(dependsOnMethods={"testValidMetadataRoot"})
    public void testValidImageMetadata() {
        AssertJUnit.assertEquals((int)1, (int)this.metadata.getImageCount());
        AssertJUnit.assertEquals((String)IMAGE_ID, (String)this.metadata.getImageID(0));
    }

    @Test(dependsOnMethods={"testValidImageNode"})
    public void testValidImageAnnotation() {
        Annotation n = this.ome.getImage(0).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals(ListAnnotation.class, n.getClass());
        ListAnnotation l = (ListAnnotation)n;
        AssertJUnit.assertEquals((String)l.getID(), (String)IMAGE_LIST_ANNOTATION_ID);
        AssertJUnit.assertEquals((String)l.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        Annotation n2 = l.getLinkedAnnotation(0);
        AssertJUnit.assertEquals(BooleanAnnotation.class, n2.getClass());
        BooleanAnnotation b = (BooleanAnnotation)n2;
        AssertJUnit.assertEquals((Object)b.getValue(), (Object)IMAGE_ANNOTATION_VALUE);
        AssertJUnit.assertEquals((String)b.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertEquals((String)b.getID(), (String)IMAGE_ANNOTATION_ID);
    }

    @Test(dependsOnMethods={"testValidImageMetadata"})
    public void testValidImageAnnotationMetadata() {
        AssertJUnit.assertEquals((int)1, (int)this.metadata.getListAnnotationCount());
        AssertJUnit.assertEquals((int)1, (int)this.metadata.getBooleanAnnotationCount());
        AssertJUnit.assertEquals((int)1, (int)this.metadata.getImageAnnotationRefCount(0));
        AssertJUnit.assertEquals((String)IMAGE_LIST_ANNOTATION_ID, (String)this.metadata.getListAnnotationID(0));
        AssertJUnit.assertEquals((Object)IMAGE_ANNOTATION_VALUE, (Object)this.metadata.getBooleanAnnotationValue(0));
        AssertJUnit.assertEquals((String)GENERAL_ANNOTATION_NAMESPACE, (String)this.metadata.getBooleanAnnotationNamespace(0));
        AssertJUnit.assertEquals((String)IMAGE_ANNOTATION_ID, (String)this.metadata.getBooleanAnnotationID(0));
    }

    @Test(dependsOnMethods={"testValidImageNode"})
    public void testValidPixelsNode() {
        Pixels pixels = this.ome.getImage(0).getPixels();
        AssertJUnit.assertEquals((Object)SIZE_X, (Object)pixels.getSizeX().getValue());
        AssertJUnit.assertEquals((Object)SIZE_Y, (Object)pixels.getSizeY().getValue());
        AssertJUnit.assertEquals((Object)SIZE_Z, (Object)pixels.getSizeZ().getValue());
        AssertJUnit.assertEquals((Object)SIZE_C, (Object)pixels.getSizeC().getValue());
        AssertJUnit.assertEquals((Object)SIZE_T, (Object)pixels.getSizeT().getValue());
        AssertJUnit.assertEquals((Object)DIMENSION_ORDER, (Object)pixels.getDimensionOrder());
        AssertJUnit.assertEquals((Object)PIXEL_TYPE, (Object)pixels.getType());
        AssertJUnit.assertEquals((int)1, (int)pixels.sizeOfTiffDataList());
    }

    @Test(dependsOnMethods={"testValidImageMetadata"})
    public void testValidPixelsMetadata() {
        AssertJUnit.assertEquals((Object)SIZE_X, (Object)this.metadata.getPixelsSizeX(0).getValue());
        AssertJUnit.assertEquals((Object)SIZE_Y, (Object)this.metadata.getPixelsSizeY(0).getValue());
        AssertJUnit.assertEquals((Object)SIZE_Z, (Object)this.metadata.getPixelsSizeZ(0).getValue());
        AssertJUnit.assertEquals((Object)SIZE_C, (Object)this.metadata.getPixelsSizeC(0).getValue());
        AssertJUnit.assertEquals((Object)SIZE_T, (Object)this.metadata.getPixelsSizeT(0).getValue());
        AssertJUnit.assertEquals((Object)DIMENSION_ORDER, (Object)this.metadata.getPixelsDimensionOrder(0));
        AssertJUnit.assertEquals((Object)PIXEL_TYPE, (Object)this.metadata.getPixelsType(0));
    }

    @Test(dependsOnMethods={"testValidPixelsNode"})
    public void testValidTiffDataNode() {
        TiffData tiffData = this.ome.getImage(0).getPixels().getTiffData(0);
        UUID uuid = tiffData.getUUID();
        AssertJUnit.assertEquals((String)TIFF_DATA_UUID, (String)uuid.getValue());
    }

    @Test(dependsOnMethods={"testValidPixelsMetadata"})
    public void testValidTiffDataMetadata() {
    }

    @Test(dependsOnMethods={"testValidPixelsNode"})
    public void testValidChannelNode() {
        Pixels pixels = this.ome.getImage(0).getPixels();
        AssertJUnit.assertEquals((int)3, (int)pixels.sizeOfChannelList());
        for (Channel channel : pixels.copyChannelList()) {
            AssertJUnit.assertNotNull((Object)channel.getID());
        }
    }

    @Test(dependsOnMethods={"testValidPixelsMetadata"})
    public void testValidChannelMetadata() {
        AssertJUnit.assertEquals((int)3, (int)this.metadata.getChannelCount(0));
        for (int i = 0; i < 3; ++i) {
            AssertJUnit.assertNotNull((Object)this.metadata.getChannelID(0, i));
        }
    }

    @Test(dependsOnMethods={"testValidChannelNode"})
    public void testValidChannelAnnotation() {
        Channel c = this.ome.getImage(0).getPixels().getChannel(0);
        Annotation n = c.getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertTrue((boolean)(n instanceof XMLAnnotation));
        AssertJUnit.assertEquals((String)CHANNEL_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertEquals((String)CHANNEL_ANNOTATION_VALUE, (String)((XMLAnnotation)n).getValue());
    }

    @Test(dependsOnMethods={"testValidOMENode"})
    public void testValidInstrumentNode() {
        Instrument instrument = this.ome.getInstrument(0);
        AssertJUnit.assertNotNull((Object)instrument);
        AssertJUnit.assertEquals((String)INSTRUMENT_ID, (String)instrument.getID());
    }

    @Test(dependsOnMethods={"testValidMetadataRoot"})
    public void testValidInstrumentMetadata() {
        AssertJUnit.assertEquals((int)1, (int)this.metadata.getInstrumentCount());
        AssertJUnit.assertEquals((String)INSTRUMENT_ID, (String)this.metadata.getInstrumentID(0));
        AssertJUnit.assertEquals((int)5, (int)this.metadata.getLightSourceCount(0));
        AssertJUnit.assertEquals((int)1, (int)this.metadata.getDetectorCount(0));
        AssertJUnit.assertEquals((int)2, (int)this.metadata.getFilterCount(0));
    }

    @Test(dependsOnMethods={"testValidInstrumentNode"})
    public void testValidInstrumentAnnotation() {
        Annotation n = this.ome.getInstrument(0).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)INSTRUMENT_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof CommentAnnotation));
        CommentAnnotation string = (CommentAnnotation)n;
        AssertJUnit.assertEquals((String)INSTRUMENT_ANNOTATION_VALUE, (String)string.getValue());
    }

    @Test(dependsOnMethods={"testValidInstrumentNode"})
    public void testValidDetectorNode() {
        Detector detector = this.ome.getInstrument(0).getDetector(0);
        AssertJUnit.assertNotNull((Object)detector);
        AssertJUnit.assertEquals((String)DETECTOR_ID, (String)detector.getID());
        AssertJUnit.assertEquals((String)DETECTOR_MODEL, (String)detector.getModel());
    }

    @Test(dependsOnMethods={"testValidDetectorNode"})
    public void testValidDetectorMetadata() {
        AssertJUnit.assertEquals((int)1, (int)this.metadata.getDetectorCount(0));
        AssertJUnit.assertEquals((String)DETECTOR_ID, (String)this.metadata.getDetectorID(0, 0));
        AssertJUnit.assertEquals((String)DETECTOR_MODEL, (String)this.metadata.getDetectorModel(0, 0));
    }

    @Test(dependsOnMethods={"testValidDetectorNode"})
    public void testValidDetectorAnnotation() {
        Annotation n = this.ome.getInstrument(0).getDetector(0).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)DETECTOR_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof CommentAnnotation));
        CommentAnnotation string = (CommentAnnotation)n;
        AssertJUnit.assertEquals((String)DETECTOR_ANNOTATION_VALUE, (String)string.getValue());
    }

    @Test(dependsOnMethods={"testValidInstrumentNode"}, enabled=false)
    public void testValidLaserNode() {
        Laser laser = (Laser)this.ome.getInstrument(0).getLightSource(0);
        AssertJUnit.assertNotNull((Object)laser);
        AssertJUnit.assertEquals((String)LIGHTSOURCE_LASER_ID, (String)laser.getID());
        AssertJUnit.assertEquals((String)LIGHTSOURCE_LASER_MODEL, (String)laser.getModel());
        AssertJUnit.assertEquals((Object)LIGHTSOURCE_LASER_POWER, (Object)laser.getPower().value(UNITS.MILLIWATT).doubleValue());
        AssertJUnit.assertEquals((Object)LASER_TYPE, (Object)laser.getType());
    }

    @Test(dependsOnMethods={"testValidLaserNode"}, enabled=false)
    public void testValidLaserMetadata() {
        AssertJUnit.assertEquals((String)LIGHTSOURCE_LASER_ID, (String)this.metadata.getLaserID(0, 0));
        AssertJUnit.assertEquals((String)LIGHTSOURCE_LASER_MODEL, (String)this.metadata.getLaserModel(0, 0));
        AssertJUnit.assertEquals((Object)LIGHTSOURCE_LASER_POWER, (Object)this.metadata.getLaserPower(0, 0).value(UNITS.MILLIWATT).doubleValue());
        AssertJUnit.assertEquals((Object)LASER_TYPE, (Object)this.metadata.getLaserType(0, 0));
    }

    @Test(dependsOnMethods={"testValidLaserMetadata"}, enabled=false)
    public void testValidLaserAnnotation() {
        Annotation n = this.ome.getInstrument(0).getLightSource(0).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)LIGHTSOURCE_LASER_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof CommentAnnotation));
        CommentAnnotation string = (CommentAnnotation)n;
        AssertJUnit.assertEquals((String)LIGHTSOURCE_LASER_ANNOTATION_VALUE, (String)string.getValue());
    }

    @Test(dependsOnMethods={"testValidLaserNode"}, enabled=false)
    public void testValidPumpNode() {
        Laser laser = (Laser)this.ome.getInstrument(0).getLightSource(0);
        Laser laserPump = (Laser)this.ome.getInstrument(0).getLightSource(1);
        AssertJUnit.assertNotNull((Object)laserPump);
        AssertJUnit.assertEquals((String)LIGHTSOURCE_PUMP_ID, (String)laserPump.getID());
        AssertJUnit.assertEquals((String)LIGHTSOURCE_PUMP_MODEL, (String)laserPump.getModel());
        AssertJUnit.assertEquals((Object)LIGHTSOURCE_PUMP_POWER, (Object)laserPump.getPower().value(UNITS.MILLIWATT).doubleValue());
        AssertJUnit.assertEquals((Object)LASER_TYPE, (Object)laserPump.getType());
        AssertJUnit.assertEquals((Object)laser.getLinkedPump(), (Object)laserPump);
    }

    @Test(dependsOnMethods={"testValidLaserMetadata"}, enabled=false)
    public void testValidPumpMetadata() {
        AssertJUnit.assertEquals((String)LIGHTSOURCE_PUMP_ID, (String)this.metadata.getLaserID(0, 1));
        AssertJUnit.assertEquals((String)LIGHTSOURCE_PUMP_MODEL, (String)this.metadata.getLaserModel(0, 1));
        AssertJUnit.assertEquals((Object)LIGHTSOURCE_PUMP_POWER, (Object)this.metadata.getLaserPower(0, 1).value(UNITS.MILLIWATT).doubleValue());
        AssertJUnit.assertEquals((Object)LASER_TYPE, (Object)this.metadata.getLaserType(0, 1));
        AssertJUnit.assertEquals((String)LIGHTSOURCE_PUMP_ID, (String)this.metadata.getLaserPump(0, 0));
    }

    @Test(dependsOnMethods={"testValidInstrumentNode"}, enabled=false)
    public void testValidArcNode() {
        Arc arc = (Arc)this.ome.getInstrument(0).getLightSource(2);
        AssertJUnit.assertNotNull((Object)arc);
        AssertJUnit.assertEquals((String)LIGHTSOURCE_ARC_ID, (String)arc.getID());
        AssertJUnit.assertEquals((String)LIGHTSOURCE_ARC_MODEL, (String)arc.getModel());
        AssertJUnit.assertEquals((Object)LIGHTSOURCE_ARC_POWER, (Object)arc.getPower().value(UNITS.MILLIWATT).doubleValue());
        AssertJUnit.assertEquals((Object)ARC_TYPE, (Object)arc.getType());
    }

    @Test(dependsOnMethods={"testValidArcNode"}, enabled=false)
    public void testValidArcMetadata() {
        AssertJUnit.assertEquals((String)LIGHTSOURCE_ARC_ID, (String)this.metadata.getArcID(0, 2));
        AssertJUnit.assertEquals((String)LIGHTSOURCE_ARC_MODEL, (String)this.metadata.getArcModel(0, 2));
        AssertJUnit.assertEquals((Object)LIGHTSOURCE_ARC_POWER, (Object)this.metadata.getArcPower(0, 2).value(UNITS.MILLIWATT).doubleValue());
        AssertJUnit.assertEquals((Object)ARC_TYPE, (Object)this.metadata.getArcType(0, 2));
    }

    @Test(dependsOnMethods={"testValidArcNode"}, enabled=false)
    public void testValidArcAnnotation() {
        Annotation n = this.ome.getInstrument(0).getLightSource(2).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)LIGHTSOURCE_ARC_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof CommentAnnotation));
        CommentAnnotation string = (CommentAnnotation)n;
        AssertJUnit.assertEquals((String)LIGHTSOURCE_ARC_ANNOTATION_VALUE, (String)string.getValue());
    }

    @Test(dependsOnMethods={"testValidInstrumentNode"}, enabled=false)
    public void testValidFilamentNode() {
        Filament filament = (Filament)this.ome.getInstrument(0).getLightSource(3);
        AssertJUnit.assertNotNull((Object)filament);
        AssertJUnit.assertEquals((String)LIGHTSOURCE_FILAMENT_ID, (String)filament.getID());
        AssertJUnit.assertEquals((String)LIGHTSOURCE_FILAMENT_MODEL, (String)filament.getModel());
        AssertJUnit.assertEquals((Object)LIGHTSOURCE_FILAMENT_POWER, (Object)filament.getPower().value(UNITS.MILLIWATT).doubleValue());
        AssertJUnit.assertEquals((Object)FILAMENT_TYPE, (Object)filament.getType());
    }

    @Test(dependsOnMethods={"testValidFilamentNode"}, enabled=false)
    public void testValidFilamentMetadata() {
        AssertJUnit.assertEquals((String)LIGHTSOURCE_FILAMENT_ID, (String)this.metadata.getFilamentID(0, 3));
        AssertJUnit.assertEquals((String)LIGHTSOURCE_FILAMENT_MODEL, (String)this.metadata.getFilamentModel(0, 3));
        AssertJUnit.assertEquals((Object)LIGHTSOURCE_FILAMENT_POWER, (Object)this.metadata.getFilamentPower(0, 3).value(UNITS.MILLIWATT).doubleValue());
        AssertJUnit.assertEquals((Object)FILAMENT_TYPE, (Object)this.metadata.getFilamentType(0, 3));
    }

    @Test(dependsOnMethods={"testValidFilamentNode"}, enabled=false)
    public void testValidFilamentAnnotation() {
        Annotation n = this.ome.getInstrument(0).getLightSource(3).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)LIGHTSOURCE_FILAMENT_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof CommentAnnotation));
        CommentAnnotation string = (CommentAnnotation)n;
        AssertJUnit.assertEquals((String)LIGHTSOURCE_FILAMENT_ANNOTATION_VALUE, (String)string.getValue());
    }

    @Test(dependsOnMethods={"testValidInstrumentNode"}, enabled=false)
    public void testValidLightEmittingDiodeNode() {
        LightEmittingDiode led = (LightEmittingDiode)this.ome.getInstrument(0).getLightSource(4);
        AssertJUnit.assertNotNull((Object)led);
        AssertJUnit.assertEquals((String)LIGHTSOURCE_LED_ID, (String)led.getID());
        AssertJUnit.assertEquals((String)LIGHTSOURCE_LED_MODEL, (String)led.getModel());
        AssertJUnit.assertEquals((Object)LIGHTSOURCE_LED_POWER, (Object)led.getPower().value(UNITS.MILLIWATT).doubleValue());
    }

    @Test(dependsOnMethods={"testValidLightEmittingDiodeNode"}, enabled=false)
    public void testValidLightEmittingDiodeAnnotation() {
        LightEmittingDiode led = (LightEmittingDiode)this.ome.getInstrument(0).getLightSource(4);
        Annotation n = led.getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)LIGHTSOURCE_LED_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof CommentAnnotation));
        CommentAnnotation string = (CommentAnnotation)n;
        AssertJUnit.assertEquals((String)LIGHTSOURCE_LED_ANNOTATION_VALUE, (String)string.getValue());
    }

    @Test(dependsOnMethods={"testValidInstrumentNode"})
    public void testValidDichroicNode() {
        Dichroic dichroic = this.ome.getInstrument(0).getDichroic(0);
        AssertJUnit.assertNotNull((Object)dichroic);
        AssertJUnit.assertEquals((String)DICHROIC_ID, (String)dichroic.getID());
        AssertJUnit.assertEquals((String)DICHROIC_SN, (String)dichroic.getSerialNumber());
    }

    @Test(dependsOnMethods={"testValidDichroicNode"})
    public void testValidDichroicAnnotation() {
        Annotation n = this.ome.getInstrument(0).getDichroic(0).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)DICHROIC_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof CommentAnnotation));
        CommentAnnotation string = (CommentAnnotation)n;
        AssertJUnit.assertEquals((String)DICHROIC_ANNOTATION_VALUE, (String)string.getValue());
    }

    @Test(dependsOnMethods={"testValidInstrumentNode"})
    public void testValidObjectiveNode() {
        Objective objective = this.ome.getInstrument(0).getObjective(0);
        AssertJUnit.assertNotNull((Object)objective);
        AssertJUnit.assertEquals((String)OBJECTIVE_ID, (String)objective.getID());
        AssertJUnit.assertEquals((String)OBJECTIVE_MODEL, (String)objective.getModel());
    }

    @Test(dependsOnMethods={"testValidObjectiveNode"})
    public void testValidObjectiveAnnotation() {
        Annotation n = this.ome.getInstrument(0).getObjective(0).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)OBJECTIVE_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof CommentAnnotation));
        CommentAnnotation string = (CommentAnnotation)n;
        AssertJUnit.assertEquals((String)OBJECTIVE_ANNOTATION_VALUE, (String)string.getValue());
    }

    @Test(dependsOnMethods={"testValidDichroicNode"})
    public void testValidFilterSetNode() {
        Dichroic dichroic = this.ome.getInstrument(0).getDichroic(0);
        AssertJUnit.assertEquals((int)1, (int)dichroic.sizeOfLinkedFilterSetList());
        FilterSet filterSet = dichroic.getLinkedFilterSet(0);
        AssertJUnit.assertNotNull((Object)filterSet);
        AssertJUnit.assertEquals((String)FILTERSET_ID, (String)filterSet.getID());
        AssertJUnit.assertEquals((String)FILTERSET_LOT, (String)filterSet.getLotNumber());
        AssertJUnit.assertEquals((String)filterSet.getLinkedDichroic().getID(), (String)dichroic.getID());
    }

    @Test(dependsOnMethods={"testValidFilterSetNode"})
    public void testValidEmissionFilterNode() {
        Filter emFilter = this.ome.getInstrument(0).getFilter(0);
        AssertJUnit.assertNotNull((Object)emFilter);
        AssertJUnit.assertEquals((String)EM_FILTER_ID, (String)emFilter.getID());
        AssertJUnit.assertEquals((Object)EM_FILTER_TYPE, (Object)emFilter.getType());
        FilterSet filterSet = this.ome.getInstrument(0).getDichroic(0).getLinkedFilterSet(0);
        AssertJUnit.assertEquals((String)EM_FILTER_ID, (String)filterSet.getLinkedEmissionFilter(0).getID());
    }

    @Test(dependsOnMethods={"testValidEmissionFilterNode"})
    public void testValidEmissionFilterAnnotation() {
        Annotation n = this.ome.getInstrument(0).getFilter(0).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)EM_FILTER_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof CommentAnnotation));
        CommentAnnotation string = (CommentAnnotation)n;
        AssertJUnit.assertEquals((String)EM_FILTER_ANNOTATION_VALUE, (String)string.getValue());
    }

    @Test(dependsOnMethods={"testValidFilterSetNode"})
    public void testValidExcitationFilter() {
        Filter exFilter = this.ome.getInstrument(0).getFilter(1);
        AssertJUnit.assertNotNull((Object)exFilter);
        AssertJUnit.assertEquals((String)EX_FILTER_ID, (String)exFilter.getID());
        AssertJUnit.assertEquals((Object)EX_FILTER_TYPE, (Object)exFilter.getType());
        FilterSet filterSet = this.ome.getInstrument(0).getDichroic(0).getLinkedFilterSet(0);
        AssertJUnit.assertEquals((String)EX_FILTER_ID, (String)filterSet.getLinkedExcitationFilter(0).getID());
    }

    @Test(dependsOnMethods={"testValidInstrumentNode", "testValidImageNode"})
    public void testImageInstrumentLinkage() {
        Instrument instrument = this.ome.getInstrument(0);
        Image image = this.ome.getImage(0);
        Instrument linkedInstrument = image.getLinkedInstrument();
        AssertJUnit.assertNotNull((Object)linkedInstrument);
        AssertJUnit.assertEquals((String)instrument.getID(), (String)linkedInstrument.getID());
        AssertJUnit.assertEquals((int)1, (int)instrument.sizeOfLinkedImageList());
        Image linkedImage = instrument.getLinkedImage(0);
        AssertJUnit.assertNotNull((Object)linkedImage);
        AssertJUnit.assertEquals((String)image.getID(), (String)linkedImage.getID());
    }

    @Test(dependsOnMethods={"testValidOMENode"})
    public void testValidPlateNode() {
        Plate plate = this.ome.getPlate(0);
        AssertJUnit.assertNotNull((Object)plate);
        AssertJUnit.assertEquals((String)PLATE_ID, (String)plate.getID());
        AssertJUnit.assertEquals((Object)plate.getRows(), (Object)WELL_ROWS);
        AssertJUnit.assertEquals((Object)plate.getColumns(), (Object)WELL_COLS);
        AssertJUnit.assertEquals((Object)plate.getRowNamingConvention(), (Object)WELL_ROW);
        AssertJUnit.assertEquals((Object)plate.getColumnNamingConvention(), (Object)WELL_COL);
        AssertJUnit.assertEquals((int)plate.sizeOfWellList(), (int)((Integer)WELL_ROWS.getValue() * (Integer)WELL_COLS.getValue()));
        Integer row = 0;
        while (row < (Integer)WELL_ROWS.getValue()) {
            Integer col = 0;
            while (col < (Integer)WELL_COLS.getValue()) {
                Well well = plate.getWell(row * (Integer)WELL_COLS.getValue() + col);
                AssertJUnit.assertNotNull((Object)well);
                AssertJUnit.assertEquals((String)String.format("Well:%d_%d", row, col), (String)well.getID());
                AssertJUnit.assertEquals((Object)well.getRow(), (Object)row);
                AssertJUnit.assertEquals((Object)well.getColumn(), (Object)col);
                Integer n = col;
                col = col + 1;
            }
            Integer n = row;
            row = row + 1;
        }
    }

    @Test(dependsOnMethods={"testValidPlateNode"})
    public void testValidPlateAnnotation() {
        Annotation n = this.ome.getPlate(0).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)PLATE_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof TimestampAnnotation));
        TimestampAnnotation timestamp = (TimestampAnnotation)n;
        AssertJUnit.assertEquals((Object)timestamp.getValue(), (Object)PLATE_ANNOTATION_VALUE);
    }

    @Test(dependsOnMethods={"testValidPlateNode"})
    public void testValidWellSamples() {
        Plate plate = this.ome.getPlate(0);
        Integer wellSampleIndex = 0;
        for (int row = 0; row < (Integer)plate.getRows().getValue(); ++row) {
            for (int col = 0; col < (Integer)plate.getColumns().getValue(); ++col) {
                Well well = plate.getWell(row * (Integer)plate.getColumns().getValue() + col);
                AssertJUnit.assertEquals((int)1, (int)well.sizeOfWellSampleList());
                WellSample sample = well.getWellSample(0);
                AssertJUnit.assertNotNull((Object)sample);
                AssertJUnit.assertEquals((String)String.format("WellSample:%d_%d", row, col), (String)sample.getID());
                AssertJUnit.assertEquals((Object)wellSampleIndex, (Object)sample.getIndex().getValue());
                Image image = sample.getLinkedImage();
                AssertJUnit.assertNotNull((Object)image);
                AssertJUnit.assertEquals((String)IMAGE_ID, (String)image.getID());
                Integer n = wellSampleIndex;
                wellSampleIndex = wellSampleIndex + 1;
            }
        }
    }

    @Test(dependsOnMethods={"testValidWellSamples"})
    public void testValidWellAnnotation() {
        Annotation n = this.ome.getPlate(0).getWell(0).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)WELL_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof LongAnnotation));
        LongAnnotation longAnnotation = (LongAnnotation)n;
        AssertJUnit.assertEquals((Object)longAnnotation.getValue(), (Object)WELL_ANNOTATION_VALUE);
    }

    @Test(dependsOnMethods={"testValidOMENode"})
    public void testValidROINode() {
        ROI roi = this.ome.getROI(0);
        AssertJUnit.assertNotNull((Object)roi);
        AssertJUnit.assertEquals((String)ROI_ID, (String)roi.getID());
        Union shapeUnion = roi.getUnion();
        AssertJUnit.assertNotNull((Object)shapeUnion);
        AssertJUnit.assertEquals((int)1, (int)shapeUnion.sizeOfShapeList());
        Shape s = shapeUnion.getShape(0);
        AssertJUnit.assertNotNull((Object)s);
        AssertJUnit.assertEquals((String)SHAPE_ID, (String)s.getID());
        AssertJUnit.assertTrue((boolean)(s instanceof Rectangle));
        Rectangle rect = (Rectangle)s;
        AssertJUnit.assertEquals((Object)RECTANGLE_X, (Object)rect.getX());
        AssertJUnit.assertEquals((Object)RECTANGLE_Y, (Object)rect.getY());
        AssertJUnit.assertEquals((Object)RECTANGLE_WIDTH, (Object)rect.getWidth());
        AssertJUnit.assertEquals((Object)RECTANGLE_HEIGHT, (Object)rect.getHeight());
    }

    @Test(dependsOnMethods={"testValidROINode"})
    public void testValidROIAnnotation() {
        Annotation n = this.ome.getROI(0).getLinkedAnnotation(0);
        AssertJUnit.assertNotNull((Object)n);
        AssertJUnit.assertEquals((String)ROI_ANNOTATION_ID, (String)n.getID());
        AssertJUnit.assertEquals((String)n.getNamespace(), (String)GENERAL_ANNOTATION_NAMESPACE);
        AssertJUnit.assertTrue((boolean)(n instanceof CommentAnnotation));
        CommentAnnotation string = (CommentAnnotation)n;
        AssertJUnit.assertEquals((String)ROI_ANNOTATION_VALUE, (String)string.getValue());
    }

    private String asString() throws TransformerException, UnsupportedEncodingException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        DOMSource source = new DOMSource(this.document);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(new OutputStreamWriter((OutputStream)os, "utf-8"));
        transformer.transform(source, result);
        return os.toString();
    }

    @Test(groups={"disabled"})
    public static void main(String[] args) throws Exception {
        InOutCurrentTest t = new InOutCurrentTest();
        t.setUp("loci.formats.utests.ObjectBasedOMEModelMock");
        System.out.println("###\n### XML\n###");
        System.out.println(t.asString);
        t.testValidOMENode();
        System.out.println("###\n### Model Objects\n###");
        Map objects = t.model.getModelObjects();
        for (Map.Entry entry : objects.entrySet()) {
            System.out.println(String.format("%s -- %s", entry.getKey(), ((OMEModelObject)entry.getValue()).toString()));
        }
        System.out.println("###\n### References\n###");
        Map references = t.model.getReferences();
        for (Map.Entry entry : references.entrySet()) {
            System.out.println(String.format("%s -- %s", entry.getKey(), ((List)entry.getValue()).toString()));
        }
    }
}

