/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.hdf5.HDF5DataTypeInformation;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5StorageLayout;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;

public final class HDF5DataSetInformation {
    private final HDF5DataTypeInformation typeInformation;
    private long[] dimensions;
    private long[] maxDimensions;
    private HDF5StorageLayout storageLayout = HDF5StorageLayout.NOT_APPLICABLE;
    private int[] chunkSizesOrNull;

    HDF5DataSetInformation(HDF5DataTypeInformation typeInformation, HDF5DataTypeVariant typeVariantOrNull) {
        this.typeInformation = typeInformation;
        if (typeVariantOrNull != null) {
            typeInformation.setTypeVariant(typeVariantOrNull);
        }
    }

    public HDF5DataTypeInformation getTypeInformation() {
        return this.typeInformation;
    }

    public HDF5DataTypeVariant tryGetTypeVariant() {
        return this.typeInformation.tryGetTypeVariant();
    }

    public boolean isTimeStamp() {
        return this.typeInformation.isTimeStamp();
    }

    public boolean isTimeDuration() {
        return this.typeInformation.isTimeDuration();
    }

    public HDF5TimeUnit tryGetTimeUnit() {
        return this.typeInformation.tryGetTimeUnit();
    }

    public long[] getDimensions() {
        return this.dimensions;
    }

    void setDimensions(long[] dimensions) {
        this.dimensions = dimensions;
    }

    public long[] getMaxDimensions() {
        return this.maxDimensions;
    }

    void setMaxDimensions(long[] maxDimensions) {
        this.maxDimensions = maxDimensions;
    }

    void setStorageLayout(HDF5StorageLayout storageLayout) {
        this.storageLayout = storageLayout;
    }

    public HDF5StorageLayout getStorageLayout() {
        return this.storageLayout;
    }

    public int[] tryGetChunkSizes() {
        return this.chunkSizesOrNull;
    }

    void setChunkSizes(int[] chunkSizes) {
        this.chunkSizesOrNull = chunkSizes;
    }

    public int getRank() {
        return this.dimensions.length;
    }

    public boolean isScalar() {
        return this.dimensions.length == 0;
    }

    public boolean isSigned() {
        return this.typeInformation.isSigned();
    }

    private static long getLength(long[] dimensions) {
        assert (dimensions != null);
        if (dimensions.length == 0) {
            return 0L;
        }
        long length = dimensions[0];
        int i = 1;
        while (i < dimensions.length) {
            length *= dimensions[i];
            ++i;
        }
        return length;
    }

    public long getNumberOfElements() {
        return HDF5DataSetInformation.getLength(this.dimensions);
    }

    public long getSize() {
        return HDF5DataSetInformation.getLength(this.dimensions) * (long)this.typeInformation.getElementSize();
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof HDF5DataSetInformation)) {
            return false;
        }
        HDF5DataSetInformation that = (HDF5DataSetInformation)obj;
        EqualsBuilder builder = new EqualsBuilder();
        builder.append(this.typeInformation, that.typeInformation);
        builder.append(this.dimensions, that.dimensions);
        builder.append(this.maxDimensions, that.maxDimensions);
        return builder.isEquals();
    }

    public int hashCode() {
        HashCodeBuilder builder = new HashCodeBuilder();
        builder.append(this.typeInformation);
        builder.append(this.dimensions);
        builder.append(this.maxDimensions);
        return builder.toHashCode();
    }

    public String toString() {
        return String.valueOf(this.typeInformation.toString()) + ":" + ArrayUtils.toString(this.dimensions);
    }
}

