/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.filter;

import java.util.ArrayList;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.filter.Enhancement;

public class Classifier
implements Enhancement {
    private String[] AttCat;
    private List<int[]> rules = new ArrayList<int[]>();

    public Classifier() {
        this.AttCat = new String[0];
        this.rules = new ArrayList<int[]>();
    }

    public Classifier(String[] AttCat) {
        this.AttCat = AttCat;
        this.rules = this.loadClassificationRules();
    }

    public static Classifier createFromVariable(Variable var) {
        List<Attribute> attributes = var.attributes().getAttributes();
        for (Attribute attribute : attributes) {
            if (attribute != var.attributes().findAttribute("classify")) continue;
            String[] sets = attribute.getStringValue().split(";");
            for (int i = 0; i < sets.length; ++i) {
                sets[i] = sets[i].trim();
            }
            return new Classifier(sets);
        }
        return new Classifier();
    }

    public int[] classifyWithAttributes(Array arr) {
        int[] classifiedArray = new int[(int)arr.getSize()];
        IndexIterator iterArr = arr.getIndexIterator();
        int i = 0;
        while (iterArr.hasNext()) {
            Number value = (Number)iterArr.getObjectNext();
            classifiedArray[i] = !Double.isNaN(value.doubleValue()) ? this.classifyArrayAttribute(value.doubleValue()) : Integer.MIN_VALUE;
            ++i;
        }
        return classifiedArray;
    }

    public int classifyArrayAttribute(double val) {
        for (int[] rule : this.rules) {
            if (!(val > (double)rule[0]) || !(val <= (double)((float)rule[1] + 1.0E-5f))) continue;
            return rule[2];
        }
        return Integer.MIN_VALUE;
    }

    private List<int[]> loadClassificationRules() {
        for (String rules : this.AttCat) {
            int[] rule = Classifier.stringToIntArray(rules);
            this.rules.add(rule);
        }
        return this.rules;
    }

    @Override
    public double convert(double val) {
        return this.classifyArrayAttribute(val);
    }

    public static int[] stringToIntArray(String str) {
        String[] stringArray = str.split(" ");
        int[] intArray = new int[stringArray.length];
        for (int i = 0; i < stringArray.length; ++i) {
            double value = Double.parseDouble(stringArray[i]);
            if (Double.isNaN(value)) {
                if (i == 0) {
                    intArray[i] = Integer.MIN_VALUE;
                    continue;
                }
                if (i == 1) {
                    intArray[i] = Integer.MAX_VALUE;
                    continue;
                }
                intArray[i] = -99999;
                continue;
            }
            intArray[i] = (int)value;
        }
        return intArray;
    }
}

