/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import java.util.ArrayList;
import loci.common.Location;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.ImageReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.out.JPEG2000Writer;
import loci.formats.services.OMEXMLService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EightBitLosslessJPEG2000Test {
    private static final Logger LOGGER = LoggerFactory.getLogger(EightBitLosslessJPEG2000Test.class);
    private ArrayList<String> files = new ArrayList();
    private byte[][] pixels = new byte[256][1];

    @BeforeMethod
    public void setUp() throws Exception {
        for (int v = -128; v < 127; v = (int)((byte)(v + 1))) {
            OMEXMLMetadata metadata;
            int index = v + 127 + 1;
            this.pixels[index][0] = v;
            String file = index + ".jp2";
            File tempFile = File.createTempFile("test", ".jp2");
            tempFile.deleteOnExit();
            Location.mapId((String)file, (String)tempFile.getAbsolutePath());
            this.files.add(file);
            try {
                ServiceFactory factory = new ServiceFactory();
                OMEXMLService service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
                metadata = service.createOMEXMLMetadata();
            }
            catch (DependencyException exc) {
                throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
            }
            catch (ServiceException exc) {
                throw new FormatException("Could not create OME-XML store.", (Throwable)exc);
            }
            MetadataTools.populateMetadata((MetadataStore)metadata, (int)0, (String)"foo", (boolean)false, (String)"XYCZT", (String)"uint8", (int)1, (int)1, (int)1, (int)1, (int)1, (int)1);
            JPEG2000Writer writer = new JPEG2000Writer();
            writer.setMetadataRetrieve((MetadataRetrieve)metadata);
            writer.setId(file);
            writer.saveBytes(0, this.pixels[index]);
            writer.close();
        }
    }

    @Test
    public void testLosslessPixels() throws Exception {
        int failureCount = 0;
        for (int i = 0; i < this.files.size(); ++i) {
            ImageReader reader = new ImageReader();
            reader.setId(this.files.get(i));
            byte[] plane = reader.openBytes(0);
            if (plane[0] != this.pixels[i][0]) {
                LOGGER.debug("FAILED on {}", (Object)this.pixels[i][0]);
                ++failureCount;
            }
            reader.close();
        }
        AssertJUnit.assertEquals((int)failureCount, (int)0);
    }
}

