/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

import java.util.Base64;

import ome.xml.model.enums.*;
import ome.xml.model.enums.handlers.*;
import ome.xml.model.primitives.*;
import ome.units.quantity.*;
import ome.units.unit.Unit;

public class BinData extends AbstractOMEModelObject
{
  // Base: AbstractOMEModelObject -- Name: BinData -- Type: BinData -- modelBaseType: AbstractOMEModelObject -- langBaseType: Object

  // -- Constants --

  public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";

  /** Logger for this class. */
  private static final Logger LOGGER =
    LoggerFactory.getLogger(BinData.class);

  // -- Instance variables --

  // Base64Binary property
  private byte[] base64Binary;

  // Compression property
  private Compression compression;

  // BigEndian property
  private Boolean bigEndian;

  // Length property
  private NonNegativeLong length;

  // Pixels_BackReference back reference
  private Pixels pixels;

  // -- Constructors --

  /** Default constructor. */
  public BinData()
  {
  }



  /**
   * Constructs BinData recursively from an XML DOM tree.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public BinData(Element element, OMEModel model)
    throws EnumerationException
  {
    update(element, model);
  }

  /** Copy constructor. */
  public BinData(BinData orig)
  {
    base64Binary = orig.base64Binary;
    compression = orig.compression;
    bigEndian = orig.bigEndian;
    length = orig.length;
    pixels = orig.pixels;
  }

  // -- Custom content from BinData specific template --


  // -- OMEModelObject API methods --

  /**
   * Updates BinData recursively from an XML DOM tree. <b>NOTE:</b> No
   * properties are removed, only added or updated.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public void update(Element element, OMEModel model)
    throws EnumerationException
  {
    super.update(element, model);
    // Element's text data
    String value_textContent = element.getTextContent();
    if (value_textContent.trim().length() > 0) {
      byte[] rawBytes = Base64.getDecoder().decode(value_textContent);
      setBase64Binary(rawBytes);
    }
    if (element.hasAttribute("Compression"))
    {
      // Attribute property which is an enumeration Compression
      setCompression(Compression.fromString(
        element.getAttribute("Compression")));
    }
    if (element.hasAttribute("BigEndian"))
    {
      // Attribute property BigEndian
      setBigEndian(Boolean.valueOf(
        element.getAttribute("BigEndian")));
    }
    if (element.hasAttribute("Length"))
    {
      // Attribute property Length
      setLength(NonNegativeLong.valueOf(
        element.getAttribute("Length")));
    }
  }

  // -- BinData API methods --

  public boolean link(Reference reference, OMEModelObject o)
  {
    return super.link(reference, o);
  }

  // Property Base64Binary
  public byte[] getBase64Binary()
  {
    return base64Binary;
  }

  public void setBase64Binary(byte[] base64Binary)
  {
    this.base64Binary = base64Binary;
  }

  // Property Compression
  public Compression getCompression()
  {
    return compression;
  }

  public void setCompression(Compression compression)
  {
    this.compression = compression;
  }

  // Property BigEndian
  public Boolean getBigEndian()
  {
    return bigEndian;
  }

  public void setBigEndian(Boolean bigEndian)
  {
    this.bigEndian = bigEndian;
  }

  // Property Length
  public NonNegativeLong getLength()
  {
    return length;
  }

  public void setLength(NonNegativeLong length)
  {
    this.length = length;
  }

  // Property Pixels_BackReference
  public Pixels getPixels()
  {
    return pixels;
  }

  public void setPixels(Pixels pixels_BackReference)
  {
    this.pixels = pixels_BackReference;
  }

  public Element asXMLElement(Document document)
  {
    return asXMLElement(document, null);
  }

  public Element asXMLElement(Document document, Element BinData_element)
  {
    // Creating XML block for BinData
    if (BinData_element == null)
    {
      BinData_element =
        document.createElementNS(NAMESPACE, "BinData");
    }

    // Ensure any base annotations add their Elements first
    super.asXMLElement(document, BinData_element);

    if (base64Binary != null)
    {
      // Element's text data
      String encodedString = Base64.getEncoder().encodeToString(base64Binary);
      BinData_element.setTextContent(encodedString);
    }
    if (compression != null)
    {
      // Attribute property Compression
      BinData_element.setAttribute("Compression", compression.toString());
    }
    if (bigEndian != null)
    {
      // Attribute property BigEndian
      BinData_element.setAttribute("BigEndian", bigEndian.toString());
    }
    if (length != null)
    {
      // Attribute property Length
      BinData_element.setAttribute("Length", length.toString());
    }
    // *** IGNORING *** Skipped back reference Pixels_BackReference

    return BinData_element;
  }
}
