/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.remote;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ucar.ma2.StructureData;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.point.PointIteratorEmpty;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationHelper;
import ucar.nc2.ft.point.StationTimeSeriesCollectionImpl;
import ucar.nc2.ft.point.StationTimeSeriesFeatureImpl;
import ucar.nc2.ft.point.remote.PointCollectionStreamRemote;
import ucar.nc2.ft.point.remote.PointDatasetRemote;
import ucar.nc2.ft.point.remote.PointIteratorStream;
import ucar.nc2.ft.point.remote.PointStream;
import ucar.nc2.ft.point.remote.PointStreamProto;
import ucar.nc2.ft.point.remote.QueryMaker;
import ucar.nc2.stream.CdmRemote;
import ucar.nc2.stream.NcStream;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;

public class StationCollectionStream
extends StationTimeSeriesCollectionImpl {
    private String uri;
    protected LatLonRect boundingBoxSubset;
    protected CalendarDateRange dateRangeSubset;

    public StationCollectionStream(String uri, CalendarDateUnit timeUnit, String altUnits) {
        super(uri, timeUnit, altUnits);
        this.uri = uri;
    }

    @Override
    protected StationHelper createStationHelper() throws IOException {
        StationHelper stationHelper = new StationHelper();
        try (InputStream in = CdmRemote.sendQuery(null, this.uri, "req=stations");){
            PointStream.MessageType mtype = PointStream.readMagic(in);
            if (mtype != PointStream.MessageType.StationList) {
                throw new RuntimeException("Station Request: bad response");
            }
            int len = NcStream.readVInt(in);
            byte[] b = new byte[len];
            NcStream.readFully(in, b);
            PointStreamProto.StationList stationsp = PointStreamProto.StationList.parseFrom(b);
            for (PointStreamProto.Station sp : stationsp.getStationsList()) {
                stationHelper.addStation(new StationFeatureStream(null, null));
            }
            StationHelper stationHelper2 = stationHelper;
            return stationHelper2;
        }
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(List<StationFeature> stations) {
        if (stations == null) {
            return this;
        }
        return new Subset(this, null, null);
    }

    @Override
    public StationTimeSeriesFeatureCollection subset(LatLonRect boundingBox) {
        if (boundingBox == null) {
            return this;
        }
        return new Subset(this, boundingBox, null);
    }

    @Override
    public PointFeatureCollection flatten(LatLonRect boundingBox, CalendarDateRange dateRange) {
        PointCollectionStreamRemote pfc = new PointCollectionStreamRemote(this.uri, this.getTimeUnit(), this.getAltUnits(), null);
        return pfc.subset(boundingBox, dateRange);
    }

    private class StationFeatureStream
    extends StationTimeSeriesFeatureImpl {
        StationTimeSeriesFeature stnFeature;
        PointIteratorStream riter;

        StationFeatureStream(StationTimeSeriesFeature s2, CalendarDateRange dateRange) {
            super(s2, StationCollectionStream.this.getTimeUnit(), StationCollectionStream.this.getAltUnits(), -1);
            this.stnFeature = s2;
            if (dateRange != null) {
                this.getInfo();
                this.info.setCalendarDateRange(dateRange);
            }
        }

        @Override
        public StationTimeSeriesFeature subset(CalendarDateRange dateRange) {
            if (dateRange == null) {
                return this;
            }
            return new StationFeatureStream(this.stnFeature, dateRange);
        }

        @Override
        @Nonnull
        public StructureData getFeatureData() throws IOException {
            return this.stnFeature.getFeatureData();
        }

        @Override
        @Nullable
        public PointFeatureCollection subset(LatLonRect boundingBox, CalendarDateRange dateRange) {
            if (boundingBox != null) {
                if (!boundingBox.contains(this.s.getLatLon())) {
                    return null;
                }
                if (dateRange == null) {
                    return this;
                }
            }
            return this.subset(dateRange);
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() throws IOException {
            String query = PointDatasetRemote.makeQuery("stn=" + this.s.getName(), null, this.getInfo().getCalendarDateRange(this.getTimeUnit()));
            InputStream in = null;
            try {
                in = CdmRemote.sendQuery(null, StationCollectionStream.this.uri, query);
                PointStream.MessageType mtype = PointStream.readMagic(in);
                if (mtype == PointStream.MessageType.End) {
                    in.close();
                    return new PointIteratorEmpty();
                }
                if (mtype != PointStream.MessageType.PointFeatureCollection) {
                    throw new RuntimeException("Station Request: bad response = " + (Object)((Object)mtype));
                }
                int len = NcStream.readVInt(in);
                byte[] b = new byte[len];
                NcStream.readFully(in, b);
                PointStreamProto.PointFeatureCollection pfc = PointStreamProto.PointFeatureCollection.parseFrom(b);
                this.riter = new PointIteratorStream(this, in, new PointStream.ProtobufPointFeatureMaker(pfc));
                return this.riter;
            }
            catch (Throwable t2) {
                if (in != null) {
                    in.close();
                }
                throw new IOException(t2.getMessage(), t2);
            }
        }
    }

    private static class Subset
    extends StationCollectionStream {
        StationCollectionStream from;

        Subset(StationCollectionStream from, LatLonRect filter_bb, CalendarDateRange filter_date) {
            super(from.uri, from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            if (filter_bb == null) {
                this.boundingBoxSubset = from.getBoundingBox();
            } else {
                LatLonRect latLonRect = this.boundingBoxSubset = from.getBoundingBox() == null ? filter_bb : from.getBoundingBox().intersect(filter_bb);
            }
            this.dateRangeSubset = filter_date == null ? from.dateRangeSubset : (from.dateRangeSubset == null ? filter_date : from.dateRangeSubset.intersect(filter_date));
        }

        @Override
        protected StationHelper createStationHelper() {
            List<StationFeature> stations = this.from.getStationHelper().getStationFeatures(this.boundingBoxSubset);
            StationHelper stationHelper = new StationHelper();
            stationHelper.setStations(stations);
            return stationHelper;
        }
    }

    private class QueryByStationList
    implements QueryMaker {
        private QueryByStationList() {
        }

        @Override
        public String makeQuery() {
            StringBuilder query = new StringBuilder("stns=");
            for (StationFeature s2 : StationCollectionStream.this.getStationHelper().getStationFeatures()) {
                query.append(s2.getName());
                query.append(",");
            }
            return PointDatasetRemote.makeQuery(query.toString(), StationCollectionStream.this.boundingBoxSubset, StationCollectionStream.this.dateRangeSubset);
        }
    }
}

