/*
 * Decompiled with CFR 0.152.
 */
package mdbtools.libmdb;

import mdbtools.libmdb.MdbHandle;
import mdbtools.libmdb.file;

public class Money {
    private static int MAXPRECISION = 20;

    public static String mdb_money_to_string(MdbHandle mdb, int start) {
        int i;
        int[] multiplier = new int[MAXPRECISION];
        int[] temp = new int[MAXPRECISION];
        int[] product = new int[MAXPRECISION];
        int num_bytes = 8;
        boolean neg = false;
        multiplier[0] = 1;
        int money = start;
        if ((mdb.pg_buf[money + 7] & 1) != 0) {
            neg = true;
            for (i = 0; i < num_bytes; ++i) {
                mdb.pg_buf[money + i] = ~mdb.pg_buf[money + i];
            }
            for (i = 0; i < num_bytes; ++i) {
                int n = money + i;
                mdb.pg_buf[n] = (byte)(mdb.pg_buf[n] + 1);
                if (mdb.pg_buf[money + i] != 0) break;
            }
        }
        mdb.pg_buf[money + 7] = 0;
        for (int pos = 0; pos < num_bytes; ++pos) {
            Money.multiply_byte(product, file.unsign(mdb.pg_buf[money + pos]), multiplier);
            System.arraycopy(multiplier, 0, temp, 0, MAXPRECISION);
            for (i = 0; i < MAXPRECISION; ++i) {
                multiplier[i] = 0;
            }
            Money.multiply_byte(multiplier, 256, temp);
        }
        String s2 = neg ? "-" + Money.array_to_string(product, 4) : Money.array_to_string(product, 4);
        return s2;
    }

    private static int multiply_byte(int[] product, int num, int[] multiplier) {
        int top;
        int[] number = new int[]{num % 10, num / 10 % 10, num / 100 % 10};
        for (top = MAXPRECISION - 1; top >= 0 && multiplier[top] == 0; --top) {
        }
        int start = 0;
        for (int i = 0; i <= top; ++i) {
            for (int j = 0; j < 3; ++j) {
                int n = j + start;
                product[n] = product[n] + multiplier[i] * number[j];
            }
            Money.do_carry(product);
            ++start;
        }
        return 0;
    }

    private static int do_carry(int[] product) {
        for (int j = 0; j < MAXPRECISION; ++j) {
            if (product[j] <= 9) continue;
            int n = j + 1;
            product[n] = product[n] + product[j] / 10;
            product[j] = product[j] % 10;
        }
        return 0;
    }

    static String array_to_string(int[] array, int scale) {
        int top;
        for (top = MAXPRECISION - 1; top >= 0 && top > scale && array[top] == 0; --top) {
        }
        if (top == -1) {
            return "0";
        }
        int j = 0;
        char[] s2 = new char[100];
        for (int i = top; i >= 0; --i) {
            if (top + 1 - j == scale) {
                s2[j++] = 46;
            }
            s2[j++] = (char)(array[i] + 48);
        }
        return new String(s2, 0, j);
    }
}

