/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import java.io.EOFException;
import java.io.IOException;
import loci.common.RandomAccessInputStream;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.meta.MetadataStore;
import ome.units.quantity.Length;

public class PQBinReader
extends FormatReader {
    public static final int HEADER_SIZE = 20;
    protected int timeBins;
    protected byte[] dataStore = null;
    protected int currentBlock;
    protected int blockLength;

    public PQBinReader() {
        super("PicoQuant Bin", "bin");
        this.domains = new String[]{"Fluorescence-Lifetime Imaging"};
        this.suffixSufficient = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int sizeT;
        int sizeY;
        int sizeX;
        long fileLength;
        int bpp = FormatTools.getBytesPerPixel((int)5);
        stream.order(true);
        try {
            fileLength = stream.length();
            sizeX = stream.readInt();
            sizeY = stream.readInt();
            stream.readFloat();
            sizeT = stream.readInt();
        }
        catch (EOFException eof) {
            return false;
        }
        return (long)(sizeX * sizeY * sizeT * bpp + 20) == fileLength;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int sizeX = this.getSizeX();
        int sizeY = this.getSizeY();
        int bpp = FormatTools.getBytesPerPixel((int)this.getPixelType());
        boolean little = this.isLittleEndian();
        int planeSize = sizeX * sizeY * this.timeBins * bpp;
        int timeBin = no;
        int binSize = sizeX * sizeY * bpp;
        int blockSize = sizeX * sizeY * this.blockLength * bpp;
        if (this.dataStore == null) {
            this.dataStore = new byte[blockSize];
            this.currentBlock = -1;
        }
        if (timeBin / this.blockLength != this.currentBlock) {
            this.currentBlock = timeBin / this.blockLength;
            byte[] rowBuf = new byte[bpp * this.timeBins * sizeX];
            this.in.seek(20L);
            int endOfBlock = (this.currentBlock + 1) * this.blockLength;
            int storeLength = endOfBlock > this.timeBins ? this.timeBins - this.currentBlock * this.blockLength : this.blockLength;
            for (int row = 0; row < sizeY; ++row) {
                this.in.read(rowBuf);
                for (int col = 0; col < sizeX; ++col) {
                    int output = (row * sizeX + col) * bpp;
                    int input = (col * this.timeBins + this.currentBlock * this.blockLength) * bpp;
                    for (int t = 0; t < storeLength; ++t) {
                        for (int bb = 0; bb < bpp; ++bb) {
                            this.dataStore[output + bb] = rowBuf[input + bb];
                        }
                        output += binSize;
                        input += bpp;
                    }
                }
            }
        }
        int iLineSize = sizeX * bpp;
        int oLineSize = w * bpp;
        int binInStore = timeBin - this.currentBlock * this.blockLength;
        int input = binSize * binInStore + y * iLineSize + x * bpp;
        int output = 0;
        for (int row = 0; row < h; ++row) {
            System.arraycopy(this.dataStore, input, buf, output, oLineSize);
            input += iLineSize;
            output += oLineSize;
        }
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.dataStore = null;
            this.timeBins = 0;
            this.currentBlock = -1;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        int sizeY;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        CoreMetadata m = (CoreMetadata)this.core.get(0);
        m.littleEndian = true;
        this.in.order(this.isLittleEndian());
        LOGGER.info("Reading header PQBin");
        int sizeX = this.in.readInt();
        m.sizeY = sizeY = this.in.readInt();
        m.sizeX = sizeX;
        float pixResol = this.in.readFloat();
        m.sizeT = this.in.readInt();
        float timeResol = this.in.readFloat();
        this.timeBins = m.sizeT;
        m.sizeZ = 1;
        m.sizeC = 1;
        m.dimensionOrder = "XYZCT";
        m.pixelType = 5;
        m.rgb = false;
        m.imageCount = m.sizeT;
        m.indexed = false;
        m.falseColor = false;
        m.metadataComplete = true;
        m.moduloT.type = "Lifetime";
        m.moduloT.parentType = "Spectra";
        m.moduloT.typeDescription = "TCSPC";
        m.moduloT.start = 0.0;
        m.moduloT.step = timeResol * 1000.0f;
        m.moduloT.end = m.moduloT.step * (double)(m.sizeT - 1);
        m.moduloT.unit = "ps";
        int sizeThreshold = 0x1000000;
        this.blockLength = 2048;
        while (this.blockLength * sizeX * sizeY > sizeThreshold) {
            this.blockLength /= 2;
        }
        if (this.blockLength > this.timeBins) {
            this.blockLength = this.timeBins;
        }
        MetadataStore store = this.makeFilterMetadata();
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this);
        Length pRpf = FormatTools.getPhysicalSizeX((Double)Double.valueOf(pixResol));
        store.setPixelsPhysicalSizeX(pRpf, 0);
        store.setPixelsPhysicalSizeY(pRpf, 0);
    }
}

