/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Optional;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"writeTests"})
public class WriteFloatTest {
    private static final byte[] PAGE = new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private static final String MODE = "rw";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;
    private boolean checkGrowth;

    @Parameters(value={"provider", "checkGrowth"})
    @BeforeMethod
    public void setUp(String provider, @Optional(value="false") String checkGrowth) throws IOException {
        this.checkGrowth = Boolean.parseBoolean(checkGrowth);
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test(groups={"initialLengthTest"})
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)28L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequential() throws IOException {
        this.fileHandle.writeFloat(0.0f);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeFloat(1.0f);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeFloat(-1.0f);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)12L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeFloat((float)Math.PI);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeFloat(Float.MAX_VALUE);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)20L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeFloat(Float.NEGATIVE_INFINITY);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)24L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeFloat(Float.NaN);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)28L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(-1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf((float)Math.PI), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(Float.MAX_VALUE), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(Float.NEGATIVE_INFINITY), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(this.fileHandle.readFloat()));
    }

    @Test
    public void testSeekForward() throws IOException {
        this.fileHandle.seek(8L);
        this.fileHandle.writeFloat(-1.0f);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)12L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeFloat((float)Math.PI);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)16L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((Object)Float.valueOf(-1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf((float)Math.PI), (Object)Float.valueOf(this.fileHandle.readFloat()));
    }

    @Test
    public void testReset() throws IOException {
        this.fileHandle.writeFloat(0.0f);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)4L, (long)this.fileHandle.length());
        }
        this.fileHandle.writeFloat(1.0f);
        if (this.checkGrowth) {
            AssertJUnit.assertEquals((long)8L, (long)this.fileHandle.length());
        }
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((Object)Float.valueOf(0.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf(1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        this.fileHandle.seek(0L);
        this.fileHandle.writeFloat(-1.0f);
        this.fileHandle.writeFloat((float)Math.PI);
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((Object)Float.valueOf(-1.0f), (Object)Float.valueOf(this.fileHandle.readFloat()));
        AssertJUnit.assertEquals((Object)Float.valueOf((float)Math.PI), (Object)Float.valueOf(this.fileHandle.readFloat()));
    }
}

