/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class ReadShortTest {
    private static final byte[] PAGE = new byte[]{0, 1, 15, 2, 0, 3, 15, 4, 0, 5, 15, 6, 0, 7, 15, 8, 0, 9, 15, 10, 0, 11, 15, 12, 0, 13, -1, -1, 0, 15, -1, -2};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)32L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequentialReadShort() throws IOException {
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3842, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3844, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3846, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)7, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3848, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)9, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3850, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)11, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3852, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)13, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)-1, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)15, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)-2, (int)this.fileHandle.readShort());
    }

    @Test
    public void testSeekForwardReadShort() throws IOException {
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3846, (int)this.fileHandle.readShort());
    }

    @Test
    public void testResetReadShort() throws IOException {
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3842, (int)this.fileHandle.readShort());
        this.fileHandle.seek(0L);
        AssertJUnit.assertEquals((int)1, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3842, (int)this.fileHandle.readShort());
    }

    @Test
    public void testSeekBackReadShort() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.seek(8L);
        AssertJUnit.assertEquals((int)5, (int)this.fileHandle.readShort());
        AssertJUnit.assertEquals((int)3846, (int)this.fileHandle.readShort());
    }

    @Test
    public void testRandomAccessReadShort() throws IOException {
        this.testSeekForwardReadShort();
        this.testSeekBackReadShort();
        this.fileHandle.seek(0L);
        this.testResetReadShort();
    }
}

