/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.base.mdarray.MDDoubleArray;
import ch.systemsx.cisd.base.mdarray.MDFloatArray;
import ch.systemsx.cisd.base.mdarray.MDIntArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.base.mdarray.MDShortArray;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValue;
import ch.systemsx.cisd.hdf5.HDF5EnumerationValueArray;
import hdf.hdf5lib.HDF5Constants;
import java.util.BitSet;
import java.util.Map;

public enum HDF5DataClass {
    BITFIELD(HDF5Constants.H5T_BITFIELD, new BasicJavaTypeProvider(BitSet.class, null, null, null)),
    ENUM(HDF5Constants.H5T_ENUM, new BasicJavaTypeProvider(HDF5EnumerationValue.class, HDF5EnumerationValueArray.class, null, null)),
    INTEGER(HDF5Constants.H5T_INTEGER, new IntJavaTypeProvider()),
    FLOAT(HDF5Constants.H5T_FLOAT, new FloatJavaTypeProvider()),
    STRING(HDF5Constants.H5T_STRING, new BasicJavaTypeProvider(String.class, String[].class, String[][].class, MDArray.class)),
    OPAQUE(HDF5Constants.H5T_OPAQUE, new BasicJavaTypeProvider(Byte.TYPE, byte[].class, byte[][].class, MDByteArray.class)),
    BOOLEAN(-1, new BasicJavaTypeProvider(Boolean.TYPE, BitSet.class, null, null)),
    COMPOUND(HDF5Constants.H5T_COMPOUND, new BasicJavaTypeProvider(Map.class, Map[].class, Map[][].class, MDArray.class)),
    REFERENCE(HDF5Constants.H5T_REFERENCE, new BasicJavaTypeProvider(String.class, String[].class, String[][].class, MDArray.class)),
    OTHER(-1, new BasicJavaTypeProvider(null, null, null, null));

    private final int id;
    private final IHDF5JavaTypeProvider typeProvider;

    private HDF5DataClass(int id, IHDF5JavaTypeProvider typeProvider) {
        this.id = id;
        this.typeProvider = typeProvider;
    }

    int getId() {
        return this.id;
    }

    IHDF5JavaTypeProvider getJavaTypeProvider() {
        return this.typeProvider;
    }

    static HDF5DataClass classIdToDataClass(int classId) {
        HDF5DataClass[] hDF5DataClassArray = HDF5DataClass.values();
        int n = hDF5DataClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            HDF5DataClass clazz = hDF5DataClassArray[n2];
            if (clazz.id == classId) {
                return clazz;
            }
            ++n2;
        }
        return OTHER;
    }

    private static class BasicJavaTypeProvider
    implements IHDF5JavaTypeProvider {
        private final Class<?> javaTypeScalarOrNull;
        private final Class<?> javaType1DArrayOrNull;
        private final Class<?> javaType2DArrayOrNull;
        private final Class<?> javaTypeMDArrayOrNull;

        BasicJavaTypeProvider(Class<?> javaTypeScalarOrNull, Class<?> javaType1DArrayOrNull, Class<?> javaType2DArrayOrNull, Class<?> javaTypeMDArrayOrNull) {
            this.javaTypeScalarOrNull = javaTypeScalarOrNull;
            this.javaType1DArrayOrNull = javaType1DArrayOrNull;
            this.javaType2DArrayOrNull = javaType2DArrayOrNull;
            this.javaTypeMDArrayOrNull = javaTypeMDArrayOrNull;
        }

        @Override
        public Class<?> tryGetJavaType(int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
            if (rank == 0) {
                return this.javaTypeScalarOrNull;
            }
            if (rank == 1) {
                return this.javaType1DArrayOrNull;
            }
            if (rank == 2) {
                return this.javaType2DArrayOrNull;
            }
            return this.javaTypeMDArrayOrNull;
        }
    }

    private static class FloatJavaTypeProvider
    implements IHDF5JavaTypeProvider {
        private FloatJavaTypeProvider() {
        }

        @Override
        public Class<?> tryGetJavaType(int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
            if (rank == 0) {
                switch (elementSize) {
                    case 4: {
                        return Float.TYPE;
                    }
                    case 8: {
                        return Double.TYPE;
                    }
                }
                return null;
            }
            if (rank == 1) {
                switch (elementSize) {
                    case 4: {
                        return float[].class;
                    }
                    case 8: {
                        return double[].class;
                    }
                }
                return null;
            }
            if (rank == 2) {
                switch (elementSize) {
                    case 4: {
                        return float[][].class;
                    }
                    case 8: {
                        return double[][].class;
                    }
                }
                return null;
            }
            switch (elementSize) {
                case 4: {
                    return MDFloatArray.class;
                }
                case 8: {
                    return MDDoubleArray.class;
                }
            }
            return null;
        }
    }

    static interface IHDF5JavaTypeProvider {
        public Class<?> tryGetJavaType(int var1, int var2, HDF5DataTypeVariant var3);
    }

    private static class IntJavaTypeProvider
    implements IHDF5JavaTypeProvider {
        private IntJavaTypeProvider() {
        }

        @Override
        public Class<?> tryGetJavaType(int rank, int elementSize, HDF5DataTypeVariant typeVariantOrNull) {
            if (rank == 0) {
                switch (elementSize) {
                    case 1: {
                        return Byte.TYPE;
                    }
                    case 2: {
                        return Short.TYPE;
                    }
                    case 4: {
                        return Integer.TYPE;
                    }
                    case 8: {
                        return Long.TYPE;
                    }
                }
                return null;
            }
            if (rank == 1) {
                switch (elementSize) {
                    case 1: {
                        return byte[].class;
                    }
                    case 2: {
                        return short[].class;
                    }
                    case 4: {
                        return int[].class;
                    }
                    case 8: {
                        return long[].class;
                    }
                }
                return null;
            }
            if (rank == 2) {
                switch (elementSize) {
                    case 1: {
                        return byte[][].class;
                    }
                    case 2: {
                        return short[][].class;
                    }
                    case 4: {
                        return int[][].class;
                    }
                    case 8: {
                        return long[][].class;
                    }
                }
                return null;
            }
            switch (elementSize) {
                case 1: {
                    return MDByteArray.class;
                }
                case 2: {
                    return MDShortArray.class;
                }
                case 4: {
                    return MDIntArray.class;
                }
                case 8: {
                    return MDLongArray.class;
                }
            }
            return null;
        }
    }
}

