/*
 * Decompiled with CFR 0.152.
 */
package loci.poi.hssf.record.formula;

import loci.poi.hssf.model.Workbook;
import loci.poi.hssf.record.RecordInputStream;
import loci.poi.hssf.record.formula.Ptg;
import loci.poi.util.LittleEndian;

public class IntPtg
extends Ptg {
    public static final int SIZE = 3;
    public static final byte sid = 30;
    private short field_1_value;

    private IntPtg() {
    }

    public IntPtg(RecordInputStream in) {
        this.setValue(in.readShort());
    }

    public IntPtg(String formulaToken) {
        this.setValue(Short.parseShort(formulaToken));
    }

    public void setValue(short value) {
        this.field_1_value = value;
    }

    public short getValue() {
        return this.field_1_value;
    }

    @Override
    public void writeBytes(byte[] array, int offset) {
        array[offset + 0] = 30;
        LittleEndian.putShort(array, offset + 1, this.getValue());
    }

    @Override
    public int getSize() {
        return 3;
    }

    @Override
    public String toFormulaString(Workbook book) {
        return "" + this.getValue();
    }

    @Override
    public byte getDefaultOperandClass() {
        return 32;
    }

    @Override
    public Object clone() {
        IntPtg ptg = new IntPtg();
        ptg.field_1_value = this.field_1_value;
        return ptg;
    }
}

