/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.math.distribution;

import java.io.Serializable;
import org.apache.commons.math.distribution.AbstractContinuousDistribution;
import org.apache.commons.math.distribution.CauchyDistribution;

public class CauchyDistributionImpl
extends AbstractContinuousDistribution
implements CauchyDistribution,
Serializable {
    private static final long serialVersionUID = 8589540077390120676L;
    private double median = 0.0;
    private double scale = 1.0;

    public CauchyDistributionImpl() {
        this(0.0, 1.0);
    }

    public CauchyDistributionImpl(double median, double s2) {
        this.setMedian(median);
        this.setScale(s2);
    }

    public double cumulativeProbability(double x) {
        return 0.5 + Math.atan((x - this.median) / this.scale) / Math.PI;
    }

    public double getMedian() {
        return this.median;
    }

    public double getScale() {
        return this.scale;
    }

    public double inverseCumulativeProbability(double p) {
        if (p < 0.0 || p > 1.0) {
            throw new IllegalArgumentException("probability argument must be between 0 and 1 (inclusive)");
        }
        double ret = p == 0.0 ? Double.NEGATIVE_INFINITY : (p == 1.0 ? Double.POSITIVE_INFINITY : this.median + this.scale * Math.tan(Math.PI * (p - 0.5)));
        return ret;
    }

    public void setMedian(double median) {
        this.median = median;
    }

    public void setScale(double s2) {
        if (s2 <= 0.0) {
            throw new IllegalArgumentException("Scale must be positive.");
        }
        this.scale = s2;
    }

    protected double getDomainLowerBound(double p) {
        double ret = p < 0.5 ? -1.7976931348623157E308 : this.getMedian();
        return ret;
    }

    protected double getDomainUpperBound(double p) {
        double ret = p < 0.5 ? this.getMedian() : Double.MAX_VALUE;
        return ret;
    }

    protected double getInitialDomain(double p) {
        double ret = p < 0.5 ? this.getMedian() - this.getScale() : (p > 0.5 ? this.getMedian() + this.getScale() : this.getMedian());
        return ret;
    }
}

