/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point.standard;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Formatter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataFactory;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureDataIteratorLimited;
import ucar.ma2.StructureMembers;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.point.StationFeature;
import ucar.nc2.ft.point.StationFeatureImpl;
import ucar.nc2.ft.point.standard.CoordVarExtractor;
import ucar.nc2.ft.point.standard.Cursor;
import ucar.nc2.ft.point.standard.Join;
import ucar.nc2.ft.point.standard.Table;
import ucar.nc2.ft.point.standard.TableConfig;
import ucar.nc2.time.CalendarDate;
import ucar.nc2.time.CalendarDateFormatter;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.EarthLocation;

public class NestedTable {
    private static Logger log = LoggerFactory.getLogger(NestedTable.class);
    private NetcdfDataset ds;
    private Formatter errlog;
    private Table leaf;
    private Table root;
    private FeatureType featureType;
    private CoordVarExtractor timeVE;
    private CoordVarExtractor nomTimeVE;
    private CoordVarExtractor latVE;
    private CoordVarExtractor lonVE;
    private CoordVarExtractor altVE;
    private CoordVarExtractor stnVE;
    private CoordVarExtractor stnDescVE;
    private CoordVarExtractor wmoVE;
    private CoordVarExtractor stnAltVE;
    private CoordVarExtractor idVE;
    private CoordVarExtractor missingVE;
    private List<Variable> extras;
    private int nlevels;

    NestedTable(NetcdfDataset ds, TableConfig config, Formatter errlog) {
        this.ds = ds;
        this.errlog = errlog;
        this.leaf = Table.factory(ds, config);
        this.root = this.getRoot();
        this.nlevels = 0;
        Table t2 = this.leaf;
        while (t2 != null) {
            if (t2.getFeatureType() != null) {
                this.featureType = t2.getFeatureType();
            }
            t2 = t2.parent;
            ++this.nlevels;
        }
        if (this.featureType == null) {
            this.featureType = FeatureDatasetFactoryManager.findFeatureType(ds);
        }
        this.timeVE = this.findCoordinateAxis(Table.CoordName.Time, this.leaf, 0);
        this.latVE = this.findCoordinateAxis(Table.CoordName.Lat, this.leaf, 0);
        this.lonVE = this.findCoordinateAxis(Table.CoordName.Lon, this.leaf, 0);
        this.altVE = this.findCoordinateAxis(Table.CoordName.Elev, this.leaf, 0);
        this.nomTimeVE = this.findCoordinateAxis(Table.CoordName.TimeNominal, this.leaf, 0);
        this.stnVE = this.findCoordinateAxis(Table.CoordName.StnId, this.leaf, 0);
        this.stnDescVE = this.findCoordinateAxis(Table.CoordName.StnDesc, this.leaf, 0);
        this.wmoVE = this.findCoordinateAxis(Table.CoordName.WmoId, this.leaf, 0);
        this.stnAltVE = this.findCoordinateAxis(Table.CoordName.StnAlt, this.leaf, 0);
        this.missingVE = this.findCoordinateAxis(Table.CoordName.MissingVar, this.leaf, 0);
        this.idVE = this.findCoordinateAxis(Table.CoordName.FeatureId, this.root, this.nlevels - 1);
        if (this.featureType == null) {
            if (this.nlevels == 1) {
                this.featureType = FeatureType.POINT;
            }
            if (this.nlevels == 2) {
                this.featureType = FeatureType.STATION;
            }
            if (this.nlevels == 3) {
                this.featureType = FeatureType.STATION_PROFILE;
            }
        }
        for (CoordinateAxis axis : ds.getCoordinateAxes()) {
            if (this.isCoordinate(axis) || this.isExtra(axis) || axis.getDimensionsAll().size() > 1) continue;
            this.addExtraVariable(axis);
        }
    }

    Table getRoot() {
        Table p = this.leaf;
        while (p.parent != null) {
            p = p.parent;
        }
        return p;
    }

    Table getLeaf() {
        return this.leaf;
    }

    List<Variable> getExtras() {
        return this.extras;
    }

    private void addExtraVariable(Variable v) {
        if (v == null) {
            return;
        }
        if (this.extras == null) {
            this.extras = new ArrayList<Variable>();
        }
        this.extras.add(v);
    }

    private boolean isExtra(Variable v) {
        return v != null && this.extras != null && this.extras.contains(v);
    }

    private boolean isCoordinate(Variable v) {
        if (v == null) {
            return false;
        }
        String name = v.getShortName();
        return this.latVE != null && this.latVE.axisName.equals(name) || this.lonVE != null && this.lonVE.axisName.equals(name) || this.altVE != null && this.altVE.axisName.equals(name) || this.stnAltVE != null && this.stnAltVE.axisName.equals(name) || this.timeVE != null && this.timeVE.axisName.equals(name) || this.nomTimeVE != null && this.nomTimeVE.axisName.equals(name);
    }

    private CoordVarExtractor findCoordinateAxis(Table.CoordName coordName, Table t2, int nestingLevel) {
        if (t2 == null) {
            return null;
        }
        String axisName = t2.findCoordinateVariableName(coordName);
        if (axisName != null) {
            VariableDS v = t2.findVariable(axisName);
            if (v != null) {
                return new CoordVarExtractorVariable(v, axisName, nestingLevel);
            }
            if (t2.extraJoins != null) {
                for (Join j : t2.extraJoins) {
                    v = j.findVariable(axisName);
                    if (v == null) continue;
                    return new CoordVarExtractorVariable(v, axisName, nestingLevel);
                }
            }
            if (t2 instanceof Table.TableSingleton) {
                Table.TableSingleton ts = (Table.TableSingleton)t2;
                return new CoordVarStructureData(axisName, ts.sdata);
            }
            if (t2 instanceof Table.TableTop) {
                v = (VariableDS)this.ds.findVariable(axisName);
                if (v != null) {
                    return new CoordVarTop(v);
                }
                return new CoordVarConstant(coordName.toString(), "", axisName);
            }
            this.errlog.format("NestedTable: cant find variable '%s' for coordinate type %s %n", new Object[]{axisName, coordName});
        }
        return this.findCoordinateAxis(coordName, t2.parent, nestingLevel + 1);
    }

    public FeatureType getFeatureType() {
        return this.featureType;
    }

    public int getNumberOfLevels() {
        return this.nlevels;
    }

    public boolean hasCoords() {
        return this.timeVE != null && this.latVE != null && this.lonVE != null;
    }

    public String getTimeName() {
        return this.timeVE.axisName;
    }

    public CalendarDateUnit getTimeUnit() {
        try {
            return CalendarDateUnit.of(null, this.timeVE.getUnitsString());
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Error on time string = " + this.timeVE.getUnitsString() + " == " + e.getMessage());
        }
    }

    public String getAltName() {
        if (this.altVE != null) {
            return this.altVE.axisName;
        }
        if (this.stnAltVE != null) {
            return this.stnAltVE.axisName;
        }
        return null;
    }

    public String getAltUnits() {
        if (this.altVE != null) {
            return this.altVE.getUnitsString();
        }
        if (this.stnAltVE != null) {
            return this.stnAltVE.getUnitsString();
        }
        return null;
    }

    public List<VariableSimpleIF> getDataVariables() {
        ArrayList<VariableSimpleIF> data = new ArrayList<VariableSimpleIF>();
        this.addDataVariables(data, this.leaf);
        Collections.sort(data);
        return data;
    }

    private void addDataVariables(List<VariableSimpleIF> list, Table t2) {
        if (t2.parent != null) {
            this.addDataVariables(list, t2.parent);
        }
        for (VariableSimpleIF col : t2.cols.values()) {
            if (t2.nondataVars.contains(col.getFullName()) || t2.nondataVars.contains(col.getShortName())) continue;
            list.add(col);
        }
    }

    public String getName() {
        Formatter formatter = new Formatter();
        formatter.format("%s", this.root.getName());
        Table t2 = this.root;
        while (t2.child != null) {
            t2 = t2.child;
            String name = t2.getName() != null ? t2.getName() : "anon";
            formatter.format("/%s", name);
        }
        return formatter.toString();
    }

    public String toString() {
        Formatter formatter = new Formatter();
        formatter.format("NestedTable = %s%n", this.getName());
        formatter.format("  Time= %s%n", this.timeVE);
        formatter.format("  Lat= %s%n", this.latVE);
        formatter.format("  Lon= %s%n", this.lonVE);
        formatter.format("  Height= %s%n", this.altVE);
        return formatter.toString();
    }

    public void show(Formatter formatter) {
        formatter.format(" NestedTable = %s%n", this.getName());
        formatter.format("   nlevels = %d%n", this.nlevels);
        this.leaf.show(formatter, 2);
    }

    public double getObsTime(Cursor cursor) {
        return this.getTime(this.timeVE, cursor.tableData);
    }

    public double getNomTime(Cursor cursor) {
        return this.getTime(this.nomTimeVE, cursor.tableData);
    }

    private double getTime(CoordVarExtractor cve, StructureData[] tableData) {
        if (cve == null) {
            return Double.NaN;
        }
        if (tableData[cve.nestingLevel] == null) {
            return Double.NaN;
        }
        if (cve.isString()) {
            String timeString = this.timeVE.getCoordValueString(tableData);
            CalendarDate date = CalendarDateFormatter.isoStringToCalendarDate(null, timeString);
            if (date == null) {
                log.error("Cant parse date - not ISO formatted, = " + timeString);
                return 0.0;
            }
            return date.getMillis();
        }
        return cve.getCoordValue(tableData);
    }

    public double getLatitude(Cursor cursor) {
        return this.latVE.getCoordValue(cursor.tableData);
    }

    public double getLongitude(Cursor cursor) {
        return this.lonVE.getCoordValue(cursor.tableData);
    }

    public EarthLocation getEarthLocation(Cursor cursor) {
        double alt;
        double lat = this.latVE.getCoordValue(cursor.tableData);
        double lon = this.lonVE.getCoordValue(cursor.tableData);
        double d = alt = this.altVE == null ? Double.NaN : this.altVE.getCoordValue(cursor.tableData);
        if (this.stnAltVE != null) {
            double stnElev = this.stnAltVE.getCoordValue(cursor.tableData);
            alt = this.altVE == null ? stnElev : (alt += stnElev);
        }
        return EarthLocation.create(lat, lon, alt);
    }

    public String getFeatureName(Cursor cursor) {
        int count = 0;
        Table t2 = this.leaf;
        while (count++ < cursor.currentIndex) {
            t2 = t2.parent;
        }
        if (t2.feature_id == null) {
            return "unknown";
        }
        StructureData sdata = cursor.getParentStructure();
        if (sdata == null) {
            return "unknown";
        }
        StructureMembers.Member m4 = sdata.findMember(t2.feature_id);
        if (m4 == null) {
            return "unknown";
        }
        if (m4.getDataType().isString()) {
            return sdata.getScalarString(m4);
        }
        if (m4.getDataType().isIntegral()) {
            return Integer.toString(sdata.convertScalarInt(m4));
        }
        return Double.toString(sdata.convertScalarDouble(m4));
    }

    public boolean isFeatureMissing(StructureData sdata) {
        return this.idVE != null && this.idVE.isMissing(sdata);
    }

    public boolean isTimeMissing(Cursor cursor) {
        return this.timeVE != null && this.timeVE.isMissing(cursor.tableData);
    }

    public boolean isAltMissing(Cursor cursor) {
        return this.altVE != null && this.altVE.isMissing(cursor.tableData);
    }

    public boolean isMissing(Cursor cursor) {
        return this.missingVE != null && this.missingVE.isMissing(cursor.tableData);
    }

    public StructureData makeObsStructureData(Cursor cursor) {
        return StructureDataFactory.make(cursor.tableData);
    }

    public StructureData makeObsStructureData(Cursor cursor, int nest) {
        return cursor.tableData[nest];
    }

    void addParentJoin(Cursor cursor) {
        int level = cursor.currentIndex;
        Table t2 = this.getTable(level);
        if (t2.extraJoins != null) {
            ArrayList<StructureData> sdata = new ArrayList<StructureData>(3);
            sdata.add(cursor.tableData[level]);
            for (Join j : t2.extraJoins) {
                sdata.add(j.getJoinData(cursor));
            }
            cursor.tableData[level] = StructureDataFactory.make(sdata);
        }
    }

    private Table getTable(int level) {
        Table t2 = this.leaf;
        for (int count = 0; count < level; ++count) {
            t2 = t2.parent;
        }
        return t2;
    }

    public StructureDataIterator getObsDataIterator(Cursor cursor) throws IOException {
        return this.root.getStructureDataIterator(cursor);
    }

    public StructureDataIterator getStationDataIterator() throws IOException {
        Table stationTable = this.root;
        StructureDataIterator siter = stationTable.getStructureDataIterator(null);
        if (stationTable.limit != null) {
            Variable limitV = this.ds.findVariable(stationTable.limit);
            int limit = limitV.readScalarInt();
            return new StructureDataIteratorLimited(siter, limit);
        }
        return siter;
    }

    public StructureDataIterator getRootFeatureDataIterator() throws IOException {
        return this.root.getStructureDataIterator(null);
    }

    public StructureDataIterator getLeafFeatureDataIterator(Cursor cursor) throws IOException {
        return this.leaf.getStructureDataIterator(cursor);
    }

    public StructureDataIterator getMiddleFeatureDataIterator(Cursor cursor) throws IOException {
        return this.leaf.parent.getStructureDataIterator(cursor);
    }

    public int getStationNestingLevel() {
        return this.stnVE.nestingLevel;
    }

    StationFeature makeStation(StructureData stationData) {
        double elev;
        if (this.stnVE.isMissing(stationData)) {
            return null;
        }
        String stationName = this.stnVE.getCoordValueAsString(stationData);
        String stationDesc = this.stnDescVE == null ? "" : this.stnDescVE.getCoordValueAsString(stationData);
        String stnWmoId = this.wmoVE == null ? "" : this.wmoVE.getCoordValueAsString(stationData);
        double lat = this.latVE.getCoordValue(stationData);
        double lon = this.lonVE.getCoordValue(stationData);
        double d = elev = this.stnAltVE == null ? Double.NaN : this.stnAltVE.getCoordValue(stationData);
        if (Double.isNaN(lat) || Double.isNaN(lon)) {
            return null;
        }
        return new StationFeatureImpl(stationName, stationDesc, stnWmoId, lat, lon, elev, -1, stationData);
    }

    private static class CoordVarConstant
    extends CoordVarExtractor {
        String units;
        String value;

        CoordVarConstant(String name, String units, String value) {
            super(name, 0);
            this.units = units;
            this.value = value;
        }

        @Override
        public double getCoordValue(StructureData sdata) {
            return Double.parseDouble(this.value);
        }

        @Override
        public long getCoordValueLong(StructureData sdata) {
            return Long.parseLong(this.value);
        }

        @Override
        public String getCoordValueString(StructureData sdata) {
            return this.value;
        }

        @Override
        public String getUnitsString() {
            return this.units;
        }

        @Override
        public boolean isString() {
            return true;
        }

        @Override
        public boolean isInt() {
            return false;
        }

        @Override
        public boolean isMissing(StructureData sdata) {
            return false;
        }

        @Override
        public String toString() {
            return "CoordVarConstant value= " + this.value;
        }
    }

    private static class CoordVarStructureData
    extends CoordVarExtractor {
        protected StructureData sdata;

        CoordVarStructureData(String axisName, StructureData sdata) {
            super(axisName, 0);
            this.sdata = sdata;
        }

        @Override
        public double getCoordValue(StructureData ignore) {
            return this.sdata.convertScalarDouble(this.memberName);
        }

        @Override
        public String getCoordValueString(StructureData ignore) {
            return this.sdata.getScalarString(this.memberName);
        }

        @Override
        public String getUnitsString() {
            StructureMembers.Member m4 = this.sdata.findMember(this.memberName);
            return m4.getUnitsString();
        }

        @Override
        public boolean isString() {
            StructureMembers.Member m4 = this.sdata.findMember(this.memberName);
            return m4.getDataType().isString();
        }

        @Override
        public boolean isInt() {
            StructureMembers.Member m4 = this.sdata.findMember(this.memberName);
            return m4.getDataType().isIntegral();
        }

        @Override
        public long getCoordValueLong(StructureData sdata) {
            return sdata.convertScalarLong(this.memberName);
        }

        @Override
        public boolean isMissing(StructureData sdata) {
            return false;
        }
    }

    private static class CoordVarTop
    extends CoordVarExtractor {
        protected VariableDS varTop;

        CoordVarTop(VariableDS v) {
            super(v.getFullName(), 0);
            this.varTop = v;
        }

        @Override
        public double getCoordValue(StructureData sdata) {
            try {
                return this.varTop.readScalarDouble();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        public String getUnitsString() {
            return this.varTop.getUnitsString();
        }

        @Override
        public boolean isString() {
            return this.varTop.getDataType().isString();
        }

        @Override
        public boolean isInt() {
            return this.varTop.getDataType().isIntegral();
        }

        @Override
        public long getCoordValueLong(StructureData sdata) {
            try {
                return this.varTop.readScalarLong();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        public String getCoordValueString(StructureData sdata) {
            try {
                return this.varTop.readScalarString();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage());
            }
        }

        @Override
        public boolean isMissing(StructureData sdata) {
            if (this.isString()) {
                return false;
            }
            double val = this.getCoordValue(sdata);
            return this.varTop.isMissing(val);
        }
    }

    private static class CoordVarExtractorVariable
    extends CoordVarExtractor {
        protected VariableDS coordVar;

        CoordVarExtractorVariable(VariableDS v, String axisName, int nestingLevel) {
            super(axisName, nestingLevel);
            this.coordVar = v;
        }

        @Override
        public String getCoordValueString(StructureData sdata) {
            if (this.coordVar.getDataType().isString()) {
                return sdata.getScalarString(this.memberName);
            }
            if (this.coordVar.getDataType().isIntegral()) {
                return Integer.toString(sdata.convertScalarInt(this.memberName));
            }
            return Double.toString(sdata.convertScalarDouble(this.memberName));
        }

        @Override
        public String getUnitsString() {
            return this.coordVar.getUnitsString();
        }

        @Override
        public boolean isString() {
            return this.coordVar.getDataType().isString();
        }

        @Override
        public boolean isMissing(StructureData sdata) {
            if (this.isString()) {
                String s2 = this.getCoordValueString(sdata);
                double test = s2.isEmpty() ? 0.0 : (double)s2.charAt(0);
                return this.coordVar.isMissing(test);
            }
            double val = this.getCoordValue(sdata);
            return this.coordVar.isMissing(val);
        }

        @Override
        public double getCoordValue(StructureData sdata) {
            return sdata.convertScalarDouble(this.memberName);
        }

        @Override
        public boolean isInt() {
            return this.coordVar.getDataType().isIntegral();
        }

        @Override
        public long getCoordValueLong(StructureData sdata) {
            return sdata.convertScalarLong(this.memberName);
        }
    }
}

