/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.internal.iosp.netcdf3;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.AbstractCollection;
import java.util.Formatter;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.CDM;
import ucar.nc2.internal.iosp.netcdf3.N3headerNew;
import ucar.nc2.internal.iosp.netcdf3.N3iospNew;
import ucar.unidata.io.RandomAccessFile;

class N3headerWriter
extends N3headerNew {
    private static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;
    private NetcdfFile ncfile;
    private ImmutableList<Variable> uvars;
    private long globalAttsPos;

    N3headerWriter(N3iospNew n3iospNew, RandomAccessFile raf, NetcdfFile ncfile) {
        super(n3iospNew);
        this.raf = raf;
        this.ncfile = ncfile;
    }

    void create(int extra, boolean largeFile, Formatter fout) throws IOException {
        this.writeHeader(extra, largeFile, false, fout);
    }

    boolean rewriteHeader(boolean largeFile, Formatter fout) throws IOException {
        int want = this.sizeHeader(largeFile);
        if ((long)want > this.dataStart) {
            return false;
        }
        this.writeHeader(0, largeFile, true, fout);
        return true;
    }

    void writeHeader(int extra, boolean largeFile, boolean keepDataStart, Formatter fout) throws IOException {
        N3headerNew.Vinfo vinfo;
        this.useLongOffset = largeFile;
        this.nonRecordDataSize = 0L;
        this.recsize = 0L;
        this.recStart = Long.MAX_VALUE;
        this.raf.seek(0L);
        this.raf.write(largeFile ? N3headerNew.MAGIC_LONG : N3headerNew.MAGIC);
        this.raf.writeInt(0);
        List<Dimension> dims = this.ncfile.getRootGroup().getDimensions();
        int numdims = dims.size();
        if (numdims == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(10);
            this.raf.writeInt(numdims);
        }
        for (int i = 0; i < numdims; ++i) {
            Dimension dim = dims.get(i);
            if (fout != null) {
                fout.format("  dim %d pos %d%n", i, this.raf.getFilePointer());
            }
            this.writeString(dim.getShortName());
            this.raf.writeInt(dim.isUnlimited() ? 0 : dim.getLength());
            if (!dim.isUnlimited()) continue;
            this.udim = dim;
        }
        this.globalAttsPos = this.raf.getFilePointer();
        this.writeAtts(this.ncfile.getRootGroup().attributes(), fout);
        ImmutableList<Variable> vars = this.ncfile.getVariables();
        ImmutableList.Builder uvarb = ImmutableList.builder();
        for (Variable curVar : vars) {
            if (!curVar.isUnlimited()) continue;
            uvarb.add(curVar);
        }
        this.uvars = uvarb.build();
        this.writeVars(vars, largeFile, fout);
        if (!keepDataStart) {
            this.dataStart = this.raf.getFilePointer();
            if (extra > 0) {
                this.dataStart += (long)extra;
            }
        }
        long pos = this.dataStart;
        for (Variable var : vars) {
            vinfo = (N3headerNew.Vinfo)var.getSPobject();
            if (vinfo.isRecord) continue;
            this.raf.seek(vinfo.begin);
            if (largeFile) {
                this.raf.writeLong(pos);
            } else {
                if (pos > Integer.MAX_VALUE) {
                    throw new IllegalArgumentException("Variable starting pos=" + pos + " may not exceed " + Integer.MAX_VALUE);
                }
                this.raf.writeInt((int)pos);
            }
            vinfo.begin = pos;
            if (fout != null) {
                fout.format("  %s begin at = %d end= %d%n", var.getFullName(), vinfo.begin, vinfo.begin + vinfo.vsize);
            }
            pos += vinfo.vsize;
            this.nonRecordDataSize = Math.max(this.nonRecordDataSize, vinfo.begin + vinfo.vsize);
        }
        this.recStart = pos;
        for (Variable var : vars) {
            vinfo = (N3headerNew.Vinfo)var.getSPobject();
            if (!vinfo.isRecord) continue;
            this.raf.seek(vinfo.begin);
            if (largeFile) {
                this.raf.writeLong(pos);
            } else {
                this.raf.writeInt((int)pos);
            }
            vinfo.begin = pos;
            if (fout != null) {
                fout.format(" %s record begin at = %d%n", var.getFullName(), this.dataStart);
            }
            pos += vinfo.vsize;
            this.recsize += vinfo.vsize;
            this.recStart = Math.min(this.recStart, vinfo.begin);
        }
        if (this.nonRecordDataSize > 0L) {
            this.nonRecordDataSize -= this.dataStart;
        }
        if (this.uvars.isEmpty()) {
            this.recStart = 0L;
        }
    }

    int sizeHeader(boolean largeFile) {
        int size = 4;
        size += 4;
        size += 8;
        for (Dimension dim : this.ncfile.getRootGroup().getDimensions()) {
            size += this.sizeString(dim.getShortName()) + 4;
        }
        size += this.sizeAtts(this.ncfile.getGlobalAttributes());
        size += 8;
        for (Variable var : this.ncfile.getVariables()) {
            size += this.sizeString(var.getShortName());
            size += 4;
            size += 4 * ((AbstractCollection)((Object)var.getDimensions())).size();
            size += this.sizeAtts(var.attributes());
            size += 8;
            size += largeFile ? 8 : 4;
        }
        return size;
    }

    private void writeAtts(Iterable<Attribute> atts, Formatter fout) throws IOException {
        List attributesToWrite = StreamSupport.stream(atts.spliterator(), false).filter(att -> !CDM.isspecial(att)).collect(Collectors.toList());
        int n = Iterables.size(attributesToWrite);
        if (n == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(12);
            this.raf.writeInt(n);
        }
        int count = 0;
        for (Attribute att2 : attributesToWrite) {
            if (fout != null) {
                fout.format("***att %d pos= %d%n", count, this.raf.getFilePointer());
            }
            this.writeString(att2.getShortName());
            int type = N3headerWriter.getType(att2.getDataType());
            this.raf.writeInt(type);
            if (type == 2) {
                this.writeStringValues(att2);
            } else {
                int nelems = att2.getLength();
                this.raf.writeInt(nelems);
                int nbytes = 0;
                for (int j = 0; j < nelems; ++j) {
                    nbytes += this.writeAttributeValue(att2.getNumericValue(j));
                }
                this.pad(nbytes, (byte)0);
                if (fout != null) {
                    fout.format(" end write val pos= %d%n", this.raf.getFilePointer());
                }
            }
            if (fout == null) continue;
            fout.format("  %s%n", att2);
        }
    }

    private int sizeAtts(Iterable<Attribute> atts) {
        int size = 8;
        for (Attribute att : atts) {
            size += this.sizeString(att.getShortName());
            size += 4;
            int type = N3headerWriter.getType(att.getDataType());
            if (type == 2) {
                size += this.sizeStringValues(att);
                continue;
            }
            size += 4;
            int nelems = att.getLength();
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.sizeAttributeValue(att.getNumericValue(j));
            }
            size += nbytes;
            size += N3headerWriter.padding(nbytes);
        }
        return size;
    }

    private void writeStringValues(Attribute att) throws IOException {
        int n = att.getLength();
        if (n == 1) {
            this.writeString(att.getStringValue());
        } else {
            StringBuilder values = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                values.append(att.getStringValue(i));
            }
            this.writeString(values.toString());
        }
    }

    private int sizeStringValues(Attribute att) {
        int size = 0;
        int n = att.getLength();
        if (n == 1) {
            size += this.sizeString(att.getStringValue());
        } else {
            StringBuilder values = new StringBuilder();
            for (int i = 0; i < n; ++i) {
                values.append(att.getStringValue(i));
            }
            size += this.sizeString(values.toString());
        }
        return size;
    }

    private int writeAttributeValue(Number numValue) throws IOException {
        if (numValue instanceof Byte) {
            this.raf.write(numValue.byteValue());
            return 1;
        }
        if (numValue instanceof Short) {
            this.raf.writeShort(numValue.shortValue());
            return 2;
        }
        if (numValue instanceof Integer) {
            this.raf.writeInt(numValue.intValue());
            return 4;
        }
        if (numValue instanceof Float) {
            this.raf.writeFloat(numValue.floatValue());
            return 4;
        }
        if (numValue instanceof Double) {
            this.raf.writeDouble(numValue.doubleValue());
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    private int sizeAttributeValue(Number numValue) {
        if (numValue instanceof Byte) {
            return 1;
        }
        if (numValue instanceof Short) {
            return 2;
        }
        if (numValue instanceof Integer) {
            return 4;
        }
        if (numValue instanceof Float) {
            return 4;
        }
        if (numValue instanceof Double) {
            return 8;
        }
        throw new IllegalStateException("unknown attribute type == " + numValue.getClass().getName());
    }

    private void writeVars(List<Variable> vars, boolean largeFile, Formatter fout) throws IOException {
        int n = vars.size();
        if (n == 0) {
            this.raf.writeInt(0);
            this.raf.writeInt(0);
        } else {
            this.raf.writeInt(11);
            this.raf.writeInt(n);
        }
        for (Variable var : vars) {
            this.writeString(var.getShortName());
            long vsize = var.getDataType().getSize();
            List dims = var.getDimensions();
            this.raf.writeInt(dims.size());
            for (Dimension dim : dims) {
                int dimIndex = this.findDimensionIndex(this.ncfile, dim);
                this.raf.writeInt(dimIndex);
                if (dim.isUnlimited()) continue;
                vsize *= (long)dim.getLength();
            }
            long unpaddedVsize = vsize;
            vsize += (long)N3headerWriter.padding(vsize);
            long varAttsPos = this.raf.getFilePointer();
            this.writeAtts(var.attributes(), fout);
            DataType dtype = var.getDataType();
            int type = N3headerWriter.getType(dtype);
            this.raf.writeInt(type);
            int vsizeWrite = vsize < 0xFFFFFFFFL ? (int)vsize : -1;
            this.raf.writeInt(vsizeWrite);
            long pos = this.raf.getFilePointer();
            if (largeFile) {
                this.raf.writeLong(0L);
            } else {
                this.raf.writeInt(0);
            }
            if (this.uvars.size() == 1 && this.uvars.get(0) == var && (dtype == DataType.CHAR || dtype == DataType.BYTE || dtype == DataType.SHORT)) {
                vsize = unpaddedVsize;
            }
            var.setSPobject(new N3headerNew.Vinfo(var.getShortName(), vsize, pos, var.isUnlimited(), varAttsPos));
        }
    }

    private void writeString(String s2) throws IOException {
        byte[] b = s2.getBytes(StandardCharsets.UTF_8);
        this.raf.writeInt(b.length);
        this.raf.write(b);
        this.pad(b.length, (byte)0);
    }

    private int sizeString(String s2) {
        int size = s2.length() + 4;
        return size + N3headerWriter.padding(s2.length());
    }

    private int findDimensionIndex(NetcdfFile ncfile, Dimension wantDim) {
        List<Dimension> dims = ncfile.getRootGroup().getDimensions();
        for (int i = 0; i < dims.size(); ++i) {
            Dimension dim = dims.get(i);
            if (!dim.equals(wantDim)) continue;
            return i;
        }
        throw new IllegalStateException("unknown Dimension == " + wantDim);
    }

    private void pad(int nbytes, byte fill) throws IOException {
        int pad = N3headerWriter.padding(nbytes);
        for (int i = 0; i < pad; ++i) {
            this.raf.write(fill);
        }
    }

    void writeNumrecs() throws IOException {
        this.raf.seek(4L);
        this.raf.writeInt(this.numrecs);
    }

    void initFromExisting(N3iospNew existingIosp) {
        N3headerNew existingHeader = existingIosp.header;
        this.dataStart = existingHeader.dataStart;
        this.nonRecordDataSize = existingHeader.nonRecordDataSize;
        this.numrecs = existingHeader.numrecs;
        this.recsize = existingHeader.recsize;
        this.recStart = existingHeader.recStart;
        this.useLongOffset = existingHeader.useLongOffset;
        this.udim = existingHeader.udim;
    }

    void setNumrecs(int n) {
        this.numrecs = n;
    }

    synchronized boolean synchNumrecs() throws IOException {
        int n = this.raf.readIntUnbuffered(4L);
        if (n == this.numrecs) {
            return false;
        }
        if (n < 0) {
            return false;
        }
        this.numrecs = n;
        this.udim.setLength(this.numrecs);
        for (Variable uvar : this.uvars) {
            uvar.resetShape();
            uvar.invalidateCache();
        }
        return true;
    }

    void updateAttribute(Variable v2, Attribute att) throws IOException {
        long pos;
        if (v2 == null) {
            pos = this.findAtt(this.globalAttsPos, att.getShortName());
        } else {
            N3headerNew.Vinfo vinfo = (N3headerNew.Vinfo)v2.getSPobject();
            pos = this.findAtt(vinfo.attsPos, att.getShortName());
        }
        this.raf.seek(pos);
        int type = this.raf.readInt();
        DataType have = N3headerWriter.getDataType(type);
        DataType want = att.getDataType();
        if (want == DataType.STRING) {
            want = DataType.CHAR;
        }
        if (want != have) {
            throw new IllegalArgumentException("Update Attribute must have same type or original = " + (Object)((Object)have) + " att = " + att);
        }
        if (type == 2) {
            String s2 = att.getStringValue();
            int org = this.raf.readInt();
            int size = org + N3headerWriter.padding(org);
            int max = Math.min(size, s2.length());
            if (max > org) {
                this.raf.seek(pos + 4L);
                this.raf.writeInt(max);
            }
            byte[] b = new byte[size];
            for (int i = 0; i < max; ++i) {
                b[i] = (byte)s2.charAt(i);
            }
            this.raf.write(b);
        } else {
            int nelems = this.raf.readInt();
            int max = Math.min(nelems, att.getLength());
            for (int j = 0; j < max; ++j) {
                this.writeAttributeValue(att.getNumericValue(j));
            }
        }
    }

    private long findAtt(long start_pos, String want) throws IOException {
        this.raf.seek(start_pos + 4L);
        int natts = this.raf.readInt();
        for (int i = 0; i < natts; ++i) {
            String name = this.readString();
            if (name.equals(want)) {
                return this.raf.getFilePointer();
            }
            int type = this.raf.readInt();
            if (type == 2) {
                this.readString();
                continue;
            }
            int nelems = this.raf.readInt();
            DataType dtype = N3headerWriter.getDataType(type);
            int[] shape = new int[]{nelems};
            Array arr = Array.factory(dtype, shape);
            IndexIterator ii = arr.getIndexIterator();
            int nbytes = 0;
            for (int j = 0; j < nelems; ++j) {
                nbytes += this.readAttributeValue(dtype, ii);
            }
            this.skip(nbytes);
        }
        throw new IllegalArgumentException("no such attribute " + want);
    }
}

