/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.lang.reflect.Method;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import loci.common.Location;
import loci.common.services.ServiceFactory;
import loci.formats.FormatException;
import loci.formats.FormatTools;
import loci.formats.in.FakeReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.formats.tools.FakeImage;
import ome.units.UNITS;
import ome.units.quantity.Length;
import ome.units.quantity.Time;
import ome.xml.model.primitives.Timestamp;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FakeReaderTest {
    private Path wd;
    private FakeReader reader;
    private OMEXMLService service;
    private MetadataRetrieve m;

    @DataProvider(name="physical sizes")
    public Object[][] physicalSizes() {
        return new Object[][]{{"1", new Length((Number)1.0, UNITS.MICROMETER)}, {"1.0", new Length((Number)1.0, UNITS.MICROMETER)}, {"1mm", new Length((Number)1.0, UNITS.MILLIMETER)}, {"1.0mm", new Length((Number)1.0, UNITS.MILLIMETER)}, {"1.0 mm", new Length((Number)1.0, UNITS.MILLIMETER)}, {"1.0\u00c5", new Length((Number)1.0, UNITS.ANGSTROM)}, {"1.0 pixel", new Length((Number)1.0, UNITS.PIXEL)}, {"1.0 reference frame", new Length((Number)1.0, UNITS.REFERENCEFRAME)}};
    }

    @DataProvider(name="invalid physical sizes")
    public Object[][] invalidPhysicalSizes() {
        return new Object[][]{{"0"}, {"0.0"}, {"-0.1"}, {"0mm"}, {"-1m"}};
    }

    @DataProvider(name="annotations")
    public Object[][] annotations() {
        return new Object[][]{{"annBool", "getBooleanAnnotationCount"}, {"annComment", "getCommentAnnotationCount"}, {"annDouble", "getDoubleAnnotationCount"}, {"annLong", "getLongAnnotationCount"}, {"annMap", "getMapAnnotationCount"}, {"annTag", "getTagAnnotationCount"}, {"annTerm", "getTermAnnotationCount"}, {"annTime", "getTimestampAnnotationCount"}, {"annXml", "getXMLAnnotationCount"}};
    }

    @DataProvider(name="shapes")
    public Object[][] shapes() {
        return new Object[][]{{"ellipses", "Ellipse"}, {"labels", "Label"}, {"lines", "Line"}, {"masks", "Mask"}, {"points", "Point"}, {"polygons", "Polygon"}, {"polylines", "Polyline"}, {"rectangles", "Rectangle"}};
    }

    @DataProvider(name="acquisition dates")
    public Object[][] acquisitionDates() {
        return new Object[][]{{"2016-03-01_16-14-00", new Timestamp("2016-03-01T16:14:00")}, {"2016-03-01", null}};
    }

    @DataProvider(name="pixelFeatures")
    public Object[][] pixelFeatures() {
        Object[] pixelTypes = new Object[]{1, 0, 3, 2, 5, 4, 6, 7};
        Object[] little = new Object[]{false, true};
        Object[][] ret = new Object[pixelTypes.length * little.length][2];
        for (int i = 0; i < pixelTypes.length; ++i) {
            for (int j = 0; j < little.length; ++j) {
                int idx = little.length * i + j;
                ret[idx][0] = pixelTypes[i];
                ret[idx][1] = little[j];
            }
        }
        return ret;
    }

    private static Location mkSubd(Path parent, String name) throws Exception {
        return new Location(Files.createDirectory(parent.resolve(name), new FileAttribute[0]).toFile());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File mkIni(String basename, String ... lines) throws Exception {
        File fakeIni = this.wd.resolve(basename).toFile();
        try (PrintWriter pw = new PrintWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(fakeIni), "UTF-8"));){
            for (String l : lines) {
                pw.println(l);
            }
        }
        return fakeIni;
    }

    private void deleteTemporaryDirectoryOnExit(Location directoryRoot) {
        directoryRoot.deleteOnExit();
        Location[] children = directoryRoot.listFiles();
        if (children != null) {
            for (Location child : children) {
                if (child.isDirectory()) {
                    this.deleteTemporaryDirectoryOnExit(child);
                    continue;
                }
                child.deleteOnExit();
            }
        }
    }

    @BeforeMethod
    public void setUp() throws Exception {
        this.wd = Files.createTempDirectory(this.getClass().getName(), new FileAttribute[0]);
        this.reader = new FakeReader();
        ServiceFactory sf = new ServiceFactory();
        this.service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        this.reader.setMetadataStore((MetadataStore)this.service.createOMEXMLMetadata());
        this.reader.setFlattenedResolutions(false);
    }

    @AfterMethod
    public void tearDown() throws Exception {
        this.reader.close();
        this.deleteTemporaryDirectoryOnExit(new Location(this.wd.toFile()));
    }

    @Test
    public void testReopenFile() throws Exception {
        this.reader.setId("foo.fake");
        this.reader.reopenFile();
    }

    @Test
    public void testCompanionFile() throws Exception {
        Files.createFile(this.wd.resolve("foo.fake.ini"), new FileAttribute[0]);
        this.reader.setId(Files.createFile(this.wd.resolve("foo.fake"), new FileAttribute[0]).toString());
        Assert.assertEquals((int)2, (int)this.reader.getUsedFiles().length);
        Assert.assertEquals((int)2, (int)this.reader.getSeriesUsedFiles().length);
        Assert.assertEquals((int)2, (int)this.reader.getUsedFiles(false).length);
        Assert.assertEquals((int)2, (int)this.reader.getSeriesUsedFiles(false).length);
        Assert.assertEquals((int)1, (int)this.reader.getUsedFiles(true).length);
        Assert.assertEquals((int)1, (int)this.reader.getSeriesUsedFiles(true).length);
    }

    @Test
    public void testNoCompanionFile() throws Exception {
        this.reader.setId(Files.createFile(this.wd.resolve("foo.fake"), new FileAttribute[0]).toString());
        Assert.assertEquals((int)1, (int)this.reader.getUsedFiles().length);
        Assert.assertEquals((int)1, (int)this.reader.getSeriesUsedFiles().length);
        Assert.assertEquals((int)1, (int)this.reader.getUsedFiles(false).length);
        Assert.assertEquals((int)1, (int)this.reader.getSeriesUsedFiles(false).length);
        Assert.assertEquals((int)0, (int)this.reader.getUsedFiles(true).length);
        Assert.assertEquals((int)0, (int)this.reader.getSeriesUsedFiles(true).length);
    }

    @Test
    public void testDefaultValues() throws Exception {
        this.reader.setId("default.fake");
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals((int)this.reader.getSizeX(), (int)512);
        Assert.assertEquals((int)this.reader.getSizeY(), (int)512);
        Assert.assertEquals((int)this.reader.getSizeZ(), (int)1);
        Assert.assertEquals((int)this.reader.getSizeC(), (int)1);
        Assert.assertEquals((int)this.reader.getSizeT(), (int)1);
        Assert.assertEquals((int)this.reader.getPixelType(), (int)1);
        Assert.assertEquals((int)this.reader.getRGBChannelCount(), (int)1);
        Assert.assertEquals((String)this.reader.getDimensionOrder(), (String)"XYZCT");
        Assert.assertEquals((Object)this.m.getImageAcquisitionDate(0), null);
        Assert.assertEquals((Object)this.m.getPixelsPhysicalSizeX(0), null);
        Assert.assertEquals((Object)this.m.getPixelsPhysicalSizeY(0), null);
        Assert.assertEquals((Object)this.m.getPixelsPhysicalSizeZ(0), null);
        Assert.assertEquals((int)this.m.getROICount(), (int)0);
        Assert.assertEquals((int)this.m.getExperimentCount(), (int)0);
    }

    @Test
    public void testValuesFromFilename() throws Exception {
        int sizeX = 513;
        this.reader.setId(String.format("foo&sizeX=%d.fake", sizeX));
        Assert.assertEquals((int)this.reader.getSizeX(), (int)sizeX);
    }

    @Test
    public void testValuesFromIni() throws Exception {
        int sizeX = 513;
        this.mkIni("foo.fake.ini", String.format("sizeX = %d", sizeX));
        this.reader.setId(this.wd.resolve("foo.fake").toString());
        Assert.assertEquals((int)this.reader.getSizeX(), (int)sizeX);
    }

    @Test
    public void testOneWell() throws Exception {
        Location oneWell = new FakeImage(FakeReaderTest.mkSubd(this.wd, "1W.fake")).generateScreen(1, 1, 1, 1, 1);
        Assert.assertTrue((boolean)this.reader.isSingleFile(oneWell.getAbsolutePath()));
        Assert.assertTrue((boolean)this.reader.isThisType(oneWell.getAbsolutePath()));
        this.reader.setId(oneWell.getAbsolutePath());
        Assert.assertEquals((int)this.reader.getOmeXmlMetadata().getWellCount(0), (int)1);
        Assert.assertEquals((int)this.reader.getUsedFiles().length, (int)1);
        Assert.assertEquals((int)this.reader.getSeriesUsedFiles(false).length, (int)1);
        Assert.assertEquals((int)this.reader.getSeriesUsedFiles(true).length, (int)0);
    }

    @Test
    public void testTwoWells() throws Exception {
        Location twoWells = new FakeImage(FakeReaderTest.mkSubd(this.wd, "2W.fake")).generateScreen(1, 1, 1, 2, 1);
        Assert.assertFalse((boolean)this.reader.isSingleFile(twoWells.getAbsolutePath()));
        Assert.assertTrue((boolean)this.reader.isThisType(twoWells.getAbsolutePath()));
        this.reader.setId(twoWells.getAbsolutePath());
        Assert.assertEquals((int)this.reader.getOmeXmlMetadata().getWellCount(0), (int)2);
        Assert.assertEquals((int)this.reader.getUsedFiles().length, (int)2);
        Assert.assertEquals((int)this.reader.getSeriesUsedFiles(false).length, (int)2);
        Assert.assertEquals((int)this.reader.getSeriesUsedFiles(true).length, (int)0);
    }

    @Test
    public void testTwoFields() throws Exception {
        Location twoFields = new FakeImage(FakeReaderTest.mkSubd(this.wd, "2F.fake")).generateScreen(1, 1, 1, 1, 2);
        this.reader.setId(twoFields.getAbsolutePath());
        Assert.assertEquals((int)this.reader.getSeriesCount(), (int)2);
    }

    @Test
    public void testTwoPlates() throws Exception {
        Location twoPlates = new FakeImage(FakeReaderTest.mkSubd(this.wd, "2P.fake")).generateScreen(2, 2, 2, 2, 4);
        this.reader.setId(twoPlates.getAbsolutePath());
        OMEXMLMetadata metadata = this.reader.getOmeXmlMetadata();
        int i = this.reader.getImageCount();
        while (i >= 0) {
            Assert.assertEquals((int)metadata.getChannelCount(i--), (int)this.reader.getSizeC());
        }
    }

    @Test
    public void testMicrobeamINI() throws Exception {
        this.mkIni("foo.fake.ini", "plates=1\nwithMicrobeam = true");
        this.reader.setId(this.wd.resolve("foo.fake").toString());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals((int)this.m.getExperimentCount(), (int)1);
        Assert.assertEquals((int)this.m.getMicrobeamManipulationCount(0), (int)1);
        this.reader.close();
        this.mkIni("foo.fake.ini", "screens=2\nwithMicrobeam=true");
        this.reader.setId(this.wd.resolve("foo.fake").toString());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals((int)this.m.getExperimentCount(), (int)2);
        Assert.assertEquals((int)this.m.getMicrobeamManipulationCount(0), (int)1);
        Assert.assertEquals((int)this.m.getMicrobeamManipulationCount(1), (int)1);
        this.reader.close();
    }

    @Test
    public void testMicrobeam() throws Exception {
        this.reader.setId("foo&plates=1&withMicrobeam=true.fake");
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals((int)this.m.getExperimentCount(), (int)1);
        Assert.assertEquals((int)this.m.getMicrobeamManipulationCount(0), (int)1);
        this.reader.close();
        this.reader.setId("foo&screens=2&withMicrobeam=true.fake");
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals((int)this.m.getExperimentCount(), (int)2);
        Assert.assertEquals((int)this.m.getMicrobeamManipulationCount(0), (int)1);
        Assert.assertEquals((int)this.m.getMicrobeamManipulationCount(1), (int)1);
        this.reader.close();
        this.testDefaultValues();
    }

    @Test
    public void testExtraMetadata() throws Exception {
        File fakeIni = this.mkIni("foo.fake.ini", "[GlobalMetadata]", "foo=bar");
        this.reader.setId(fakeIni.getAbsolutePath());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals(this.reader.getGlobalMetadata().get("foo"), (Object)"bar");
    }

    @Test
    public void testPlaneMetadata() throws Exception {
        File fakeIni = this.mkIni("foo.fake.ini", "sizeC=2", "[series_0]", "ExposureTime_0=100.0", "ExposureTimeUnit_0=ms", "ExposureTime_1=50.0", "ExposureTimeUnit_1=ns", "PositionX_0=10.0", "PositionY_0=20.0", "PositionZ_0=30.0", "PositionXUnit_0=mm", "PositionYUnit_0=mm", "PositionZUnit_0=mm", "PositionX_1=5.0", "PositionY_1=10.0", "PositionZ_1=15.0", "PositionXUnit_1=nm", "PositionYUnit_1=nm", "PositionZUnit_1=nm");
        this.reader.setId(fakeIni.getAbsolutePath());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((Object)this.m.getPixelsSizeC(0).getNumberValue(), (Object)2);
        Assert.assertEquals((Object)this.m.getPlaneExposureTime(0, 0), (Object)new Time((Number)100.0, UNITS.MILLISECOND));
        Assert.assertEquals((Object)this.m.getPlaneExposureTime(0, 1), (Object)new Time((Number)50.0, UNITS.NANOSECOND));
        Assert.assertEquals((Object)this.m.getPlanePositionX(0, 0), (Object)new Length((Number)10.0, UNITS.MM));
        Assert.assertEquals((Object)this.m.getPlanePositionY(0, 0), (Object)new Length((Number)20.0, UNITS.MM));
        Assert.assertEquals((Object)this.m.getPlanePositionZ(0, 0), (Object)new Length((Number)30.0, UNITS.MM));
        Assert.assertEquals((Object)this.m.getPlanePositionX(0, 1), (Object)new Length((Number)5.0, UNITS.NM));
        Assert.assertEquals((Object)this.m.getPlanePositionY(0, 1), (Object)new Length((Number)10.0, UNITS.NM));
        Assert.assertEquals((Object)this.m.getPlanePositionZ(0, 1), (Object)new Length((Number)15.0, UNITS.NM));
    }

    @Test(dataProvider="physical sizes")
    public void testPhysicalSizeX(String value, Length length) throws Exception {
        String[] ids;
        File fakeIni = this.mkIni("foo.fake.ini", "physicalSizeX = " + value);
        for (String id : ids = new String[]{fakeIni.getAbsolutePath(), "foo&physicalSizeX=" + value + ".fake"}) {
            this.reader.setId(id);
            this.m = this.service.asRetrieve(this.reader.getMetadataStore());
            Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
            Assert.assertEquals((Object)this.m.getPixelsPhysicalSizeX(0), (Object)length);
            this.reader.close();
        }
        this.testDefaultValues();
    }

    @Test(dataProvider="physical sizes")
    public void testPhysicalSizeY(String value, Length length) throws Exception {
        String[] ids;
        File fakeIni = this.mkIni("foo.fake.ini", "physicalSizeY = " + value);
        for (String id : ids = new String[]{fakeIni.getAbsolutePath(), "foo&physicalSizeY=" + value + ".fake"}) {
            this.reader.setId(id);
            this.m = this.service.asRetrieve(this.reader.getMetadataStore());
            Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
            Assert.assertEquals((Object)this.m.getPixelsPhysicalSizeY(0), (Object)length);
            this.reader.close();
        }
        this.testDefaultValues();
    }

    @Test(dataProvider="physical sizes")
    public void testPhysicalSizeZ(String value, Length length) throws Exception {
        String[] ids;
        File fakeIni = this.mkIni("foo.fake.ini", "physicalSizeZ = " + value);
        for (String id : ids = new String[]{fakeIni.getAbsolutePath(), "foo&physicalSizeZ=" + value + ".fake"}) {
            this.reader.setId(id);
            this.m = this.service.asRetrieve(this.reader.getMetadataStore());
            Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
            Assert.assertEquals((Object)this.m.getPixelsPhysicalSizeZ(0), (Object)length);
            this.reader.close();
        }
        this.testDefaultValues();
    }

    @Test(dataProvider="invalid physical sizes")
    public void testInvalidPhysicalSize(String value) throws Exception {
        String[] ids;
        File fakeIni = this.mkIni("foo.fake.ini", "physicalSizeX = " + value);
        for (String id : ids = new String[]{fakeIni.getAbsolutePath(), "foo&physicalSizeX=" + value + ".fake"}) {
            this.reader.setId(id);
            this.m = this.service.asRetrieve(this.reader.getMetadataStore());
            Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
            Assert.assertEquals((Object)this.m.getPixelsPhysicalSizeX(0), null);
            this.reader.close();
        }
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testPhysicalSizeZBadParsing() throws Exception {
        this.reader.setId("foo&physicalSizeZ=1 1.fake");
    }

    @Test(expectedExceptions={RuntimeException.class})
    public void testPhysicalSizeZIniBadParsing() throws Exception {
        this.mkIni("foo.fake.ini", "physicalSizeZ = 1 1");
        this.reader.setId(this.wd.resolve("foo.fake").toString());
    }

    @Test(dataProvider="acquisition dates")
    public void testAcquisitionDate(String value, Timestamp date) throws Exception {
        this.reader.setId("foo&acquisitionDate=" + value + ".fake");
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals((Object)this.m.getImageAcquisitionDate(0), (Object)date);
        this.reader.close();
        this.testDefaultValues();
    }

    @Test(dataProvider="acquisition dates")
    public void testAcquisitionDateIni(String value, Timestamp date) throws Exception {
        this.mkIni("foo.fake.ini", "acquisitionDate = " + value);
        this.reader.setId(this.wd.resolve("foo.fake").toString());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals((Object)this.m.getImageAcquisitionDate(0), (Object)date);
        this.reader.close();
        this.testDefaultValues();
    }

    @Test(dataProvider="acquisition dates")
    public void testAcquisitionDateMultiSeries(String value, Timestamp date) throws Exception {
        this.reader.setId("foo&series=10&acquisitionDate=" + value + ".fake");
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)this.m.getImageAcquisitionDate(i), (Object)date);
        }
        this.reader.close();
        this.testDefaultValues();
    }

    @Test(dataProvider="annotations")
    public void testAnnotations(String key, String methodName) throws Exception {
        this.reader.setId("foo&series=5&" + key + "=10.fake");
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Method method = Class.forName("loci.formats.meta.MetadataRetrieve").getMethod(methodName, new Class[0]);
        Assert.assertEquals((Object)method.invoke((Object)this.m, new Object[0]), (Object)50);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((int)this.m.getImageAnnotationRefCount(0), (int)10);
        }
        this.reader.close();
        this.testDefaultValues();
    }

    @Test(dataProvider="annotations")
    public void testAnnotationsINI(String key, String methodName) throws Exception {
        this.mkIni("foo.fake.ini", "series = 5\n" + key + " = 10");
        this.reader.setId(this.wd.resolve("foo.fake").toString());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Method method = Class.forName("loci.formats.meta.MetadataRetrieve").getMethod(methodName, new Class[0]);
        Assert.assertEquals((Object)method.invoke((Object)this.m, new Object[0]), (Object)50);
        for (int i = 0; i < 5; ++i) {
            Assert.assertEquals((int)this.m.getImageAnnotationRefCount(0), (int)10);
        }
        this.reader.close();
        this.testDefaultValues();
    }

    private void checkROIs(MetadataRetrieve m, int nImages, int nRoisPerImage, String shapeType, int nOtherRois) throws Exception {
        int i;
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(m)));
        Assert.assertEquals((int)m.getImageCount(), (int)nImages);
        Assert.assertEquals((int)m.getROICount(), (int)(nImages * nRoisPerImage + nOtherRois));
        for (i = 0; i < m.getImageCount(); ++i) {
            Assert.assertEquals((int)m.getImageROIRefCount(0), (int)nRoisPerImage);
        }
        for (i = nOtherRois; i < m.getROICount(); ++i) {
            Assert.assertEquals((int)m.getShapeCount(i), (int)1);
            Assert.assertEquals((String)m.getShapeType(i, 0), (String)shapeType);
        }
    }

    @Test(dataProvider="shapes")
    public void testShapes(String key, String type) throws Exception {
        this.reader.setId("foo&series=5&" + key + "=10.fake");
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        this.checkROIs(this.m, 5, 10, type, 0);
        this.reader.close();
        this.reader.setId("foo&plateRows=10&plateCols=10&" + key + "=5&withMicrobeam=true.fake");
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        this.checkROIs(this.m, 100, 5, type, 1);
        this.reader.close();
        this.reader.setId("foo&plateRows=10&plateCols=10&" + key + "=5.fake");
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        this.checkROIs(this.m, 100, 5, type, 0);
        this.reader.close();
        this.reader.setId("foo&screens=2&plateRows=10&plateCols=10&" + key + "=5.fake");
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        this.checkROIs(this.m, 200, 5, type, 0);
        this.reader.close();
        this.testDefaultValues();
    }

    @Test(dataProvider="shapes")
    public void testShapesINI(String key, String type) throws Exception {
        this.mkIni("foo.fake.ini", "series = 5\n" + key + " = 10");
        this.reader.setId(this.wd.resolve("foo.fake").toString());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        this.checkROIs(this.m, 5, 10, type, 0);
        this.reader.close();
        this.mkIni("foo.fake.ini", "plateRows = 10\nplateCols = 10\n" + key + " = 5\nwithMicrobeam=true");
        this.reader.setId(this.wd.resolve("foo.fake").toString());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        this.checkROIs(this.m, 100, 5, type, 1);
        this.reader.close();
        this.mkIni("foo.fake.ini", "plateRows = 10\nplateCols = 10\n" + key + " = 5");
        this.reader.setId(this.wd.resolve("foo.fake").toString());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        this.checkROIs(this.m, 100, 5, type, 0);
        this.reader.close();
        this.mkIni("foo.fake.ini", "screens = 2\nplateRows = 10\nplateCols = 10\n" + key + " = 5");
        this.reader.setId(this.wd.resolve("foo.fake").toString());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        this.checkROIs(this.m, 200, 5, type, 0);
        this.reader.close();
        this.testDefaultValues();
    }

    @Test(dataProvider="pixelFeatures")
    public void testSpecialPixels(int pixelType, boolean little) throws Exception {
        String pt = FormatTools.getPixelTypeString((int)pixelType);
        int nSeries = 2;
        int sizeC = 3;
        int sizeZ = 4;
        int sizeT = 5;
        this.reader.setId(String.format("foo&pixelType=%s&series=%s&sizeZ=%s&sizeC=%s&sizeT=%s&little=%s.fake", pt, nSeries, sizeZ, sizeC, sizeT, little));
        this.reader.setSeries(1);
        int no = sizeC * sizeZ * sizeT - 1;
        byte[] plane = this.reader.openBytes(no);
        int[] exp = new int[]{1, no, sizeZ - 1, sizeC - 1, sizeT - 1};
        Assert.assertEquals((Object)FakeReader.readSpecialPixels((byte[])plane, (int)pixelType, (boolean)little), (Object)exp);
        if (pixelType == 1) {
            Assert.assertEquals((Object)FakeReader.readSpecialPixels((byte[])plane), (Object)exp);
        }
    }

    @Test
    public void testSpecialPixelsInterleaved() throws Exception {
        int nSeries = 2;
        int rgb = 3;
        int sizeC = 3;
        int effSizeC = sizeC / rgb;
        int sizeZ = 4;
        int sizeT = 5;
        this.reader.setId(String.format("foo&series=%s&sizeZ=%s&sizeC=%s&sizeT=%s&rgb=%d&interleaved=true.fake", nSeries, sizeZ, sizeC, sizeT, rgb));
        this.reader.setSeries(1);
        int no = effSizeC * sizeZ * sizeT - 1;
        byte[] plane = this.reader.openBytes(no);
        int[] exp = new int[]{1, no, sizeZ - 1, effSizeC - 1, sizeT - 1};
        Assert.assertEquals((Object)FakeReader.readSpecialPixels((byte[])plane, (int)1, (boolean)true, (int)rgb, (boolean)true), (Object)exp);
    }

    @Test
    public void testSpecialPixelsIndexed() throws Exception {
        int nSeries = 2;
        int sizeC = 3;
        int sizeZ = 4;
        int sizeT = 5;
        this.reader.setId(String.format("foo&series=%s&sizeZ=%s&sizeC=%s&sizeT=%s&indexed=true.fake", nSeries, sizeZ, sizeC, sizeT));
        this.reader.setSeries(1);
        int no = sizeC * sizeZ * sizeT - 1;
        byte[] plane = this.reader.openBytes(no);
        int[] exp = new int[]{1, no, sizeZ - 1, sizeC - 1, sizeT - 1};
        int[] indices = FakeReader.readSpecialPixels((byte[])plane);
        Assert.assertEquals((int)indices.length, (int)exp.length);
        int[] specialPixels = new int[indices.length];
        byte[][] lut = this.reader.get8BitLookupTable();
        for (int i = 0; i < indices.length; ++i) {
            specialPixels[i] = lut[0][indices[i]];
        }
        Assert.assertEquals((Object)specialPixels, (Object)exp);
    }

    @Test
    public void testPyramidDefaultScale() throws Exception {
        this.reader.setId("test&sizeX=10000&sizeY=10000&resolutions=4.fake");
        Assert.assertEquals((int)this.reader.getSeriesCount(), (int)1);
        Assert.assertEquals((int)this.reader.getResolutionCount(), (int)4);
        for (int i = 1; i < this.reader.getResolutionCount(); ++i) {
            int x = this.reader.getSizeX();
            int y = this.reader.getSizeY();
            this.reader.setResolution(i);
            Assert.assertEquals((int)(x / 2), (int)this.reader.getSizeX());
            Assert.assertEquals((int)(y / 2), (int)this.reader.getSizeY());
        }
    }

    @Test
    public void testPyramidValidScale() throws Exception {
        this.reader.setId("test&sizeX=10000&sizeY=10000&resolutions=3&resolutionScale=4.fake");
        Assert.assertEquals((int)this.reader.getSeriesCount(), (int)1);
        Assert.assertEquals((int)this.reader.getResolutionCount(), (int)3);
        for (int i = 1; i < this.reader.getResolutionCount(); ++i) {
            int x = this.reader.getSizeX();
            int y = this.reader.getSizeY();
            this.reader.setResolution(i);
            Assert.assertEquals((int)(x / 4), (int)this.reader.getSizeX());
            Assert.assertEquals((int)(y / 4), (int)this.reader.getSizeY());
        }
    }

    @Test(expectedExceptions={FormatException.class})
    public void testPyramidInvalidScale() throws Exception {
        this.reader.setId("test&sizeX=10000&sizeY=10000&resolutions=4&resolutionScale=0.fake");
    }

    @Test(expectedExceptions={FormatException.class})
    public void testPyramidInvalidResolutions() throws Exception {
        this.reader.setId("test&sizeX=10000&sizeY=10000&resolutions=0.fake");
    }

    @Test
    public void testPyramidNoResolutions() throws Exception {
        this.reader.setId("test&sizeX=10000&sizeY=10000&resolutions=1.fake");
        Assert.assertEquals((int)this.reader.getSeriesCount(), (int)1);
        Assert.assertEquals((int)this.reader.getResolutionCount(), (int)1);
    }

    @Test
    public void testValidDimensionOrders() throws Exception {
        this.reader.setId("test&sizeC=3&rgb=3.fake");
        Assert.assertEquals((String)this.reader.getDimensionOrder(), (String)"XYCZT");
        this.reader.setId("test&sizeC=3&rgb=1.fake");
        Assert.assertEquals((String)this.reader.getDimensionOrder(), (String)"XYZCT");
        this.reader.setId("test&dimOrder=XYZTC.fake");
        Assert.assertEquals((String)this.reader.getDimensionOrder(), (String)"XYZTC");
        this.reader.setId("test&sizeC=3&rgb=3&dimOrder=XYCTZ.fake");
        Assert.assertEquals((String)this.reader.getDimensionOrder(), (String)"XYCTZ");
        this.reader.setId("test&sizeC=3&rgb=3&dimOrder=XYZTC.fake");
        Assert.assertEquals((String)this.reader.getDimensionOrder(), (String)"XYCZT");
    }

    @Test(expectedExceptions={FormatException.class})
    public void testInvalidDimensionOrder() throws Exception {
        this.reader.setId("test&dimOrder=CXYZT.fake");
    }

    @Test
    public void testExcitationWavelengths() throws Exception {
        File fakeIni = this.mkIni("excitationWavelengths.fake.ini", "sizeC=5", "excitation_0 = 502nm", "excitation_1 = 502.0nm", "excitation_2 = 502", "excitation_4 = 5020\u00c5");
        this.reader.setId(this.wd.resolve("excitationWavelengths.fake").toString());
        Assert.assertEquals((int)this.reader.getSizeC(), (int)5);
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(0, 0), (Object)new Length((Number)502.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(0, 1), (Object)new Length((Number)502.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(0, 2), (Object)new Length((Number)502.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(0, 3), null);
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(0, 4), (Object)new Length((Number)5020.0, UNITS.ANGSTROM));
        this.reader.close();
    }

    @Test
    public void testEmissionWavelengths() throws Exception {
        File fakeIni = this.mkIni("emissionWavelengths.fake.ini", "sizeC=5", "emission_0 = 502nm", "emission_1 = 502.0nm", "emission_2 = 502", "emission_4 = 5020\u00c5");
        this.reader.setId(this.wd.resolve("emissionWavelengths.fake").toString());
        Assert.assertEquals((int)this.reader.getSizeC(), (int)5);
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(0, 0), (Object)new Length((Number)502.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(0, 1), (Object)new Length((Number)502.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(0, 2), (Object)new Length((Number)502.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(0, 3), null);
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(0, 4), (Object)new Length((Number)5020.0, UNITS.ANGSTROM));
        this.reader.close();
    }

    @Test
    public void testWavelengthSeries() throws Exception {
        File fakeIni = this.mkIni("multiseries_wavelengths.fake.ini", "series=2", "sizeC=2", "[series_0]", "ChannelExcitationWavelength_0=340.0nm", "ChannelEmissionWavelength_0=450.0nm", "ChannelExcitationWavelength_1=470.0nm", "ChannelEmissionWavelength_1=512.0nm", "[series_1]", "ChannelExcitationWavelength_0=350.0nm", "ChannelEmissionWavelength_0=425.0nm", "ChannelExcitationWavelength_1=500.0nm", "ChannelEmissionWavelength_1=580.0nm");
        this.reader.setId(fakeIni.getAbsolutePath());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(0, 0), (Object)new Length((Number)340.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(0, 0), (Object)new Length((Number)450.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(0, 1), (Object)new Length((Number)470.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(0, 1), (Object)new Length((Number)512.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(1, 0), (Object)new Length((Number)350.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(1, 0), (Object)new Length((Number)425.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(1, 1), (Object)new Length((Number)500.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(1, 1), (Object)new Length((Number)580.0, UNITS.NANOMETER));
    }

    @Test
    public void testWavelengthSeriesOverride() throws Exception {
        File fakeIni = this.mkIni("multiseries_wavelengths.fake.ini", "series=2", "sizeC=2", "excitation_0=340nm", "emission_0=450nm", "excitation_1=470nm", "emission_1=512nm", "[series_0]", "[series_1]", "ChannelExcitationWavelength_0=350.0nm", "ChannelEmissionWavelength_0=425.0nm", "ChannelExcitationWavelength_1=500.0nm", "ChannelEmissionWavelength_1=580.0nm");
        this.reader.setId(fakeIni.getAbsolutePath());
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(0, 0), (Object)new Length((Number)340.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(0, 0), (Object)new Length((Number)450.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(0, 1), (Object)new Length((Number)470.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(0, 1), (Object)new Length((Number)512.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(1, 0), (Object)new Length((Number)350.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(1, 0), (Object)new Length((Number)425.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelExcitationWavelength(1, 1), (Object)new Length((Number)500.0, UNITS.NANOMETER));
        Assert.assertEquals((Object)this.m.getChannelEmissionWavelength(1, 1), (Object)new Length((Number)580.0, UNITS.NANOMETER));
    }

    @DataProvider(name="instruments")
    public Object[][] intruments() {
        return new Object[][]{{"test&withInstrument=true.fake", 1, 1}, {"test&withInstrument=true&series=3.fake", 3, 1}, {"test&sizeC=5&withInstrument=true.fake", 1, 5}, {"test&plates=1&plateRows=2&plateCols=2.fake", 4, 1}, {"test&plates=1&plateRows=2&plateCols=2&sizeC=4.fake", 4, 4}};
    }

    @Test(dataProvider="intruments")
    public void testInstrument(String id, int imageCount, int channelCount) throws Exception {
        this.reader.setId(id);
        this.m = this.service.asRetrieve(this.reader.getMetadataStore());
        Assert.assertTrue((boolean)this.service.validateOMEXML(this.service.getOMEXML(this.m)));
        Assert.assertEquals((int)this.m.getDetectorCount(0), (int)1);
        Assert.assertEquals((int)this.m.getDichroicCount(0), (int)1);
        Assert.assertEquals((int)this.m.getFilterCount(0), (int)2);
        Assert.assertEquals((int)this.m.getFilterSetCount(0), (int)1);
        Assert.assertEquals((int)this.m.getImageCount(), (int)imageCount);
        Assert.assertEquals((int)this.m.getInstrumentCount(), (int)1);
        Assert.assertEquals((int)this.m.getLightSourceCount(0), (int)5);
        Assert.assertEquals((int)this.m.getObjectiveCount(0), (int)1);
        for (int i = 0; i < imageCount; ++i) {
            Assert.assertEquals((String)this.m.getImageInstrumentRef(i), (String)this.m.getInstrumentID(0));
            Assert.assertEquals((String)this.m.getObjectiveSettingsID(i), (String)this.m.getObjectiveID(0, 0));
            for (int c = 0; c < channelCount; ++c) {
                Assert.assertEquals((int)this.m.getChannelCount(i), (int)channelCount);
                Assert.assertEquals((String)this.m.getChannelFilterSetRef(i, c), (String)this.m.getFilterSetID(0, 0));
                switch (c % 5) {
                    case 0: {
                        Assert.assertEquals((String)this.m.getChannelLightSourceSettingsID(i, c), (String)this.m.getLaserID(0, 0));
                        break;
                    }
                    case 1: {
                        Assert.assertEquals((String)this.m.getChannelLightSourceSettingsID(i, c), (String)this.m.getArcID(0, 1));
                        break;
                    }
                    case 2: {
                        Assert.assertEquals((String)this.m.getChannelLightSourceSettingsID(i, c), (String)this.m.getFilamentID(0, 2));
                        break;
                    }
                    case 3: {
                        Assert.assertEquals((String)this.m.getChannelLightSourceSettingsID(i, c), (String)this.m.getLightEmittingDiodeID(0, 3));
                        break;
                    }
                    case 4: {
                        Assert.assertEquals((String)this.m.getChannelLightSourceSettingsID(i, c), (String)this.m.getLaserID(0, 4));
                    }
                }
                Assert.assertEquals((String)this.m.getLightPathDichroicRef(i, c), (String)this.m.getDichroicID(0, 0));
                Assert.assertEquals((int)this.m.getLightPathEmissionFilterRefCount(i, c), (int)1);
                Assert.assertEquals((String)this.m.getLightPathEmissionFilterRef(i, c, 0), (String)this.m.getFilterID(0, 0));
                Assert.assertEquals((int)this.m.getLightPathExcitationFilterRefCount(i, c), (int)1);
                Assert.assertEquals((String)this.m.getLightPathExcitationFilterRef(i, c, 0), (String)this.m.getFilterID(0, 1));
            }
        }
    }
}

