/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests;

import java.math.BigInteger;
import loci.formats.FilePatternBlock;
import loci.formats.IllegalBlockException;
import org.testng.AssertJUnit;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class FilePatternBlockTest {
    @DataProvider(name="range")
    public Object[][] rangeBlocks() {
        return new Object[][]{{"<0-2>", new String[]{"0", "1", "2"}, true, true}, {"<9-11>", new String[]{"9", "10", "11"}, false, true}, {"<09-11>", new String[]{"09", "10", "11"}, true, true}, {"<1-5:2>", new String[]{"1", "3", "5"}, true, true}, {"<A-C>", new String[]{"A", "B", "C"}, true, false}, {"<A-E:2>", new String[]{"A", "C", "E"}, true, false}, {"<X-Z>", new String[]{"X", "Y", "Z"}, true, false}, {"<V-Z:2>", new String[]{"V", "X", "Z"}, true, false}, {"<a-c>", new String[]{"a", "b", "c"}, true, false}, {"<a-e:2>", new String[]{"a", "c", "e"}, true, false}, {"<x-z>", new String[]{"x", "y", "z"}, true, false}, {"<v-z:2>", new String[]{"v", "x", "z"}, true, false}};
    }

    @DataProvider(name="commasep")
    public Object[][] commaSepBlocks() {
        return new Object[][]{{"<1,3,6>", new String[]{"1", "3", "6"}, true, true}, {"<01,03,11>", new String[]{"01", "03", "11"}, true, true}, {"<1,3,11>", new String[]{"1", "3", "11"}, false, true}, {"<R,G,B>", new String[]{"R", "G", "B"}, true, false}, {"<Cy3,DAPI>", new String[]{"Cy3", "DAPI"}, false, false}, {"<Cy3-B,DAPI>", new String[]{"Cy3-B", "DAPI"}, false, false}, {"<Cy3>", new String[]{"Cy3"}, true, false}, {"<9>", new String[]{"9"}, true, true}, {"<Z>", new String[]{"Z"}, true, false}, {"<z>", new String[]{"z"}, true, false}, {"<>", new String[]{""}, true, false}};
    }

    @DataProvider(name="invalid")
    public Object[][] invalidBlocks() {
        return new Object[][]{{""}, {"<"}, {">"}, {"9"}, {"<9"}, {"9>"}, {"<!-A>"}, {"<A-~>"}, {"<A-C:!>"}};
    }

    private void commonChecks(String pattern, String[] elements, boolean fixed, boolean numeric) {
        FilePatternBlock block = new FilePatternBlock(pattern);
        String[] blkElements = block.getElements();
        AssertJUnit.assertEquals((int)blkElements.length, (int)elements.length);
        for (int i = 0; i < blkElements.length; ++i) {
            AssertJUnit.assertEquals((String)blkElements[i], (String)elements[i]);
        }
        AssertJUnit.assertEquals((String)block.getBlock(), (String)pattern);
        AssertJUnit.assertEquals((boolean)block.isFixed(), (boolean)fixed);
        AssertJUnit.assertEquals((boolean)block.isNumeric(), (boolean)numeric);
    }

    private void rangeChecks(String pattern, String[] elements, boolean numeric) {
        BigInteger step;
        FilePatternBlock block = new FilePatternBlock(pattern);
        int radix = numeric ? 10 : 36;
        BigInteger first = new BigInteger(elements[0], radix);
        BigInteger last = new BigInteger(elements[elements.length - 1], radix);
        try {
            step = new BigInteger(elements[1], radix).subtract(first);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            step = new BigInteger("1");
        }
        AssertJUnit.assertTrue((boolean)block.getFirst().equals(first));
        AssertJUnit.assertTrue((boolean)block.getLast().equals(last));
        AssertJUnit.assertTrue((boolean)block.getStep().equals(step));
    }

    private void commaSepChecks(String pattern) {
        FilePatternBlock block = new FilePatternBlock(pattern);
        AssertJUnit.assertNull((Object)block.getFirst());
        AssertJUnit.assertNull((Object)block.getLast());
        AssertJUnit.assertNull((Object)block.getStep());
    }

    @Test(dataProvider="range")
    public void testRange(String pattern, String[] elements, boolean fixed, boolean numeric) {
        this.commonChecks(pattern, elements, fixed, numeric);
        this.rangeChecks(pattern, elements, numeric);
    }

    @Test(dataProvider="commasep")
    public void testCommaSep(String pattern, String[] elements, boolean fixed, boolean numeric) {
        this.commonChecks(pattern, elements, fixed, numeric);
        this.commaSepChecks(pattern);
    }

    @Test(dataProvider="invalid", expectedExceptions={IllegalBlockException.class})
    public void testInvalidBlocks(String pattern) {
        FilePatternBlock block = new FilePatternBlock(pattern);
    }
}

