/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.math.BigInteger;
import loci.formats.IllegalBlockException;

public class FilePatternBlock {
    public static final String BLOCK_START = "<";
    public static final String BLOCK_END = ">";
    private String[] elements;
    private boolean fixed;
    private boolean numeric;
    private int zeroes;
    private String block;
    private BigInteger begin = null;
    private BigInteger end = null;
    private BigInteger step = null;

    public FilePatternBlock(String block) {
        this.block = block;
        this.explode();
    }

    public String[] getElements() {
        return this.elements;
    }

    public String getBlock() {
        return this.block;
    }

    public boolean isFixed() {
        return this.fixed;
    }

    public boolean isNumeric() {
        return this.numeric;
    }

    public BigInteger getFirst() {
        return this.begin;
    }

    public BigInteger getLast() {
        return this.end;
    }

    public BigInteger getStep() {
        return this.step;
    }

    private void throwBadBlock(String msgTemplate) {
        throw new IllegalBlockException(String.format(msgTemplate, this.block));
    }

    private void throwBadBlock(String msgTemplate, Throwable cause) {
        throw new IllegalBlockException(String.format(msgTemplate, this.block), cause);
    }

    private void setNumeric() {
        this.numeric = true;
        for (String s : this.elements) {
            try {
                new BigInteger(s);
            }
            catch (NumberFormatException e) {
                this.numeric = false;
                break;
            }
        }
    }

    private void setFixed() {
        this.fixed = true;
        int L = this.elements[0].length();
        for (int i = 1; i < this.elements.length; ++i) {
            if (this.elements[i].length() == L) continue;
            this.fixed = false;
            break;
        }
    }

    private void explode() {
        if (!this.block.startsWith(BLOCK_START) || !this.block.endsWith(BLOCK_END)) {
            this.throwBadBlock("\"%s\": missing block delimiter(s)");
        }
        String trimmed = this.block.substring(BLOCK_START.length(), this.block.length() - BLOCK_END.length());
        this.elements = trimmed.split(",", -1);
        if (this.elements.length > 1) {
            this.setNumeric();
            this.setFixed();
            return;
        }
        this.elements = this.elements[0].split("-");
        if (this.elements.length < 2) {
            this.setNumeric();
            this.fixed = true;
            return;
        }
        String b = this.elements[0];
        this.elements = this.elements[1].split(":", -1);
        String e = this.elements[0];
        String s = this.elements.length < 2 ? "1" : this.elements[1];
        this.numeric = true;
        try {
            this.begin = new BigInteger(b);
            this.end = new BigInteger(e);
            this.step = new BigInteger(s);
        }
        catch (NumberFormatException badN) {
            this.numeric = false;
            try {
                this.begin = new BigInteger(b, 36);
                this.end = new BigInteger(e, 36);
                this.step = new BigInteger(s, 36);
            }
            catch (NumberFormatException badL) {
                this.throwBadBlock("invalid range delimiter(s)", badL);
            }
        }
        this.fixed = b.length() == e.length();
        this.zeroes = 0;
        this.zeroes = 0;
        while (this.zeroes < e.length() && e.charAt(this.zeroes) == '0') {
            ++this.zeroes;
        }
        int count = this.end.subtract(this.begin).divide(this.step).intValue() + 1;
        this.elements = new String[count];
        for (int i = 0; i < count; ++i) {
            String value;
            BigInteger v = this.begin.add(this.step.multiply(BigInteger.valueOf(i)));
            String string = value = this.numeric ? v.toString() : v.toString(36);
            if (!this.numeric) {
                value = Character.isLowerCase(b.charAt(0)) ? value.toLowerCase() : value.toUpperCase();
            }
            int padChars = this.fixed ? e.length() - value.length() : 0;
            this.elements[i] = value;
            for (int j = 0; j < padChars; ++j) {
                this.elements[i] = "0" + this.elements[i];
            }
        }
    }
}

