/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataA;
import ucar.ma2.StructureMembers;
import ucar.nc2.Sequence;
import ucar.nc2.Structure;
import ucar.nc2.Variable;

public class ArrayStructureMA
extends ArrayStructure {
    public ArrayStructureMA(StructureMembers members, int[] shape) {
        super(members, shape);
    }

    public ArrayStructureMA(StructureMembers members, int[] shape, StructureData[] sdata) {
        super(members, shape);
        if (this.nelems != sdata.length) {
            throw new IllegalArgumentException("StructureData length= " + sdata.length + "!= shape.length=" + this.nelems);
        }
        this.sdata = sdata;
    }

    public static ArrayStructureMA factoryMA(ArrayStructure from) throws IOException {
        if (from instanceof ArrayStructureMA) {
            return (ArrayStructureMA)from;
        }
        if (from.getSize() > 0L) {
            ArrayStructureMA to = new ArrayStructureMA(new StructureMembers(from.getStructureMembers()), from.getShape());
            for (StructureMembers.Member m4 : from.getMembers()) {
                to.setMemberArray(m4.getName(), from.extractMemberArray(m4));
            }
            return to;
        }
        int numRecords = -1;
        LinkedHashMap<String, Array> memberArrayMap = new LinkedHashMap<String, Array>();
        for (StructureMembers.Member m5 : from.getMembers()) {
            Array array = from.extractMemberArray(m5);
            assert (array.getSize() > 0L) : "array's size should have been computed in extractMemberArray().";
            int firstDimLen = array.getShape()[0];
            if (numRecords == -1) {
                numRecords = firstDimLen;
            } else assert (numRecords == firstDimLen) : String.format("Expected all structure members to have the same firstdimension length, but %d != %d.", numRecords, firstDimLen);
            memberArrayMap.put(m5.getName(), array);
        }
        int[] shape = numRecords == -1 ? new int[]{0} : new int[]{numRecords};
        ArrayStructureMA to = new ArrayStructureMA(new StructureMembers(from.getStructureMembers()), shape);
        for (Map.Entry entry : memberArrayMap.entrySet()) {
            to.setMemberArray((String)entry.getKey(), (Array)entry.getValue());
        }
        return to;
    }

    @Override
    protected StructureData makeStructureData(ArrayStructure as, int index) {
        return new StructureDataA(as, index);
    }

    public void setMemberArray(String memberName, Array data) {
        StructureMembers.Member m4 = this.members.findMember(memberName);
        m4.setDataArray(data);
    }

    @Override
    public Array getArray(int recno, StructureMembers.Member m4) {
        Array data;
        if (m4.isVariableLength() && (data = m4.getDataArray()) instanceof ArrayObject) {
            ArrayObject ao = (ArrayObject)data;
            Object dao = ao.getObject(recno);
            assert (dao instanceof Array);
            return (Array)dao;
        }
        return super.getArray(recno, m4);
    }

    public static ArrayStructureMA factoryMA(Structure from, int[] shape) {
        StructureMembers sm = from.makeStructureMembers();
        for (Variable v : from.getVariables()) {
            Array data = v instanceof Sequence ? Array.factory(DataType.SEQUENCE, shape) : (v instanceof Structure ? ArrayStructureMA.factoryMA((Structure)v, ArrayStructureMA.combine(shape, v.getShape())) : Array.factory(v.getDataType(), ArrayStructureMA.combine(shape, v.getShape())));
            StructureMembers.Member m4 = sm.findMember(v.getShortName());
            m4.setDataArray(data);
        }
        return new ArrayStructureMA(sm, shape);
    }

    private static int[] combine(int[] shape1, int[] shape2) {
        int[] result = new int[shape1.length + shape2.length];
        System.arraycopy(shape1, 0, result, 0, shape1.length);
        System.arraycopy(shape2, 0, result, shape1.length, shape2.length);
        return result;
    }
}

