/*
 * Decompiled with CFR 0.152.
 */
package com.esotericsoftware.kryo.util;

import com.esotericsoftware.kryo.util.ObjectIntMap;

public class IdentityObjectIntMap<K>
extends ObjectIntMap<K> {
    public IdentityObjectIntMap() {
    }

    public IdentityObjectIntMap(int initialCapacity) {
        super(initialCapacity);
    }

    public IdentityObjectIntMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
    }

    public IdentityObjectIntMap(IdentityObjectIntMap<K> map) {
        super(map);
    }

    @Override
    protected int place(K item) {
        return System.identityHashCode(item) & this.mask;
    }

    @Override
    public int get(K key, int defaultValue) {
        int i = this.place(key);
        Object other;
        while ((other = this.keyTable[i]) != null) {
            if (other == key) {
                return this.valueTable[i];
            }
            i = i + 1 & this.mask;
        }
        return defaultValue;
    }

    @Override
    int locateKey(K key) {
        if (key == null) {
            throw new IllegalArgumentException("key cannot be null.");
        }
        Object[] keyTable = this.keyTable;
        int i = this.place(key);
        Object other;
        while ((other = keyTable[i]) != null) {
            if (other == key) {
                return i;
            }
            i = i + 1 & this.mask;
        }
        return -(i + 1);
    }

    @Override
    public int hashCode() {
        int h2 = this.size;
        Object[] keyTable = this.keyTable;
        int[] valueTable = this.valueTable;
        int n = keyTable.length;
        for (int i = 0; i < n; ++i) {
            Object key = keyTable[i];
            if (key == null) continue;
            h2 += System.identityHashCode(key) + valueTable[i];
        }
        return h2;
    }
}

