/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs;

import java.io.IOException;
import loci.common.RandomAccessInputStream;
import ome.codecs.BaseCodec;
import ome.codecs.ByteVector;
import ome.codecs.CodecException;
import ome.codecs.CodecOptions;
import ome.codecs.UnsupportedCompressionException;

public class LZOCodec
extends BaseCodec {
    private static final int LZO_OVERRUN = -6;

    @Override
    public byte[] compress(byte[] data, CodecOptions options) throws CodecException {
        throw new UnsupportedCompressionException("LZO Compression not currently supported");
    }

    @Override
    public byte[] decompress(RandomAccessInputStream in, CodecOptions options) throws CodecException, IOException {
        byte[] b;
        if (in == null) {
            throw new IllegalArgumentException("No data to decompress.");
        }
        ByteVector dst = new ByteVector();
        int t2 = in.read() & 0xFF;
        if (t2 > 17) {
            b = new byte[t2 -= 17];
            in.read(b);
            dst.add(b);
            t2 = in.read() & 0xFF;
            if (t2 < 16) {
                return dst.toByteArray();
            }
        }
        block0: while (true) {
            block25: {
                int mPos;
                block24: {
                    if (t2 >= 16) break block24;
                    if (t2 == 0) {
                        byte f = in.readByte();
                        while (f == 0) {
                            t2 += 255;
                            f = in.readByte();
                        }
                        t2 += 15 + (f & 0xFF);
                    }
                    b = new byte[t2 += 3];
                    in.read(b);
                    dst.add(b);
                    t2 = in.read() & 0xFF;
                    if (t2 >= 16) break block24;
                    mPos = dst.size() - 2049 - (t2 >> 2) - ((in.read() & 0xFF) << 2);
                    if (mPos < 0) {
                        t2 = -6;
                        break;
                    }
                    t2 = 3;
                    do {
                        dst.add(dst.get(mPos++));
                    } while (--t2 > 0);
                    in.seek(in.getFilePointer() - 2L);
                    t2 = in.read() & 3;
                    in.skipBytes(1);
                    if (t2 == 0) break block25;
                    b = new byte[t2];
                    in.read(b);
                    dst.add(b);
                    t2 = in.read() & 0xFF;
                }
                while (true) {
                    if (t2 >= 64) {
                        mPos = dst.size() - 1 - (t2 >> 2 & 7) - ((in.read() & 0xFF) << 3);
                        t2 = (t2 >> 5) - 1;
                    } else if (t2 >= 32) {
                        if ((t2 &= 0x1F) == 0) {
                            byte f = in.readByte();
                            while (f == 0) {
                                t2 += 255;
                                f = in.readByte();
                            }
                            t2 += 31 + (f & 0xFF);
                        }
                        mPos = dst.size() - 1 - ((in.read() & 0xFF) >> 2);
                        mPos -= (in.read() & 0xFF) << 6;
                    } else if (t2 >= 16) {
                        mPos = dst.size() - ((t2 & 8) << 11);
                        if ((t2 &= 7) == 0) {
                            byte f = in.readByte();
                            while (f == 0) {
                                t2 += 255;
                                f = in.readByte();
                            }
                            t2 += 7 + (f & 0xFF);
                        }
                        mPos -= (in.read() & 0xFF) >> 2;
                        if ((mPos -= (in.read() & 0xFF) << 6) == dst.size()) break block0;
                        mPos -= 16384;
                    } else {
                        mPos = dst.size() - 1 - (t2 >> 2) - ((in.read() & 0xFF) << 2);
                        t2 = 0;
                    }
                    if (mPos < 0) {
                        t2 = -6;
                        break block0;
                    }
                    t2 += 2;
                    do {
                        dst.add(dst.get(mPos++));
                    } while (--t2 > 0);
                    in.seek(in.getFilePointer() - 2L);
                    t2 = in.read() & 3;
                    in.skipBytes(1);
                    if (t2 == 0) break;
                    b = new byte[t2];
                    in.read(b);
                    dst.add(b);
                    t2 = 0;
                    t2 = in.read() & 0xFF;
                }
            }
            t2 = in.read() & 0xFF;
        }
        return dst.toByteArray();
    }
}

