/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.Iterator;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.TrajectoryProfileFeature;
import ucar.nc2.ft.point.CollectionIteratorAdapter;
import ucar.nc2.ft.point.PointFeatureCCImpl;
import ucar.nc2.time.CalendarDateUnit;

public abstract class SectionFeatureImpl
extends PointFeatureCCImpl
implements TrajectoryProfileFeature {
    protected PointFeatureCollectionIterator localIterator;

    protected SectionFeatureImpl(String name, CalendarDateUnit timeUnit, String altUnits) {
        super(name, timeUnit, altUnits, FeatureType.TRAJECTORY_PROFILE);
    }

    @Override
    public Iterator<ProfileFeature> iterator() {
        try {
            PointFeatureCollectionIterator pfIterator = this.getPointFeatureCollectionIterator();
            return new CollectionIteratorAdapter<ProfileFeature>(pfIterator);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public boolean hasNext() throws IOException {
        if (this.localIterator == null) {
            this.resetIteration();
        }
        return this.localIterator.hasNext();
    }

    @Override
    public ProfileFeature next() throws IOException {
        return (ProfileFeature)this.localIterator.next();
    }

    @Override
    public void resetIteration() throws IOException {
        this.localIterator = this.getPointFeatureCollectionIterator();
    }
}

