/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.radial;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.radial.CFRadialAdapter;
import ucar.nc2.dt.radial.Dorade2RadialAdapter;
import ucar.nc2.dt.radial.Nexrad2RadialAdapter;
import ucar.nc2.dt.radial.NidsRadialAdapter;
import ucar.nc2.dt.radial.NsslRadialAdapter;
import ucar.nc2.dt.radial.UF2RadialAdapter;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactory;
import ucar.nc2.util.CancelTask;

public class RadialDatasetStandardFactory
implements FeatureDatasetFactory {
    private static List<FeatureDatasetFactory> factories = new ArrayList<FeatureDatasetFactory>(10);

    static void registerFactory(Class c) {
        Object instance;
        if (!FeatureDatasetFactory.class.isAssignableFrom(c)) {
            throw new IllegalArgumentException("Class " + c.getName() + " must implement TypedDatasetFactoryIF");
        }
        try {
            instance = c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " cannot instantiate, probably need default Constructor");
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("FeatureDatasetFactoryManager Class " + c.getName() + " is not accessible");
        }
        factories.add((FeatureDatasetFactory)instance);
    }

    @Override
    public Object isMine(FeatureType wantFeatureType, NetcdfDataset ds, Formatter errlog) throws IOException {
        if (wantFeatureType != FeatureType.RADIAL && wantFeatureType != FeatureType.ANY) {
            return null;
        }
        for (FeatureDatasetFactory fac : factories) {
            Object anal = fac.isMine(FeatureType.RADIAL, ds, errlog);
            if (anal == null) continue;
            return anal;
        }
        return null;
    }

    @Override
    public FeatureDataset open(FeatureType ftype, NetcdfDataset ncd, Object analysis, CancelTask task, Formatter errlog) throws IOException {
        FeatureDatasetFactory fac = (FeatureDatasetFactory)analysis;
        return fac.open(FeatureType.RADIAL, ncd, null, task, errlog);
    }

    @Override
    public FeatureType[] getFeatureTypes() {
        return new FeatureType[]{FeatureType.RADIAL};
    }

    static {
        RadialDatasetStandardFactory.registerFactory(NsslRadialAdapter.class);
        RadialDatasetStandardFactory.registerFactory(Dorade2RadialAdapter.class);
        RadialDatasetStandardFactory.registerFactory(Nexrad2RadialAdapter.class);
        RadialDatasetStandardFactory.registerFactory(NidsRadialAdapter.class);
        RadialDatasetStandardFactory.registerFactory(UF2RadialAdapter.class);
        RadialDatasetStandardFactory.registerFactory(CFRadialAdapter.class);
    }
}

