/*
 * Decompiled with CFR 0.152.
 */
package ome.codecs.gui;

import java.awt.image.DataBuffer;

public class UnsignedIntBuffer
extends DataBuffer {
    private int[][] bankData;

    public UnsignedIntBuffer(int[] dataArray, int size) {
        super(3, size);
        this.bankData = new int[1][];
        this.bankData[0] = dataArray;
    }

    public UnsignedIntBuffer(int[][] dataArray, int size) {
        super(3, size);
        this.bankData = dataArray;
    }

    public int[] getData() {
        return this.bankData[0];
    }

    public int[] getData(int bank) {
        return this.bankData[bank];
    }

    @Override
    public int getElem(int i) {
        return this.getElem(0, i);
    }

    @Override
    public int getElem(int bank, int i) {
        int value = this.bankData[bank][i + this.getOffsets()[bank]];
        return (int)((long)value & 0xFFFFFFFFL);
    }

    @Override
    public float getElemFloat(int i) {
        return this.getElemFloat(0, i);
    }

    @Override
    public float getElemFloat(int bank, int i) {
        return (long)this.getElem(bank, i) & 0xFFFFFFFFL;
    }

    @Override
    public double getElemDouble(int i) {
        return this.getElemDouble(0, i);
    }

    @Override
    public double getElemDouble(int bank, int i) {
        return (long)this.getElem(bank, i) & 0xFFFFFFFFL;
    }

    @Override
    public void setElem(int i, int val) {
        this.setElem(0, i, val);
    }

    @Override
    public void setElem(int bank, int i, int val) {
        this.bankData[bank][i + this.getOffsets()[bank]] = val;
    }

    @Override
    public void setElemFloat(int i, float val) {
        this.setElemFloat(0, i, val);
    }

    @Override
    public void setElemFloat(int bank, int i, float val) {
        this.bankData[bank][i + this.getOffsets()[bank]] = (int)val;
    }

    @Override
    public void setElemDouble(int i, double val) {
        this.setElemDouble(0, i, val);
    }

    @Override
    public void setElemDouble(int bank, int i, double val) {
        this.bankData[bank][i + this.getOffsets()[bank]] = (int)val;
    }
}

