/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset.transform;

import ucar.nc2.AttributeContainer;
import ucar.nc2.dataset.ProjectionCT;
import ucar.nc2.dataset.TransformType;
import ucar.nc2.dataset.transform.AbstractTransformBuilder;
import ucar.nc2.dataset.transform.HorizTransformBuilderIF;
import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.projection.proj4.EquidistantAzimuthalProjection;

public class AzimuthalEquidistant
extends AbstractTransformBuilder
implements HorizTransformBuilderIF {
    @Override
    public String getTransformName() {
        return "azimuthal_equidistant";
    }

    public TransformType getTransformType() {
        return TransformType.Projection;
    }

    @Override
    public ProjectionCT makeCoordinateTransform(AttributeContainer ctv, String geoCoordinateUnits) {
        this.readStandardParams(ctv, geoCoordinateUnits);
        if (this.earth == null) {
            this.earth = this.earth_radius > 0.0 ? new Earth(this.earth_radius * 1000.0) : new Earth();
        }
        EquidistantAzimuthalProjection proj = new EquidistantAzimuthalProjection(this.lat0, this.lon0, this.false_easting, this.false_northing, this.earth);
        return new ProjectionCT(ctv.getName(), "FGDC", proj);
    }
}

