/*
 * Decompiled with CFR 0.152.
 */
package loci.common.utests;

import java.io.IOException;
import loci.common.IRandomAccess;
import loci.common.utests.providers.IRandomAccessProvider;
import loci.common.utests.providers.IRandomAccessProviderFactory;
import org.testng.AssertJUnit;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

@Test(groups={"readTests"})
public class ReadCharTest {
    private static final byte[] PAGE = new byte[]{0, 97, 0, 98, 0, 99, 0, 100, 0, 101, 0, 102, 0, 103, 0, 104, 0, 105, 0, 106, 0, 107, 0, 108, 0, 109, 0, 110, 0, 111, 0, 112};
    private static final String MODE = "r";
    private static final int BUFFER_SIZE = 1024;
    private IRandomAccess fileHandle;

    @Parameters(value={"provider"})
    @BeforeMethod
    public void setUp(String provider) throws IOException {
        IRandomAccessProviderFactory factory = new IRandomAccessProviderFactory();
        IRandomAccessProvider instance = factory.getInstance(provider);
        this.fileHandle = instance.createMock(PAGE, MODE, 1024);
    }

    @Test
    public void testLength() throws IOException {
        AssertJUnit.assertEquals((long)32L, (long)this.fileHandle.length());
    }

    @Test
    public void testSequentialReadChar() throws IOException {
        char[] expectedValues;
        for (char expectedValue : expectedValues = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p'}) {
            char value = this.fileHandle.readChar();
            AssertJUnit.assertTrue((boolean)Character.isLetter(value));
            AssertJUnit.assertEquals((char)expectedValue, (char)value);
        }
    }

    @Test
    public void testSeekForwardReadChar() throws IOException {
        this.fileHandle.seek(8L);
        char value = this.fileHandle.readChar();
        AssertJUnit.assertTrue((boolean)Character.isLetter(value));
        AssertJUnit.assertEquals((char)'e', (char)value);
        value = this.fileHandle.readChar();
        AssertJUnit.assertTrue((boolean)Character.isLetter(value));
        AssertJUnit.assertEquals((char)'f', (char)value);
    }

    @Test
    public void testResetReadChar() throws IOException {
        char value = this.fileHandle.readChar();
        AssertJUnit.assertTrue((boolean)Character.isLetter(value));
        AssertJUnit.assertEquals((char)'a', (char)value);
        value = this.fileHandle.readChar();
        AssertJUnit.assertTrue((boolean)Character.isLetter(value));
        AssertJUnit.assertEquals((char)'b', (char)value);
        this.fileHandle.seek(0L);
        value = this.fileHandle.readChar();
        AssertJUnit.assertTrue((boolean)Character.isLetter(value));
        AssertJUnit.assertEquals((char)'a', (char)value);
        value = this.fileHandle.readChar();
        AssertJUnit.assertTrue((boolean)Character.isLetter(value));
        AssertJUnit.assertEquals((char)'b', (char)value);
    }

    @Test
    public void testSeekBackReadChar() throws IOException {
        this.fileHandle.seek(16L);
        this.fileHandle.seek(8L);
        char value = this.fileHandle.readChar();
        AssertJUnit.assertTrue((boolean)Character.isLetter(value));
        AssertJUnit.assertEquals((char)'e', (char)value);
        value = this.fileHandle.readChar();
        AssertJUnit.assertTrue((boolean)Character.isLetter(value));
        AssertJUnit.assertEquals((char)'f', (char)value);
    }

    @Test
    public void testRandomAccessReadChar() throws IOException {
        this.testSeekForwardReadChar();
        this.testSeekBackReadChar();
        this.fileHandle.seek(0L);
        this.testResetReadChar();
    }
}

