/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.meta;

import java.util.List;

import ome.xml.model.*;
import ome.xml.model.enums.*;
import ome.xml.model.primitives.*;

import ome.units.quantity.Angle;
import ome.units.quantity.ElectricPotential;
import ome.units.quantity.Frequency;
import ome.units.quantity.Length;
import ome.units.quantity.Power;
import ome.units.quantity.Pressure;
import ome.units.quantity.Temperature;
import ome.units.quantity.Time;
import ome.units.unit.Unit;

/**
 * A metadata store implementation for constructing and manipulating OME-XML
 * DOMs for the current version of OME-XML.
 *
 * @author Curtis Rueden ctrueden at wisc.edu
 * @author Melissa Linkert linkert at wisc.edu
 */
public class OMEXMLMetadataImpl extends AbstractOMEXMLMetadata
{
  private OMEXMLMetadataRoot root; // OME

  private OMEModel model;

  public OMEXMLMetadataImpl()
  {
    createRoot();
  }

  public void createRoot()
  {
    root = new OMEXMLMetadataRoot();
    model = new OMEModelImpl();
  }

  public MetadataRoot getRoot()
  {
    return root;
  }

  public void setRoot(MetadataRoot root)
  {
    if (root instanceof OMEXMLMetadataRoot)
      this.root = (OMEXMLMetadataRoot) root;
    else
      throw new IllegalArgumentException("Expecting OMEXMLMetadataRoot class or subclass.");
    model = new OMEModelImpl();
  }

  public String dumpXML()
  {
    resolveReferences();
    return super.dumpXML();
  }

  public int resolveReferences()
  {
    return model.resolveReferences();
  }

  // -- Entity counting (manual definitions) --

  public int getBooleanAnnotationAnnotationCount(int booleanAnnotationIndex) {
    return root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public int getCommentAnnotationAnnotationCount(int commentAnnotationIndex) {
    return root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public int getDoubleAnnotationAnnotationCount(int doubleAnnotationIndex) {
    return root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public int getFileAnnotationAnnotationCount(int fileAnnotationIndex) {
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public int getListAnnotationAnnotationCount(int listAnnotationIndex) {
    return root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public int getLongAnnotationAnnotationCount(int longAnnotationIndex) {
    return root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public int getMapAnnotationAnnotationCount(int mapAnnotationIndex) {
    return root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public int getTagAnnotationAnnotationCount(int tagAnnotationIndex) {
    return root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public int getTermAnnotationAnnotationCount(int termAnnotationIndex) {
    return root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public int getTimestampAnnotationAnnotationCount(int timestampAnnotationIndex)
  {
    return root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public int getXMLAnnotationAnnotationCount(int xmlAnnotationIndex) {
    return root.getStructuredAnnotations().getXMLAnnotation(xmlAnnotationIndex).sizeOfLinkedAnnotationList();
  }

  public String getLightSourceType(int instrumentIndex, int lightSourceIndex)
  {
    LightSource o = root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
    String className = o.getClass().getName();
    return className.substring(
      className.lastIndexOf('.') + 1);
  }
  public String getShapeType(int ROIIndex, int shapeIndex)
  {
    Shape o = root.getROI(ROIIndex).getUnion().getShape(shapeIndex);
    String className = o.getClass().getName();
    return className.substring(
      className.lastIndexOf('.') + 1);
  }

  // -- Entity counting (code generated definitions) --

  // AnnotationRef entity counting
  public int getChannelAnnotationRefCount(int imageIndex, int channelIndex)
  {
    // AnnotationRef is a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).sizeOfLinkedAnnotationList();
  }

  public int getDatasetAnnotationRefCount(int datasetIndex)
  {
    // AnnotationRef is a reference
    return root.getDataset(datasetIndex).sizeOfLinkedAnnotationList();
  }

  public int getDetectorAnnotationRefCount(int instrumentIndex, int detectorIndex)
  {
    // AnnotationRef is a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).sizeOfLinkedAnnotationList();
  }

  public int getDichroicAnnotationRefCount(int instrumentIndex, int dichroicIndex)
  {
    // AnnotationRef is a reference
    return root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).sizeOfLinkedAnnotationList();
  }

  public int getExperimenterAnnotationRefCount(int experimenterIndex)
  {
    // AnnotationRef is a reference
    return root.getExperimenter(experimenterIndex).sizeOfLinkedAnnotationList();
  }

  public int getExperimenterGroupAnnotationRefCount(int experimenterGroupIndex)
  {
    // AnnotationRef is a reference
    return root.getExperimenterGroup(experimenterGroupIndex).sizeOfLinkedAnnotationList();
  }

  public int getFilterAnnotationRefCount(int instrumentIndex, int filterIndex)
  {
    // AnnotationRef is a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).sizeOfLinkedAnnotationList();
  }

  public int getFolderAnnotationRefCount(int folderIndex)
  {
    // AnnotationRef is a reference
    return root.getFolder(folderIndex).sizeOfLinkedAnnotationList();
  }

  public int getImageAnnotationRefCount(int imageIndex)
  {
    // AnnotationRef is a reference
    return root.getImage(imageIndex).sizeOfLinkedAnnotationList();
  }

  public int getInstrumentAnnotationRefCount(int instrumentIndex)
  {
    // AnnotationRef is a reference
    return root.getInstrument(instrumentIndex).sizeOfLinkedAnnotationList();
  }

  public int getLightPathAnnotationRefCount(int imageIndex, int channelIndex)
  {
    // AnnotationRef is a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().sizeOfLinkedAnnotationList();
  }

  public int getLightSourceAnnotationRefCount(int instrumentIndex, int lightSourceIndex)
  {
    // AnnotationRef is a reference
    return root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex).sizeOfLinkedAnnotationList();
  }

  public int getObjectiveAnnotationRefCount(int instrumentIndex, int objectiveIndex)
  {
    // AnnotationRef is a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).sizeOfLinkedAnnotationList();
  }

  public int getPlaneAnnotationRefCount(int imageIndex, int planeIndex)
  {
    // AnnotationRef is a reference
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).sizeOfLinkedAnnotationList();
  }

  public int getPlateAnnotationRefCount(int plateIndex)
  {
    // AnnotationRef is a reference
    return root.getPlate(plateIndex).sizeOfLinkedAnnotationList();
  }

  public int getPlateAcquisitionAnnotationRefCount(int plateIndex, int plateAcquisitionIndex)
  {
    // AnnotationRef is a reference
    return root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).sizeOfLinkedAnnotationList();
  }

  public int getProjectAnnotationRefCount(int projectIndex)
  {
    // AnnotationRef is a reference
    return root.getProject(projectIndex).sizeOfLinkedAnnotationList();
  }

  public int getROIAnnotationRefCount(int ROIIndex)
  {
    // AnnotationRef is a reference
    return root.getROI(ROIIndex).sizeOfLinkedAnnotationList();
  }

  public int getReagentAnnotationRefCount(int screenIndex, int reagentIndex)
  {
    // AnnotationRef is a reference
    return root.getScreen(screenIndex).getReagent(reagentIndex).sizeOfLinkedAnnotationList();
  }

  public int getScreenAnnotationRefCount(int screenIndex)
  {
    // AnnotationRef is a reference
    return root.getScreen(screenIndex).sizeOfLinkedAnnotationList();
  }

  public int getShapeAnnotationRefCount(int ROIIndex, int shapeIndex)
  {
    // AnnotationRef is a reference
    return root.getROI(ROIIndex).getUnion().getShape(shapeIndex).sizeOfLinkedAnnotationList();
  }

  public int getWellAnnotationRefCount(int plateIndex, int wellIndex)
  {
    // AnnotationRef is a reference
    return root.getPlate(plateIndex).getWell(wellIndex).sizeOfLinkedAnnotationList();
  }

  // BinData entity counting
  public int getPixelsBinDataCount(int imageIndex)
  {
    // BinData is not a reference
    return root.getImage(imageIndex).getPixels().sizeOfBinDataList();
  }

  // BinaryFile entity counting
  // BinaryOnly entity counting
  // BooleanAnnotation entity counting
  public int getBooleanAnnotationCount()
  {
    // BooleanAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfBooleanAnnotationList();
  }

  // Channel entity counting
  public int getChannelCount(int imageIndex)
  {
    // Channel is not a reference
    return root.getImage(imageIndex).getPixels().sizeOfChannelList();
  }

  // CommentAnnotation entity counting
  public int getCommentAnnotationCount()
  {
    // CommentAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfCommentAnnotationList();
  }

  // Dataset entity counting
  public int getDatasetCount()
  {
    // Dataset is not a reference
    return root.sizeOfDatasetList();
  }

  // DatasetRef entity counting
  public int getDatasetRefCount(int projectIndex)
  {
    // DatasetRef is a reference
    return root.getProject(projectIndex).sizeOfLinkedDatasetList();
  }

  // Detector entity counting
  public int getDetectorCount(int instrumentIndex)
  {
    // Detector is not a reference
    return root.getInstrument(instrumentIndex).sizeOfDetectorList();
  }

  // DetectorSettings entity counting
  // Dichroic entity counting
  public int getDichroicCount(int instrumentIndex)
  {
    // Dichroic is not a reference
    return root.getInstrument(instrumentIndex).sizeOfDichroicList();
  }

  // DichroicRef entity counting
  // DoubleAnnotation entity counting
  public int getDoubleAnnotationCount()
  {
    // DoubleAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfDoubleAnnotationList();
  }

  // EmissionFilterRef entity counting
  public int getFilterSetEmissionFilterRefCount(int instrumentIndex, int filterSetIndex)
  {
    // EmissionFilterRef is a reference
    return root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).sizeOfLinkedEmissionFilterList();
  }

  public int getLightPathEmissionFilterRefCount(int imageIndex, int channelIndex)
  {
    // EmissionFilterRef is a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().sizeOfLinkedEmissionFilterList();
  }

  // ExcitationFilterRef entity counting
  public int getFilterSetExcitationFilterRefCount(int instrumentIndex, int filterSetIndex)
  {
    // ExcitationFilterRef is a reference
    return root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).sizeOfLinkedExcitationFilterList();
  }

  public int getLightPathExcitationFilterRefCount(int imageIndex, int channelIndex)
  {
    // ExcitationFilterRef is a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().sizeOfLinkedExcitationFilterList();
  }

  // Experiment entity counting
  public int getExperimentCount()
  {
    // Experiment is not a reference
    return root.sizeOfExperimentList();
  }

  // ExperimentRef entity counting
  // Experimenter entity counting
  public int getExperimenterCount()
  {
    // Experimenter is not a reference
    return root.sizeOfExperimenterList();
  }

  // ExperimenterGroup entity counting
  public int getExperimenterGroupCount()
  {
    // ExperimenterGroup is not a reference
    return root.sizeOfExperimenterGroupList();
  }

  // ExperimenterGroupRef entity counting
  // ExperimenterRef entity counting
  public int getExperimenterGroupExperimenterRefCount(int experimenterGroupIndex)
  {
    // ExperimenterRef is a reference
    return root.getExperimenterGroup(experimenterGroupIndex).sizeOfLinkedExperimenterList();
  }

  // FileAnnotation entity counting
  public int getFileAnnotationCount()
  {
    // FileAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfFileAnnotationList();
  }

  // Filter entity counting
  public int getFilterCount(int instrumentIndex)
  {
    // Filter is not a reference
    return root.getInstrument(instrumentIndex).sizeOfFilterList();
  }

  // FilterSet entity counting
  public int getFilterSetCount(int instrumentIndex)
  {
    // FilterSet is not a reference
    return root.getInstrument(instrumentIndex).sizeOfFilterSetList();
  }

  // FilterSetRef entity counting
  // Folder entity counting
  public int getFolderCount()
  {
    // Folder is not a reference
    return root.sizeOfFolderList();
  }

  // FolderRef entity counting
  public int getFolderRefCount(int folderIndex)
  {
    // FolderRef is a reference
    return root.getFolder(folderIndex).sizeOfLinkedFolderList();
  }

  // Image entity counting
  public int getImageCount()
  {
    // Image is not a reference
    return root.sizeOfImageList();
  }

  // ImageRef entity counting
  public int getDatasetImageRefCount(int datasetIndex)
  {
    // ImageRef is a reference
    return root.getDataset(datasetIndex).sizeOfLinkedImageList();
  }

  public int getFolderImageRefCount(int folderIndex)
  {
    // ImageRef is a reference
    return root.getFolder(folderIndex).sizeOfLinkedImageList();
  }

  // ImagingEnvironment entity counting
  // Instrument entity counting
  public int getInstrumentCount()
  {
    // Instrument is not a reference
    return root.sizeOfInstrumentList();
  }

  // InstrumentRef entity counting
  // Leader entity counting
  public int getLeaderCount(int experimenterGroupIndex)
  {
    // Leader is a reference
    return root.getExperimenterGroup(experimenterGroupIndex).sizeOfLinkedLeaderList();
  }

  // LightPath entity counting
  // LightSource entity counting
  public int getLightSourceCount(int instrumentIndex)
  {
    // LightSource is not a reference
    return root.getInstrument(instrumentIndex).sizeOfLightSourceList();
  }

  // LightSourceSettings entity counting
  public int getMicrobeamManipulationLightSourceSettingsCount(int experimentIndex, int microbeamManipulationIndex)
  {
    // LightSourceSettings is not a reference
    return root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).sizeOfLightSourceSettingsList();
  }

  // ListAnnotation entity counting
  public int getListAnnotationCount()
  {
    // ListAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfListAnnotationList();
  }

  // LongAnnotation entity counting
  public int getLongAnnotationCount()
  {
    // LongAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfLongAnnotationList();
  }

  // Map entity counting
  // MapAnnotation entity counting
  public int getMapAnnotationCount()
  {
    // MapAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfMapAnnotationList();
  }

  // MetadataOnly entity counting
  // MicrobeamManipulation entity counting
  public int getMicrobeamManipulationCount(int experimentIndex)
  {
    // MicrobeamManipulation is not a reference
    return root.getExperiment(experimentIndex).sizeOfMicrobeamManipulationList();
  }

  // MicrobeamManipulationRef entity counting
  public int getMicrobeamManipulationRefCount(int imageIndex)
  {
    // MicrobeamManipulationRef is a reference
    return root.getImage(imageIndex).sizeOfLinkedMicrobeamManipulationList();
  }

  // Microscope entity counting
  // Objective entity counting
  public int getObjectiveCount(int instrumentIndex)
  {
    // Objective is not a reference
    return root.getInstrument(instrumentIndex).sizeOfObjectiveList();
  }

  // ObjectiveSettings entity counting
  // Pixels entity counting
  // Plane entity counting
  public int getPlaneCount(int imageIndex)
  {
    // Plane is not a reference
    return root.getImage(imageIndex).getPixels().sizeOfPlaneList();
  }

  // Plate entity counting
  public int getPlateCount()
  {
    // Plate is not a reference
    return root.sizeOfPlateList();
  }

  // PlateAcquisition entity counting
  public int getPlateAcquisitionCount(int plateIndex)
  {
    // PlateAcquisition is not a reference
    return root.getPlate(plateIndex).sizeOfPlateAcquisitionList();
  }

  // PlateRef entity counting
  public int getPlateRefCount(int screenIndex)
  {
    // PlateRef is a reference
    return root.getScreen(screenIndex).sizeOfLinkedPlateList();
  }

  // Project entity counting
  public int getProjectCount()
  {
    // Project is not a reference
    return root.sizeOfProjectList();
  }

  // Pump entity counting
  // ROI entity counting
  public int getROICount()
  {
    // ROI is not a reference
    return root.sizeOfROIList();
  }

  // ROIRef entity counting
  public int getFolderROIRefCount(int folderIndex)
  {
    // ROIRef is a reference
    return root.getFolder(folderIndex).sizeOfLinkedROIList();
  }

  public int getImageROIRefCount(int imageIndex)
  {
    // ROIRef is a reference
    return root.getImage(imageIndex).sizeOfLinkedROIList();
  }

  public int getMicrobeamManipulationROIRefCount(int experimentIndex, int microbeamManipulationIndex)
  {
    // ROIRef is a reference
    return root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).sizeOfLinkedROIList();
  }

  // Reagent entity counting
  public int getReagentCount(int screenIndex)
  {
    // Reagent is not a reference
    return root.getScreen(screenIndex).sizeOfReagentList();
  }

  // ReagentRef entity counting
  // Rights entity counting
  // Screen entity counting
  public int getScreenCount()
  {
    // Screen is not a reference
    return root.sizeOfScreenList();
  }

  // Shape entity counting
  public int getShapeCount(int ROIIndex)
  {
    // Shape is not a reference
    return root.getROI(ROIIndex).getUnion().sizeOfShapeList();
  }

  // StageLabel entity counting
  // StructuredAnnotations entity counting
  // TagAnnotation entity counting
  public int getTagAnnotationCount()
  {
    // TagAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfTagAnnotationList();
  }

  // TermAnnotation entity counting
  public int getTermAnnotationCount()
  {
    // TermAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfTermAnnotationList();
  }

  // TiffData entity counting
  public int getTiffDataCount(int imageIndex)
  {
    // TiffData is not a reference
    return root.getImage(imageIndex).getPixels().sizeOfTiffDataList();
  }

  // TimestampAnnotation entity counting
  public int getTimestampAnnotationCount()
  {
    // TimestampAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfTimestampAnnotationList();
  }

  // TransmittanceRange entity counting
  public void setUUIDValue(String value, int imageIndex, int tiffDataIndex)
  {
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfTiffDataList() == tiffDataIndex)
    {
      o2.addTiffData(new TiffData());
    }
    TiffData o3 = o2.getTiffData(tiffDataIndex);
    if (o3.getUUID() == null)
    {
      o3.setUUID(new UUID());
    }
    UUID o4 = o3.getUUID();
    o4.setValue(value);
  }

  public String getUUIDValue(int imageIndex, int tiffDataIndex)
  {
    return root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getUUID().getValue();
  }

  // UUID entity counting
  // Union entity counting
  // Well entity counting
  public int getWellCount(int plateIndex)
  {
    // Well is not a reference
    return root.getPlate(plateIndex).sizeOfWellList();
  }

  // WellSample entity counting
  public int getWellSampleCount(int plateIndex, int wellIndex)
  {
    // WellSample is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).sizeOfWellSampleList();
  }

  // WellSampleRef entity counting
  public int getWellSampleRefCount(int plateIndex, int plateAcquisitionIndex)
  {
    // WellSampleRef is a reference
    return root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).sizeOfLinkedWellSampleList();
  }

  // XMLAnnotation entity counting
  public int getXMLAnnotationCount()
  {
    // XMLAnnotation is not a reference
    return root.getStructuredAnnotations().sizeOfXMLAnnotationList();
  }


  // -- Entity retrieval (manual definitions) --

  /** Gets the UUID associated with this collection of metadata. */
  public String getUUID()
  {
    return root.getUUID();
  }

  /** Gets the Creator associated with this collection of metadata. */
  public String getCreator()
  {
    return root.getCreator();
  }

  /** Gets the Map value associated with this annotation */
  public List<MapPair> getMapAnnotationValue(int mapAnnotationIndex)
  {
    return root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getValue();
  }

  /** Gets the Map value associated with this generic light source */
  public List<MapPair> getGenericExcitationSourceMap(int instrumentIndex, int lightSourceIndex)
  {
    GenericExcitationSource o = (GenericExcitationSource) root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex);
    return o.getMap();
  }

  /** Gets the Map value associated with this imaging environment */
  public List<MapPair> getImagingEnvironmentMap(int imageIndex)
  {
    return root.getImage(imageIndex).getImagingEnvironment().getMap();
  }

  // -- Entity retrieval (code generated definitions) --


  //
  // AnnotationRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference AnnotationRef


  //
  // Arc property storage

  public String getArcAnnotationRef(int instrumentIndex, int lightSourceIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Arc)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getArcID(int instrumentIndex, int lightSourceIndex)
  {
    // ID is not a reference
    return ((Arc)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getID();
  }

  public String getArcLotNumber(int instrumentIndex, int lightSourceIndex)
  {
    // LotNumber is not a reference
    return ((Arc)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLotNumber();
  }

  public String getArcManufacturer(int instrumentIndex, int lightSourceIndex)
  {
    // Manufacturer is not a reference
    return ((Arc)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getManufacturer();
  }

  public String getArcModel(int instrumentIndex, int lightSourceIndex)
  {
    // Model is not a reference
    return ((Arc)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getModel();
  }

  public Power getArcPower(int instrumentIndex, int lightSourceIndex)
  {
    // Power is not a reference
    return ((Arc)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getPower();
  }

  public String getArcSerialNumber(int instrumentIndex, int lightSourceIndex)
  {
    // SerialNumber is not a reference
    return ((Arc)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getSerialNumber();
  }

  public ArcType getArcType(int instrumentIndex, int lightSourceIndex)
  {
    // Type is not a reference
    return ((Arc)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getType();
  }


  //
  // BinData property storage

  public byte[] getBinaryFileBinData(int fileAnnotationIndex)
  {
    // Base64Binary is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getBinData().getBase64Binary();
  }

  public byte[] getMaskBinData(int ROIIndex, int shapeIndex)
  {
    // Base64Binary is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getBinData().getBase64Binary();
  }

  public byte[] getPixelsBinData(int imageIndex, int binDataIndex)
  {
    // Base64Binary is not a reference
    return root.getImage(imageIndex).getPixels().getBinData(binDataIndex).getBase64Binary();
  }

  public Boolean getBinaryFileBinDataBigEndian(int fileAnnotationIndex)
  {
    // BigEndian is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getBinData().getBigEndian();
  }

  public Boolean getMaskBinDataBigEndian(int ROIIndex, int shapeIndex)
  {
    // BigEndian is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getBinData().getBigEndian();
  }

  public Boolean getPixelsBinDataBigEndian(int imageIndex, int binDataIndex)
  {
    // BigEndian is not a reference
    return root.getImage(imageIndex).getPixels().getBinData(binDataIndex).getBigEndian();
  }

  public Compression getBinaryFileBinDataCompression(int fileAnnotationIndex)
  {
    // Compression is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getBinData().getCompression();
  }

  public Compression getMaskBinDataCompression(int ROIIndex, int shapeIndex)
  {
    // Compression is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getBinData().getCompression();
  }

  public Compression getPixelsBinDataCompression(int imageIndex, int binDataIndex)
  {
    // Compression is not a reference
    return root.getImage(imageIndex).getPixels().getBinData(binDataIndex).getCompression();
  }

  public NonNegativeLong getBinaryFileBinDataLength(int fileAnnotationIndex)
  {
    // Length is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getBinData().getLength();
  }

  public NonNegativeLong getMaskBinDataLength(int ROIIndex, int shapeIndex)
  {
    // Length is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getBinData().getLength();
  }

  public NonNegativeLong getPixelsBinDataLength(int imageIndex, int binDataIndex)
  {
    // Length is not a reference
    return root.getImage(imageIndex).getPixels().getBinData(binDataIndex).getLength();
  }


  //
  // BinaryFile property storage

  public String getBinaryFileFileName(int fileAnnotationIndex)
  {
    // FileName is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getFileName();
  }

  public String getBinaryFileMIMEType(int fileAnnotationIndex)
  {
    // MIMEType is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getMIMEType();
  }

  public NonNegativeLong getBinaryFileSize(int fileAnnotationIndex)
  {
    // Size is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getBinaryFile().getSize();
  }


  //
  // BinaryOnly property storage

  public String getBinaryOnlyMetadataFile()
  {
    // MetadataFile is not a reference
    return root.getBinaryOnly().getMetadataFile();
  }

  public String getBinaryOnlyUUID()
  {
    // UUID is not a reference
    return root.getBinaryOnly().getUUID();
  }


  //
  // BooleanAnnotation property storage

  public String getBooleanAnnotationAnnotationRef(int booleanAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getBooleanAnnotationAnnotator(int booleanAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getAnnotator();
  }

  public String getBooleanAnnotationDescription(int booleanAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getDescription();
  }

  public String getBooleanAnnotationID(int booleanAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getID();
  }

  public String getBooleanAnnotationNamespace(int booleanAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getNamespace();
  }

  public Boolean getBooleanAnnotationValue(int booleanAnnotationIndex)
  {
    // Value is not a reference
    return root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex).getValue();
  }


  //
  // Channel property storage

  public AcquisitionMode getChannelAcquisitionMode(int imageIndex, int channelIndex)
  {
    // AcquisitionMode is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getAcquisitionMode();
  }

  public String getChannelAnnotationRef(int imageIndex, int channelIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Color getChannelColor(int imageIndex, int channelIndex)
  {
    // Color is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getColor();
  }

  public ContrastMethod getChannelContrastMethod(int imageIndex, int channelIndex)
  {
    // ContrastMethod is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getContrastMethod();
  }

  public Length getChannelEmissionWavelength(int imageIndex, int channelIndex)
  {
    // EmissionWavelength is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getEmissionWavelength();
  }

  public Length getChannelExcitationWavelength(int imageIndex, int channelIndex)
  {
    // ExcitationWavelength is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getExcitationWavelength();
  }

  public String getChannelFilterSetRef(int imageIndex, int channelIndex)
  {
    // FilterSetRef is reference and occurs only once
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLinkedFilterSet().getID();
  }

  public String getChannelFluor(int imageIndex, int channelIndex)
  {
    // Fluor is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getFluor();
  }

  public String getChannelID(int imageIndex, int channelIndex)
  {
    // ID is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getID();
  }

  public IlluminationType getChannelIlluminationType(int imageIndex, int channelIndex)
  {
    // IlluminationType is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getIlluminationType();
  }

  public Double getChannelNDFilter(int imageIndex, int channelIndex)
  {
    // NDFilter is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getNDFilter();
  }

  public String getChannelName(int imageIndex, int channelIndex)
  {
    // Name is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getName();
  }

  public Length getChannelPinholeSize(int imageIndex, int channelIndex)
  {
    // PinholeSize is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getPinholeSize();
  }

  public Integer getChannelPockelCellSetting(int imageIndex, int channelIndex)
  {
    // PockelCellSetting is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getPockelCellSetting();
  }

  public PositiveInteger getChannelSamplesPerPixel(int imageIndex, int channelIndex)
  {
    // SamplesPerPixel is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getSamplesPerPixel();
  }


  //
  // CommentAnnotation property storage

  public String getCommentAnnotationAnnotationRef(int commentAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getCommentAnnotationAnnotator(int commentAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getAnnotator();
  }

  public String getCommentAnnotationDescription(int commentAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getDescription();
  }

  public String getCommentAnnotationID(int commentAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getID();
  }

  public String getCommentAnnotationNamespace(int commentAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getNamespace();
  }

  public String getCommentAnnotationValue(int commentAnnotationIndex)
  {
    // Value is not a reference
    return root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex).getValue();
  }


  //
  // Dataset property storage

  public String getDatasetAnnotationRef(int datasetIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getDataset(datasetIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getDatasetDescription(int datasetIndex)
  {
    // Description is not a reference
    return root.getDataset(datasetIndex).getDescription();
  }

  public String getDatasetExperimenterGroupRef(int datasetIndex)
  {
    // ExperimenterGroupRef is reference and occurs only once
    return root.getDataset(datasetIndex).getLinkedExperimenterGroup().getID();
  }

  public String getDatasetExperimenterRef(int datasetIndex)
  {
    // ExperimenterRef is reference and occurs only once
    return root.getDataset(datasetIndex).getLinkedExperimenter().getID();
  }

  public String getDatasetID(int datasetIndex)
  {
    // ID is not a reference
    return root.getDataset(datasetIndex).getID();
  }

  public String getDatasetImageRef(int datasetIndex, int imageRefIndex)
  {
    // ImageRef is reference and occurs more than once
    return root.getDataset(datasetIndex).getLinkedImage(imageRefIndex).getID();
  }

  public String getDatasetName(int datasetIndex)
  {
    // Name is not a reference
    return root.getDataset(datasetIndex).getName();
  }


  //
  // DatasetRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference DatasetRef


  //
  // Detector property storage

  public Double getDetectorAmplificationGain(int instrumentIndex, int detectorIndex)
  {
    // AmplificationGain is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getAmplificationGain();
  }

  public String getDetectorAnnotationRef(int instrumentIndex, int detectorIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Double getDetectorGain(int instrumentIndex, int detectorIndex)
  {
    // Gain is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getGain();
  }

  public String getDetectorID(int instrumentIndex, int detectorIndex)
  {
    // ID is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getID();
  }

  public String getDetectorLotNumber(int instrumentIndex, int detectorIndex)
  {
    // LotNumber is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getLotNumber();
  }

  public String getDetectorManufacturer(int instrumentIndex, int detectorIndex)
  {
    // Manufacturer is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getManufacturer();
  }

  public String getDetectorModel(int instrumentIndex, int detectorIndex)
  {
    // Model is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getModel();
  }

  public Double getDetectorOffset(int instrumentIndex, int detectorIndex)
  {
    // Offset is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getOffset();
  }

  public String getDetectorSerialNumber(int instrumentIndex, int detectorIndex)
  {
    // SerialNumber is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getSerialNumber();
  }

  public DetectorType getDetectorType(int instrumentIndex, int detectorIndex)
  {
    // Type is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getType();
  }

  public ElectricPotential getDetectorVoltage(int instrumentIndex, int detectorIndex)
  {
    // Voltage is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getVoltage();
  }

  public Double getDetectorZoom(int instrumentIndex, int detectorIndex)
  {
    // Zoom is not a reference
    return root.getInstrument(instrumentIndex).getDetector(detectorIndex).getZoom();
  }


  //
  // DetectorSettings property storage

  public Binning getDetectorSettingsBinning(int imageIndex, int channelIndex)
  {
    // Binning is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getBinning();
  }

  public Double getDetectorSettingsGain(int imageIndex, int channelIndex)
  {
    // Gain is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getGain();
  }

  public String getDetectorSettingsID(int imageIndex, int channelIndex)
  {
    // ID is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getID();
  }

  public PositiveInteger getDetectorSettingsIntegration(int imageIndex, int channelIndex)
  {
    // Integration is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getIntegration();
  }

  public Double getDetectorSettingsOffset(int imageIndex, int channelIndex)
  {
    // Offset is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getOffset();
  }

  public Frequency getDetectorSettingsReadOutRate(int imageIndex, int channelIndex)
  {
    // ReadOutRate is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getReadOutRate();
  }

  public ElectricPotential getDetectorSettingsVoltage(int imageIndex, int channelIndex)
  {
    // Voltage is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getVoltage();
  }

  public Double getDetectorSettingsZoom(int imageIndex, int channelIndex)
  {
    // Zoom is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getDetectorSettings().getZoom();
  }


  //
  // Dichroic property storage

  public String getDichroicAnnotationRef(int instrumentIndex, int dichroicIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getDichroicID(int instrumentIndex, int dichroicIndex)
  {
    // ID is not a reference
    return root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getID();
  }

  public String getDichroicLotNumber(int instrumentIndex, int dichroicIndex)
  {
    // LotNumber is not a reference
    return root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getLotNumber();
  }

  public String getDichroicManufacturer(int instrumentIndex, int dichroicIndex)
  {
    // Manufacturer is not a reference
    return root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getManufacturer();
  }

  public String getDichroicModel(int instrumentIndex, int dichroicIndex)
  {
    // Model is not a reference
    return root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getModel();
  }

  public String getDichroicSerialNumber(int instrumentIndex, int dichroicIndex)
  {
    // SerialNumber is not a reference
    return root.getInstrument(instrumentIndex).getDichroic(dichroicIndex).getSerialNumber();
  }


  //
  // DichroicRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference DichroicRef


  //
  // DoubleAnnotation property storage

  public String getDoubleAnnotationAnnotationRef(int doubleAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getDoubleAnnotationAnnotator(int doubleAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getAnnotator();
  }

  public String getDoubleAnnotationDescription(int doubleAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getDescription();
  }

  public String getDoubleAnnotationID(int doubleAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getID();
  }

  public String getDoubleAnnotationNamespace(int doubleAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getNamespace();
  }

  public Double getDoubleAnnotationValue(int doubleAnnotationIndex)
  {
    // Value is not a reference
    return root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex).getValue();
  }


  //
  // Ellipse property storage

  public String getEllipseAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Color getEllipseFillColor(int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillColor();
  }

  public FillRule getEllipseFillRule(int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillRule();
  }

  public FontFamily getEllipseFontFamily(int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontFamily();
  }

  public Length getEllipseFontSize(int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontSize();
  }

  public FontStyle getEllipseFontStyle(int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontStyle();
  }

  public String getEllipseID(int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getID();
  }

  public Boolean getEllipseLocked(int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLocked();
  }

  public Double getEllipseRadiusX(int ROIIndex, int shapeIndex)
  {
    // RadiusX is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getRadiusX();
  }

  public Double getEllipseRadiusY(int ROIIndex, int shapeIndex)
  {
    // RadiusY is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getRadiusY();
  }

  public Color getEllipseStrokeColor(int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeColor();
  }

  public String getEllipseStrokeDashArray(int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeDashArray();
  }

  public Length getEllipseStrokeWidth(int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeWidth();
  }

  public String getEllipseText(int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getText();
  }

  public NonNegativeInteger getEllipseTheC(int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheC();
  }

  public NonNegativeInteger getEllipseTheT(int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheT();
  }

  public NonNegativeInteger getEllipseTheZ(int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheZ();
  }

  public AffineTransform getEllipseTransform(int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTransform();
  }

  public Double getEllipseX(int ROIIndex, int shapeIndex)
  {
    // X is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getX();
  }

  public Double getEllipseY(int ROIIndex, int shapeIndex)
  {
    // Y is not a reference
    return ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getY();
  }


  //
  // EmissionFilterRef property storage


  //
  // ExcitationFilterRef property storage


  //
  // Experiment property storage

  public String getExperimentDescription(int experimentIndex)
  {
    // Description is not a reference
    return root.getExperiment(experimentIndex).getDescription();
  }

  public String getExperimentExperimenterRef(int experimentIndex)
  {
    // ExperimenterRef is reference and occurs only once
    return root.getExperiment(experimentIndex).getLinkedExperimenter().getID();
  }

  public String getExperimentID(int experimentIndex)
  {
    // ID is not a reference
    return root.getExperiment(experimentIndex).getID();
  }

  public ExperimentType getExperimentType(int experimentIndex)
  {
    // Type is not a reference
    return root.getExperiment(experimentIndex).getType();
  }


  //
  // ExperimentRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference ExperimentRef


  //
  // Experimenter property storage

  public String getExperimenterAnnotationRef(int experimenterIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getExperimenter(experimenterIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getExperimenterEmail(int experimenterIndex)
  {
    // Email is not a reference
    return root.getExperimenter(experimenterIndex).getEmail();
  }

  public String getExperimenterFirstName(int experimenterIndex)
  {
    // FirstName is not a reference
    return root.getExperimenter(experimenterIndex).getFirstName();
  }

  public String getExperimenterID(int experimenterIndex)
  {
    // ID is not a reference
    return root.getExperimenter(experimenterIndex).getID();
  }

  public String getExperimenterInstitution(int experimenterIndex)
  {
    // Institution is not a reference
    return root.getExperimenter(experimenterIndex).getInstitution();
  }

  public String getExperimenterLastName(int experimenterIndex)
  {
    // LastName is not a reference
    return root.getExperimenter(experimenterIndex).getLastName();
  }

  public String getExperimenterMiddleName(int experimenterIndex)
  {
    // MiddleName is not a reference
    return root.getExperimenter(experimenterIndex).getMiddleName();
  }

  public String getExperimenterUserName(int experimenterIndex)
  {
    // UserName is not a reference
    return root.getExperimenter(experimenterIndex).getUserName();
  }


  //
  // ExperimenterGroup property storage

  public String getExperimenterGroupAnnotationRef(int experimenterGroupIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getExperimenterGroup(experimenterGroupIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getExperimenterGroupDescription(int experimenterGroupIndex)
  {
    // Description is not a reference
    return root.getExperimenterGroup(experimenterGroupIndex).getDescription();
  }

  public String getExperimenterGroupExperimenterRef(int experimenterGroupIndex, int experimenterRefIndex)
  {
    // ExperimenterRef is reference and occurs more than once
    return root.getExperimenterGroup(experimenterGroupIndex).getLinkedExperimenter(experimenterRefIndex).getID();
  }

  public String getExperimenterGroupID(int experimenterGroupIndex)
  {
    // ID is not a reference
    return root.getExperimenterGroup(experimenterGroupIndex).getID();
  }

  public String getExperimenterGroupLeader(int experimenterGroupIndex, int leaderIndex)
  {
    // Leader is reference and occurs more than once
    return root.getExperimenterGroup(experimenterGroupIndex).getLinkedLeader(leaderIndex).getID();
  }

  public String getExperimenterGroupName(int experimenterGroupIndex)
  {
    // Name is not a reference
    return root.getExperimenterGroup(experimenterGroupIndex).getName();
  }


  //
  // ExperimenterGroupRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference ExperimenterGroupRef


  //
  // ExperimenterRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference ExperimenterRef


  //
  // Filament property storage

  public String getFilamentAnnotationRef(int instrumentIndex, int lightSourceIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Filament)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getFilamentID(int instrumentIndex, int lightSourceIndex)
  {
    // ID is not a reference
    return ((Filament)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getID();
  }

  public String getFilamentLotNumber(int instrumentIndex, int lightSourceIndex)
  {
    // LotNumber is not a reference
    return ((Filament)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLotNumber();
  }

  public String getFilamentManufacturer(int instrumentIndex, int lightSourceIndex)
  {
    // Manufacturer is not a reference
    return ((Filament)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getManufacturer();
  }

  public String getFilamentModel(int instrumentIndex, int lightSourceIndex)
  {
    // Model is not a reference
    return ((Filament)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getModel();
  }

  public Power getFilamentPower(int instrumentIndex, int lightSourceIndex)
  {
    // Power is not a reference
    return ((Filament)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getPower();
  }

  public String getFilamentSerialNumber(int instrumentIndex, int lightSourceIndex)
  {
    // SerialNumber is not a reference
    return ((Filament)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getSerialNumber();
  }

  public FilamentType getFilamentType(int instrumentIndex, int lightSourceIndex)
  {
    // Type is not a reference
    return ((Filament)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getType();
  }


  //
  // FileAnnotation property storage

  public String getFileAnnotationAnnotationRef(int fileAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getFileAnnotationAnnotator(int fileAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getAnnotator();
  }

  public String getFileAnnotationDescription(int fileAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getDescription();
  }

  public String getFileAnnotationID(int fileAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getID();
  }

  public String getFileAnnotationNamespace(int fileAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex).getNamespace();
  }


  //
  // Filter property storage

  public String getFilterAnnotationRef(int instrumentIndex, int filterIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getFilterFilterWheel(int instrumentIndex, int filterIndex)
  {
    // FilterWheel is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getFilterWheel();
  }

  public String getFilterID(int instrumentIndex, int filterIndex)
  {
    // ID is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getID();
  }

  public String getFilterLotNumber(int instrumentIndex, int filterIndex)
  {
    // LotNumber is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getLotNumber();
  }

  public String getFilterManufacturer(int instrumentIndex, int filterIndex)
  {
    // Manufacturer is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getManufacturer();
  }

  public String getFilterModel(int instrumentIndex, int filterIndex)
  {
    // Model is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getModel();
  }

  public String getFilterSerialNumber(int instrumentIndex, int filterIndex)
  {
    // SerialNumber is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getSerialNumber();
  }

  public FilterType getFilterType(int instrumentIndex, int filterIndex)
  {
    // Type is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getType();
  }


  //
  // FilterSet property storage

  public String getFilterSetDichroicRef(int instrumentIndex, int filterSetIndex)
  {
    // DichroicRef is reference and occurs only once
    return root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedDichroic().getID();
  }

  public String getFilterSetEmissionFilterRef(int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex)
  {
    // EmissionFilterRef is reference and occurs more than once
    return root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedEmissionFilter(emissionFilterRefIndex).getID();
  }

  public String getFilterSetExcitationFilterRef(int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex)
  {
    // ExcitationFilterRef is reference and occurs more than once
    return root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLinkedExcitationFilter(excitationFilterRefIndex).getID();
  }

  public String getFilterSetID(int instrumentIndex, int filterSetIndex)
  {
    // ID is not a reference
    return root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getID();
  }

  public String getFilterSetLotNumber(int instrumentIndex, int filterSetIndex)
  {
    // LotNumber is not a reference
    return root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getLotNumber();
  }

  public String getFilterSetManufacturer(int instrumentIndex, int filterSetIndex)
  {
    // Manufacturer is not a reference
    return root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getManufacturer();
  }

  public String getFilterSetModel(int instrumentIndex, int filterSetIndex)
  {
    // Model is not a reference
    return root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getModel();
  }

  public String getFilterSetSerialNumber(int instrumentIndex, int filterSetIndex)
  {
    // SerialNumber is not a reference
    return root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex).getSerialNumber();
  }


  //
  // FilterSetRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference FilterSetRef


  //
  // Folder property storage

  public String getFolderAnnotationRef(int folderIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getFolder(folderIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getFolderDescription(int folderIndex)
  {
    // Description is not a reference
    return root.getFolder(folderIndex).getDescription();
  }

  public String getFolderFolderRef(int folderIndex, int folderRefIndex)
  {
    // FolderRef is reference and occurs more than once
    return root.getFolder(folderIndex).getLinkedFolder(folderRefIndex).getID();
  }

  public String getFolderID(int folderIndex)
  {
    // ID is not a reference
    return root.getFolder(folderIndex).getID();
  }

  public String getFolderImageRef(int folderIndex, int imageRefIndex)
  {
    // ImageRef is reference and occurs more than once
    return root.getFolder(folderIndex).getLinkedImage(imageRefIndex).getID();
  }

  public String getFolderName(int folderIndex)
  {
    // Name is not a reference
    return root.getFolder(folderIndex).getName();
  }

  public String getFolderROIRef(int folderIndex, int ROIRefIndex)
  {
    // ROIRef is reference and occurs more than once
    return root.getFolder(folderIndex).getLinkedROI(ROIRefIndex).getID();
  }


  //
  // FolderRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference FolderRef


  //
  // GenericExcitationSource property storage

  public String getGenericExcitationSourceAnnotationRef(int instrumentIndex, int lightSourceIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((GenericExcitationSource)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getGenericExcitationSourceID(int instrumentIndex, int lightSourceIndex)
  {
    // ID is not a reference
    return ((GenericExcitationSource)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getID();
  }

  public String getGenericExcitationSourceLotNumber(int instrumentIndex, int lightSourceIndex)
  {
    // LotNumber is not a reference
    return ((GenericExcitationSource)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLotNumber();
  }

  public String getGenericExcitationSourceManufacturer(int instrumentIndex, int lightSourceIndex)
  {
    // Manufacturer is not a reference
    return ((GenericExcitationSource)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getManufacturer();
  }

  public String getGenericExcitationSourceModel(int instrumentIndex, int lightSourceIndex)
  {
    // Model is not a reference
    return ((GenericExcitationSource)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getModel();
  }

  public Power getGenericExcitationSourcePower(int instrumentIndex, int lightSourceIndex)
  {
    // Power is not a reference
    return ((GenericExcitationSource)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getPower();
  }

  public String getGenericExcitationSourceSerialNumber(int instrumentIndex, int lightSourceIndex)
  {
    // SerialNumber is not a reference
    return ((GenericExcitationSource)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getSerialNumber();
  }


  //
  // Image property storage

  public Timestamp getImageAcquisitionDate(int imageIndex)
  {
    // AcquisitionDate is not a reference
    return root.getImage(imageIndex).getAcquisitionDate();
  }

  public String getImageAnnotationRef(int imageIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getImage(imageIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getImageDescription(int imageIndex)
  {
    // Description is not a reference
    return root.getImage(imageIndex).getDescription();
  }

  public String getImageExperimentRef(int imageIndex)
  {
    // ExperimentRef is reference and occurs only once
    return root.getImage(imageIndex).getLinkedExperiment().getID();
  }

  public String getImageExperimenterGroupRef(int imageIndex)
  {
    // ExperimenterGroupRef is reference and occurs only once
    return root.getImage(imageIndex).getLinkedExperimenterGroup().getID();
  }

  public String getImageExperimenterRef(int imageIndex)
  {
    // ExperimenterRef is reference and occurs only once
    return root.getImage(imageIndex).getLinkedExperimenter().getID();
  }

  public String getImageID(int imageIndex)
  {
    // ID is not a reference
    return root.getImage(imageIndex).getID();
  }

  public String getImageInstrumentRef(int imageIndex)
  {
    // InstrumentRef is reference and occurs only once
    return root.getImage(imageIndex).getLinkedInstrument().getID();
  }

  public String getImageMicrobeamManipulationRef(int imageIndex, int microbeamManipulationRefIndex)
  {
    // MicrobeamManipulationRef is reference and occurs more than once
    return root.getImage(imageIndex).getLinkedMicrobeamManipulation(microbeamManipulationRefIndex).getID();
  }

  public String getImageName(int imageIndex)
  {
    // Name is not a reference
    return root.getImage(imageIndex).getName();
  }

  public String getImageROIRef(int imageIndex, int ROIRefIndex)
  {
    // ROIRef is reference and occurs more than once
    return root.getImage(imageIndex).getLinkedROI(ROIRefIndex).getID();
  }


  //
  // ImageRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference ImageRef


  //
  // ImagingEnvironment property storage

  public Pressure getImagingEnvironmentAirPressure(int imageIndex)
  {
    // AirPressure is not a reference
    return root.getImage(imageIndex).getImagingEnvironment().getAirPressure();
  }

  public PercentFraction getImagingEnvironmentCO2Percent(int imageIndex)
  {
    // CO2Percent is not a reference
    return root.getImage(imageIndex).getImagingEnvironment().getCO2Percent();
  }

  public PercentFraction getImagingEnvironmentHumidity(int imageIndex)
  {
    // Humidity is not a reference
    return root.getImage(imageIndex).getImagingEnvironment().getHumidity();
  }

  public Temperature getImagingEnvironmentTemperature(int imageIndex)
  {
    // Temperature is not a reference
    return root.getImage(imageIndex).getImagingEnvironment().getTemperature();
  }


  //
  // Instrument property storage

  public String getInstrumentAnnotationRef(int instrumentIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getInstrument(instrumentIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getInstrumentID(int instrumentIndex)
  {
    // ID is not a reference
    return root.getInstrument(instrumentIndex).getID();
  }


  //
  // InstrumentRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference InstrumentRef


  //
  // Label property storage

  public String getLabelAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Color getLabelFillColor(int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillColor();
  }

  public FillRule getLabelFillRule(int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillRule();
  }

  public FontFamily getLabelFontFamily(int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontFamily();
  }

  public Length getLabelFontSize(int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontSize();
  }

  public FontStyle getLabelFontStyle(int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontStyle();
  }

  public String getLabelID(int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getID();
  }

  public Boolean getLabelLocked(int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLocked();
  }

  public Color getLabelStrokeColor(int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeColor();
  }

  public String getLabelStrokeDashArray(int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeDashArray();
  }

  public Length getLabelStrokeWidth(int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeWidth();
  }

  public String getLabelText(int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getText();
  }

  public NonNegativeInteger getLabelTheC(int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheC();
  }

  public NonNegativeInteger getLabelTheT(int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheT();
  }

  public NonNegativeInteger getLabelTheZ(int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheZ();
  }

  public AffineTransform getLabelTransform(int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTransform();
  }

  public Double getLabelX(int ROIIndex, int shapeIndex)
  {
    // X is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getX();
  }

  public Double getLabelY(int ROIIndex, int shapeIndex)
  {
    // Y is not a reference
    return ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getY();
  }


  //
  // Laser property storage

  public String getLaserAnnotationRef(int instrumentIndex, int lightSourceIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public PositiveInteger getLaserFrequencyMultiplication(int instrumentIndex, int lightSourceIndex)
  {
    // FrequencyMultiplication is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getFrequencyMultiplication();
  }

  public String getLaserID(int instrumentIndex, int lightSourceIndex)
  {
    // ID is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getID();
  }

  public LaserMedium getLaserLaserMedium(int instrumentIndex, int lightSourceIndex)
  {
    // LaserMedium is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLaserMedium();
  }

  public String getLaserLotNumber(int instrumentIndex, int lightSourceIndex)
  {
    // LotNumber is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLotNumber();
  }

  public String getLaserManufacturer(int instrumentIndex, int lightSourceIndex)
  {
    // Manufacturer is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getManufacturer();
  }

  public String getLaserModel(int instrumentIndex, int lightSourceIndex)
  {
    // Model is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getModel();
  }

  public Boolean getLaserPockelCell(int instrumentIndex, int lightSourceIndex)
  {
    // PockelCell is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getPockelCell();
  }

  public Power getLaserPower(int instrumentIndex, int lightSourceIndex)
  {
    // Power is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getPower();
  }

  public Pulse getLaserPulse(int instrumentIndex, int lightSourceIndex)
  {
    // Pulse is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getPulse();
  }

  public String getLaserPump(int instrumentIndex, int lightSourceIndex)
  {
    // Pump is reference and occurs only once
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLinkedPump().getID();
  }

  public Frequency getLaserRepetitionRate(int instrumentIndex, int lightSourceIndex)
  {
    // RepetitionRate is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getRepetitionRate();
  }

  public String getLaserSerialNumber(int instrumentIndex, int lightSourceIndex)
  {
    // SerialNumber is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getSerialNumber();
  }

  public Boolean getLaserTuneable(int instrumentIndex, int lightSourceIndex)
  {
    // Tuneable is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getTuneable();
  }

  public LaserType getLaserType(int instrumentIndex, int lightSourceIndex)
  {
    // Type is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getType();
  }

  public Length getLaserWavelength(int instrumentIndex, int lightSourceIndex)
  {
    // Wavelength is not a reference
    return ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getWavelength();
  }


  //
  // Leader property storage

  // 0:9999
  // Is multi path? False
  // Ignoring ExperimenterGroup_BackReference property of reference Leader

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference Leader


  //
  // LightEmittingDiode property storage

  public String getLightEmittingDiodeAnnotationRef(int instrumentIndex, int lightSourceIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((LightEmittingDiode)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getLightEmittingDiodeID(int instrumentIndex, int lightSourceIndex)
  {
    // ID is not a reference
    return ((LightEmittingDiode)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getID();
  }

  public String getLightEmittingDiodeLotNumber(int instrumentIndex, int lightSourceIndex)
  {
    // LotNumber is not a reference
    return ((LightEmittingDiode)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getLotNumber();
  }

  public String getLightEmittingDiodeManufacturer(int instrumentIndex, int lightSourceIndex)
  {
    // Manufacturer is not a reference
    return ((LightEmittingDiode)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getManufacturer();
  }

  public String getLightEmittingDiodeModel(int instrumentIndex, int lightSourceIndex)
  {
    // Model is not a reference
    return ((LightEmittingDiode)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getModel();
  }

  public Power getLightEmittingDiodePower(int instrumentIndex, int lightSourceIndex)
  {
    // Power is not a reference
    return ((LightEmittingDiode)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getPower();
  }

  public String getLightEmittingDiodeSerialNumber(int instrumentIndex, int lightSourceIndex)
  {
    // SerialNumber is not a reference
    return ((LightEmittingDiode)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)).getSerialNumber();
  }


  //
  // LightPath property storage

  public String getLightPathAnnotationRef(int imageIndex, int channelIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getLightPathDichroicRef(int imageIndex, int channelIndex)
  {
    // DichroicRef is reference and occurs only once
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedDichroic().getID();
  }

  public String getLightPathEmissionFilterRef(int imageIndex, int channelIndex, int emissionFilterRefIndex)
  {
    // EmissionFilterRef is reference and occurs more than once
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedEmissionFilter(emissionFilterRefIndex).getID();
  }

  public String getLightPathExcitationFilterRef(int imageIndex, int channelIndex, int excitationFilterRefIndex)
  {
    // ExcitationFilterRef is reference and occurs more than once
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath().getLinkedExcitationFilter(excitationFilterRefIndex).getID();
  }


  //
  // LightSourceSettings property storage

  public PercentFraction getChannelLightSourceSettingsAttenuation(int imageIndex, int channelIndex)
  {
    // Attenuation is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getAttenuation();
  }

  public PercentFraction getMicrobeamManipulationLightSourceSettingsAttenuation(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex)
  {
    // Attenuation is not a reference
    return root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getAttenuation();
  }

  public String getChannelLightSourceSettingsID(int imageIndex, int channelIndex)
  {
    // ID is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getID();
  }

  public String getMicrobeamManipulationLightSourceSettingsID(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex)
  {
    // ID is not a reference
    return root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getID();
  }

  public Length getChannelLightSourceSettingsWavelength(int imageIndex, int channelIndex)
  {
    // Wavelength is not a reference
    return root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightSourceSettings().getWavelength();
  }

  public Length getMicrobeamManipulationLightSourceSettingsWavelength(int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex)
  {
    // Wavelength is not a reference
    return root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLightSourceSettings(lightSourceSettingsIndex).getWavelength();
  }


  //
  // Line property storage

  public String getLineAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Color getLineFillColor(int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillColor();
  }

  public FillRule getLineFillRule(int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillRule();
  }

  public FontFamily getLineFontFamily(int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontFamily();
  }

  public Length getLineFontSize(int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontSize();
  }

  public FontStyle getLineFontStyle(int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontStyle();
  }

  public String getLineID(int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getID();
  }

  public Boolean getLineLocked(int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLocked();
  }

  public Marker getLineMarkerEnd(int ROIIndex, int shapeIndex)
  {
    // MarkerEnd is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getMarkerEnd();
  }

  public Marker getLineMarkerStart(int ROIIndex, int shapeIndex)
  {
    // MarkerStart is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getMarkerStart();
  }

  public Color getLineStrokeColor(int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeColor();
  }

  public String getLineStrokeDashArray(int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeDashArray();
  }

  public Length getLineStrokeWidth(int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeWidth();
  }

  public String getLineText(int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getText();
  }

  public NonNegativeInteger getLineTheC(int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheC();
  }

  public NonNegativeInteger getLineTheT(int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheT();
  }

  public NonNegativeInteger getLineTheZ(int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheZ();
  }

  public AffineTransform getLineTransform(int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTransform();
  }

  public Double getLineX1(int ROIIndex, int shapeIndex)
  {
    // X1 is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getX1();
  }

  public Double getLineX2(int ROIIndex, int shapeIndex)
  {
    // X2 is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getX2();
  }

  public Double getLineY1(int ROIIndex, int shapeIndex)
  {
    // Y1 is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getY1();
  }

  public Double getLineY2(int ROIIndex, int shapeIndex)
  {
    // Y2 is not a reference
    return ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getY2();
  }


  //
  // ListAnnotation property storage

  public String getListAnnotationAnnotationRef(int listAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getListAnnotationAnnotator(int listAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getAnnotator();
  }

  public String getListAnnotationDescription(int listAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getDescription();
  }

  public String getListAnnotationID(int listAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getID();
  }

  public String getListAnnotationNamespace(int listAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex).getNamespace();
  }


  //
  // LongAnnotation property storage

  public String getLongAnnotationAnnotationRef(int longAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getLongAnnotationAnnotator(int longAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getAnnotator();
  }

  public String getLongAnnotationDescription(int longAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getDescription();
  }

  public String getLongAnnotationID(int longAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getID();
  }

  public String getLongAnnotationNamespace(int longAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getNamespace();
  }

  public Long getLongAnnotationValue(int longAnnotationIndex)
  {
    // Value is not a reference
    return root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex).getValue();
  }


  //
  // Map property storage


  //
  // MapAnnotation property storage

  public String getMapAnnotationAnnotationRef(int mapAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getMapAnnotationAnnotator(int mapAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getAnnotator();
  }

  public String getMapAnnotationDescription(int mapAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getDescription();
  }

  public String getMapAnnotationID(int mapAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getID();
  }

  public String getMapAnnotationNamespace(int mapAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex).getNamespace();
  }


  //
  // Mask property storage

  public String getMaskAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Color getMaskFillColor(int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillColor();
  }

  public FillRule getMaskFillRule(int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillRule();
  }

  public FontFamily getMaskFontFamily(int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontFamily();
  }

  public Length getMaskFontSize(int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontSize();
  }

  public FontStyle getMaskFontStyle(int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontStyle();
  }

  public Double getMaskHeight(int ROIIndex, int shapeIndex)
  {
    // Height is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getHeight();
  }

  public String getMaskID(int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getID();
  }

  public Boolean getMaskLocked(int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLocked();
  }

  public Color getMaskStrokeColor(int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeColor();
  }

  public String getMaskStrokeDashArray(int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeDashArray();
  }

  public Length getMaskStrokeWidth(int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeWidth();
  }

  public String getMaskText(int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getText();
  }

  public NonNegativeInteger getMaskTheC(int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheC();
  }

  public NonNegativeInteger getMaskTheT(int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheT();
  }

  public NonNegativeInteger getMaskTheZ(int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheZ();
  }

  public AffineTransform getMaskTransform(int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTransform();
  }

  public Double getMaskWidth(int ROIIndex, int shapeIndex)
  {
    // Width is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getWidth();
  }

  public Double getMaskX(int ROIIndex, int shapeIndex)
  {
    // X is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getX();
  }

  public Double getMaskY(int ROIIndex, int shapeIndex)
  {
    // Y is not a reference
    return ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getY();
  }


  //
  // MetadataOnly property storage


  //
  // MicrobeamManipulation property storage

  public String getMicrobeamManipulationDescription(int experimentIndex, int microbeamManipulationIndex)
  {
    // Description is not a reference
    return root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getDescription();
  }

  public String getMicrobeamManipulationExperimenterRef(int experimentIndex, int microbeamManipulationIndex)
  {
    // ExperimenterRef is reference and occurs only once
    return root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLinkedExperimenter().getID();
  }

  public String getMicrobeamManipulationID(int experimentIndex, int microbeamManipulationIndex)
  {
    // ID is not a reference
    return root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getID();
  }

  public String getMicrobeamManipulationROIRef(int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex)
  {
    // ROIRef is reference and occurs more than once
    return root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getLinkedROI(ROIRefIndex).getID();
  }

  public MicrobeamManipulationType getMicrobeamManipulationType(int experimentIndex, int microbeamManipulationIndex)
  {
    // Type is not a reference
    return root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex).getType();
  }


  //
  // MicrobeamManipulationRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference MicrobeamManipulationRef


  //
  // Microscope property storage

  public String getMicroscopeLotNumber(int instrumentIndex)
  {
    // LotNumber is not a reference
    return root.getInstrument(instrumentIndex).getMicroscope().getLotNumber();
  }

  public String getMicroscopeManufacturer(int instrumentIndex)
  {
    // Manufacturer is not a reference
    return root.getInstrument(instrumentIndex).getMicroscope().getManufacturer();
  }

  public String getMicroscopeModel(int instrumentIndex)
  {
    // Model is not a reference
    return root.getInstrument(instrumentIndex).getMicroscope().getModel();
  }

  public String getMicroscopeSerialNumber(int instrumentIndex)
  {
    // SerialNumber is not a reference
    return root.getInstrument(instrumentIndex).getMicroscope().getSerialNumber();
  }

  public MicroscopeType getMicroscopeType(int instrumentIndex)
  {
    // Type is not a reference
    return root.getInstrument(instrumentIndex).getMicroscope().getType();
  }


  //
  // Objective property storage

  public String getObjectiveAnnotationRef(int instrumentIndex, int objectiveIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Double getObjectiveCalibratedMagnification(int instrumentIndex, int objectiveIndex)
  {
    // CalibratedMagnification is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getCalibratedMagnification();
  }

  public Correction getObjectiveCorrection(int instrumentIndex, int objectiveIndex)
  {
    // Correction is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getCorrection();
  }

  public String getObjectiveID(int instrumentIndex, int objectiveIndex)
  {
    // ID is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getID();
  }

  public Immersion getObjectiveImmersion(int instrumentIndex, int objectiveIndex)
  {
    // Immersion is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getImmersion();
  }

  public Boolean getObjectiveIris(int instrumentIndex, int objectiveIndex)
  {
    // Iris is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getIris();
  }

  public Double getObjectiveLensNA(int instrumentIndex, int objectiveIndex)
  {
    // LensNA is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getLensNA();
  }

  public String getObjectiveLotNumber(int instrumentIndex, int objectiveIndex)
  {
    // LotNumber is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getLotNumber();
  }

  public String getObjectiveManufacturer(int instrumentIndex, int objectiveIndex)
  {
    // Manufacturer is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getManufacturer();
  }

  public String getObjectiveModel(int instrumentIndex, int objectiveIndex)
  {
    // Model is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getModel();
  }

  public Double getObjectiveNominalMagnification(int instrumentIndex, int objectiveIndex)
  {
    // NominalMagnification is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getNominalMagnification();
  }

  public String getObjectiveSerialNumber(int instrumentIndex, int objectiveIndex)
  {
    // SerialNumber is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getSerialNumber();
  }

  public Length getObjectiveWorkingDistance(int instrumentIndex, int objectiveIndex)
  {
    // WorkingDistance is not a reference
    return root.getInstrument(instrumentIndex).getObjective(objectiveIndex).getWorkingDistance();
  }


  //
  // ObjectiveSettings property storage

  public Double getObjectiveSettingsCorrectionCollar(int imageIndex)
  {
    // CorrectionCollar is not a reference
    return root.getImage(imageIndex).getObjectiveSettings().getCorrectionCollar();
  }

  public String getObjectiveSettingsID(int imageIndex)
  {
    // ID is not a reference
    return root.getImage(imageIndex).getObjectiveSettings().getID();
  }

  public Medium getObjectiveSettingsMedium(int imageIndex)
  {
    // Medium is not a reference
    return root.getImage(imageIndex).getObjectiveSettings().getMedium();
  }

  public Double getObjectiveSettingsRefractiveIndex(int imageIndex)
  {
    // RefractiveIndex is not a reference
    return root.getImage(imageIndex).getObjectiveSettings().getRefractiveIndex();
  }


  //
  // Pixels property storage

  public Boolean getPixelsBigEndian(int imageIndex)
  {
    // BigEndian is not a reference
    return root.getImage(imageIndex).getPixels().getBigEndian();
  }

  public DimensionOrder getPixelsDimensionOrder(int imageIndex)
  {
    // DimensionOrder is not a reference
    return root.getImage(imageIndex).getPixels().getDimensionOrder();
  }

  public String getPixelsID(int imageIndex)
  {
    // ID is not a reference
    return root.getImage(imageIndex).getPixels().getID();
  }

  public Boolean getPixelsInterleaved(int imageIndex)
  {
    // Interleaved is not a reference
    return root.getImage(imageIndex).getPixels().getInterleaved();
  }

  public Length getPixelsPhysicalSizeX(int imageIndex)
  {
    // PhysicalSizeX is not a reference
    return root.getImage(imageIndex).getPixels().getPhysicalSizeX();
  }

  public Length getPixelsPhysicalSizeY(int imageIndex)
  {
    // PhysicalSizeY is not a reference
    return root.getImage(imageIndex).getPixels().getPhysicalSizeY();
  }

  public Length getPixelsPhysicalSizeZ(int imageIndex)
  {
    // PhysicalSizeZ is not a reference
    return root.getImage(imageIndex).getPixels().getPhysicalSizeZ();
  }

  public PositiveInteger getPixelsSignificantBits(int imageIndex)
  {
    // SignificantBits is not a reference
    return root.getImage(imageIndex).getPixels().getSignificantBits();
  }

  public PositiveInteger getPixelsSizeC(int imageIndex)
  {
    // SizeC is not a reference
    return root.getImage(imageIndex).getPixels().getSizeC();
  }

  public PositiveInteger getPixelsSizeT(int imageIndex)
  {
    // SizeT is not a reference
    return root.getImage(imageIndex).getPixels().getSizeT();
  }

  public PositiveInteger getPixelsSizeX(int imageIndex)
  {
    // SizeX is not a reference
    return root.getImage(imageIndex).getPixels().getSizeX();
  }

  public PositiveInteger getPixelsSizeY(int imageIndex)
  {
    // SizeY is not a reference
    return root.getImage(imageIndex).getPixels().getSizeY();
  }

  public PositiveInteger getPixelsSizeZ(int imageIndex)
  {
    // SizeZ is not a reference
    return root.getImage(imageIndex).getPixels().getSizeZ();
  }

  public Time getPixelsTimeIncrement(int imageIndex)
  {
    // TimeIncrement is not a reference
    return root.getImage(imageIndex).getPixels().getTimeIncrement();
  }

  public PixelType getPixelsType(int imageIndex)
  {
    // Type is not a reference
    return root.getImage(imageIndex).getPixels().getType();
  }


  //
  // Plane property storage

  public String getPlaneAnnotationRef(int imageIndex, int planeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Time getPlaneDeltaT(int imageIndex, int planeIndex)
  {
    // DeltaT is not a reference
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).getDeltaT();
  }

  public Time getPlaneExposureTime(int imageIndex, int planeIndex)
  {
    // ExposureTime is not a reference
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).getExposureTime();
  }

  public String getPlaneHashSHA1(int imageIndex, int planeIndex)
  {
    // HashSHA1 is not a reference
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).getHashSHA1();
  }

  public Length getPlanePositionX(int imageIndex, int planeIndex)
  {
    // PositionX is not a reference
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionX();
  }

  public Length getPlanePositionY(int imageIndex, int planeIndex)
  {
    // PositionY is not a reference
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionY();
  }

  public Length getPlanePositionZ(int imageIndex, int planeIndex)
  {
    // PositionZ is not a reference
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).getPositionZ();
  }

  public NonNegativeInteger getPlaneTheC(int imageIndex, int planeIndex)
  {
    // TheC is not a reference
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheC();
  }

  public NonNegativeInteger getPlaneTheT(int imageIndex, int planeIndex)
  {
    // TheT is not a reference
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheT();
  }

  public NonNegativeInteger getPlaneTheZ(int imageIndex, int planeIndex)
  {
    // TheZ is not a reference
    return root.getImage(imageIndex).getPixels().getPlane(planeIndex).getTheZ();
  }


  //
  // Plate property storage

  public String getPlateAnnotationRef(int plateIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getPlate(plateIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public NamingConvention getPlateColumnNamingConvention(int plateIndex)
  {
    // ColumnNamingConvention is not a reference
    return root.getPlate(plateIndex).getColumnNamingConvention();
  }

  public PositiveInteger getPlateColumns(int plateIndex)
  {
    // Columns is not a reference
    return root.getPlate(plateIndex).getColumns();
  }

  public String getPlateDescription(int plateIndex)
  {
    // Description is not a reference
    return root.getPlate(plateIndex).getDescription();
  }

  public String getPlateExternalIdentifier(int plateIndex)
  {
    // ExternalIdentifier is not a reference
    return root.getPlate(plateIndex).getExternalIdentifier();
  }

  public NonNegativeInteger getPlateFieldIndex(int plateIndex)
  {
    // FieldIndex is not a reference
    return root.getPlate(plateIndex).getFieldIndex();
  }

  public String getPlateID(int plateIndex)
  {
    // ID is not a reference
    return root.getPlate(plateIndex).getID();
  }

  public String getPlateName(int plateIndex)
  {
    // Name is not a reference
    return root.getPlate(plateIndex).getName();
  }

  public NamingConvention getPlateRowNamingConvention(int plateIndex)
  {
    // RowNamingConvention is not a reference
    return root.getPlate(plateIndex).getRowNamingConvention();
  }

  public PositiveInteger getPlateRows(int plateIndex)
  {
    // Rows is not a reference
    return root.getPlate(plateIndex).getRows();
  }

  public String getPlateStatus(int plateIndex)
  {
    // Status is not a reference
    return root.getPlate(plateIndex).getStatus();
  }

  public Length getPlateWellOriginX(int plateIndex)
  {
    // WellOriginX is not a reference
    return root.getPlate(plateIndex).getWellOriginX();
  }

  public Length getPlateWellOriginY(int plateIndex)
  {
    // WellOriginY is not a reference
    return root.getPlate(plateIndex).getWellOriginY();
  }


  //
  // PlateAcquisition property storage

  public String getPlateAcquisitionAnnotationRef(int plateIndex, int plateAcquisitionIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getPlateAcquisitionDescription(int plateIndex, int plateAcquisitionIndex)
  {
    // Description is not a reference
    return root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getDescription();
  }

  public Timestamp getPlateAcquisitionEndTime(int plateIndex, int plateAcquisitionIndex)
  {
    // EndTime is not a reference
    return root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getEndTime();
  }

  public String getPlateAcquisitionID(int plateIndex, int plateAcquisitionIndex)
  {
    // ID is not a reference
    return root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getID();
  }

  public PositiveInteger getPlateAcquisitionMaximumFieldCount(int plateIndex, int plateAcquisitionIndex)
  {
    // MaximumFieldCount is not a reference
    return root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getMaximumFieldCount();
  }

  public String getPlateAcquisitionName(int plateIndex, int plateAcquisitionIndex)
  {
    // Name is not a reference
    return root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getName();
  }

  public Timestamp getPlateAcquisitionStartTime(int plateIndex, int plateAcquisitionIndex)
  {
    // StartTime is not a reference
    return root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getStartTime();
  }

  public String getPlateAcquisitionWellSampleRef(int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex)
  {
    // WellSampleRef is reference and occurs more than once
    return root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex).getLinkedWellSample(wellSampleRefIndex).getID();
  }


  //
  // PlateRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference PlateRef


  //
  // Point property storage

  public String getPointAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Color getPointFillColor(int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillColor();
  }

  public FillRule getPointFillRule(int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillRule();
  }

  public FontFamily getPointFontFamily(int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontFamily();
  }

  public Length getPointFontSize(int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontSize();
  }

  public FontStyle getPointFontStyle(int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontStyle();
  }

  public String getPointID(int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getID();
  }

  public Boolean getPointLocked(int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLocked();
  }

  public Color getPointStrokeColor(int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeColor();
  }

  public String getPointStrokeDashArray(int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeDashArray();
  }

  public Length getPointStrokeWidth(int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeWidth();
  }

  public String getPointText(int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getText();
  }

  public NonNegativeInteger getPointTheC(int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheC();
  }

  public NonNegativeInteger getPointTheT(int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheT();
  }

  public NonNegativeInteger getPointTheZ(int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheZ();
  }

  public AffineTransform getPointTransform(int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTransform();
  }

  public Double getPointX(int ROIIndex, int shapeIndex)
  {
    // X is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getX();
  }

  public Double getPointY(int ROIIndex, int shapeIndex)
  {
    // Y is not a reference
    return ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getY();
  }


  //
  // Polygon property storage

  public String getPolygonAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Color getPolygonFillColor(int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillColor();
  }

  public FillRule getPolygonFillRule(int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillRule();
  }

  public FontFamily getPolygonFontFamily(int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontFamily();
  }

  public Length getPolygonFontSize(int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontSize();
  }

  public FontStyle getPolygonFontStyle(int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontStyle();
  }

  public String getPolygonID(int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getID();
  }

  public Boolean getPolygonLocked(int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLocked();
  }

  public String getPolygonPoints(int ROIIndex, int shapeIndex)
  {
    // Points is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getPoints();
  }

  public Color getPolygonStrokeColor(int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeColor();
  }

  public String getPolygonStrokeDashArray(int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeDashArray();
  }

  public Length getPolygonStrokeWidth(int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeWidth();
  }

  public String getPolygonText(int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getText();
  }

  public NonNegativeInteger getPolygonTheC(int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheC();
  }

  public NonNegativeInteger getPolygonTheT(int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheT();
  }

  public NonNegativeInteger getPolygonTheZ(int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheZ();
  }

  public AffineTransform getPolygonTransform(int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    return ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTransform();
  }


  //
  // Polyline property storage

  public String getPolylineAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Color getPolylineFillColor(int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillColor();
  }

  public FillRule getPolylineFillRule(int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillRule();
  }

  public FontFamily getPolylineFontFamily(int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontFamily();
  }

  public Length getPolylineFontSize(int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontSize();
  }

  public FontStyle getPolylineFontStyle(int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontStyle();
  }

  public String getPolylineID(int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getID();
  }

  public Boolean getPolylineLocked(int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLocked();
  }

  public Marker getPolylineMarkerEnd(int ROIIndex, int shapeIndex)
  {
    // MarkerEnd is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getMarkerEnd();
  }

  public Marker getPolylineMarkerStart(int ROIIndex, int shapeIndex)
  {
    // MarkerStart is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getMarkerStart();
  }

  public String getPolylinePoints(int ROIIndex, int shapeIndex)
  {
    // Points is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getPoints();
  }

  public Color getPolylineStrokeColor(int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeColor();
  }

  public String getPolylineStrokeDashArray(int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeDashArray();
  }

  public Length getPolylineStrokeWidth(int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeWidth();
  }

  public String getPolylineText(int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getText();
  }

  public NonNegativeInteger getPolylineTheC(int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheC();
  }

  public NonNegativeInteger getPolylineTheT(int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheT();
  }

  public NonNegativeInteger getPolylineTheZ(int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheZ();
  }

  public AffineTransform getPolylineTransform(int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    return ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTransform();
  }


  //
  // Project property storage

  public String getProjectAnnotationRef(int projectIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getProject(projectIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getProjectDatasetRef(int projectIndex, int datasetRefIndex)
  {
    // DatasetRef is reference and occurs more than once
    return root.getProject(projectIndex).getLinkedDataset(datasetRefIndex).getID();
  }

  public String getProjectDescription(int projectIndex)
  {
    // Description is not a reference
    return root.getProject(projectIndex).getDescription();
  }

  public String getProjectExperimenterGroupRef(int projectIndex)
  {
    // ExperimenterGroupRef is reference and occurs only once
    return root.getProject(projectIndex).getLinkedExperimenterGroup().getID();
  }

  public String getProjectExperimenterRef(int projectIndex)
  {
    // ExperimenterRef is reference and occurs only once
    return root.getProject(projectIndex).getLinkedExperimenter().getID();
  }

  public String getProjectID(int projectIndex)
  {
    // ID is not a reference
    return root.getProject(projectIndex).getID();
  }

  public String getProjectName(int projectIndex)
  {
    // Name is not a reference
    return root.getProject(projectIndex).getName();
  }


  //
  // Pump property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference Pump

  // 0:9999
  // Is multi path? False
  // Ignoring Laser_BackReference property of reference Pump


  //
  // ROI property storage

  public String getROIAnnotationRef(int ROIIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getROI(ROIIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getROIDescription(int ROIIndex)
  {
    // Description is not a reference
    return root.getROI(ROIIndex).getDescription();
  }

  public String getROIID(int ROIIndex)
  {
    // ID is not a reference
    return root.getROI(ROIIndex).getID();
  }

  public String getROIName(int ROIIndex)
  {
    // Name is not a reference
    return root.getROI(ROIIndex).getName();
  }


  //
  // ROIRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference ROIRef


  //
  // Reagent property storage

  public String getReagentAnnotationRef(int screenIndex, int reagentIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getScreen(screenIndex).getReagent(reagentIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getReagentDescription(int screenIndex, int reagentIndex)
  {
    // Description is not a reference
    return root.getScreen(screenIndex).getReagent(reagentIndex).getDescription();
  }

  public String getReagentID(int screenIndex, int reagentIndex)
  {
    // ID is not a reference
    return root.getScreen(screenIndex).getReagent(reagentIndex).getID();
  }

  public String getReagentName(int screenIndex, int reagentIndex)
  {
    // Name is not a reference
    return root.getScreen(screenIndex).getReagent(reagentIndex).getName();
  }

  public String getReagentReagentIdentifier(int screenIndex, int reagentIndex)
  {
    // ReagentIdentifier is not a reference
    return root.getScreen(screenIndex).getReagent(reagentIndex).getReagentIdentifier();
  }


  //
  // ReagentRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference ReagentRef


  //
  // Rectangle property storage

  public String getRectangleAnnotationRef(int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Color getRectangleFillColor(int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillColor();
  }

  public FillRule getRectangleFillRule(int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFillRule();
  }

  public FontFamily getRectangleFontFamily(int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontFamily();
  }

  public Length getRectangleFontSize(int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontSize();
  }

  public FontStyle getRectangleFontStyle(int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getFontStyle();
  }

  public Double getRectangleHeight(int ROIIndex, int shapeIndex)
  {
    // Height is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getHeight();
  }

  public String getRectangleID(int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getID();
  }

  public Boolean getRectangleLocked(int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getLocked();
  }

  public Color getRectangleStrokeColor(int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeColor();
  }

  public String getRectangleStrokeDashArray(int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeDashArray();
  }

  public Length getRectangleStrokeWidth(int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getStrokeWidth();
  }

  public String getRectangleText(int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getText();
  }

  public NonNegativeInteger getRectangleTheC(int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheC();
  }

  public NonNegativeInteger getRectangleTheT(int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheT();
  }

  public NonNegativeInteger getRectangleTheZ(int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTheZ();
  }

  public AffineTransform getRectangleTransform(int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getTransform();
  }

  public Double getRectangleWidth(int ROIIndex, int shapeIndex)
  {
    // Width is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getWidth();
  }

  public Double getRectangleX(int ROIIndex, int shapeIndex)
  {
    // X is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getX();
  }

  public Double getRectangleY(int ROIIndex, int shapeIndex)
  {
    // Y is not a reference
    return ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)).getY();
  }


  //
  // Rights property storage

  public String getRightsRightsHeld()
  {
    // RightsHeld is not a reference
    return root.getRights().getRightsHeld();
  }

  public String getRightsRightsHolder()
  {
    // RightsHolder is not a reference
    return root.getRights().getRightsHolder();
  }


  //
  // Screen property storage

  public String getScreenAnnotationRef(int screenIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getScreen(screenIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getScreenDescription(int screenIndex)
  {
    // Description is not a reference
    return root.getScreen(screenIndex).getDescription();
  }

  public String getScreenID(int screenIndex)
  {
    // ID is not a reference
    return root.getScreen(screenIndex).getID();
  }

  public String getScreenName(int screenIndex)
  {
    // Name is not a reference
    return root.getScreen(screenIndex).getName();
  }

  public String getScreenPlateRef(int screenIndex, int plateRefIndex)
  {
    // PlateRef is reference and occurs more than once
    return root.getScreen(screenIndex).getLinkedPlate(plateRefIndex).getID();
  }

  public String getScreenProtocolDescription(int screenIndex)
  {
    // ProtocolDescription is not a reference
    return root.getScreen(screenIndex).getProtocolDescription();
  }

  public String getScreenProtocolIdentifier(int screenIndex)
  {
    // ProtocolIdentifier is not a reference
    return root.getScreen(screenIndex).getProtocolIdentifier();
  }

  public String getScreenReagentSetDescription(int screenIndex)
  {
    // ReagentSetDescription is not a reference
    return root.getScreen(screenIndex).getReagentSetDescription();
  }

  public String getScreenReagentSetIdentifier(int screenIndex)
  {
    // ReagentSetIdentifier is not a reference
    return root.getScreen(screenIndex).getReagentSetIdentifier();
  }

  public String getScreenType(int screenIndex)
  {
    // Type is not a reference
    return root.getScreen(screenIndex).getType();
  }


  //
  // StageLabel property storage

  public String getStageLabelName(int imageIndex)
  {
    // Name is not a reference
    return root.getImage(imageIndex).getStageLabel().getName();
  }

  public Length getStageLabelX(int imageIndex)
  {
    // X is not a reference
    return root.getImage(imageIndex).getStageLabel().getX();
  }

  public Length getStageLabelY(int imageIndex)
  {
    // Y is not a reference
    return root.getImage(imageIndex).getStageLabel().getY();
  }

  public Length getStageLabelZ(int imageIndex)
  {
    // Z is not a reference
    return root.getImage(imageIndex).getStageLabel().getZ();
  }


  //
  // StructuredAnnotations property storage


  //
  // TagAnnotation property storage

  public String getTagAnnotationAnnotationRef(int tagAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getTagAnnotationAnnotator(int tagAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getAnnotator();
  }

  public String getTagAnnotationDescription(int tagAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getDescription();
  }

  public String getTagAnnotationID(int tagAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getID();
  }

  public String getTagAnnotationNamespace(int tagAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getNamespace();
  }

  public String getTagAnnotationValue(int tagAnnotationIndex)
  {
    // Value is not a reference
    return root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex).getValue();
  }


  //
  // TermAnnotation property storage

  public String getTermAnnotationAnnotationRef(int termAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getTermAnnotationAnnotator(int termAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getAnnotator();
  }

  public String getTermAnnotationDescription(int termAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getDescription();
  }

  public String getTermAnnotationID(int termAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getID();
  }

  public String getTermAnnotationNamespace(int termAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getNamespace();
  }

  public String getTermAnnotationValue(int termAnnotationIndex)
  {
    // Value is not a reference
    return root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex).getValue();
  }


  //
  // TiffData property storage

  public NonNegativeInteger getTiffDataFirstC(int imageIndex, int tiffDataIndex)
  {
    // FirstC is not a reference
    return root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstC();
  }

  public NonNegativeInteger getTiffDataFirstT(int imageIndex, int tiffDataIndex)
  {
    // FirstT is not a reference
    return root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstT();
  }

  public NonNegativeInteger getTiffDataFirstZ(int imageIndex, int tiffDataIndex)
  {
    // FirstZ is not a reference
    return root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getFirstZ();
  }

  public NonNegativeInteger getTiffDataIFD(int imageIndex, int tiffDataIndex)
  {
    // IFD is not a reference
    return root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getIFD();
  }

  public NonNegativeInteger getTiffDataPlaneCount(int imageIndex, int tiffDataIndex)
  {
    // PlaneCount is not a reference
    return root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getPlaneCount();
  }


  //
  // TimestampAnnotation property storage

  public String getTimestampAnnotationAnnotationRef(int timestampAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getTimestampAnnotationAnnotator(int timestampAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getAnnotator();
  }

  public String getTimestampAnnotationDescription(int timestampAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getDescription();
  }

  public String getTimestampAnnotationID(int timestampAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getID();
  }

  public String getTimestampAnnotationNamespace(int timestampAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getNamespace();
  }

  public Timestamp getTimestampAnnotationValue(int timestampAnnotationIndex)
  {
    // Value is not a reference
    return root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex).getValue();
  }


  //
  // TransmittanceRange property storage

  public Length getTransmittanceRangeCutIn(int instrumentIndex, int filterIndex)
  {
    // CutIn is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutIn();
  }

  public Length getTransmittanceRangeCutInTolerance(int instrumentIndex, int filterIndex)
  {
    // CutInTolerance is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutInTolerance();
  }

  public Length getTransmittanceRangeCutOut(int instrumentIndex, int filterIndex)
  {
    // CutOut is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutOut();
  }

  public Length getTransmittanceRangeCutOutTolerance(int instrumentIndex, int filterIndex)
  {
    // CutOutTolerance is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getCutOutTolerance();
  }

  public PercentFraction getTransmittanceRangeTransmittance(int instrumentIndex, int filterIndex)
  {
    // Transmittance is not a reference
    return root.getInstrument(instrumentIndex).getFilter(filterIndex).getTransmittanceRange().getTransmittance();
  }


  //
  // UUID property storage

  public String getUUIDFileName(int imageIndex, int tiffDataIndex)
  {
    // FileName is not a reference
    return root.getImage(imageIndex).getPixels().getTiffData(tiffDataIndex).getUUID().getFileName();
  }


  //
  // Union property storage


  //
  // Well property storage

  public String getWellAnnotationRef(int plateIndex, int wellIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getPlate(plateIndex).getWell(wellIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public Color getWellColor(int plateIndex, int wellIndex)
  {
    // Color is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getColor();
  }

  public NonNegativeInteger getWellColumn(int plateIndex, int wellIndex)
  {
    // Column is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getColumn();
  }

  public String getWellExternalDescription(int plateIndex, int wellIndex)
  {
    // ExternalDescription is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getExternalDescription();
  }

  public String getWellExternalIdentifier(int plateIndex, int wellIndex)
  {
    // ExternalIdentifier is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getExternalIdentifier();
  }

  public String getWellID(int plateIndex, int wellIndex)
  {
    // ID is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getID();
  }

  public String getWellReagentRef(int plateIndex, int wellIndex)
  {
    // ReagentRef is reference and occurs only once
    return root.getPlate(plateIndex).getWell(wellIndex).getLinkedReagent().getID();
  }

  public NonNegativeInteger getWellRow(int plateIndex, int wellIndex)
  {
    // Row is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getRow();
  }

  public String getWellType(int plateIndex, int wellIndex)
  {
    // Type is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getType();
  }


  //
  // WellSample property storage

  public String getWellSampleID(int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // ID is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getID();
  }

  public String getWellSampleImageRef(int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // ImageRef is reference and occurs only once
    return root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getLinkedImage().getID();
  }

  public NonNegativeInteger getWellSampleIndex(int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // Index is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getIndex();
  }

  public Length getWellSamplePositionX(int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // PositionX is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getPositionX();
  }

  public Length getWellSamplePositionY(int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // PositionY is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getPositionY();
  }

  public Timestamp getWellSampleTimepoint(int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // Timepoint is not a reference
    return root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex).getTimepoint();
  }


  //
  // WellSampleRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference WellSampleRef


  //
  // XMLAnnotation property storage

  public String getXMLAnnotationAnnotationRef(int XMLAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    return root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getLinkedAnnotation(annotationRefIndex).getID();
  }

  public String getXMLAnnotationAnnotator(int XMLAnnotationIndex)
  {
    // Annotator is not a reference
    return root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getAnnotator();
  }

  public String getXMLAnnotationDescription(int XMLAnnotationIndex)
  {
    // Description is not a reference
    return root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getDescription();
  }

  public String getXMLAnnotationID(int XMLAnnotationIndex)
  {
    // ID is not a reference
    return root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getID();
  }

  public String getXMLAnnotationNamespace(int XMLAnnotationIndex)
  {
    // Namespace is not a reference
    return root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getNamespace();
  }

  public String getXMLAnnotationValue(int XMLAnnotationIndex)
  {
    // Value is not a reference
    return root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex).getValue();
  }


  // -- Entity storage (manual definitions) --

  /** Sets the UUID associated with this collection of metadata. */
  public void setUUID(String uuid)
  {
    root.setUUID(uuid);
  }

  /** Sets the Creator associated with this collection of metadata. */
  public void setCreator(String creator)
  {
    root.setCreator(creator);
  }

  /** Sets the Map value associated with this annotation */
  public void setMapAnnotationValue(List<MapPair> value, int mapAnnotationIndex)
  {
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfMapAnnotationList() == mapAnnotationIndex)
    {
      o1.addMapAnnotation(new MapAnnotation());
    }
    MapAnnotation o2 = o1.getMapAnnotation(mapAnnotationIndex);
    o2.setValue(value);
  }

  /** Sets the Map value associated with this generic light source */
  public void setGenericExcitationSourceMap(List<MapPair> map, int instrumentIndex, int lightSourceIndex)
  {
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new GenericExcitationSource());
    }
    LightSource o2 = o1.getLightSource(lightSourceIndex);
    ((GenericExcitationSource)o2).setMap(map);
  }

  /** Sets the Map value associated with this imaging environment */
  public void setImagingEnvironmentMap(List<MapPair> map, int imageIndex)
  {
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getImagingEnvironment() == null)
    {
      o1.setImagingEnvironment(new ImagingEnvironment());
    }
    ImagingEnvironment o2 = o1.getImagingEnvironment();
    o2.setMap(map);
  }

  // -- Entity storage (code generated definitions) --


  //
  // AnnotationRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference AnnotationRef


  //
  // Arc property storage

  public void setArcAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Arc concreteObject = ((Arc)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Arc)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)),
        annotationLinks_reference);
    }
  }

  public void setArcID(String id, int instrumentIndex, int lightSourceIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Arc());
    }
    Arc o2 = (Arc) o1.getLightSource(lightSourceIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setArcLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Arc());
    }
    Arc o2 = (Arc) o1.getLightSource(lightSourceIndex);
    o2.setLotNumber(lotNumber);
  }

  public void setArcManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Arc());
    }
    Arc o2 = (Arc) o1.getLightSource(lightSourceIndex);
    o2.setManufacturer(manufacturer);
  }

  public void setArcModel(String model, int instrumentIndex, int lightSourceIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Arc());
    }
    Arc o2 = (Arc) o1.getLightSource(lightSourceIndex);
    o2.setModel(model);
  }

  public void setArcPower(Power power, int instrumentIndex, int lightSourceIndex)
  {
    // Power is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Arc());
    }
    Arc o2 = (Arc) o1.getLightSource(lightSourceIndex);
    o2.setPower(power);
  }

  public void setArcSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Arc());
    }
    Arc o2 = (Arc) o1.getLightSource(lightSourceIndex);
    o2.setSerialNumber(serialNumber);
  }

  public void setArcType(ArcType type, int instrumentIndex, int lightSourceIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Arc());
    }
    Arc o2 = (Arc) o1.getLightSource(lightSourceIndex);
    o2.setType(type);
  }


  //
  // BinData property storage

  public void setBinaryFileBinData(byte[] base64Binary, int fileAnnotationIndex)
  {
    // Base64Binary is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    if (o2.getBinaryFile() == null)
    {
      o2.setBinaryFile(new BinaryFile());
    }
    BinaryFile o3 = o2.getBinaryFile();
    if (o3.getBinData() == null)
    {
      o3.setBinData(new BinData());
    }
    BinData o4 = o3.getBinData();
    o4.setBase64Binary(base64Binary);
  }

  public void setMaskBinData(byte[] base64Binary, int ROIIndex, int shapeIndex)
  {
    // Base64Binary is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    if (o3.getBinData() == null)
    {
      o3.setBinData(new BinData());
    }
    BinData o4 = o3.getBinData();
    o4.setBase64Binary(base64Binary);
  }

  public void setPixelsBinData(byte[] base64Binary, int imageIndex, int binDataIndex)
  {
    // Base64Binary is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfBinDataList() == binDataIndex)
    {
      o2.addBinData(new BinData());
    }
    BinData o3 = o2.getBinData(binDataIndex);
    o3.setBase64Binary(base64Binary);
  }

  public void setBinaryFileBinDataBigEndian(Boolean bigEndian, int fileAnnotationIndex)
  {
    // BigEndian is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    if (o2.getBinaryFile() == null)
    {
      o2.setBinaryFile(new BinaryFile());
    }
    BinaryFile o3 = o2.getBinaryFile();
    if (o3.getBinData() == null)
    {
      o3.setBinData(new BinData());
    }
    BinData o4 = o3.getBinData();
    o4.setBigEndian(bigEndian);
  }

  public void setMaskBinDataBigEndian(Boolean bigEndian, int ROIIndex, int shapeIndex)
  {
    // BigEndian is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    if (o3.getBinData() == null)
    {
      o3.setBinData(new BinData());
    }
    BinData o4 = o3.getBinData();
    o4.setBigEndian(bigEndian);
  }

  public void setPixelsBinDataBigEndian(Boolean bigEndian, int imageIndex, int binDataIndex)
  {
    // BigEndian is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfBinDataList() == binDataIndex)
    {
      o2.addBinData(new BinData());
    }
    BinData o3 = o2.getBinData(binDataIndex);
    o3.setBigEndian(bigEndian);
  }

  public void setBinaryFileBinDataCompression(Compression compression, int fileAnnotationIndex)
  {
    // Compression is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    if (o2.getBinaryFile() == null)
    {
      o2.setBinaryFile(new BinaryFile());
    }
    BinaryFile o3 = o2.getBinaryFile();
    if (o3.getBinData() == null)
    {
      o3.setBinData(new BinData());
    }
    BinData o4 = o3.getBinData();
    o4.setCompression(compression);
  }

  public void setMaskBinDataCompression(Compression compression, int ROIIndex, int shapeIndex)
  {
    // Compression is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    if (o3.getBinData() == null)
    {
      o3.setBinData(new BinData());
    }
    BinData o4 = o3.getBinData();
    o4.setCompression(compression);
  }

  public void setPixelsBinDataCompression(Compression compression, int imageIndex, int binDataIndex)
  {
    // Compression is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfBinDataList() == binDataIndex)
    {
      o2.addBinData(new BinData());
    }
    BinData o3 = o2.getBinData(binDataIndex);
    o3.setCompression(compression);
  }

  public void setBinaryFileBinDataLength(NonNegativeLong length, int fileAnnotationIndex)
  {
    // Length is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    if (o2.getBinaryFile() == null)
    {
      o2.setBinaryFile(new BinaryFile());
    }
    BinaryFile o3 = o2.getBinaryFile();
    if (o3.getBinData() == null)
    {
      o3.setBinData(new BinData());
    }
    BinData o4 = o3.getBinData();
    o4.setLength(length);
  }

  public void setMaskBinDataLength(NonNegativeLong length, int ROIIndex, int shapeIndex)
  {
    // Length is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    if (o3.getBinData() == null)
    {
      o3.setBinData(new BinData());
    }
    BinData o4 = o3.getBinData();
    o4.setLength(length);
  }

  public void setPixelsBinDataLength(NonNegativeLong length, int imageIndex, int binDataIndex)
  {
    // Length is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfBinDataList() == binDataIndex)
    {
      o2.addBinData(new BinData());
    }
    BinData o3 = o2.getBinData(binDataIndex);
    o3.setLength(length);
  }


  //
  // BinaryFile property storage

  public void setBinaryFileFileName(String fileName, int fileAnnotationIndex)
  {
    // FileName is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    if (o2.getBinaryFile() == null)
    {
      o2.setBinaryFile(new BinaryFile());
    }
    BinaryFile o3 = o2.getBinaryFile();
    o3.setFileName(fileName);
  }

  public void setBinaryFileMIMEType(String mimeType, int fileAnnotationIndex)
  {
    // MIMEType is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    if (o2.getBinaryFile() == null)
    {
      o2.setBinaryFile(new BinaryFile());
    }
    BinaryFile o3 = o2.getBinaryFile();
    o3.setMIMEType(mimeType);
  }

  public void setBinaryFileSize(NonNegativeLong size, int fileAnnotationIndex)
  {
    // Size is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    if (o2.getBinaryFile() == null)
    {
      o2.setBinaryFile(new BinaryFile());
    }
    BinaryFile o3 = o2.getBinaryFile();
    o3.setSize(size);
  }


  //
  // BinaryOnly property storage

  public void setBinaryOnlyMetadataFile(String metadataFile)
  {
    // MetadataFile is not a reference
    OME o0 = root;
    if (o0.getBinaryOnly() == null)
    {
      o0.setBinaryOnly(new BinaryOnly());
    }
    BinaryOnly o1 = o0.getBinaryOnly();
    o1.setMetadataFile(metadataFile);
  }

  public void setBinaryOnlyUUID(String uuid)
  {
    // UUID is not a reference
    OME o0 = root;
    if (o0.getBinaryOnly() == null)
    {
      o0.setBinaryOnly(new BinaryOnly());
    }
    BinaryOnly o1 = o0.getBinaryOnly();
    o1.setUUID(uuid);
  }


  //
  // BooleanAnnotation property storage

  public void setBooleanAnnotationAnnotationRef(String annotation, int booleanAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      BooleanAnnotation concreteObject = root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getBooleanAnnotation(booleanAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setBooleanAnnotationAnnotator(String annotator, int booleanAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfBooleanAnnotationList() == booleanAnnotationIndex)
    {
      o1.addBooleanAnnotation(new BooleanAnnotation());
    }
    BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setBooleanAnnotationDescription(String description, int booleanAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfBooleanAnnotationList() == booleanAnnotationIndex)
    {
      o1.addBooleanAnnotation(new BooleanAnnotation());
    }
    BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
    o2.setDescription(description);
  }

  public void setBooleanAnnotationID(String id, int booleanAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfBooleanAnnotationList() == booleanAnnotationIndex)
    {
      o1.addBooleanAnnotation(new BooleanAnnotation());
    }
    BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setBooleanAnnotationNamespace(String namespace, int booleanAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfBooleanAnnotationList() == booleanAnnotationIndex)
    {
      o1.addBooleanAnnotation(new BooleanAnnotation());
    }
    BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
    o2.setNamespace(namespace);
  }

  public void setBooleanAnnotationValue(Boolean value, int booleanAnnotationIndex)
  {
    // Value is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfBooleanAnnotationList() == booleanAnnotationIndex)
    {
      o1.addBooleanAnnotation(new BooleanAnnotation());
    }
    BooleanAnnotation o2 = o1.getBooleanAnnotation(booleanAnnotationIndex);
    o2.setValue(value);
  }


  //
  // Channel property storage

  public void setChannelAcquisitionMode(AcquisitionMode acquisitionMode, int imageIndex, int channelIndex)
  {
    // AcquisitionMode is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setAcquisitionMode(acquisitionMode);
  }

  public void setChannelAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Channel concreteObject = root.getImage(imageIndex).getPixels().getChannel(channelIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getImage(imageIndex).getPixels().getChannel(channelIndex),
        annotationLinks_reference);
    }
  }

  public void setChannelColor(Color color, int imageIndex, int channelIndex)
  {
    // Color is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setColor(color);
  }

  public void setChannelContrastMethod(ContrastMethod contrastMethod, int imageIndex, int channelIndex)
  {
    // ContrastMethod is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setContrastMethod(contrastMethod);
  }

  public void setChannelEmissionWavelength(Length emissionWavelength, int imageIndex, int channelIndex)
  {
    // EmissionWavelength is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setEmissionWavelength(emissionWavelength);
  }

  public void setChannelExcitationWavelength(Length excitationWavelength, int imageIndex, int channelIndex)
  {
    // ExcitationWavelength is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setExcitationWavelength(excitationWavelength);
  }

  public void setChannelFilterSetRef(String filterSet, int imageIndex, int channelIndex)
  {
    // FilterSetRef is reference and occurs more than once
    FilterSetRef filterSet_reference = new FilterSetRef();
    filterSet_reference.setID(filterSet);
    model.addReference(
      root.getImage(imageIndex).getPixels().getChannel(channelIndex),
      filterSet_reference);
  }

  public void setChannelFluor(String fluor, int imageIndex, int channelIndex)
  {
    // Fluor is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setFluor(fluor);
  }

  public void setChannelID(String id, int imageIndex, int channelIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
    if (o3.getLightPath() == null)
    {
      o3.setLightPath(new LightPath());
    }

  }

  public void setChannelIlluminationType(IlluminationType illuminationType, int imageIndex, int channelIndex)
  {
    // IlluminationType is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setIlluminationType(illuminationType);
  }

  public void setChannelNDFilter(Double ndFilter, int imageIndex, int channelIndex)
  {
    // NDFilter is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setNDFilter(ndFilter);
  }

  public void setChannelName(String name, int imageIndex, int channelIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setName(name);
  }

  public void setChannelPinholeSize(Length pinholeSize, int imageIndex, int channelIndex)
  {
    // PinholeSize is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setPinholeSize(pinholeSize);
  }

  public void setChannelPockelCellSetting(Integer pockelCellSetting, int imageIndex, int channelIndex)
  {
    // PockelCellSetting is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setPockelCellSetting(pockelCellSetting);
  }

  public void setChannelSamplesPerPixel(PositiveInteger samplesPerPixel, int imageIndex, int channelIndex)
  {
    // SamplesPerPixel is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    o3.setSamplesPerPixel(samplesPerPixel);
  }


  //
  // CommentAnnotation property storage

  public void setCommentAnnotationAnnotationRef(String annotation, int commentAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      CommentAnnotation concreteObject = root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getCommentAnnotation(commentAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setCommentAnnotationAnnotator(String annotator, int commentAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfCommentAnnotationList() == commentAnnotationIndex)
    {
      o1.addCommentAnnotation(new CommentAnnotation());
    }
    CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setCommentAnnotationDescription(String description, int commentAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfCommentAnnotationList() == commentAnnotationIndex)
    {
      o1.addCommentAnnotation(new CommentAnnotation());
    }
    CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
    o2.setDescription(description);
  }

  public void setCommentAnnotationID(String id, int commentAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfCommentAnnotationList() == commentAnnotationIndex)
    {
      o1.addCommentAnnotation(new CommentAnnotation());
    }
    CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setCommentAnnotationNamespace(String namespace, int commentAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfCommentAnnotationList() == commentAnnotationIndex)
    {
      o1.addCommentAnnotation(new CommentAnnotation());
    }
    CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
    o2.setNamespace(namespace);
  }

  public void setCommentAnnotationValue(String value, int commentAnnotationIndex)
  {
    // Value is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfCommentAnnotationList() == commentAnnotationIndex)
    {
      o1.addCommentAnnotation(new CommentAnnotation());
    }
    CommentAnnotation o2 = o1.getCommentAnnotation(commentAnnotationIndex);
    o2.setValue(value);
  }


  //
  // Dataset property storage

  public void setDatasetAnnotationRef(String annotation, int datasetIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Dataset concreteObject = root.getDataset(datasetIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getDataset(datasetIndex),
        annotationLinks_reference);
    }
  }

  public void setDatasetDescription(String description, int datasetIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfDatasetList() == datasetIndex)
    {
      o0.addDataset(new Dataset());
    }
    Dataset o1 = o0.getDataset(datasetIndex);
    o1.setDescription(description);
  }

  public void setDatasetExperimenterGroupRef(String experimenterGroup, int datasetIndex)
  {
    // ExperimenterGroupRef is reference and occurs more than once
    ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
    experimenterGroup_reference.setID(experimenterGroup);
    model.addReference(
      root.getDataset(datasetIndex),
      experimenterGroup_reference);
  }

  public void setDatasetExperimenterRef(String experimenter, int datasetIndex)
  {
    // ExperimenterRef is reference and occurs more than once
    ExperimenterRef experimenter_reference = new ExperimenterRef();
    experimenter_reference.setID(experimenter);
    model.addReference(
      root.getDataset(datasetIndex),
      experimenter_reference);
  }

  public void setDatasetID(String id, int datasetIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfDatasetList() == datasetIndex)
    {
      o0.addDataset(new Dataset());
    }
    Dataset o1 = o0.getDataset(datasetIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }

  public void setDatasetImageRef(String image, int datasetIndex, int imageRefIndex)
  {
    // ImageRef is reference and occurs more than once
    ImageRef imageLinks_reference = new ImageRef();
    imageLinks_reference.setID(image);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(image);
    if (referencedObj != null && referencedObj instanceof Image)
    {
      Image typedRef = (Image) referencedObj;
      Dataset concreteObject = root.getDataset(datasetIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedImageList() == imageRefIndex)
      {
        concreteObject.linkImage(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedImage(imageRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getDataset(datasetIndex),
        imageLinks_reference);
    }
  }

  public void setDatasetName(String name, int datasetIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfDatasetList() == datasetIndex)
    {
      o0.addDataset(new Dataset());
    }
    Dataset o1 = o0.getDataset(datasetIndex);
    o1.setName(name);
  }


  //
  // DatasetRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference DatasetRef


  //
  // Detector property storage

  public void setDetectorAmplificationGain(Double amplificationGain, int instrumentIndex, int detectorIndex)
  {
    // AmplificationGain is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    o2.setAmplificationGain(amplificationGain);
  }

  public void setDetectorAnnotationRef(String annotation, int instrumentIndex, int detectorIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Detector concreteObject = root.getInstrument(instrumentIndex).getDetector(detectorIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getInstrument(instrumentIndex).getDetector(detectorIndex),
        annotationLinks_reference);
    }
  }

  public void setDetectorGain(Double gain, int instrumentIndex, int detectorIndex)
  {
    // Gain is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    o2.setGain(gain);
  }

  public void setDetectorID(String id, int instrumentIndex, int detectorIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setDetectorLotNumber(String lotNumber, int instrumentIndex, int detectorIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    o2.setLotNumber(lotNumber);
  }

  public void setDetectorManufacturer(String manufacturer, int instrumentIndex, int detectorIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    o2.setManufacturer(manufacturer);
  }

  public void setDetectorModel(String model, int instrumentIndex, int detectorIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    o2.setModel(model);
  }

  public void setDetectorOffset(Double offset, int instrumentIndex, int detectorIndex)
  {
    // Offset is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    o2.setOffset(offset);
  }

  public void setDetectorSerialNumber(String serialNumber, int instrumentIndex, int detectorIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    o2.setSerialNumber(serialNumber);
  }

  public void setDetectorType(DetectorType type, int instrumentIndex, int detectorIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    o2.setType(type);
  }

  public void setDetectorVoltage(ElectricPotential voltage, int instrumentIndex, int detectorIndex)
  {
    // Voltage is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    o2.setVoltage(voltage);
  }

  public void setDetectorZoom(Double zoom, int instrumentIndex, int detectorIndex)
  {
    // Zoom is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDetectorList() == detectorIndex)
    {
      o1.addDetector(new Detector());
    }
    Detector o2 = o1.getDetector(detectorIndex);
    o2.setZoom(zoom);
  }


  //
  // DetectorSettings property storage

  public void setDetectorSettingsBinning(Binning binning, int imageIndex, int channelIndex)
  {
    // Binning is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getDetectorSettings() == null)
    {
      o3.setDetectorSettings(new DetectorSettings());
    }
    DetectorSettings o4 = o3.getDetectorSettings();
    o4.setBinning(binning);
  }

  public void setDetectorSettingsGain(Double gain, int imageIndex, int channelIndex)
  {
    // Gain is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getDetectorSettings() == null)
    {
      o3.setDetectorSettings(new DetectorSettings());
    }
    DetectorSettings o4 = o3.getDetectorSettings();
    o4.setGain(gain);
  }

  public void setDetectorSettingsID(String id, int imageIndex, int channelIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getDetectorSettings() == null)
    {
      o3.setDetectorSettings(new DetectorSettings());
    }
    DetectorSettings o4 = o3.getDetectorSettings();
    model.addModelObject(id, o4);
    o4.setID(id);
  }

  public void setDetectorSettingsIntegration(PositiveInteger integration, int imageIndex, int channelIndex)
  {
    // Integration is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getDetectorSettings() == null)
    {
      o3.setDetectorSettings(new DetectorSettings());
    }
    DetectorSettings o4 = o3.getDetectorSettings();
    o4.setIntegration(integration);
  }

  public void setDetectorSettingsOffset(Double offset, int imageIndex, int channelIndex)
  {
    // Offset is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getDetectorSettings() == null)
    {
      o3.setDetectorSettings(new DetectorSettings());
    }
    DetectorSettings o4 = o3.getDetectorSettings();
    o4.setOffset(offset);
  }

  public void setDetectorSettingsReadOutRate(Frequency readOutRate, int imageIndex, int channelIndex)
  {
    // ReadOutRate is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getDetectorSettings() == null)
    {
      o3.setDetectorSettings(new DetectorSettings());
    }
    DetectorSettings o4 = o3.getDetectorSettings();
    o4.setReadOutRate(readOutRate);
  }

  public void setDetectorSettingsVoltage(ElectricPotential voltage, int imageIndex, int channelIndex)
  {
    // Voltage is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getDetectorSettings() == null)
    {
      o3.setDetectorSettings(new DetectorSettings());
    }
    DetectorSettings o4 = o3.getDetectorSettings();
    o4.setVoltage(voltage);
  }

  public void setDetectorSettingsZoom(Double zoom, int imageIndex, int channelIndex)
  {
    // Zoom is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getDetectorSettings() == null)
    {
      o3.setDetectorSettings(new DetectorSettings());
    }
    DetectorSettings o4 = o3.getDetectorSettings();
    o4.setZoom(zoom);
  }


  //
  // Dichroic property storage

  public void setDichroicAnnotationRef(String annotation, int instrumentIndex, int dichroicIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Dichroic concreteObject = root.getInstrument(instrumentIndex).getDichroic(dichroicIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getInstrument(instrumentIndex).getDichroic(dichroicIndex),
        annotationLinks_reference);
    }
  }

  public void setDichroicID(String id, int instrumentIndex, int dichroicIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDichroicList() == dichroicIndex)
    {
      o1.addDichroic(new Dichroic());
    }
    Dichroic o2 = o1.getDichroic(dichroicIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setDichroicLotNumber(String lotNumber, int instrumentIndex, int dichroicIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDichroicList() == dichroicIndex)
    {
      o1.addDichroic(new Dichroic());
    }
    Dichroic o2 = o1.getDichroic(dichroicIndex);
    o2.setLotNumber(lotNumber);
  }

  public void setDichroicManufacturer(String manufacturer, int instrumentIndex, int dichroicIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDichroicList() == dichroicIndex)
    {
      o1.addDichroic(new Dichroic());
    }
    Dichroic o2 = o1.getDichroic(dichroicIndex);
    o2.setManufacturer(manufacturer);
  }

  public void setDichroicModel(String model, int instrumentIndex, int dichroicIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDichroicList() == dichroicIndex)
    {
      o1.addDichroic(new Dichroic());
    }
    Dichroic o2 = o1.getDichroic(dichroicIndex);
    o2.setModel(model);
  }

  public void setDichroicSerialNumber(String serialNumber, int instrumentIndex, int dichroicIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfDichroicList() == dichroicIndex)
    {
      o1.addDichroic(new Dichroic());
    }
    Dichroic o2 = o1.getDichroic(dichroicIndex);
    o2.setSerialNumber(serialNumber);
  }


  //
  // DichroicRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference DichroicRef


  //
  // DoubleAnnotation property storage

  public void setDoubleAnnotationAnnotationRef(String annotation, int doubleAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      DoubleAnnotation concreteObject = root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getDoubleAnnotation(doubleAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setDoubleAnnotationAnnotator(String annotator, int doubleAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfDoubleAnnotationList() == doubleAnnotationIndex)
    {
      o1.addDoubleAnnotation(new DoubleAnnotation());
    }
    DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setDoubleAnnotationDescription(String description, int doubleAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfDoubleAnnotationList() == doubleAnnotationIndex)
    {
      o1.addDoubleAnnotation(new DoubleAnnotation());
    }
    DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
    o2.setDescription(description);
  }

  public void setDoubleAnnotationID(String id, int doubleAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfDoubleAnnotationList() == doubleAnnotationIndex)
    {
      o1.addDoubleAnnotation(new DoubleAnnotation());
    }
    DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setDoubleAnnotationNamespace(String namespace, int doubleAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfDoubleAnnotationList() == doubleAnnotationIndex)
    {
      o1.addDoubleAnnotation(new DoubleAnnotation());
    }
    DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
    o2.setNamespace(namespace);
  }

  public void setDoubleAnnotationValue(Double value, int doubleAnnotationIndex)
  {
    // Value is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfDoubleAnnotationList() == doubleAnnotationIndex)
    {
      o1.addDoubleAnnotation(new DoubleAnnotation());
    }
    DoubleAnnotation o2 = o1.getDoubleAnnotation(doubleAnnotationIndex);
    o2.setValue(value);
  }


  //
  // Ellipse property storage

  public void setEllipseAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Ellipse concreteObject = ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Ellipse)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)),
        annotationLinks_reference);
    }
  }

  public void setEllipseFillColor(Color fillColor, int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setFillColor(fillColor);
  }

  public void setEllipseFillRule(FillRule fillRule, int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setFillRule(fillRule);
  }

  public void setEllipseFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setFontFamily(fontFamily);
  }

  public void setEllipseFontSize(Length fontSize, int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setFontSize(fontSize);
  }

  public void setEllipseFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setFontStyle(fontStyle);
  }

  public void setEllipseID(String id, int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
  }

  public void setEllipseLocked(Boolean locked, int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setLocked(locked);
  }

  public void setEllipseRadiusX(Double radiusX, int ROIIndex, int shapeIndex)
  {
    // RadiusX is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setRadiusX(radiusX);
  }

  public void setEllipseRadiusY(Double radiusY, int ROIIndex, int shapeIndex)
  {
    // RadiusY is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setRadiusY(radiusY);
  }

  public void setEllipseStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setStrokeColor(strokeColor);
  }

  public void setEllipseStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setStrokeDashArray(strokeDashArray);
  }

  public void setEllipseStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setStrokeWidth(strokeWidth);
  }

  public void setEllipseText(String text, int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setText(text);
  }

  public void setEllipseTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setTheC(theC);
  }

  public void setEllipseTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setTheT(theT);
  }

  public void setEllipseTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setTheZ(theZ);
  }

  public void setEllipseTransform(AffineTransform transform, int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setTransform(transform);
  }

  public void setEllipseX(Double x, int ROIIndex, int shapeIndex)
  {
    // X is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setX(x);
  }

  public void setEllipseY(Double y, int ROIIndex, int shapeIndex)
  {
    // Y is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Ellipse());
    }
    Ellipse o3 = (Ellipse) o2.getShape(shapeIndex);
    o3.setY(y);
  }


  //
  // EmissionFilterRef property storage


  //
  // ExcitationFilterRef property storage


  //
  // Experiment property storage

  public void setExperimentDescription(String description, int experimentIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimentList() == experimentIndex)
    {
      o0.addExperiment(new Experiment());
    }
    Experiment o1 = o0.getExperiment(experimentIndex);
    o1.setDescription(description);
  }

  public void setExperimentExperimenterRef(String experimenter, int experimentIndex)
  {
    // ExperimenterRef is reference and occurs more than once
    ExperimenterRef experimenter_reference = new ExperimenterRef();
    experimenter_reference.setID(experimenter);
    model.addReference(
      root.getExperiment(experimentIndex),
      experimenter_reference);
  }

  public void setExperimentID(String id, int experimentIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimentList() == experimentIndex)
    {
      o0.addExperiment(new Experiment());
    }
    Experiment o1 = o0.getExperiment(experimentIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }

  public void setExperimentType(ExperimentType type, int experimentIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimentList() == experimentIndex)
    {
      o0.addExperiment(new Experiment());
    }
    Experiment o1 = o0.getExperiment(experimentIndex);
    o1.setType(type);
  }


  //
  // ExperimentRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference ExperimentRef


  //
  // Experimenter property storage

  public void setExperimenterAnnotationRef(String annotation, int experimenterIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Experimenter concreteObject = root.getExperimenter(experimenterIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getExperimenter(experimenterIndex),
        annotationLinks_reference);
    }
  }

  public void setExperimenterEmail(String email, int experimenterIndex)
  {
    // Email is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimenterList() == experimenterIndex)
    {
      o0.addExperimenter(new Experimenter());
    }
    Experimenter o1 = o0.getExperimenter(experimenterIndex);
    o1.setEmail(email);
  }

  public void setExperimenterFirstName(String firstName, int experimenterIndex)
  {
    // FirstName is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimenterList() == experimenterIndex)
    {
      o0.addExperimenter(new Experimenter());
    }
    Experimenter o1 = o0.getExperimenter(experimenterIndex);
    o1.setFirstName(firstName);
  }

  public void setExperimenterID(String id, int experimenterIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimenterList() == experimenterIndex)
    {
      o0.addExperimenter(new Experimenter());
    }
    Experimenter o1 = o0.getExperimenter(experimenterIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }

  public void setExperimenterInstitution(String institution, int experimenterIndex)
  {
    // Institution is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimenterList() == experimenterIndex)
    {
      o0.addExperimenter(new Experimenter());
    }
    Experimenter o1 = o0.getExperimenter(experimenterIndex);
    o1.setInstitution(institution);
  }

  public void setExperimenterLastName(String lastName, int experimenterIndex)
  {
    // LastName is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimenterList() == experimenterIndex)
    {
      o0.addExperimenter(new Experimenter());
    }
    Experimenter o1 = o0.getExperimenter(experimenterIndex);
    o1.setLastName(lastName);
  }

  public void setExperimenterMiddleName(String middleName, int experimenterIndex)
  {
    // MiddleName is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimenterList() == experimenterIndex)
    {
      o0.addExperimenter(new Experimenter());
    }
    Experimenter o1 = o0.getExperimenter(experimenterIndex);
    o1.setMiddleName(middleName);
  }

  public void setExperimenterUserName(String userName, int experimenterIndex)
  {
    // UserName is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimenterList() == experimenterIndex)
    {
      o0.addExperimenter(new Experimenter());
    }
    Experimenter o1 = o0.getExperimenter(experimenterIndex);
    o1.setUserName(userName);
  }


  //
  // ExperimenterGroup property storage

  public void setExperimenterGroupAnnotationRef(String annotation, int experimenterGroupIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      ExperimenterGroup concreteObject = root.getExperimenterGroup(experimenterGroupIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getExperimenterGroup(experimenterGroupIndex),
        annotationLinks_reference);
    }
  }

  public void setExperimenterGroupDescription(String description, int experimenterGroupIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimenterGroupList() == experimenterGroupIndex)
    {
      o0.addExperimenterGroup(new ExperimenterGroup());
    }
    ExperimenterGroup o1 = o0.getExperimenterGroup(experimenterGroupIndex);
    o1.setDescription(description);
  }

  public void setExperimenterGroupExperimenterRef(String experimenter, int experimenterGroupIndex, int experimenterRefIndex)
  {
    // ExperimenterRef is reference and occurs more than once
    ExperimenterRef experimenterLinks_reference = new ExperimenterRef();
    experimenterLinks_reference.setID(experimenter);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(experimenter);
    if (referencedObj != null && referencedObj instanceof Experimenter)
    {
      Experimenter typedRef = (Experimenter) referencedObj;
      ExperimenterGroup concreteObject = root.getExperimenterGroup(experimenterGroupIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedExperimenterList() == experimenterRefIndex)
      {
        concreteObject.linkExperimenter(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedExperimenter(experimenterRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getExperimenterGroup(experimenterGroupIndex),
        experimenterLinks_reference);
    }
  }

  public void setExperimenterGroupID(String id, int experimenterGroupIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimenterGroupList() == experimenterGroupIndex)
    {
      o0.addExperimenterGroup(new ExperimenterGroup());
    }
    ExperimenterGroup o1 = o0.getExperimenterGroup(experimenterGroupIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }

  public void setExperimenterGroupLeader(String leader, int experimenterGroupIndex, int leaderIndex)
  {
    // Leader is reference and occurs more than once
    Leader leaders_reference = new Leader();
    leaders_reference.setID(leader);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(leader);
    if (referencedObj != null && referencedObj instanceof Experimenter)
    {
      Experimenter typedRef = (Experimenter) referencedObj;
      ExperimenterGroup concreteObject = root.getExperimenterGroup(experimenterGroupIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedLeaderList() == leaderIndex)
      {
        concreteObject.linkLeader(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedLeader(leaderIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getExperimenterGroup(experimenterGroupIndex),
        leaders_reference);
    }
  }

  public void setExperimenterGroupName(String name, int experimenterGroupIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimenterGroupList() == experimenterGroupIndex)
    {
      o0.addExperimenterGroup(new ExperimenterGroup());
    }
    ExperimenterGroup o1 = o0.getExperimenterGroup(experimenterGroupIndex);
    o1.setName(name);
  }


  //
  // ExperimenterGroupRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference ExperimenterGroupRef


  //
  // ExperimenterRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference ExperimenterRef


  //
  // Filament property storage

  public void setFilamentAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Filament concreteObject = ((Filament)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Filament)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)),
        annotationLinks_reference);
    }
  }

  public void setFilamentID(String id, int instrumentIndex, int lightSourceIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Filament());
    }
    Filament o2 = (Filament) o1.getLightSource(lightSourceIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setFilamentLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Filament());
    }
    Filament o2 = (Filament) o1.getLightSource(lightSourceIndex);
    o2.setLotNumber(lotNumber);
  }

  public void setFilamentManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Filament());
    }
    Filament o2 = (Filament) o1.getLightSource(lightSourceIndex);
    o2.setManufacturer(manufacturer);
  }

  public void setFilamentModel(String model, int instrumentIndex, int lightSourceIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Filament());
    }
    Filament o2 = (Filament) o1.getLightSource(lightSourceIndex);
    o2.setModel(model);
  }

  public void setFilamentPower(Power power, int instrumentIndex, int lightSourceIndex)
  {
    // Power is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Filament());
    }
    Filament o2 = (Filament) o1.getLightSource(lightSourceIndex);
    o2.setPower(power);
  }

  public void setFilamentSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Filament());
    }
    Filament o2 = (Filament) o1.getLightSource(lightSourceIndex);
    o2.setSerialNumber(serialNumber);
  }

  public void setFilamentType(FilamentType type, int instrumentIndex, int lightSourceIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Filament());
    }
    Filament o2 = (Filament) o1.getLightSource(lightSourceIndex);
    o2.setType(type);
  }


  //
  // FileAnnotation property storage

  public void setFileAnnotationAnnotationRef(String annotation, int fileAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      FileAnnotation concreteObject = root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getFileAnnotation(fileAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setFileAnnotationAnnotator(String annotator, int fileAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setFileAnnotationDescription(String description, int fileAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    o2.setDescription(description);
  }

  public void setFileAnnotationID(String id, int fileAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setFileAnnotationNamespace(String namespace, int fileAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfFileAnnotationList() == fileAnnotationIndex)
    {
      o1.addFileAnnotation(new FileAnnotation());
    }
    FileAnnotation o2 = o1.getFileAnnotation(fileAnnotationIndex);
    o2.setNamespace(namespace);
  }


  //
  // Filter property storage

  public void setFilterAnnotationRef(String annotation, int instrumentIndex, int filterIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Filter concreteObject = root.getInstrument(instrumentIndex).getFilter(filterIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getInstrument(instrumentIndex).getFilter(filterIndex),
        annotationLinks_reference);
    }
  }

  public void setFilterFilterWheel(String filterWheel, int instrumentIndex, int filterIndex)
  {
    // FilterWheel is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    o2.setFilterWheel(filterWheel);
  }

  public void setFilterID(String id, int instrumentIndex, int filterIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setFilterLotNumber(String lotNumber, int instrumentIndex, int filterIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    o2.setLotNumber(lotNumber);
  }

  public void setFilterManufacturer(String manufacturer, int instrumentIndex, int filterIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    o2.setManufacturer(manufacturer);
  }

  public void setFilterModel(String model, int instrumentIndex, int filterIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    o2.setModel(model);
  }

  public void setFilterSerialNumber(String serialNumber, int instrumentIndex, int filterIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    o2.setSerialNumber(serialNumber);
  }

  public void setFilterType(FilterType type, int instrumentIndex, int filterIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    o2.setType(type);
  }


  //
  // FilterSet property storage

  public void setFilterSetDichroicRef(String dichroic, int instrumentIndex, int filterSetIndex)
  {
    // DichroicRef is reference and occurs more than once
    DichroicRef dichroic_reference = new DichroicRef();
    dichroic_reference.setID(dichroic);
    model.addReference(
      root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex),
      dichroic_reference);
  }

  public void setFilterSetEmissionFilterRef(String emissionFilter, int instrumentIndex, int filterSetIndex, int emissionFilterRefIndex)
  {
    // EmissionFilterRef is reference and occurs more than once
    EmissionFilterRef emissionFilterLinks_reference = new EmissionFilterRef();
    emissionFilterLinks_reference.setID(emissionFilter);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(emissionFilter);
    if (referencedObj != null && referencedObj instanceof Filter)
    {
      Filter typedRef = (Filter) referencedObj;
      FilterSet concreteObject = root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedEmissionFilterList() == emissionFilterRefIndex)
      {
        concreteObject.linkEmissionFilter(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedEmissionFilter(emissionFilterRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex),
        emissionFilterLinks_reference);
    }
  }

  public void setFilterSetExcitationFilterRef(String excitationFilter, int instrumentIndex, int filterSetIndex, int excitationFilterRefIndex)
  {
    // ExcitationFilterRef is reference and occurs more than once
    ExcitationFilterRef excitationFilterLinks_reference = new ExcitationFilterRef();
    excitationFilterLinks_reference.setID(excitationFilter);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(excitationFilter);
    if (referencedObj != null && referencedObj instanceof Filter)
    {
      Filter typedRef = (Filter) referencedObj;
      FilterSet concreteObject = root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedExcitationFilterList() == excitationFilterRefIndex)
      {
        concreteObject.linkExcitationFilter(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedExcitationFilter(excitationFilterRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getInstrument(instrumentIndex).getFilterSet(filterSetIndex),
        excitationFilterLinks_reference);
    }
  }

  public void setFilterSetID(String id, int instrumentIndex, int filterSetIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterSetList() == filterSetIndex)
    {
      o1.addFilterSet(new FilterSet());
    }
    FilterSet o2 = o1.getFilterSet(filterSetIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setFilterSetLotNumber(String lotNumber, int instrumentIndex, int filterSetIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterSetList() == filterSetIndex)
    {
      o1.addFilterSet(new FilterSet());
    }
    FilterSet o2 = o1.getFilterSet(filterSetIndex);
    o2.setLotNumber(lotNumber);
  }

  public void setFilterSetManufacturer(String manufacturer, int instrumentIndex, int filterSetIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterSetList() == filterSetIndex)
    {
      o1.addFilterSet(new FilterSet());
    }
    FilterSet o2 = o1.getFilterSet(filterSetIndex);
    o2.setManufacturer(manufacturer);
  }

  public void setFilterSetModel(String model, int instrumentIndex, int filterSetIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterSetList() == filterSetIndex)
    {
      o1.addFilterSet(new FilterSet());
    }
    FilterSet o2 = o1.getFilterSet(filterSetIndex);
    o2.setModel(model);
  }

  public void setFilterSetSerialNumber(String serialNumber, int instrumentIndex, int filterSetIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterSetList() == filterSetIndex)
    {
      o1.addFilterSet(new FilterSet());
    }
    FilterSet o2 = o1.getFilterSet(filterSetIndex);
    o2.setSerialNumber(serialNumber);
  }


  //
  // FilterSetRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference FilterSetRef


  //
  // Folder property storage

  public void setFolderAnnotationRef(String annotation, int folderIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Folder concreteObject = root.getFolder(folderIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getFolder(folderIndex),
        annotationLinks_reference);
    }
  }

  public void setFolderDescription(String description, int folderIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfFolderList() == folderIndex)
    {
      o0.addFolder(new Folder());
    }
    Folder o1 = o0.getFolder(folderIndex);
    o1.setDescription(description);
  }

  public void setFolderFolderRef(String folder, int folderIndex, int folderRefIndex)
  {
    // FolderRef is reference and occurs more than once
    FolderRef folders_reference = new FolderRef();
    folders_reference.setID(folder);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(folder);
    if (referencedObj != null && referencedObj instanceof Folder)
    {
      Folder typedRef = (Folder) referencedObj;
      Folder concreteObject = root.getFolder(folderIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedFolderList() == folderRefIndex)
      {
        concreteObject.linkFolder(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedFolder(folderRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getFolder(folderIndex),
        folders_reference);
    }
  }

  public void setFolderID(String id, int folderIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfFolderList() == folderIndex)
    {
      o0.addFolder(new Folder());
    }
    Folder o1 = o0.getFolder(folderIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }

  public void setFolderImageRef(String image, int folderIndex, int imageRefIndex)
  {
    // ImageRef is reference and occurs more than once
    ImageRef imageLinks_reference = new ImageRef();
    imageLinks_reference.setID(image);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(image);
    if (referencedObj != null && referencedObj instanceof Image)
    {
      Image typedRef = (Image) referencedObj;
      Folder concreteObject = root.getFolder(folderIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedImageList() == imageRefIndex)
      {
        concreteObject.linkImage(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedImage(imageRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getFolder(folderIndex),
        imageLinks_reference);
    }
  }

  public void setFolderName(String name, int folderIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfFolderList() == folderIndex)
    {
      o0.addFolder(new Folder());
    }
    Folder o1 = o0.getFolder(folderIndex);
    o1.setName(name);
  }

  public void setFolderROIRef(String roi, int folderIndex, int ROIRefIndex)
  {
    // ROIRef is reference and occurs more than once
    ROIRef roiLinks_reference = new ROIRef();
    roiLinks_reference.setID(roi);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(roi);
    if (referencedObj != null && referencedObj instanceof ROI)
    {
      ROI typedRef = (ROI) referencedObj;
      Folder concreteObject = root.getFolder(folderIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedROIList() == ROIRefIndex)
      {
        concreteObject.linkROI(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedROI(ROIRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getFolder(folderIndex),
        roiLinks_reference);
    }
  }


  //
  // FolderRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference FolderRef


  //
  // GenericExcitationSource property storage

  public void setGenericExcitationSourceAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      GenericExcitationSource concreteObject = ((GenericExcitationSource)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((GenericExcitationSource)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)),
        annotationLinks_reference);
    }
  }

  public void setGenericExcitationSourceID(String id, int instrumentIndex, int lightSourceIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new GenericExcitationSource());
    }
    GenericExcitationSource o2 = (GenericExcitationSource) o1.getLightSource(lightSourceIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setGenericExcitationSourceLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new GenericExcitationSource());
    }
    GenericExcitationSource o2 = (GenericExcitationSource) o1.getLightSource(lightSourceIndex);
    o2.setLotNumber(lotNumber);
  }

  public void setGenericExcitationSourceManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new GenericExcitationSource());
    }
    GenericExcitationSource o2 = (GenericExcitationSource) o1.getLightSource(lightSourceIndex);
    o2.setManufacturer(manufacturer);
  }

  public void setGenericExcitationSourceModel(String model, int instrumentIndex, int lightSourceIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new GenericExcitationSource());
    }
    GenericExcitationSource o2 = (GenericExcitationSource) o1.getLightSource(lightSourceIndex);
    o2.setModel(model);
  }

  public void setGenericExcitationSourcePower(Power power, int instrumentIndex, int lightSourceIndex)
  {
    // Power is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new GenericExcitationSource());
    }
    GenericExcitationSource o2 = (GenericExcitationSource) o1.getLightSource(lightSourceIndex);
    o2.setPower(power);
  }

  public void setGenericExcitationSourceSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new GenericExcitationSource());
    }
    GenericExcitationSource o2 = (GenericExcitationSource) o1.getLightSource(lightSourceIndex);
    o2.setSerialNumber(serialNumber);
  }


  //
  // Image property storage

  public void setImageAcquisitionDate(Timestamp acquisitionDate, int imageIndex)
  {
    // AcquisitionDate is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    o1.setAcquisitionDate(acquisitionDate);
  }

  public void setImageAnnotationRef(String annotation, int imageIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Image concreteObject = root.getImage(imageIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getImage(imageIndex),
        annotationLinks_reference);
    }
  }

  public void setImageDescription(String description, int imageIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    o1.setDescription(description);
  }

  public void setImageExperimentRef(String experiment, int imageIndex)
  {
    // ExperimentRef is reference and occurs more than once
    ExperimentRef experiment_reference = new ExperimentRef();
    experiment_reference.setID(experiment);
    model.addReference(
      root.getImage(imageIndex),
      experiment_reference);
  }

  public void setImageExperimenterGroupRef(String experimenterGroup, int imageIndex)
  {
    // ExperimenterGroupRef is reference and occurs more than once
    ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
    experimenterGroup_reference.setID(experimenterGroup);
    model.addReference(
      root.getImage(imageIndex),
      experimenterGroup_reference);
  }

  public void setImageExperimenterRef(String experimenter, int imageIndex)
  {
    // ExperimenterRef is reference and occurs more than once
    ExperimenterRef experimenter_reference = new ExperimenterRef();
    experimenter_reference.setID(experimenter);
    model.addReference(
      root.getImage(imageIndex),
      experimenter_reference);
  }

  public void setImageID(String id, int imageIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }

  public void setImageInstrumentRef(String instrument, int imageIndex)
  {
    // InstrumentRef is reference and occurs more than once
    InstrumentRef instrument_reference = new InstrumentRef();
    instrument_reference.setID(instrument);
    model.addReference(
      root.getImage(imageIndex),
      instrument_reference);
  }

  public void setImageMicrobeamManipulationRef(String microbeamManipulation, int imageIndex, int microbeamManipulationRefIndex)
  {
    // MicrobeamManipulationRef is reference and occurs more than once
    MicrobeamManipulationRef microbeamManipulationLinks_reference = new MicrobeamManipulationRef();
    microbeamManipulationLinks_reference.setID(microbeamManipulation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(microbeamManipulation);
    if (referencedObj != null && referencedObj instanceof MicrobeamManipulation)
    {
      MicrobeamManipulation typedRef = (MicrobeamManipulation) referencedObj;
      Image concreteObject = root.getImage(imageIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedMicrobeamManipulationList() == microbeamManipulationRefIndex)
      {
        concreteObject.linkMicrobeamManipulation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedMicrobeamManipulation(microbeamManipulationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getImage(imageIndex),
        microbeamManipulationLinks_reference);
    }
  }

  public void setImageName(String name, int imageIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    o1.setName(name);
  }

  public void setImageROIRef(String roi, int imageIndex, int ROIRefIndex)
  {
    // ROIRef is reference and occurs more than once
    ROIRef roiLinks_reference = new ROIRef();
    roiLinks_reference.setID(roi);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(roi);
    if (referencedObj != null && referencedObj instanceof ROI)
    {
      ROI typedRef = (ROI) referencedObj;
      Image concreteObject = root.getImage(imageIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedROIList() == ROIRefIndex)
      {
        concreteObject.linkROI(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedROI(ROIRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getImage(imageIndex),
        roiLinks_reference);
    }
  }


  //
  // ImageRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference ImageRef


  //
  // ImagingEnvironment property storage

  public void setImagingEnvironmentAirPressure(Pressure airPressure, int imageIndex)
  {
    // AirPressure is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getImagingEnvironment() == null)
    {
      o1.setImagingEnvironment(new ImagingEnvironment());
    }
    ImagingEnvironment o2 = o1.getImagingEnvironment();
    o2.setAirPressure(airPressure);
  }

  public void setImagingEnvironmentCO2Percent(PercentFraction co2Percent, int imageIndex)
  {
    // CO2Percent is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getImagingEnvironment() == null)
    {
      o1.setImagingEnvironment(new ImagingEnvironment());
    }
    ImagingEnvironment o2 = o1.getImagingEnvironment();
    o2.setCO2Percent(co2Percent);
  }

  public void setImagingEnvironmentHumidity(PercentFraction humidity, int imageIndex)
  {
    // Humidity is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getImagingEnvironment() == null)
    {
      o1.setImagingEnvironment(new ImagingEnvironment());
    }
    ImagingEnvironment o2 = o1.getImagingEnvironment();
    o2.setHumidity(humidity);
  }

  public void setImagingEnvironmentTemperature(Temperature temperature, int imageIndex)
  {
    // Temperature is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getImagingEnvironment() == null)
    {
      o1.setImagingEnvironment(new ImagingEnvironment());
    }
    ImagingEnvironment o2 = o1.getImagingEnvironment();
    o2.setTemperature(temperature);
  }


  //
  // Instrument property storage

  public void setInstrumentAnnotationRef(String annotation, int instrumentIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Instrument concreteObject = root.getInstrument(instrumentIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getInstrument(instrumentIndex),
        annotationLinks_reference);
    }
  }

  public void setInstrumentID(String id, int instrumentIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }


  //
  // InstrumentRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference InstrumentRef


  //
  // Label property storage

  public void setLabelAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Label concreteObject = ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Label)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)),
        annotationLinks_reference);
    }
  }

  public void setLabelFillColor(Color fillColor, int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setFillColor(fillColor);
  }

  public void setLabelFillRule(FillRule fillRule, int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setFillRule(fillRule);
  }

  public void setLabelFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setFontFamily(fontFamily);
  }

  public void setLabelFontSize(Length fontSize, int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setFontSize(fontSize);
  }

  public void setLabelFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setFontStyle(fontStyle);
  }

  public void setLabelID(String id, int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
  }

  public void setLabelLocked(Boolean locked, int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setLocked(locked);
  }

  public void setLabelStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setStrokeColor(strokeColor);
  }

  public void setLabelStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setStrokeDashArray(strokeDashArray);
  }

  public void setLabelStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setStrokeWidth(strokeWidth);
  }

  public void setLabelText(String text, int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setText(text);
  }

  public void setLabelTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setTheC(theC);
  }

  public void setLabelTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setTheT(theT);
  }

  public void setLabelTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setTheZ(theZ);
  }

  public void setLabelTransform(AffineTransform transform, int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setTransform(transform);
  }

  public void setLabelX(Double x, int ROIIndex, int shapeIndex)
  {
    // X is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setX(x);
  }

  public void setLabelY(Double y, int ROIIndex, int shapeIndex)
  {
    // Y is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Label());
    }
    Label o3 = (Label) o2.getShape(shapeIndex);
    o3.setY(y);
  }


  //
  // Laser property storage

  public void setLaserAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Laser concreteObject = ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)),
        annotationLinks_reference);
    }
  }

  public void setLaserFrequencyMultiplication(PositiveInteger frequencyMultiplication, int instrumentIndex, int lightSourceIndex)
  {
    // FrequencyMultiplication is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setFrequencyMultiplication(frequencyMultiplication);
  }

  public void setLaserID(String id, int instrumentIndex, int lightSourceIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setLaserLaserMedium(LaserMedium laserMedium, int instrumentIndex, int lightSourceIndex)
  {
    // LaserMedium is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setLaserMedium(laserMedium);
  }

  public void setLaserLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setLotNumber(lotNumber);
  }

  public void setLaserManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setManufacturer(manufacturer);
  }

  public void setLaserModel(String model, int instrumentIndex, int lightSourceIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setModel(model);
  }

  public void setLaserPockelCell(Boolean pockelCell, int instrumentIndex, int lightSourceIndex)
  {
    // PockelCell is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setPockelCell(pockelCell);
  }

  public void setLaserPower(Power power, int instrumentIndex, int lightSourceIndex)
  {
    // Power is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setPower(power);
  }

  public void setLaserPulse(Pulse pulse, int instrumentIndex, int lightSourceIndex)
  {
    // Pulse is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setPulse(pulse);
  }

  public void setLaserPump(String pump, int instrumentIndex, int lightSourceIndex)
  {
    // Pump is reference and occurs more than once
    Pump pump_reference = new Pump();
    pump_reference.setID(pump);
    model.addReference(
      ((Laser)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)),
      pump_reference);
  }

  public void setLaserRepetitionRate(Frequency repetitionRate, int instrumentIndex, int lightSourceIndex)
  {
    // RepetitionRate is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setRepetitionRate(repetitionRate);
  }

  public void setLaserSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setSerialNumber(serialNumber);
  }

  public void setLaserTuneable(Boolean tuneable, int instrumentIndex, int lightSourceIndex)
  {
    // Tuneable is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setTuneable(tuneable);
  }

  public void setLaserType(LaserType type, int instrumentIndex, int lightSourceIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setType(type);
  }

  public void setLaserWavelength(Length wavelength, int instrumentIndex, int lightSourceIndex)
  {
    // Wavelength is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new Laser());
    }
    Laser o2 = (Laser) o1.getLightSource(lightSourceIndex);
    o2.setWavelength(wavelength);
  }


  //
  // Leader property storage

  // 0:9999
  // Is multi path? False
  // Ignoring ExperimenterGroup_BackReference property of reference Leader

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference Leader


  //
  // LightEmittingDiode property storage

  public void setLightEmittingDiodeAnnotationRef(String annotation, int instrumentIndex, int lightSourceIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      LightEmittingDiode concreteObject = ((LightEmittingDiode)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((LightEmittingDiode)root.getInstrument(instrumentIndex).getLightSource(lightSourceIndex)),
        annotationLinks_reference);
    }
  }

  public void setLightEmittingDiodeID(String id, int instrumentIndex, int lightSourceIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new LightEmittingDiode());
    }
    LightEmittingDiode o2 = (LightEmittingDiode) o1.getLightSource(lightSourceIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setLightEmittingDiodeLotNumber(String lotNumber, int instrumentIndex, int lightSourceIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new LightEmittingDiode());
    }
    LightEmittingDiode o2 = (LightEmittingDiode) o1.getLightSource(lightSourceIndex);
    o2.setLotNumber(lotNumber);
  }

  public void setLightEmittingDiodeManufacturer(String manufacturer, int instrumentIndex, int lightSourceIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new LightEmittingDiode());
    }
    LightEmittingDiode o2 = (LightEmittingDiode) o1.getLightSource(lightSourceIndex);
    o2.setManufacturer(manufacturer);
  }

  public void setLightEmittingDiodeModel(String model, int instrumentIndex, int lightSourceIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new LightEmittingDiode());
    }
    LightEmittingDiode o2 = (LightEmittingDiode) o1.getLightSource(lightSourceIndex);
    o2.setModel(model);
  }

  public void setLightEmittingDiodePower(Power power, int instrumentIndex, int lightSourceIndex)
  {
    // Power is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new LightEmittingDiode());
    }
    LightEmittingDiode o2 = (LightEmittingDiode) o1.getLightSource(lightSourceIndex);
    o2.setPower(power);
  }

  public void setLightEmittingDiodeSerialNumber(String serialNumber, int instrumentIndex, int lightSourceIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfLightSourceList() == lightSourceIndex)
    {
      o1.addLightSource(new LightEmittingDiode());
    }
    LightEmittingDiode o2 = (LightEmittingDiode) o1.getLightSource(lightSourceIndex);
    o2.setSerialNumber(serialNumber);
  }


  //
  // LightPath property storage

  public void setLightPathAnnotationRef(String annotation, int imageIndex, int channelIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      LightPath concreteObject = root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath();
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(),
        annotationLinks_reference);
    }
  }

  public void setLightPathDichroicRef(String dichroic, int imageIndex, int channelIndex)
  {
    // DichroicRef is reference and occurs more than once
    DichroicRef dichroic_reference = new DichroicRef();
    dichroic_reference.setID(dichroic);
    model.addReference(
      root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(),
      dichroic_reference);
  }

  public void setLightPathEmissionFilterRef(String emissionFilter, int imageIndex, int channelIndex, int emissionFilterRefIndex)
  {
    // EmissionFilterRef is reference and occurs more than once
    EmissionFilterRef emissionFilterLinks_reference = new EmissionFilterRef();
    emissionFilterLinks_reference.setID(emissionFilter);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(emissionFilter);
    if (referencedObj != null && referencedObj instanceof Filter)
    {
      Filter typedRef = (Filter) referencedObj;
      LightPath concreteObject = root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath();
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedEmissionFilterList() == emissionFilterRefIndex)
      {
        concreteObject.linkEmissionFilter(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedEmissionFilter(emissionFilterRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(),
        emissionFilterLinks_reference);
    }
  }

  public void setLightPathExcitationFilterRef(String excitationFilter, int imageIndex, int channelIndex, int excitationFilterRefIndex)
  {
    // ExcitationFilterRef is reference and occurs more than once
    ExcitationFilterRef excitationFilterLinks_reference = new ExcitationFilterRef();
    excitationFilterLinks_reference.setID(excitationFilter);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(excitationFilter);
    if (referencedObj != null && referencedObj instanceof Filter)
    {
      Filter typedRef = (Filter) referencedObj;
      LightPath concreteObject = root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath();
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedExcitationFilterList() == excitationFilterRefIndex)
      {
        concreteObject.linkExcitationFilter(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedExcitationFilter(excitationFilterRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getImage(imageIndex).getPixels().getChannel(channelIndex).getLightPath(),
        excitationFilterLinks_reference);
    }
  }


  //
  // LightSourceSettings property storage

  public void setChannelLightSourceSettingsAttenuation(PercentFraction attenuation, int imageIndex, int channelIndex)
  {
    // Attenuation is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getLightSourceSettings() == null)
    {
      o3.setLightSourceSettings(new LightSourceSettings());
    }
    LightSourceSettings o4 = o3.getLightSourceSettings();
    o4.setAttenuation(attenuation);
  }

  public void setMicrobeamManipulationLightSourceSettingsAttenuation(PercentFraction attenuation, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex)
  {
    // Attenuation is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimentList() == experimentIndex)
    {
      o0.addExperiment(new Experiment());
    }
    Experiment o1 = o0.getExperiment(experimentIndex);
    if (o1.sizeOfMicrobeamManipulationList() == microbeamManipulationIndex)
    {
      o1.addMicrobeamManipulation(new MicrobeamManipulation());
    }
    MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
    if (o2.sizeOfLightSourceSettingsList() == lightSourceSettingsIndex)
    {
      o2.addLightSourceSettings(new LightSourceSettings());
    }
    LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
    o3.setAttenuation(attenuation);
  }

  public void setChannelLightSourceSettingsID(String id, int imageIndex, int channelIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getLightSourceSettings() == null)
    {
      o3.setLightSourceSettings(new LightSourceSettings());
    }
    LightSourceSettings o4 = o3.getLightSourceSettings();
    model.addModelObject(id, o4);
    o4.setID(id);
  }

  public void setMicrobeamManipulationLightSourceSettingsID(String id, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimentList() == experimentIndex)
    {
      o0.addExperiment(new Experiment());
    }
    Experiment o1 = o0.getExperiment(experimentIndex);
    if (o1.sizeOfMicrobeamManipulationList() == microbeamManipulationIndex)
    {
      o1.addMicrobeamManipulation(new MicrobeamManipulation());
    }
    MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
    if (o2.sizeOfLightSourceSettingsList() == lightSourceSettingsIndex)
    {
      o2.addLightSourceSettings(new LightSourceSettings());
    }
    LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
  }

  public void setChannelLightSourceSettingsWavelength(Length wavelength, int imageIndex, int channelIndex)
  {
    // Wavelength is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfChannelList() == channelIndex)
    {
      o2.addChannel(new Channel());
    }
    Channel o3 = o2.getChannel(channelIndex);
    if (o3.getLightSourceSettings() == null)
    {
      o3.setLightSourceSettings(new LightSourceSettings());
    }
    LightSourceSettings o4 = o3.getLightSourceSettings();
    o4.setWavelength(wavelength);
  }

  public void setMicrobeamManipulationLightSourceSettingsWavelength(Length wavelength, int experimentIndex, int microbeamManipulationIndex, int lightSourceSettingsIndex)
  {
    // Wavelength is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimentList() == experimentIndex)
    {
      o0.addExperiment(new Experiment());
    }
    Experiment o1 = o0.getExperiment(experimentIndex);
    if (o1.sizeOfMicrobeamManipulationList() == microbeamManipulationIndex)
    {
      o1.addMicrobeamManipulation(new MicrobeamManipulation());
    }
    MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
    if (o2.sizeOfLightSourceSettingsList() == lightSourceSettingsIndex)
    {
      o2.addLightSourceSettings(new LightSourceSettings());
    }
    LightSourceSettings o3 = o2.getLightSourceSettings(lightSourceSettingsIndex);
    o3.setWavelength(wavelength);
  }


  //
  // Line property storage

  public void setLineAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Line concreteObject = ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Line)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)),
        annotationLinks_reference);
    }
  }

  public void setLineFillColor(Color fillColor, int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setFillColor(fillColor);
  }

  public void setLineFillRule(FillRule fillRule, int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setFillRule(fillRule);
  }

  public void setLineFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setFontFamily(fontFamily);
  }

  public void setLineFontSize(Length fontSize, int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setFontSize(fontSize);
  }

  public void setLineFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setFontStyle(fontStyle);
  }

  public void setLineID(String id, int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
  }

  public void setLineLocked(Boolean locked, int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setLocked(locked);
  }

  public void setLineMarkerEnd(Marker markerEnd, int ROIIndex, int shapeIndex)
  {
    // MarkerEnd is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setMarkerEnd(markerEnd);
  }

  public void setLineMarkerStart(Marker markerStart, int ROIIndex, int shapeIndex)
  {
    // MarkerStart is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setMarkerStart(markerStart);
  }

  public void setLineStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setStrokeColor(strokeColor);
  }

  public void setLineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setStrokeDashArray(strokeDashArray);
  }

  public void setLineStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setStrokeWidth(strokeWidth);
  }

  public void setLineText(String text, int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setText(text);
  }

  public void setLineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setTheC(theC);
  }

  public void setLineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setTheT(theT);
  }

  public void setLineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setTheZ(theZ);
  }

  public void setLineTransform(AffineTransform transform, int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setTransform(transform);
  }

  public void setLineX1(Double x1, int ROIIndex, int shapeIndex)
  {
    // X1 is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setX1(x1);
  }

  public void setLineX2(Double x2, int ROIIndex, int shapeIndex)
  {
    // X2 is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setX2(x2);
  }

  public void setLineY1(Double y1, int ROIIndex, int shapeIndex)
  {
    // Y1 is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setY1(y1);
  }

  public void setLineY2(Double y2, int ROIIndex, int shapeIndex)
  {
    // Y2 is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Line());
    }
    Line o3 = (Line) o2.getShape(shapeIndex);
    o3.setY2(y2);
  }


  //
  // ListAnnotation property storage

  public void setListAnnotationAnnotationRef(String annotation, int listAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      ListAnnotation concreteObject = root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getListAnnotation(listAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setListAnnotationAnnotator(String annotator, int listAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfListAnnotationList() == listAnnotationIndex)
    {
      o1.addListAnnotation(new ListAnnotation());
    }
    ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setListAnnotationDescription(String description, int listAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfListAnnotationList() == listAnnotationIndex)
    {
      o1.addListAnnotation(new ListAnnotation());
    }
    ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
    o2.setDescription(description);
  }

  public void setListAnnotationID(String id, int listAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfListAnnotationList() == listAnnotationIndex)
    {
      o1.addListAnnotation(new ListAnnotation());
    }
    ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setListAnnotationNamespace(String namespace, int listAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfListAnnotationList() == listAnnotationIndex)
    {
      o1.addListAnnotation(new ListAnnotation());
    }
    ListAnnotation o2 = o1.getListAnnotation(listAnnotationIndex);
    o2.setNamespace(namespace);
  }


  //
  // LongAnnotation property storage

  public void setLongAnnotationAnnotationRef(String annotation, int longAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      LongAnnotation concreteObject = root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getLongAnnotation(longAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setLongAnnotationAnnotator(String annotator, int longAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfLongAnnotationList() == longAnnotationIndex)
    {
      o1.addLongAnnotation(new LongAnnotation());
    }
    LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setLongAnnotationDescription(String description, int longAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfLongAnnotationList() == longAnnotationIndex)
    {
      o1.addLongAnnotation(new LongAnnotation());
    }
    LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
    o2.setDescription(description);
  }

  public void setLongAnnotationID(String id, int longAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfLongAnnotationList() == longAnnotationIndex)
    {
      o1.addLongAnnotation(new LongAnnotation());
    }
    LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setLongAnnotationNamespace(String namespace, int longAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfLongAnnotationList() == longAnnotationIndex)
    {
      o1.addLongAnnotation(new LongAnnotation());
    }
    LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
    o2.setNamespace(namespace);
  }

  public void setLongAnnotationValue(Long value, int longAnnotationIndex)
  {
    // Value is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfLongAnnotationList() == longAnnotationIndex)
    {
      o1.addLongAnnotation(new LongAnnotation());
    }
    LongAnnotation o2 = o1.getLongAnnotation(longAnnotationIndex);
    o2.setValue(value);
  }


  //
  // Map property storage


  //
  // MapAnnotation property storage

  public void setMapAnnotationAnnotationRef(String annotation, int mapAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      MapAnnotation concreteObject = root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getMapAnnotation(mapAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setMapAnnotationAnnotator(String annotator, int mapAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfMapAnnotationList() == mapAnnotationIndex)
    {
      o1.addMapAnnotation(new MapAnnotation());
    }
    MapAnnotation o2 = o1.getMapAnnotation(mapAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setMapAnnotationDescription(String description, int mapAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfMapAnnotationList() == mapAnnotationIndex)
    {
      o1.addMapAnnotation(new MapAnnotation());
    }
    MapAnnotation o2 = o1.getMapAnnotation(mapAnnotationIndex);
    o2.setDescription(description);
  }

  public void setMapAnnotationID(String id, int mapAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfMapAnnotationList() == mapAnnotationIndex)
    {
      o1.addMapAnnotation(new MapAnnotation());
    }
    MapAnnotation o2 = o1.getMapAnnotation(mapAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setMapAnnotationNamespace(String namespace, int mapAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfMapAnnotationList() == mapAnnotationIndex)
    {
      o1.addMapAnnotation(new MapAnnotation());
    }
    MapAnnotation o2 = o1.getMapAnnotation(mapAnnotationIndex);
    o2.setNamespace(namespace);
  }


  //
  // Mask property storage

  public void setMaskAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Mask concreteObject = ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Mask)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)),
        annotationLinks_reference);
    }
  }

  public void setMaskFillColor(Color fillColor, int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setFillColor(fillColor);
  }

  public void setMaskFillRule(FillRule fillRule, int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setFillRule(fillRule);
  }

  public void setMaskFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setFontFamily(fontFamily);
  }

  public void setMaskFontSize(Length fontSize, int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setFontSize(fontSize);
  }

  public void setMaskFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setFontStyle(fontStyle);
  }

  public void setMaskHeight(Double height, int ROIIndex, int shapeIndex)
  {
    // Height is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setHeight(height);
  }

  public void setMaskID(String id, int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
  }

  public void setMaskLocked(Boolean locked, int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setLocked(locked);
  }

  public void setMaskStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setStrokeColor(strokeColor);
  }

  public void setMaskStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setStrokeDashArray(strokeDashArray);
  }

  public void setMaskStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setStrokeWidth(strokeWidth);
  }

  public void setMaskText(String text, int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setText(text);
  }

  public void setMaskTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setTheC(theC);
  }

  public void setMaskTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setTheT(theT);
  }

  public void setMaskTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setTheZ(theZ);
  }

  public void setMaskTransform(AffineTransform transform, int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setTransform(transform);
  }

  public void setMaskWidth(Double width, int ROIIndex, int shapeIndex)
  {
    // Width is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setWidth(width);
  }

  public void setMaskX(Double x, int ROIIndex, int shapeIndex)
  {
    // X is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setX(x);
  }

  public void setMaskY(Double y, int ROIIndex, int shapeIndex)
  {
    // Y is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Mask());
    }
    Mask o3 = (Mask) o2.getShape(shapeIndex);
    o3.setY(y);
  }


  //
  // MetadataOnly property storage


  //
  // MicrobeamManipulation property storage

  public void setMicrobeamManipulationDescription(String description, int experimentIndex, int microbeamManipulationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimentList() == experimentIndex)
    {
      o0.addExperiment(new Experiment());
    }
    Experiment o1 = o0.getExperiment(experimentIndex);
    if (o1.sizeOfMicrobeamManipulationList() == microbeamManipulationIndex)
    {
      o1.addMicrobeamManipulation(new MicrobeamManipulation());
    }
    MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
    o2.setDescription(description);
  }

  public void setMicrobeamManipulationExperimenterRef(String experimenter, int experimentIndex, int microbeamManipulationIndex)
  {
    // ExperimenterRef is reference and occurs more than once
    ExperimenterRef experimenter_reference = new ExperimenterRef();
    experimenter_reference.setID(experimenter);
    model.addReference(
      root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex),
      experimenter_reference);
  }

  public void setMicrobeamManipulationID(String id, int experimentIndex, int microbeamManipulationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimentList() == experimentIndex)
    {
      o0.addExperiment(new Experiment());
    }
    Experiment o1 = o0.getExperiment(experimentIndex);
    if (o1.sizeOfMicrobeamManipulationList() == microbeamManipulationIndex)
    {
      o1.addMicrobeamManipulation(new MicrobeamManipulation());
    }
    MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setMicrobeamManipulationROIRef(String roi, int experimentIndex, int microbeamManipulationIndex, int ROIRefIndex)
  {
    // ROIRef is reference and occurs more than once
    ROIRef roiLinks_reference = new ROIRef();
    roiLinks_reference.setID(roi);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(roi);
    if (referencedObj != null && referencedObj instanceof ROI)
    {
      ROI typedRef = (ROI) referencedObj;
      MicrobeamManipulation concreteObject = root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedROIList() == ROIRefIndex)
      {
        concreteObject.linkROI(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedROI(ROIRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getExperiment(experimentIndex).getMicrobeamManipulation(microbeamManipulationIndex),
        roiLinks_reference);
    }
  }

  public void setMicrobeamManipulationType(MicrobeamManipulationType type, int experimentIndex, int microbeamManipulationIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfExperimentList() == experimentIndex)
    {
      o0.addExperiment(new Experiment());
    }
    Experiment o1 = o0.getExperiment(experimentIndex);
    if (o1.sizeOfMicrobeamManipulationList() == microbeamManipulationIndex)
    {
      o1.addMicrobeamManipulation(new MicrobeamManipulation());
    }
    MicrobeamManipulation o2 = o1.getMicrobeamManipulation(microbeamManipulationIndex);
    o2.setType(type);
  }


  //
  // MicrobeamManipulationRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference MicrobeamManipulationRef


  //
  // Microscope property storage

  public void setMicroscopeLotNumber(String lotNumber, int instrumentIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.getMicroscope() == null)
    {
      o1.setMicroscope(new Microscope());
    }
    Microscope o2 = o1.getMicroscope();
    o2.setLotNumber(lotNumber);
  }

  public void setMicroscopeManufacturer(String manufacturer, int instrumentIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.getMicroscope() == null)
    {
      o1.setMicroscope(new Microscope());
    }
    Microscope o2 = o1.getMicroscope();
    o2.setManufacturer(manufacturer);
  }

  public void setMicroscopeModel(String model, int instrumentIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.getMicroscope() == null)
    {
      o1.setMicroscope(new Microscope());
    }
    Microscope o2 = o1.getMicroscope();
    o2.setModel(model);
  }

  public void setMicroscopeSerialNumber(String serialNumber, int instrumentIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.getMicroscope() == null)
    {
      o1.setMicroscope(new Microscope());
    }
    Microscope o2 = o1.getMicroscope();
    o2.setSerialNumber(serialNumber);
  }

  public void setMicroscopeType(MicroscopeType type, int instrumentIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.getMicroscope() == null)
    {
      o1.setMicroscope(new Microscope());
    }
    Microscope o2 = o1.getMicroscope();
    o2.setType(type);
  }


  //
  // Objective property storage

  public void setObjectiveAnnotationRef(String annotation, int instrumentIndex, int objectiveIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Objective concreteObject = root.getInstrument(instrumentIndex).getObjective(objectiveIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getInstrument(instrumentIndex).getObjective(objectiveIndex),
        annotationLinks_reference);
    }
  }

  public void setObjectiveCalibratedMagnification(Double calibratedMagnification, int instrumentIndex, int objectiveIndex)
  {
    // CalibratedMagnification is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setCalibratedMagnification(calibratedMagnification);
  }

  public void setObjectiveCorrection(Correction correction, int instrumentIndex, int objectiveIndex)
  {
    // Correction is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setCorrection(correction);
  }

  public void setObjectiveID(String id, int instrumentIndex, int objectiveIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setObjectiveImmersion(Immersion immersion, int instrumentIndex, int objectiveIndex)
  {
    // Immersion is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setImmersion(immersion);
  }

  public void setObjectiveIris(Boolean iris, int instrumentIndex, int objectiveIndex)
  {
    // Iris is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setIris(iris);
  }

  public void setObjectiveLensNA(Double lensNA, int instrumentIndex, int objectiveIndex)
  {
    // LensNA is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setLensNA(lensNA);
  }

  public void setObjectiveLotNumber(String lotNumber, int instrumentIndex, int objectiveIndex)
  {
    // LotNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setLotNumber(lotNumber);
  }

  public void setObjectiveManufacturer(String manufacturer, int instrumentIndex, int objectiveIndex)
  {
    // Manufacturer is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setManufacturer(manufacturer);
  }

  public void setObjectiveModel(String model, int instrumentIndex, int objectiveIndex)
  {
    // Model is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setModel(model);
  }

  public void setObjectiveNominalMagnification(Double nominalMagnification, int instrumentIndex, int objectiveIndex)
  {
    // NominalMagnification is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setNominalMagnification(nominalMagnification);
  }

  public void setObjectiveSerialNumber(String serialNumber, int instrumentIndex, int objectiveIndex)
  {
    // SerialNumber is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setSerialNumber(serialNumber);
  }

  public void setObjectiveWorkingDistance(Length workingDistance, int instrumentIndex, int objectiveIndex)
  {
    // WorkingDistance is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfObjectiveList() == objectiveIndex)
    {
      o1.addObjective(new Objective());
    }
    Objective o2 = o1.getObjective(objectiveIndex);
    o2.setWorkingDistance(workingDistance);
  }


  //
  // ObjectiveSettings property storage

  public void setObjectiveSettingsCorrectionCollar(Double correctionCollar, int imageIndex)
  {
    // CorrectionCollar is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getObjectiveSettings() == null)
    {
      o1.setObjectiveSettings(new ObjectiveSettings());
    }
    ObjectiveSettings o2 = o1.getObjectiveSettings();
    o2.setCorrectionCollar(correctionCollar);
  }

  public void setObjectiveSettingsID(String id, int imageIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getObjectiveSettings() == null)
    {
      o1.setObjectiveSettings(new ObjectiveSettings());
    }
    ObjectiveSettings o2 = o1.getObjectiveSettings();
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setObjectiveSettingsMedium(Medium medium, int imageIndex)
  {
    // Medium is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getObjectiveSettings() == null)
    {
      o1.setObjectiveSettings(new ObjectiveSettings());
    }
    ObjectiveSettings o2 = o1.getObjectiveSettings();
    o2.setMedium(medium);
  }

  public void setObjectiveSettingsRefractiveIndex(Double refractiveIndex, int imageIndex)
  {
    // RefractiveIndex is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getObjectiveSettings() == null)
    {
      o1.setObjectiveSettings(new ObjectiveSettings());
    }
    ObjectiveSettings o2 = o1.getObjectiveSettings();
    o2.setRefractiveIndex(refractiveIndex);
  }


  //
  // Pixels property storage

  public void setPixelsBigEndian(Boolean bigEndian, int imageIndex)
  {
    // BigEndian is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setBigEndian(bigEndian);
  }

  public void setPixelsDimensionOrder(DimensionOrder dimensionOrder, int imageIndex)
  {
    // DimensionOrder is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setDimensionOrder(dimensionOrder);
  }

  public void setPixelsID(String id, int imageIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setPixelsInterleaved(Boolean interleaved, int imageIndex)
  {
    // Interleaved is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setInterleaved(interleaved);
  }

  public void setPixelsPhysicalSizeX(Length physicalSizeX, int imageIndex)
  {
    // PhysicalSizeX is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setPhysicalSizeX(physicalSizeX);
  }

  public void setPixelsPhysicalSizeY(Length physicalSizeY, int imageIndex)
  {
    // PhysicalSizeY is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setPhysicalSizeY(physicalSizeY);
  }

  public void setPixelsPhysicalSizeZ(Length physicalSizeZ, int imageIndex)
  {
    // PhysicalSizeZ is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setPhysicalSizeZ(physicalSizeZ);
  }

  public void setPixelsSignificantBits(PositiveInteger significantBits, int imageIndex)
  {
    // SignificantBits is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setSignificantBits(significantBits);
  }

  public void setPixelsSizeC(PositiveInteger sizeC, int imageIndex)
  {
    // SizeC is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setSizeC(sizeC);
  }

  public void setPixelsSizeT(PositiveInteger sizeT, int imageIndex)
  {
    // SizeT is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setSizeT(sizeT);
  }

  public void setPixelsSizeX(PositiveInteger sizeX, int imageIndex)
  {
    // SizeX is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setSizeX(sizeX);
  }

  public void setPixelsSizeY(PositiveInteger sizeY, int imageIndex)
  {
    // SizeY is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setSizeY(sizeY);
  }

  public void setPixelsSizeZ(PositiveInteger sizeZ, int imageIndex)
  {
    // SizeZ is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setSizeZ(sizeZ);
  }

  public void setPixelsTimeIncrement(Time timeIncrement, int imageIndex)
  {
    // TimeIncrement is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setTimeIncrement(timeIncrement);
  }

  public void setPixelsType(PixelType type, int imageIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    o2.setType(type);
  }


  //
  // Plane property storage

  public void setPlaneAnnotationRef(String annotation, int imageIndex, int planeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Plane concreteObject = root.getImage(imageIndex).getPixels().getPlane(planeIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getImage(imageIndex).getPixels().getPlane(planeIndex),
        annotationLinks_reference);
    }
  }

  public void setPlaneDeltaT(Time deltaT, int imageIndex, int planeIndex)
  {
    // DeltaT is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfPlaneList() == planeIndex)
    {
      o2.addPlane(new Plane());
    }
    Plane o3 = o2.getPlane(planeIndex);
    o3.setDeltaT(deltaT);
  }

  public void setPlaneExposureTime(Time exposureTime, int imageIndex, int planeIndex)
  {
    // ExposureTime is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfPlaneList() == planeIndex)
    {
      o2.addPlane(new Plane());
    }
    Plane o3 = o2.getPlane(planeIndex);
    o3.setExposureTime(exposureTime);
  }

  public void setPlaneHashSHA1(String hashSHA1, int imageIndex, int planeIndex)
  {
    // HashSHA1 is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfPlaneList() == planeIndex)
    {
      o2.addPlane(new Plane());
    }
    Plane o3 = o2.getPlane(planeIndex);
    o3.setHashSHA1(hashSHA1);
  }

  public void setPlanePositionX(Length positionX, int imageIndex, int planeIndex)
  {
    // PositionX is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfPlaneList() == planeIndex)
    {
      o2.addPlane(new Plane());
    }
    Plane o3 = o2.getPlane(planeIndex);
    o3.setPositionX(positionX);
  }

  public void setPlanePositionY(Length positionY, int imageIndex, int planeIndex)
  {
    // PositionY is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfPlaneList() == planeIndex)
    {
      o2.addPlane(new Plane());
    }
    Plane o3 = o2.getPlane(planeIndex);
    o3.setPositionY(positionY);
  }

  public void setPlanePositionZ(Length positionZ, int imageIndex, int planeIndex)
  {
    // PositionZ is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfPlaneList() == planeIndex)
    {
      o2.addPlane(new Plane());
    }
    Plane o3 = o2.getPlane(planeIndex);
    o3.setPositionZ(positionZ);
  }

  public void setPlaneTheC(NonNegativeInteger theC, int imageIndex, int planeIndex)
  {
    // TheC is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfPlaneList() == planeIndex)
    {
      o2.addPlane(new Plane());
    }
    Plane o3 = o2.getPlane(planeIndex);
    o3.setTheC(theC);
  }

  public void setPlaneTheT(NonNegativeInteger theT, int imageIndex, int planeIndex)
  {
    // TheT is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfPlaneList() == planeIndex)
    {
      o2.addPlane(new Plane());
    }
    Plane o3 = o2.getPlane(planeIndex);
    o3.setTheT(theT);
  }

  public void setPlaneTheZ(NonNegativeInteger theZ, int imageIndex, int planeIndex)
  {
    // TheZ is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfPlaneList() == planeIndex)
    {
      o2.addPlane(new Plane());
    }
    Plane o3 = o2.getPlane(planeIndex);
    o3.setTheZ(theZ);
  }


  //
  // Plate property storage

  public void setPlateAnnotationRef(String annotation, int plateIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Plate concreteObject = root.getPlate(plateIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getPlate(plateIndex),
        annotationLinks_reference);
    }
  }

  public void setPlateColumnNamingConvention(NamingConvention columnNamingConvention, int plateIndex)
  {
    // ColumnNamingConvention is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setColumnNamingConvention(columnNamingConvention);
  }

  public void setPlateColumns(PositiveInteger columns, int plateIndex)
  {
    // Columns is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setColumns(columns);
  }

  public void setPlateDescription(String description, int plateIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setDescription(description);
  }

  public void setPlateExternalIdentifier(String externalIdentifier, int plateIndex)
  {
    // ExternalIdentifier is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setExternalIdentifier(externalIdentifier);
  }

  public void setPlateFieldIndex(NonNegativeInteger fieldIndex, int plateIndex)
  {
    // FieldIndex is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setFieldIndex(fieldIndex);
  }

  public void setPlateID(String id, int plateIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }

  public void setPlateName(String name, int plateIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setName(name);
  }

  public void setPlateRowNamingConvention(NamingConvention rowNamingConvention, int plateIndex)
  {
    // RowNamingConvention is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setRowNamingConvention(rowNamingConvention);
  }

  public void setPlateRows(PositiveInteger rows, int plateIndex)
  {
    // Rows is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setRows(rows);
  }

  public void setPlateStatus(String status, int plateIndex)
  {
    // Status is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setStatus(status);
  }

  public void setPlateWellOriginX(Length wellOriginX, int plateIndex)
  {
    // WellOriginX is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setWellOriginX(wellOriginX);
  }

  public void setPlateWellOriginY(Length wellOriginY, int plateIndex)
  {
    // WellOriginY is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    o1.setWellOriginY(wellOriginY);
  }


  //
  // PlateAcquisition property storage

  public void setPlateAcquisitionAnnotationRef(String annotation, int plateIndex, int plateAcquisitionIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      PlateAcquisition concreteObject = root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex),
        annotationLinks_reference);
    }
  }

  public void setPlateAcquisitionDescription(String description, int plateIndex, int plateAcquisitionIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfPlateAcquisitionList() == plateAcquisitionIndex)
    {
      o1.addPlateAcquisition(new PlateAcquisition());
    }
    PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
    o2.setDescription(description);
  }

  public void setPlateAcquisitionEndTime(Timestamp endTime, int plateIndex, int plateAcquisitionIndex)
  {
    // EndTime is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfPlateAcquisitionList() == plateAcquisitionIndex)
    {
      o1.addPlateAcquisition(new PlateAcquisition());
    }
    PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
    o2.setEndTime(endTime);
  }

  public void setPlateAcquisitionID(String id, int plateIndex, int plateAcquisitionIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfPlateAcquisitionList() == plateAcquisitionIndex)
    {
      o1.addPlateAcquisition(new PlateAcquisition());
    }
    PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setPlateAcquisitionMaximumFieldCount(PositiveInteger maximumFieldCount, int plateIndex, int plateAcquisitionIndex)
  {
    // MaximumFieldCount is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfPlateAcquisitionList() == plateAcquisitionIndex)
    {
      o1.addPlateAcquisition(new PlateAcquisition());
    }
    PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
    o2.setMaximumFieldCount(maximumFieldCount);
  }

  public void setPlateAcquisitionName(String name, int plateIndex, int plateAcquisitionIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfPlateAcquisitionList() == plateAcquisitionIndex)
    {
      o1.addPlateAcquisition(new PlateAcquisition());
    }
    PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
    o2.setName(name);
  }

  public void setPlateAcquisitionStartTime(Timestamp startTime, int plateIndex, int plateAcquisitionIndex)
  {
    // StartTime is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfPlateAcquisitionList() == plateAcquisitionIndex)
    {
      o1.addPlateAcquisition(new PlateAcquisition());
    }
    PlateAcquisition o2 = o1.getPlateAcquisition(plateAcquisitionIndex);
    o2.setStartTime(startTime);
  }

  public void setPlateAcquisitionWellSampleRef(String wellSample, int plateIndex, int plateAcquisitionIndex, int wellSampleRefIndex)
  {
    // WellSampleRef is reference and occurs more than once
    WellSampleRef wellSamples_reference = new WellSampleRef();
    wellSamples_reference.setID(wellSample);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(wellSample);
    if (referencedObj != null && referencedObj instanceof WellSample)
    {
      WellSample typedRef = (WellSample) referencedObj;
      PlateAcquisition concreteObject = root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedWellSampleList() == wellSampleRefIndex)
      {
        concreteObject.linkWellSample(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedWellSample(wellSampleRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getPlate(plateIndex).getPlateAcquisition(plateAcquisitionIndex),
        wellSamples_reference);
    }
  }


  //
  // PlateRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference PlateRef


  //
  // Point property storage

  public void setPointAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Point concreteObject = ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Point)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)),
        annotationLinks_reference);
    }
  }

  public void setPointFillColor(Color fillColor, int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setFillColor(fillColor);
  }

  public void setPointFillRule(FillRule fillRule, int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setFillRule(fillRule);
  }

  public void setPointFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setFontFamily(fontFamily);
  }

  public void setPointFontSize(Length fontSize, int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setFontSize(fontSize);
  }

  public void setPointFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setFontStyle(fontStyle);
  }

  public void setPointID(String id, int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
  }

  public void setPointLocked(Boolean locked, int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setLocked(locked);
  }

  public void setPointStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setStrokeColor(strokeColor);
  }

  public void setPointStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setStrokeDashArray(strokeDashArray);
  }

  public void setPointStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setStrokeWidth(strokeWidth);
  }

  public void setPointText(String text, int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setText(text);
  }

  public void setPointTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setTheC(theC);
  }

  public void setPointTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setTheT(theT);
  }

  public void setPointTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setTheZ(theZ);
  }

  public void setPointTransform(AffineTransform transform, int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setTransform(transform);
  }

  public void setPointX(Double x, int ROIIndex, int shapeIndex)
  {
    // X is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setX(x);
  }

  public void setPointY(Double y, int ROIIndex, int shapeIndex)
  {
    // Y is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Point());
    }
    Point o3 = (Point) o2.getShape(shapeIndex);
    o3.setY(y);
  }


  //
  // Polygon property storage

  public void setPolygonAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Polygon concreteObject = ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Polygon)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)),
        annotationLinks_reference);
    }
  }

  public void setPolygonFillColor(Color fillColor, int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setFillColor(fillColor);
  }

  public void setPolygonFillRule(FillRule fillRule, int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setFillRule(fillRule);
  }

  public void setPolygonFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setFontFamily(fontFamily);
  }

  public void setPolygonFontSize(Length fontSize, int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setFontSize(fontSize);
  }

  public void setPolygonFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setFontStyle(fontStyle);
  }

  public void setPolygonID(String id, int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
  }

  public void setPolygonLocked(Boolean locked, int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setLocked(locked);
  }

  public void setPolygonPoints(String points, int ROIIndex, int shapeIndex)
  {
    // Points is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setPoints(points);
  }

  public void setPolygonStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setStrokeColor(strokeColor);
  }

  public void setPolygonStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setStrokeDashArray(strokeDashArray);
  }

  public void setPolygonStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setStrokeWidth(strokeWidth);
  }

  public void setPolygonText(String text, int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setText(text);
  }

  public void setPolygonTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setTheC(theC);
  }

  public void setPolygonTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setTheT(theT);
  }

  public void setPolygonTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setTheZ(theZ);
  }

  public void setPolygonTransform(AffineTransform transform, int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polygon());
    }
    Polygon o3 = (Polygon) o2.getShape(shapeIndex);
    o3.setTransform(transform);
  }


  //
  // Polyline property storage

  public void setPolylineAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Polyline concreteObject = ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Polyline)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)),
        annotationLinks_reference);
    }
  }

  public void setPolylineFillColor(Color fillColor, int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setFillColor(fillColor);
  }

  public void setPolylineFillRule(FillRule fillRule, int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setFillRule(fillRule);
  }

  public void setPolylineFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setFontFamily(fontFamily);
  }

  public void setPolylineFontSize(Length fontSize, int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setFontSize(fontSize);
  }

  public void setPolylineFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setFontStyle(fontStyle);
  }

  public void setPolylineID(String id, int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
  }

  public void setPolylineLocked(Boolean locked, int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setLocked(locked);
  }

  public void setPolylineMarkerEnd(Marker markerEnd, int ROIIndex, int shapeIndex)
  {
    // MarkerEnd is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setMarkerEnd(markerEnd);
  }

  public void setPolylineMarkerStart(Marker markerStart, int ROIIndex, int shapeIndex)
  {
    // MarkerStart is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setMarkerStart(markerStart);
  }

  public void setPolylinePoints(String points, int ROIIndex, int shapeIndex)
  {
    // Points is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setPoints(points);
  }

  public void setPolylineStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setStrokeColor(strokeColor);
  }

  public void setPolylineStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setStrokeDashArray(strokeDashArray);
  }

  public void setPolylineStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setStrokeWidth(strokeWidth);
  }

  public void setPolylineText(String text, int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setText(text);
  }

  public void setPolylineTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setTheC(theC);
  }

  public void setPolylineTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setTheT(theT);
  }

  public void setPolylineTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setTheZ(theZ);
  }

  public void setPolylineTransform(AffineTransform transform, int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Polyline());
    }
    Polyline o3 = (Polyline) o2.getShape(shapeIndex);
    o3.setTransform(transform);
  }


  //
  // Project property storage

  public void setProjectAnnotationRef(String annotation, int projectIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Project concreteObject = root.getProject(projectIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getProject(projectIndex),
        annotationLinks_reference);
    }
  }

  public void setProjectDatasetRef(String dataset, int projectIndex, int datasetRefIndex)
  {
    // DatasetRef is reference and occurs more than once
    DatasetRef datasetLinks_reference = new DatasetRef();
    datasetLinks_reference.setID(dataset);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(dataset);
    if (referencedObj != null && referencedObj instanceof Dataset)
    {
      Dataset typedRef = (Dataset) referencedObj;
      Project concreteObject = root.getProject(projectIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedDatasetList() == datasetRefIndex)
      {
        concreteObject.linkDataset(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedDataset(datasetRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getProject(projectIndex),
        datasetLinks_reference);
    }
  }

  public void setProjectDescription(String description, int projectIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfProjectList() == projectIndex)
    {
      o0.addProject(new Project());
    }
    Project o1 = o0.getProject(projectIndex);
    o1.setDescription(description);
  }

  public void setProjectExperimenterGroupRef(String experimenterGroup, int projectIndex)
  {
    // ExperimenterGroupRef is reference and occurs more than once
    ExperimenterGroupRef experimenterGroup_reference = new ExperimenterGroupRef();
    experimenterGroup_reference.setID(experimenterGroup);
    model.addReference(
      root.getProject(projectIndex),
      experimenterGroup_reference);
  }

  public void setProjectExperimenterRef(String experimenter, int projectIndex)
  {
    // ExperimenterRef is reference and occurs more than once
    ExperimenterRef experimenter_reference = new ExperimenterRef();
    experimenter_reference.setID(experimenter);
    model.addReference(
      root.getProject(projectIndex),
      experimenter_reference);
  }

  public void setProjectID(String id, int projectIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfProjectList() == projectIndex)
    {
      o0.addProject(new Project());
    }
    Project o1 = o0.getProject(projectIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }

  public void setProjectName(String name, int projectIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfProjectList() == projectIndex)
    {
      o0.addProject(new Project());
    }
    Project o1 = o0.getProject(projectIndex);
    o1.setName(name);
  }


  //
  // Pump property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference Pump

  // 0:9999
  // Is multi path? False
  // Ignoring Laser_BackReference property of reference Pump


  //
  // ROI property storage

  public void setROIAnnotationRef(String annotation, int ROIIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      ROI concreteObject = root.getROI(ROIIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getROI(ROIIndex),
        annotationLinks_reference);
    }
  }

  public void setROIDescription(String description, int ROIIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    o1.setDescription(description);
  }

  public void setROIID(String id, int ROIIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }

  public void setROIName(String name, int ROIIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    o1.setName(name);
  }


  //
  // ROIRef property storage

  // 1:1
  // Is multi path? True
  // Ignoring ID property of reference ROIRef


  //
  // Reagent property storage

  public void setReagentAnnotationRef(String annotation, int screenIndex, int reagentIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Reagent concreteObject = root.getScreen(screenIndex).getReagent(reagentIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getScreen(screenIndex).getReagent(reagentIndex),
        annotationLinks_reference);
    }
  }

  public void setReagentDescription(String description, int screenIndex, int reagentIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    if (o1.sizeOfReagentList() == reagentIndex)
    {
      o1.addReagent(new Reagent());
    }
    Reagent o2 = o1.getReagent(reagentIndex);
    o2.setDescription(description);
  }

  public void setReagentID(String id, int screenIndex, int reagentIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    if (o1.sizeOfReagentList() == reagentIndex)
    {
      o1.addReagent(new Reagent());
    }
    Reagent o2 = o1.getReagent(reagentIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setReagentName(String name, int screenIndex, int reagentIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    if (o1.sizeOfReagentList() == reagentIndex)
    {
      o1.addReagent(new Reagent());
    }
    Reagent o2 = o1.getReagent(reagentIndex);
    o2.setName(name);
  }

  public void setReagentReagentIdentifier(String reagentIdentifier, int screenIndex, int reagentIndex)
  {
    // ReagentIdentifier is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    if (o1.sizeOfReagentList() == reagentIndex)
    {
      o1.addReagent(new Reagent());
    }
    Reagent o2 = o1.getReagent(reagentIndex);
    o2.setReagentIdentifier(reagentIdentifier);
  }


  //
  // ReagentRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference ReagentRef


  //
  // Rectangle property storage

  public void setRectangleAnnotationRef(String annotation, int ROIIndex, int shapeIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Rectangle concreteObject = ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex));
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        ((Rectangle)root.getROI(ROIIndex).getUnion().getShape(shapeIndex)),
        annotationLinks_reference);
    }
  }

  public void setRectangleFillColor(Color fillColor, int ROIIndex, int shapeIndex)
  {
    // FillColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setFillColor(fillColor);
  }

  public void setRectangleFillRule(FillRule fillRule, int ROIIndex, int shapeIndex)
  {
    // FillRule is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setFillRule(fillRule);
  }

  public void setRectangleFontFamily(FontFamily fontFamily, int ROIIndex, int shapeIndex)
  {
    // FontFamily is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setFontFamily(fontFamily);
  }

  public void setRectangleFontSize(Length fontSize, int ROIIndex, int shapeIndex)
  {
    // FontSize is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setFontSize(fontSize);
  }

  public void setRectangleFontStyle(FontStyle fontStyle, int ROIIndex, int shapeIndex)
  {
    // FontStyle is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setFontStyle(fontStyle);
  }

  public void setRectangleHeight(Double height, int ROIIndex, int shapeIndex)
  {
    // Height is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setHeight(height);
  }

  public void setRectangleID(String id, int ROIIndex, int shapeIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
  }

  public void setRectangleLocked(Boolean locked, int ROIIndex, int shapeIndex)
  {
    // Locked is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setLocked(locked);
  }

  public void setRectangleStrokeColor(Color strokeColor, int ROIIndex, int shapeIndex)
  {
    // StrokeColor is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setStrokeColor(strokeColor);
  }

  public void setRectangleStrokeDashArray(String strokeDashArray, int ROIIndex, int shapeIndex)
  {
    // StrokeDashArray is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setStrokeDashArray(strokeDashArray);
  }

  public void setRectangleStrokeWidth(Length strokeWidth, int ROIIndex, int shapeIndex)
  {
    // StrokeWidth is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setStrokeWidth(strokeWidth);
  }

  public void setRectangleText(String text, int ROIIndex, int shapeIndex)
  {
    // Text is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setText(text);
  }

  public void setRectangleTheC(NonNegativeInteger theC, int ROIIndex, int shapeIndex)
  {
    // TheC is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setTheC(theC);
  }

  public void setRectangleTheT(NonNegativeInteger theT, int ROIIndex, int shapeIndex)
  {
    // TheT is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setTheT(theT);
  }

  public void setRectangleTheZ(NonNegativeInteger theZ, int ROIIndex, int shapeIndex)
  {
    // TheZ is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setTheZ(theZ);
  }

  public void setRectangleTransform(AffineTransform transform, int ROIIndex, int shapeIndex)
  {
    // Transform is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setTransform(transform);
  }

  public void setRectangleWidth(Double width, int ROIIndex, int shapeIndex)
  {
    // Width is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setWidth(width);
  }

  public void setRectangleX(Double x, int ROIIndex, int shapeIndex)
  {
    // X is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setX(x);
  }

  public void setRectangleY(Double y, int ROIIndex, int shapeIndex)
  {
    // Y is not a reference
    OME o0 = root;
    if (o0.sizeOfROIList() == ROIIndex)
    {
      o0.addROI(new ROI());
    }
    ROI o1 = o0.getROI(ROIIndex);
    if (o1.getUnion() == null)
    {
      o1.setUnion(new Union());
    }
    Union o2 = o1.getUnion();
    if (o2.sizeOfShapeList() == shapeIndex)
    {
      o2.addShape(new Rectangle());
    }
    Rectangle o3 = (Rectangle) o2.getShape(shapeIndex);
    o3.setY(y);
  }


  //
  // Rights property storage

  public void setRightsRightsHeld(String rightsHeld)
  {
    // RightsHeld is not a reference
    OME o0 = root;
    if (o0.getRights() == null)
    {
      o0.setRights(new Rights());
    }
    Rights o1 = o0.getRights();
    o1.setRightsHeld(rightsHeld);
  }

  public void setRightsRightsHolder(String rightsHolder)
  {
    // RightsHolder is not a reference
    OME o0 = root;
    if (o0.getRights() == null)
    {
      o0.setRights(new Rights());
    }
    Rights o1 = o0.getRights();
    o1.setRightsHolder(rightsHolder);
  }


  //
  // Screen property storage

  public void setScreenAnnotationRef(String annotation, int screenIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Screen concreteObject = root.getScreen(screenIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getScreen(screenIndex),
        annotationLinks_reference);
    }
  }

  public void setScreenDescription(String description, int screenIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    o1.setDescription(description);
  }

  public void setScreenID(String id, int screenIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    model.addModelObject(id, o1);
    o1.setID(id);
  }

  public void setScreenName(String name, int screenIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    o1.setName(name);
  }

  public void setScreenPlateRef(String plate, int screenIndex, int plateRefIndex)
  {
    // PlateRef is reference and occurs more than once
    PlateRef plateLinks_reference = new PlateRef();
    plateLinks_reference.setID(plate);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(plate);
    if (referencedObj != null && referencedObj instanceof Plate)
    {
      Plate typedRef = (Plate) referencedObj;
      Screen concreteObject = root.getScreen(screenIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedPlateList() == plateRefIndex)
      {
        concreteObject.linkPlate(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedPlate(plateRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getScreen(screenIndex),
        plateLinks_reference);
    }
  }

  public void setScreenProtocolDescription(String protocolDescription, int screenIndex)
  {
    // ProtocolDescription is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    o1.setProtocolDescription(protocolDescription);
  }

  public void setScreenProtocolIdentifier(String protocolIdentifier, int screenIndex)
  {
    // ProtocolIdentifier is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    o1.setProtocolIdentifier(protocolIdentifier);
  }

  public void setScreenReagentSetDescription(String reagentSetDescription, int screenIndex)
  {
    // ReagentSetDescription is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    o1.setReagentSetDescription(reagentSetDescription);
  }

  public void setScreenReagentSetIdentifier(String reagentSetIdentifier, int screenIndex)
  {
    // ReagentSetIdentifier is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    o1.setReagentSetIdentifier(reagentSetIdentifier);
  }

  public void setScreenType(String type, int screenIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfScreenList() == screenIndex)
    {
      o0.addScreen(new Screen());
    }
    Screen o1 = o0.getScreen(screenIndex);
    o1.setType(type);
  }


  //
  // StageLabel property storage

  public void setStageLabelName(String name, int imageIndex)
  {
    // Name is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getStageLabel() == null)
    {
      o1.setStageLabel(new StageLabel());
    }
    StageLabel o2 = o1.getStageLabel();
    o2.setName(name);
  }

  public void setStageLabelX(Length x, int imageIndex)
  {
    // X is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getStageLabel() == null)
    {
      o1.setStageLabel(new StageLabel());
    }
    StageLabel o2 = o1.getStageLabel();
    o2.setX(x);
  }

  public void setStageLabelY(Length y, int imageIndex)
  {
    // Y is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getStageLabel() == null)
    {
      o1.setStageLabel(new StageLabel());
    }
    StageLabel o2 = o1.getStageLabel();
    o2.setY(y);
  }

  public void setStageLabelZ(Length z, int imageIndex)
  {
    // Z is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getStageLabel() == null)
    {
      o1.setStageLabel(new StageLabel());
    }
    StageLabel o2 = o1.getStageLabel();
    o2.setZ(z);
  }


  //
  // StructuredAnnotations property storage


  //
  // TagAnnotation property storage

  public void setTagAnnotationAnnotationRef(String annotation, int tagAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      TagAnnotation concreteObject = root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getTagAnnotation(tagAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setTagAnnotationAnnotator(String annotator, int tagAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTagAnnotationList() == tagAnnotationIndex)
    {
      o1.addTagAnnotation(new TagAnnotation());
    }
    TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setTagAnnotationDescription(String description, int tagAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTagAnnotationList() == tagAnnotationIndex)
    {
      o1.addTagAnnotation(new TagAnnotation());
    }
    TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
    o2.setDescription(description);
  }

  public void setTagAnnotationID(String id, int tagAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTagAnnotationList() == tagAnnotationIndex)
    {
      o1.addTagAnnotation(new TagAnnotation());
    }
    TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setTagAnnotationNamespace(String namespace, int tagAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTagAnnotationList() == tagAnnotationIndex)
    {
      o1.addTagAnnotation(new TagAnnotation());
    }
    TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
    o2.setNamespace(namespace);
  }

  public void setTagAnnotationValue(String value, int tagAnnotationIndex)
  {
    // Value is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTagAnnotationList() == tagAnnotationIndex)
    {
      o1.addTagAnnotation(new TagAnnotation());
    }
    TagAnnotation o2 = o1.getTagAnnotation(tagAnnotationIndex);
    o2.setValue(value);
  }


  //
  // TermAnnotation property storage

  public void setTermAnnotationAnnotationRef(String annotation, int termAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      TermAnnotation concreteObject = root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getTermAnnotation(termAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setTermAnnotationAnnotator(String annotator, int termAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTermAnnotationList() == termAnnotationIndex)
    {
      o1.addTermAnnotation(new TermAnnotation());
    }
    TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setTermAnnotationDescription(String description, int termAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTermAnnotationList() == termAnnotationIndex)
    {
      o1.addTermAnnotation(new TermAnnotation());
    }
    TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
    o2.setDescription(description);
  }

  public void setTermAnnotationID(String id, int termAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTermAnnotationList() == termAnnotationIndex)
    {
      o1.addTermAnnotation(new TermAnnotation());
    }
    TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setTermAnnotationNamespace(String namespace, int termAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTermAnnotationList() == termAnnotationIndex)
    {
      o1.addTermAnnotation(new TermAnnotation());
    }
    TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
    o2.setNamespace(namespace);
  }

  public void setTermAnnotationValue(String value, int termAnnotationIndex)
  {
    // Value is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTermAnnotationList() == termAnnotationIndex)
    {
      o1.addTermAnnotation(new TermAnnotation());
    }
    TermAnnotation o2 = o1.getTermAnnotation(termAnnotationIndex);
    o2.setValue(value);
  }


  //
  // TiffData property storage

  public void setTiffDataFirstC(NonNegativeInteger firstC, int imageIndex, int tiffDataIndex)
  {
    // FirstC is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfTiffDataList() == tiffDataIndex)
    {
      o2.addTiffData(new TiffData());
    }
    TiffData o3 = o2.getTiffData(tiffDataIndex);
    o3.setFirstC(firstC);
  }

  public void setTiffDataFirstT(NonNegativeInteger firstT, int imageIndex, int tiffDataIndex)
  {
    // FirstT is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfTiffDataList() == tiffDataIndex)
    {
      o2.addTiffData(new TiffData());
    }
    TiffData o3 = o2.getTiffData(tiffDataIndex);
    o3.setFirstT(firstT);
  }

  public void setTiffDataFirstZ(NonNegativeInteger firstZ, int imageIndex, int tiffDataIndex)
  {
    // FirstZ is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfTiffDataList() == tiffDataIndex)
    {
      o2.addTiffData(new TiffData());
    }
    TiffData o3 = o2.getTiffData(tiffDataIndex);
    o3.setFirstZ(firstZ);
  }

  public void setTiffDataIFD(NonNegativeInteger ifd, int imageIndex, int tiffDataIndex)
  {
    // IFD is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfTiffDataList() == tiffDataIndex)
    {
      o2.addTiffData(new TiffData());
    }
    TiffData o3 = o2.getTiffData(tiffDataIndex);
    o3.setIFD(ifd);
  }

  public void setTiffDataPlaneCount(NonNegativeInteger planeCount, int imageIndex, int tiffDataIndex)
  {
    // PlaneCount is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfTiffDataList() == tiffDataIndex)
    {
      o2.addTiffData(new TiffData());
    }
    TiffData o3 = o2.getTiffData(tiffDataIndex);
    o3.setPlaneCount(planeCount);
  }


  //
  // TimestampAnnotation property storage

  public void setTimestampAnnotationAnnotationRef(String annotation, int timestampAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      TimestampAnnotation concreteObject = root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getTimestampAnnotation(timestampAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setTimestampAnnotationAnnotator(String annotator, int timestampAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTimestampAnnotationList() == timestampAnnotationIndex)
    {
      o1.addTimestampAnnotation(new TimestampAnnotation());
    }
    TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setTimestampAnnotationDescription(String description, int timestampAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTimestampAnnotationList() == timestampAnnotationIndex)
    {
      o1.addTimestampAnnotation(new TimestampAnnotation());
    }
    TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
    o2.setDescription(description);
  }

  public void setTimestampAnnotationID(String id, int timestampAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTimestampAnnotationList() == timestampAnnotationIndex)
    {
      o1.addTimestampAnnotation(new TimestampAnnotation());
    }
    TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setTimestampAnnotationNamespace(String namespace, int timestampAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTimestampAnnotationList() == timestampAnnotationIndex)
    {
      o1.addTimestampAnnotation(new TimestampAnnotation());
    }
    TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
    o2.setNamespace(namespace);
  }

  public void setTimestampAnnotationValue(Timestamp value, int timestampAnnotationIndex)
  {
    // Value is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfTimestampAnnotationList() == timestampAnnotationIndex)
    {
      o1.addTimestampAnnotation(new TimestampAnnotation());
    }
    TimestampAnnotation o2 = o1.getTimestampAnnotation(timestampAnnotationIndex);
    o2.setValue(value);
  }


  //
  // TransmittanceRange property storage

  public void setTransmittanceRangeCutIn(Length cutIn, int instrumentIndex, int filterIndex)
  {
    // CutIn is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    if (o2.getTransmittanceRange() == null)
    {
      o2.setTransmittanceRange(new TransmittanceRange());
    }
    TransmittanceRange o3 = o2.getTransmittanceRange();
    o3.setCutIn(cutIn);
  }

  public void setTransmittanceRangeCutInTolerance(Length cutInTolerance, int instrumentIndex, int filterIndex)
  {
    // CutInTolerance is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    if (o2.getTransmittanceRange() == null)
    {
      o2.setTransmittanceRange(new TransmittanceRange());
    }
    TransmittanceRange o3 = o2.getTransmittanceRange();
    o3.setCutInTolerance(cutInTolerance);
  }

  public void setTransmittanceRangeCutOut(Length cutOut, int instrumentIndex, int filterIndex)
  {
    // CutOut is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    if (o2.getTransmittanceRange() == null)
    {
      o2.setTransmittanceRange(new TransmittanceRange());
    }
    TransmittanceRange o3 = o2.getTransmittanceRange();
    o3.setCutOut(cutOut);
  }

  public void setTransmittanceRangeCutOutTolerance(Length cutOutTolerance, int instrumentIndex, int filterIndex)
  {
    // CutOutTolerance is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    if (o2.getTransmittanceRange() == null)
    {
      o2.setTransmittanceRange(new TransmittanceRange());
    }
    TransmittanceRange o3 = o2.getTransmittanceRange();
    o3.setCutOutTolerance(cutOutTolerance);
  }

  public void setTransmittanceRangeTransmittance(PercentFraction transmittance, int instrumentIndex, int filterIndex)
  {
    // Transmittance is not a reference
    OME o0 = root;
    if (o0.sizeOfInstrumentList() == instrumentIndex)
    {
      o0.addInstrument(new Instrument());
    }
    Instrument o1 = o0.getInstrument(instrumentIndex);
    if (o1.sizeOfFilterList() == filterIndex)
    {
      o1.addFilter(new Filter());
    }
    Filter o2 = o1.getFilter(filterIndex);
    if (o2.getTransmittanceRange() == null)
    {
      o2.setTransmittanceRange(new TransmittanceRange());
    }
    TransmittanceRange o3 = o2.getTransmittanceRange();
    o3.setTransmittance(transmittance);
  }


  //
  // UUID property storage

  public void setUUIDFileName(String fileName, int imageIndex, int tiffDataIndex)
  {
    // FileName is not a reference
    OME o0 = root;
    if (o0.sizeOfImageList() == imageIndex)
    {
      o0.addImage(new Image());
    }
    Image o1 = o0.getImage(imageIndex);
    if (o1.getPixels() == null)
    {
      o1.setPixels(new Pixels());
    }
    Pixels o2 = o1.getPixels();
    if (o2.sizeOfTiffDataList() == tiffDataIndex)
    {
      o2.addTiffData(new TiffData());
    }
    TiffData o3 = o2.getTiffData(tiffDataIndex);
    if (o3.getUUID() == null)
    {
      o3.setUUID(new UUID());
    }
    UUID o4 = o3.getUUID();
    o4.setFileName(fileName);
  }


  //
  // Union property storage


  //
  // Well property storage

  public void setWellAnnotationRef(String annotation, int plateIndex, int wellIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      Well concreteObject = root.getPlate(plateIndex).getWell(wellIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getPlate(plateIndex).getWell(wellIndex),
        annotationLinks_reference);
    }
  }

  public void setWellColor(Color color, int plateIndex, int wellIndex)
  {
    // Color is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    o2.setColor(color);
  }

  public void setWellColumn(NonNegativeInteger column, int plateIndex, int wellIndex)
  {
    // Column is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    o2.setColumn(column);
  }

  public void setWellExternalDescription(String externalDescription, int plateIndex, int wellIndex)
  {
    // ExternalDescription is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    o2.setExternalDescription(externalDescription);
  }

  public void setWellExternalIdentifier(String externalIdentifier, int plateIndex, int wellIndex)
  {
    // ExternalIdentifier is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    o2.setExternalIdentifier(externalIdentifier);
  }

  public void setWellID(String id, int plateIndex, int wellIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setWellReagentRef(String reagent, int plateIndex, int wellIndex)
  {
    // ReagentRef is reference and occurs more than once
    ReagentRef reagent_reference = new ReagentRef();
    reagent_reference.setID(reagent);
    model.addReference(
      root.getPlate(plateIndex).getWell(wellIndex),
      reagent_reference);
  }

  public void setWellRow(NonNegativeInteger row, int plateIndex, int wellIndex)
  {
    // Row is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    o2.setRow(row);
  }

  public void setWellType(String type, int plateIndex, int wellIndex)
  {
    // Type is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    o2.setType(type);
  }


  //
  // WellSample property storage

  public void setWellSampleID(String id, int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    if (o2.sizeOfWellSampleList() == wellSampleIndex)
    {
      o2.addWellSample(new WellSample());
    }
    WellSample o3 = o2.getWellSample(wellSampleIndex);
    model.addModelObject(id, o3);
    o3.setID(id);
  }

  public void setWellSampleImageRef(String image, int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // ImageRef is reference and occurs more than once
    ImageRef image_reference = new ImageRef();
    image_reference.setID(image);
    model.addReference(
      root.getPlate(plateIndex).getWell(wellIndex).getWellSample(wellSampleIndex),
      image_reference);
  }

  public void setWellSampleIndex(NonNegativeInteger index, int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // Index is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    if (o2.sizeOfWellSampleList() == wellSampleIndex)
    {
      o2.addWellSample(new WellSample());
    }
    WellSample o3 = o2.getWellSample(wellSampleIndex);
    o3.setIndex(index);
  }

  public void setWellSamplePositionX(Length positionX, int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // PositionX is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    if (o2.sizeOfWellSampleList() == wellSampleIndex)
    {
      o2.addWellSample(new WellSample());
    }
    WellSample o3 = o2.getWellSample(wellSampleIndex);
    o3.setPositionX(positionX);
  }

  public void setWellSamplePositionY(Length positionY, int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // PositionY is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    if (o2.sizeOfWellSampleList() == wellSampleIndex)
    {
      o2.addWellSample(new WellSample());
    }
    WellSample o3 = o2.getWellSample(wellSampleIndex);
    o3.setPositionY(positionY);
  }

  public void setWellSampleTimepoint(Timestamp timepoint, int plateIndex, int wellIndex, int wellSampleIndex)
  {
    // Timepoint is not a reference
    OME o0 = root;
    if (o0.sizeOfPlateList() == plateIndex)
    {
      o0.addPlate(new Plate());
    }
    Plate o1 = o0.getPlate(plateIndex);
    if (o1.sizeOfWellList() == wellIndex)
    {
      o1.addWell(new Well());
    }
    Well o2 = o1.getWell(wellIndex);
    if (o2.sizeOfWellSampleList() == wellSampleIndex)
    {
      o2.addWellSample(new WellSample());
    }
    WellSample o3 = o2.getWellSample(wellSampleIndex);
    o3.setTimepoint(timepoint);
  }


  //
  // WellSampleRef property storage

  // 1:1
  // Is multi path? False
  // Ignoring ID property of reference WellSampleRef


  //
  // XMLAnnotation property storage

  public void setXMLAnnotationAnnotationRef(String annotation, int XMLAnnotationIndex, int annotationRefIndex)
  {
    // AnnotationRef is reference and occurs more than once
    AnnotationRef annotationLinks_reference = new AnnotationRef();
    annotationLinks_reference.setID(annotation);
    // Try to resolve reference immediately if the referenced object exists
    OMEModelObject referencedObj = model.getModelObject(annotation);
    if (referencedObj != null && referencedObj instanceof Annotation)
    {
      Annotation typedRef = (Annotation) referencedObj;
      XMLAnnotation concreteObject = root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex);
      // Extend list by one element if needed (only allows sequential growth)
      if (concreteObject.sizeOfLinkedAnnotationList() == annotationRefIndex)
      {
        concreteObject.linkAnnotation(typedRef);
      }
      else
      {
        // Set at specific index
        concreteObject.setLinkedAnnotation(annotationRefIndex, typedRef);
      }
    }
    else
    {
      // Deferred resolution: reference will be resolved later
      model.addReference(
        root.getStructuredAnnotations().getXMLAnnotation(XMLAnnotationIndex),
        annotationLinks_reference);
    }
  }

  public void setXMLAnnotationAnnotator(String annotator, int XMLAnnotationIndex)
  {
    // Annotator is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfXMLAnnotationList() == XMLAnnotationIndex)
    {
      o1.addXMLAnnotation(new XMLAnnotation());
    }
    XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
    o2.setAnnotator(annotator);
  }

  public void setXMLAnnotationDescription(String description, int XMLAnnotationIndex)
  {
    // Description is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfXMLAnnotationList() == XMLAnnotationIndex)
    {
      o1.addXMLAnnotation(new XMLAnnotation());
    }
    XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
    o2.setDescription(description);
  }

  public void setXMLAnnotationID(String id, int XMLAnnotationIndex)
  {
    // ID is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfXMLAnnotationList() == XMLAnnotationIndex)
    {
      o1.addXMLAnnotation(new XMLAnnotation());
    }
    XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
    model.addModelObject(id, o2);
    o2.setID(id);
  }

  public void setXMLAnnotationNamespace(String namespace, int XMLAnnotationIndex)
  {
    // Namespace is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfXMLAnnotationList() == XMLAnnotationIndex)
    {
      o1.addXMLAnnotation(new XMLAnnotation());
    }
    XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
    o2.setNamespace(namespace);
  }

  public void setXMLAnnotationValue(String value, int XMLAnnotationIndex)
  {
    // Value is not a reference
    OME o0 = root;
    if (o0.getStructuredAnnotations() == null)
    {
      o0.setStructuredAnnotations(new StructuredAnnotations());
    }
    StructuredAnnotations o1 = o0.getStructuredAnnotations();
    if (o1.sizeOfXMLAnnotationList() == XMLAnnotationIndex)
    {
      o1.addXMLAnnotation(new XMLAnnotation());
    }
    XMLAnnotation o2 = o1.getXMLAnnotation(XMLAnnotationIndex);
    o2.setValue(value);
  }

}
