/*
 * #%L
 * OME-XML Java library for working with OME-XML metadata structures.
 * %%
 * Copyright (C) 2006 - 2016 Open Microscopy Environment:
 *   - Massachusetts Institute of Technology
 *   - National Institutes of Health
 *   - University of Dundee
 *   - Board of Regents of the University of Wisconsin-Madison
 *   - Glencoe Software, Inc.
 * %%
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT HOLDERS OR CONTRIBUTORS BE
 * LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
 * CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
 * SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
 * INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
 * CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
 * ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * The views and conclusions contained in the software and documentation are
 * those of the authors and should not be interpreted as representing official
 * policies, either expressed or implied, of any organization.
 * #L%
 */

/*-----------------------------------------------------------------------------
 *
 * THIS IS AUTOMATICALLY GENERATED CODE.  DO NOT MODIFY.
 *
 *-----------------------------------------------------------------------------
 */

package ome.xml.model;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import ome.xml.model.enums.*;
import ome.xml.model.enums.handlers.*;
import ome.xml.model.primitives.*;
import ome.units.quantity.*;
import ome.units.unit.Unit;

public class Polyline extends Shape
{
  // Base: Shape -- Name: Polyline -- Type: Polyline -- modelBaseType: Shape -- langBaseType: Object

  // -- Constants --

  public static final String NAMESPACE = "http://www.openmicroscopy.org/Schemas/OME/2016-06";

  /** Logger for this class. */
  private static final Logger LOGGER =
    LoggerFactory.getLogger(Polyline.class);

  // -- Instance variables --

  // Points property
  private String points;

  // MarkerStart property
  private Marker markerStart;

  // MarkerEnd property
  private Marker markerEnd;

  // -- Constructors --

  /** Default constructor. */
  public Polyline()
  {
    super();
  }



  /**
   * Constructs Polyline recursively from an XML DOM tree.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public Polyline(Element element, OMEModel model)
    throws EnumerationException
  {
    update(element, model);
  }

  /** Copy constructor. */
  public Polyline(Polyline orig)
  {
    super(orig);
    points = orig.points;
    markerStart = orig.markerStart;
    markerEnd = orig.markerEnd;
  }

  // -- Custom content from Polyline specific template --


  // -- OMEModelObject API methods --

  /**
   * Updates Polyline recursively from an XML DOM tree. <b>NOTE:</b> No
   * properties are removed, only added or updated.
   * @param element Root of the XML DOM tree to construct a model object
   * graph from.
   * @param model Handler for the OME model which keeps track of instances
   * and references seen during object population.
   * @throws EnumerationException If there is an error instantiating an
   * enumeration during model object creation.
   */
  public void update(Element element, OMEModel model)
    throws EnumerationException
  {
    super.update(element, model);
    if (element.hasAttribute("Points"))
    {
      // Attribute property Points
      setPoints(String.valueOf(
        element.getAttribute("Points")));
    }
    if (element.hasAttribute("MarkerStart"))
    {
      // Attribute property which is an enumeration MarkerStart
      setMarkerStart(Marker.fromString(
        element.getAttribute("MarkerStart")));
    }
    if (element.hasAttribute("MarkerEnd"))
    {
      // Attribute property which is an enumeration MarkerEnd
      setMarkerEnd(Marker.fromString(
        element.getAttribute("MarkerEnd")));
    }
  }

  // -- Polyline API methods --

  public boolean link(Reference reference, OMEModelObject o)
  {
    return super.link(reference, o);
  }

  // Property Points
  public String getPoints()
  {
    return points;
  }

  public void setPoints(String points)
  {
    this.points = points;
  }

  // Property MarkerStart
  public Marker getMarkerStart()
  {
    return markerStart;
  }

  public void setMarkerStart(Marker markerStart)
  {
    this.markerStart = markerStart;
  }

  // Property MarkerEnd
  public Marker getMarkerEnd()
  {
    return markerEnd;
  }

  public void setMarkerEnd(Marker markerEnd)
  {
    this.markerEnd = markerEnd;
  }

  public Element asXMLElement(Document document)
  {
    return asXMLElement(document, null);
  }

  public Element asXMLElement(Document document, Element Polyline_element)
  {
    // Creating XML block for Polyline
    if (Polyline_element == null)
    {
      Polyline_element =
        document.createElementNS(NAMESPACE, "Polyline");
    }

    // Ensure any base annotations add their Elements first
    super.asXMLElement(document, Polyline_element);

    if (points != null)
    {
      // Attribute property Points
      Polyline_element.setAttribute("Points", points);
    }
    if (markerStart != null)
    {
      // Attribute property MarkerStart
      Polyline_element.setAttribute("MarkerStart", markerStart.toString());
    }
    if (markerEnd != null)
    {
      // Attribute property MarkerEnd
      Polyline_element.setAttribute("MarkerEnd", markerEnd.toString());
    }

    return Polyline_element;
  }
}
