/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft.point;

import java.io.IOException;
import java.util.List;
import javax.annotation.Nonnull;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.ft.PointFeatureCC;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.point.DsgCollectionImpl;
import ucar.nc2.ft.point.PointCollectionImpl;
import ucar.nc2.ft.point.PointIteratorFlatten;
import ucar.nc2.time.CalendarDateRange;
import ucar.nc2.time.CalendarDateUnit;
import ucar.unidata.geoloc.LatLonRect;

public abstract class PointFeatureCCImpl
extends DsgCollectionImpl
implements PointFeatureCC {
    protected FeatureType collectionFeatureType;

    protected PointFeatureCCImpl(String name, CalendarDateUnit timeUnit, String altUnits, FeatureType collectionFeatureType) {
        super(name, timeUnit, altUnits);
        this.collectionFeatureType = collectionFeatureType;
    }

    protected PointFeatureCCImpl(String name, List<CoordinateAxis> coords, FeatureType collectionFeatureType) {
        super(name, coords);
        this.collectionFeatureType = collectionFeatureType;
    }

    @Override
    @Nonnull
    public FeatureType getCollectionFeatureType() {
        return this.collectionFeatureType;
    }

    private static class NestedPointFeatureCollectionFlatten
    extends PointCollectionImpl {
        protected PointFeatureCCImpl from;
        protected LatLonRect filter_bb;
        protected CalendarDateRange filter_date;

        NestedPointFeatureCollectionFlatten(PointFeatureCCImpl from, LatLonRect filter_bb, CalendarDateRange filter_date) {
            super(from.getName(), from.getTimeUnit(), from.getAltUnits());
            this.from = from;
            this.filter_bb = filter_bb;
            this.filter_date = filter_date;
        }

        @Override
        public PointFeatureIterator getPointFeatureIterator() throws IOException {
            return new PointIteratorFlatten(this.from.getCollectionIterator(), this.filter_bb, this.filter_date);
        }
    }
}

