/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.utests.tiff;

import java.io.File;
import loci.common.services.ServiceFactory;
import loci.formats.ImageWriter;
import loci.formats.in.TiffReader;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import ome.xml.model.enums.DimensionOrder;
import ome.xml.model.enums.PixelType;
import ome.xml.model.primitives.PositiveInteger;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class OMETiffWriterLargeImageWidthTest {
    public static final int SIZE_X = 139256;
    public static final int SIZE_Y = 4;
    public static final int SIZE_Z = 100;
    public static final int SIZE_C = 1;
    public static final int SIZE_T = 20;
    private static final byte[] buf = new byte[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 16, 17, 18, 19, 20, 21};
    private File target;
    private OMEXMLMetadata ms;

    @BeforeClass
    public void setUp() throws Exception {
        this.target = File.createTempFile("OMETiffWriterTest", ".ome.tiff");
        ServiceFactory sf = new ServiceFactory();
        OMEXMLService service = (OMEXMLService)sf.getInstance(OMEXMLService.class);
        this.ms = service.createOMEXMLMetadata();
        this.ms.setImageID("Image:1", 0);
        this.ms.setPixelsID("Pixels:1", 0);
        this.ms.setPixelsDimensionOrder(DimensionOrder.XYZCT, 0);
        this.ms.setPixelsSizeX(new PositiveInteger(Integer.valueOf(139256)), 0);
        this.ms.setPixelsSizeY(new PositiveInteger(Integer.valueOf(4)), 0);
        this.ms.setPixelsSizeZ(new PositiveInteger(Integer.valueOf(100)), 0);
        this.ms.setPixelsSizeC(new PositiveInteger(Integer.valueOf(1)), 0);
        this.ms.setPixelsSizeT(new PositiveInteger(Integer.valueOf(20)), 0);
        this.ms.setPixelsType(PixelType.UINT8, 0);
        this.ms.setPixelsBinDataBigEndian(Boolean.valueOf(true), 0, 0);
        this.ms.setChannelID("Channel:1", 0, 0);
        this.ms.setChannelSamplesPerPixel(new PositiveInteger(Integer.valueOf(1)), 0, 0);
    }

    @AfterClass
    public void tearDown() throws Exception {
        this.target.delete();
    }

    @Test
    public void testImageWidthWrittenCorrectly() throws Exception {
        ImageWriter writer = new ImageWriter();
        writer.setMetadataRetrieve((MetadataRetrieve)this.ms);
        writer.setId(this.target.getAbsolutePath());
        writer.saveBytes(0, buf, 0, 0, buf.length, 1);
        writer.close();
        TiffReader reader = new TiffReader();
        reader.setId(this.target.getAbsolutePath());
        AssertJUnit.assertEquals((int)139256, (int)reader.getSizeX());
        AssertJUnit.assertEquals((int)4, (int)reader.getSizeY());
    }
}

