/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.StringTokenizer;
import loci.common.IniList;
import loci.common.IniParser;

public class EntityList {
    private static final boolean DEBUG = false;
    protected HashMap<String, HashMap<String, String>> versions = new HashMap();
    protected HashMap<String, Entity> entities = new HashMap();
    protected String ver;
    protected String ent;
    protected String prop;

    public EntityList(String versionPath, String entityPath) throws IOException {
        String name;
        System.out.println("Parsing configuration data");
        IniParser parser = new IniParser();
        IniList versionList = parser.parseINI(versionPath, EntityList.class);
        IniList entityList = parser.parseINI(entityPath, EntityList.class);
        for (HashMap attrs : versionList) {
            name = (String)attrs.get("header");
            this.versions.put(name, attrs);
        }
        this.entities = new HashMap();
        block6: for (HashMap attrs : entityList) {
            name = (String)attrs.get("header");
            StringTokenizer st = new StringTokenizer(name);
            int num = st.countTokens();
            switch (num) {
                case 1: {
                    this.entities.put(name, new Entity(attrs));
                    System.out.println("\t" + name);
                    continue block6;
                }
                case 2: {
                    String t1 = st.nextToken();
                    String t2 = st.nextToken();
                    Entity entity = this.entities.get(t1);
                    if (entity == null) {
                        throw new IOException("bad entity name '" + t1 + "'");
                    }
                    attrs.put("header", t2);
                    HashMap<String, String> version = this.versions.get(t2);
                    if (version == null) {
                        entity.props.put(t2, new Property(attrs));
                        continue block6;
                    }
                    entity.versions.put(t2, attrs);
                    continue block6;
                }
                case 3: {
                    String t1 = st.nextToken();
                    String t2 = st.nextToken();
                    String t3 = st.nextToken();
                    Entity entity = this.entities.get(t1);
                    if (entity == null) {
                        throw new IOException("bad entity name '" + t1 + "'");
                    }
                    Property prop = entity.props.get(t2);
                    if (prop == null) {
                        throw new IOException("bad property name '" + t2 + "' for entity '" + t1 + "'");
                    }
                    attrs.put("header", t2);
                    prop.versions.put(t3, attrs);
                    continue block6;
                }
            }
            throw new IOException("bad token count for header '" + name + "'");
        }
    }

    public void setVersion(String version) {
        this.ver = version;
    }

    public String getVersion() {
        return this.ver;
    }

    public void setEntity(String entity) {
        this.ent = entity;
        this.prop = null;
    }

    public String getEntity() {
        return this.ent;
    }

    public void setProperty(String property) {
        this.prop = property;
    }

    public String getProperty() {
        return this.prop;
    }

    public List<String> versions() {
        ArrayList<String> list = new ArrayList<String>(this.versions.keySet());
        Collections.sort(list);
        return list;
    }

    public List<String> entities() {
        ArrayList<String> list = new ArrayList<String>(this.entities.keySet());
        Collections.sort(list);
        return list;
    }

    public List<String> props() {
        if (this.ent == null) {
            return null;
        }
        Entity e = this.entities.get(this.ent);
        ArrayList<String> list = new ArrayList<String>(e.props.keySet());
        Collections.sort(list);
        return list;
    }

    public String name() {
        return this.value("header");
    }

    public String value(String key) {
        return this.value(key, this.ver, this.ent, this.prop);
    }

    public String value(String key, String version, String entity, String property) {
        HashMap<String, String> attrs;
        String value;
        Entity e = null;
        Property p = null;
        if (entity != null) {
            e = this.entities.get(entity);
        }
        if (property != null && e != null) {
            p = e.props.get(property);
        }
        if ((value = null) == null && version != null && p != null && (attrs = p.versions.get(version)) != null) {
            value = attrs.get(key);
        }
        if (value == null && p != null) {
            value = p.attrs.get(key);
        }
        if (value == null && version != null && e != null && (attrs = e.versions.get(version)) != null) {
            value = attrs.get(key);
        }
        if (value == null && e != null) {
            value = e.attrs.get(key);
        }
        if (value == null && version != null && (attrs = this.versions.get(version)) != null) {
            value = attrs.get(key);
        }
        return value;
    }

    private void debug(String s) {
        System.out.println("DEBUG: " + s);
    }
}

