/*
 * Decompiled with CFR 0.152.
 */
package loci.formats.in;

import com.google.common.io.BaseEncoding;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import loci.common.CBZip2InputStream;
import loci.common.RandomAccessInputStream;
import loci.common.services.DependencyException;
import loci.common.services.ServiceException;
import loci.common.services.ServiceFactory;
import loci.common.xml.BaseHandler;
import loci.common.xml.XMLTools;
import loci.formats.CoreMetadata;
import loci.formats.FormatException;
import loci.formats.FormatReader;
import loci.formats.FormatTools;
import loci.formats.IFormatReader;
import loci.formats.MetadataTools;
import loci.formats.MissingLibraryException;
import loci.formats.codec.CodecOptions;
import loci.formats.codec.JPEG2000Codec;
import loci.formats.codec.JPEGCodec;
import loci.formats.codec.ZlibCodec;
import loci.formats.meta.MetadataRetrieve;
import loci.formats.meta.MetadataStore;
import loci.formats.ome.OMEXMLMetadata;
import loci.formats.services.OMEXMLService;
import loci.formats.services.OMEXMLServiceImpl;
import org.xml.sax.Attributes;
import org.xml.sax.Locator;
import org.xml.sax.helpers.DefaultHandler;

public class OMEXMLReader
extends FormatReader {
    private List<BinData> binData;
    private List<Long> binDataOffsets;
    private List<String> compression;
    private String omexml;
    private boolean hasSPW = false;

    public OMEXMLReader() {
        super("OME-XML", new String[]{"ome", "ome.xml"});
        this.domains = FormatTools.NON_GRAPHICS_DOMAINS;
        this.suffixNecessary = false;
    }

    public boolean isThisType(RandomAccessInputStream stream) throws IOException {
        int blockLen = 64;
        String xml = stream.readString(64);
        return xml.startsWith("<?xml") && xml.indexOf("<OME") >= 0;
    }

    public boolean isThisType(String name, boolean open) {
        if (OMEXMLReader.checkSuffix((String)name, (String)"companion.ome")) {
            return false;
        }
        return super.isThisType(name, open);
    }

    public String[] getDomains() {
        String[] stringArray;
        FormatTools.assertId((String)this.currentId, (boolean)true, (int)1);
        if (this.hasSPW) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "High-Content Screening (HCS)";
        } else {
            stringArray = FormatTools.NON_SPECIAL_DOMAINS;
        }
        return stringArray;
    }

    public byte[] openBytes(int no, byte[] buf, int x, int y, int w, int h) throws FormatException, IOException {
        if (this.binDataOffsets.size() == 0) {
            return buf;
        }
        FormatTools.checkPlaneParameters((IFormatReader)this, (int)no, (int)buf.length, (int)x, (int)y, (int)w, (int)h);
        int index = no;
        int series = this.getSeries();
        for (int i = 0; i < series; ++i) {
            index += ((CoreMetadata)this.core.get((int)i)).imageCount;
        }
        if (index >= this.binDataOffsets.size()) {
            index = this.binDataOffsets.size() - 1;
        }
        long offset = this.binDataOffsets.get(index);
        String compress = this.compression.get(index);
        this.in.seek(offset);
        int depth = FormatTools.getBytesPerPixel((int)this.getPixelType());
        int planeSize = this.getSizeX() * this.getSizeY() * depth;
        CodecOptions options = new CodecOptions();
        options.width = this.getSizeX();
        options.height = this.getSizeY();
        options.bitsPerSample = depth * 8;
        options.channels = this.getRGBChannelCount();
        options.maxBytes = planeSize;
        options.littleEndian = this.isLittleEndian();
        options.interleaved = this.isInterleaved();
        String encoded = this.in.readString("<");
        encoded = encoded.trim();
        if (encoded.length() == 0 || encoded.equals("<")) {
            LOGGER.debug("No pixel data for plane #{}", (Object)no);
            return buf;
        }
        encoded = encoded.substring(0, encoded.length() - 1);
        byte[] pixels = BaseEncoding.base64().decode((CharSequence)encoded);
        if (pixels.length == 0) {
            LOGGER.debug("No pixel data for plane #{}", (Object)no);
            return buf;
        }
        if (compress.equals("bzip2")) {
            byte[] tempPixels = pixels;
            pixels = new byte[tempPixels.length - 2];
            System.arraycopy(tempPixels, 2, pixels, 0, pixels.length);
            ByteArrayInputStream bais = new ByteArrayInputStream(pixels);
            CBZip2InputStream bzip = new CBZip2InputStream((InputStream)bais);
            pixels = new byte[planeSize];
            bzip.read(pixels, 0, pixels.length);
            tempPixels = null;
            bais.close();
            bzip.close();
            bais = null;
            bzip = null;
        } else if (compress.equals("zlib")) {
            pixels = new ZlibCodec().decompress(pixels, options);
        } else if (compress.equals("J2K")) {
            pixels = new JPEG2000Codec().decompress(pixels, options);
        } else if (compress.equals("JPEG")) {
            pixels = new JPEGCodec().decompress(pixels, options);
        }
        for (int row = 0; row < h; ++row) {
            int off = (row + y) * this.getSizeX() * depth + x * depth;
            System.arraycopy(pixels, off, buf, row * w * depth, w * depth);
        }
        pixels = null;
        return buf;
    }

    public void close(boolean fileOnly) throws IOException {
        super.close(fileOnly);
        if (!fileOnly) {
            this.compression = null;
            this.binDataOffsets = null;
            this.binData = null;
            this.omexml = null;
            this.hasSPW = false;
        }
    }

    protected void initFile(String id) throws FormatException, IOException {
        OMEXMLMetadata omexmlMeta;
        OMEXMLService service;
        super.initFile(id);
        this.in = new RandomAccessInputStream(id);
        this.in.setEncoding("ASCII");
        this.binData = new ArrayList<BinData>();
        this.binDataOffsets = new ArrayList<Long>();
        this.compression = new ArrayList<String>();
        OMEXMLHandler handler = new OMEXMLHandler();
        try (RandomAccessInputStream s = new RandomAccessInputStream(id);){
            XMLTools.parseXML((RandomAccessInputStream)s, (DefaultHandler)((Object)handler));
        }
        catch (IOException e) {
            throw new FormatException("Malformed OME-XML", (Throwable)e);
        }
        int lineNumber = 1;
        for (BinData bin : this.binData) {
            int line = bin.getRow();
            int col = bin.getColumn();
            while (lineNumber < line) {
                this.in.readLine();
                ++lineNumber;
            }
            this.binDataOffsets.add(this.in.getFilePointer() + (long)col - 1L);
        }
        LOGGER.info("Populating metadata");
        try {
            ServiceFactory factory = new ServiceFactory();
            service = (OMEXMLService)factory.getInstance(OMEXMLService.class);
            omexmlMeta = service.createOMEXMLMetadata(this.omexml);
        }
        catch (DependencyException de) {
            throw new MissingLibraryException(OMEXMLServiceImpl.NO_OME_XML_MSG, (Throwable)de);
        }
        catch (ServiceException se) {
            throw new FormatException((Throwable)se);
        }
        this.hasSPW = omexmlMeta.getPlateCount() > 0;
        Hashtable originalMetadata = service.getOriginalMetadata(omexmlMeta);
        if (originalMetadata != null) {
            this.metadata = originalMetadata;
        }
        int numDatasets = omexmlMeta.getImageCount();
        int oldSeries = this.getSeries();
        this.core.clear();
        for (int i = 0; i < numDatasets; ++i) {
            CoreMetadata ms = new CoreMetadata();
            this.core.add(ms);
            this.setSeries(i);
            Integer w = (Integer)omexmlMeta.getPixelsSizeX(i).getValue();
            Integer h = (Integer)omexmlMeta.getPixelsSizeY(i).getValue();
            Integer t = (Integer)omexmlMeta.getPixelsSizeT(i).getValue();
            Integer z = (Integer)omexmlMeta.getPixelsSizeZ(i).getValue();
            Integer c = (Integer)omexmlMeta.getPixelsSizeC(i).getValue();
            if (w == null || h == null || t == null || z == null || c == null) {
                throw new FormatException("Image dimensions not found");
            }
            Boolean endian = null;
            if (this.binData.size() > 0) {
                endian = false;
                if (omexmlMeta.getPixelsBigEndian(i) != null) {
                    endian = (boolean)omexmlMeta.getPixelsBigEndian(i);
                } else if (omexmlMeta.getPixelsBinDataCount(i) != 0) {
                    endian = (boolean)omexmlMeta.getPixelsBinDataBigEndian(i, 0);
                }
            }
            String pixType = omexmlMeta.getPixelsType(i).toString();
            ms.dimensionOrder = omexmlMeta.getPixelsDimensionOrder(i).toString();
            ms.sizeX = w;
            ms.sizeY = h;
            ms.sizeT = t;
            ms.sizeZ = z;
            ms.sizeC = c;
            ms.imageCount = this.getSizeZ() * this.getSizeC() * this.getSizeT();
            ms.littleEndian = endian == null ? false : endian == false;
            ms.rgb = false;
            ms.interleaved = false;
            ms.indexed = false;
            ms.falseColor = true;
            ms.pixelType = FormatTools.pixelTypeFromString((String)pixType);
            ms.orderCertain = true;
            if (omexmlMeta.getPixelsSignificantBits(i) == null) continue;
            ms.bitsPerPixel = (Integer)omexmlMeta.getPixelsSignificantBits(i).getValue();
        }
        this.setSeries(oldSeries);
        MetadataStore store = this.getMetadataStore();
        service.convertMetadata((MetadataRetrieve)omexmlMeta, store);
        MetadataTools.populatePixels((MetadataStore)store, (IFormatReader)this, (boolean)false, (boolean)false);
    }

    class OMEXMLHandler
    extends BaseHandler {
        private final StringBuilder xmlBuffer = new StringBuilder();
        private String currentQName;
        private Locator locator;
        private boolean inPixels = false;

        public void characters(char[] ch, int start, int length) {
            if (!this.inPixels || this.currentQName.indexOf("BinData") < 0) {
                this.xmlBuffer.append(XMLTools.escapeXML((String)new String(ch, start, length)));
            }
        }

        public void endElement(String uri, String localName, String qName) {
            if (qName.indexOf("Pixels") != -1) {
                this.inPixels = false;
            }
            this.xmlBuffer.append("</");
            this.xmlBuffer.append(qName);
            this.xmlBuffer.append(">");
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) {
            this.currentQName = qName;
            if (qName.indexOf("Pixels") != -1) {
                this.inPixels = true;
            }
            if (this.inPixels && qName.indexOf("BinData") != -1) {
                OMEXMLReader.this.binData.add(new BinData(this.locator.getLineNumber(), this.locator.getColumnNumber()));
                String compress = attributes.getValue("Compression");
                OMEXMLReader.this.compression.add(compress == null ? "" : compress);
                this.xmlBuffer.append("<");
                this.xmlBuffer.append(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String key = XMLTools.escapeXML((String)attributes.getQName(i));
                    String value = XMLTools.escapeXML((String)attributes.getValue(i));
                    if (key.equals("Length")) {
                        value = "0";
                    }
                    this.xmlBuffer.append(" ");
                    this.xmlBuffer.append(key);
                    this.xmlBuffer.append("=\"");
                    this.xmlBuffer.append(value);
                    this.xmlBuffer.append("\"");
                }
                this.xmlBuffer.append(">");
            } else {
                this.xmlBuffer.append("<");
                this.xmlBuffer.append(qName);
                for (int i = 0; i < attributes.getLength(); ++i) {
                    String key = XMLTools.escapeXML((String)attributes.getQName(i));
                    String value = XMLTools.escapeXML((String)attributes.getValue(i));
                    if (key.equals("BigEndian")) {
                        String endian = value.toLowerCase();
                        if (!endian.equals("true") && !endian.equals("false")) {
                            if (endian.startsWith("t")) {
                                endian = "true";
                            } else if (endian.startsWith("f")) {
                                endian = "false";
                            }
                        }
                        value = endian;
                    }
                    this.xmlBuffer.append(" ");
                    this.xmlBuffer.append(key);
                    this.xmlBuffer.append("=\"");
                    this.xmlBuffer.append(value);
                    this.xmlBuffer.append("\"");
                }
                this.xmlBuffer.append(">");
            }
        }

        public void endDocument() {
            OMEXMLReader.this.omexml = this.xmlBuffer.toString();
        }

        public void setDocumentLocator(Locator locator) {
            this.locator = locator;
        }
    }

    class BinData {
        private int row;
        private int column;

        public BinData(int row, int column) {
            this.row = row;
            this.column = column;
        }

        public int getRow() {
            return this.row;
        }

        public int getColumn() {
            return this.column;
        }
    }
}

